/*
 * Decompiled with CFR 0.152.
 */
package com.wuntee.oter.packagemanager;

import com.wuntee.oter.aapt.androidmanifest.AndroidManifestObject;
import com.wuntee.oter.aapt.androidmanifest.AndroidManifestWorkshop;
import com.wuntee.oter.adb.AdbWorkshop;
import com.wuntee.oter.exception.CommandFailedException;
import com.wuntee.oter.fs.FsDiffController;
import com.wuntee.oter.fs.FsNode;
import com.wuntee.oter.fs.FsWorkshop;
import com.wuntee.oter.packagemanager.PackageBean;
import com.wuntee.oter.packagemanager.PackageManagerWorkshop;
import com.wuntee.oter.view.Gui;
import com.wuntee.oter.view.GuiWorkshop;
import com.wuntee.oter.view.widgets.CTabItemWithDatabase;
import com.wuntee.oter.view.widgets.CTabItemWithHexViewer;
import com.wuntee.oter.view.widgets.CTabItemWithStyledText;
import com.wuntee.oter.view.widgets.runnable.FileToStyledTextRunnable;
import com.wuntee.oter.view.widgets.runnable.FsListToTreeRunnable;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.swt.widgets.TableItem;

public class PackageManagerController {
    private static Logger logger = Logger.getLogger(FsDiffController.class);
    private Gui gui;
    public static final String[] ALL_KEYS = new String[]{PackageBean.class.getName()};

    public PackageManagerController(Gui gui) {
        this.gui = gui;
    }

    public void pullPackages(String destinationDirectory) {
        String error = "";
        TableItem[] tableItemArray = this.gui.getApkTable().getTable().getSelection();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray[n2];
            PackageBean bean = (PackageBean)tableItem.getData(PackageBean.class.getName());
            this.gui.setStatusBlocking("Pulling: " + bean.getClazz());
            try {
                File dst = new File(destinationDirectory, String.valueOf(bean.getClazz()) + ".apk");
                dst = AdbWorkshop.pullFileTo(bean.getApk(), dst.getAbsolutePath());
                logger.debug((Object)("Pulled: " + dst.getAbsolutePath()));
            }
            catch (Exception e) {
                error = String.valueOf(error) + "\n\t" + bean.getClazz();
            }
            ++n2;
        }
        if (error.equals("")) {
            GuiWorkshop.messageDialog(this.gui.getShell(), "All files have been sucessfully pulled.");
        } else {
            GuiWorkshop.messageError(this.gui.getShell(), "Could not pull the following files:" + error);
        }
        this.gui.clearStatus();
    }

    public void uninstallPackages(TableItem[] selected) {
        String msg = "The following packages have been uninstalled: ";
        TableItem[] tableItemArray = selected;
        int n = selected.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem t = tableItemArray[n2];
            PackageBean bean = (PackageBean)t.getData(PackageBean.class.getName());
            String packageClazz = bean.getClazz();
            try {
                AdbWorkshop.uninstallPackage(packageClazz);
                msg = String.valueOf(msg) + "\n\t" + packageClazz;
            }
            catch (Exception e) {
                GuiWorkshop.messageError(this.gui.getShell(), "Could not uninstall: " + packageClazz + ", " + e.getMessage());
                logger.error((Object)("Could not uninstall: " + packageClazz), (Throwable)e);
            }
            ++n2;
        }
        GuiWorkshop.messageDialog(this.gui.getShell(), msg);
    }

    public void loadFileContentsToTab(FsNode node) throws IOException, InterruptedException, CommandFailedException, ClassNotFoundException, SQLException {
        logger.debug((Object)("Node selected: " + node.getFullPath()));
        if (!node.isDirectory()) {
            this.gui.setStatus("Loading file " + node.getName());
            File f = AdbWorkshop.pullFile(node.getFullPath());
            if (node.getName().endsWith(".db")) {
                CTabItemWithDatabase cTabItemWithDatabase = new CTabItemWithDatabase(this.gui.getPackageManagerFilesTabs(), node.getName(), f, 64);
            } else if (node.getName().endsWith(".xml") || node.getName().endsWith(".txt")) {
                CTabItemWithStyledText a = new CTabItemWithStyledText(this.gui.getPackageManagerFilesTabs(), node.getName(), 64);
                this.gui.runRunnableAsync(new FileToStyledTextRunnable(f, a.getStyledText()));
            } else {
                CTabItemWithHexViewer cTabItemWithHexViewer = new CTabItemWithHexViewer(this.gui.getPackageManagerFilesTabs(), node.getName(), f, 64);
            }
            this.gui.clearStatus();
        }
    }

    public void loadFileContentsToSQLiteTab(FsNode node) throws ClassNotFoundException, SQLException, IOException, InterruptedException, CommandFailedException {
        this.gui.setStatus("Loading file " + node.getName());
        File f = AdbWorkshop.pullFile(node.getFullPath());
        CTabItemWithDatabase item = new CTabItemWithDatabase(this.gui.getPackageManagerFilesTabs(), node.getName(), f, 64);
        this.gui.clearStatus();
    }

    public void loadFileContentsToTextTab(FsNode node) throws IOException, InterruptedException, CommandFailedException {
        this.gui.setStatus("Loading file " + node.getName());
        File f = AdbWorkshop.pullFile(node.getFullPath());
        CTabItemWithStyledText a = new CTabItemWithStyledText(this.gui.getPackageManagerFilesTabs(), node.getName(), 64);
        this.gui.runRunnableAsync(new FileToStyledTextRunnable(f, a.getStyledText()));
        this.gui.clearStatus();
    }

    public void loadFileContentsToHexTab(FsNode node) throws IOException, InterruptedException, CommandFailedException {
        this.gui.setStatus("Loading file " + node.getName());
        File f = AdbWorkshop.pullFile(node.getFullPath());
        CTabItemWithHexViewer hexTab = new CTabItemWithHexViewer(this.gui.getPackageManagerFilesTabs(), node.getName(), f, 64);
        this.gui.clearStatus();
    }

    public void loadPackageDetails(TableItem[] selection) {
        if (selection.length > 1) {
            return;
        }
        TableItem item = selection[0];
        final PackageBean bean = (PackageBean)item.getData(PackageBean.class.getName());
        logger.info((Object)("Loading package details for: " + bean.getApk()));
        this.gui.setStatus("Loading package details for: " + bean.getApk());
        Thread details = new Thread(new Runnable(){

            @Override
            public void run() {
                File apk = null;
                try {
                    apk = AdbWorkshop.pullFile(bean.getApk());
                }
                catch (Exception e) {
                    logger.error((Object)"Could not pull apk from device: ", (Throwable)e);
                    GuiWorkshop.messageErrorThreaded(PackageManagerController.this.gui, "Could not pull apk from device: " + e.getMessage());
                }
                if (apk != null) {
                    try {
                        final AndroidManifestObject root = AndroidManifestWorkshop.getAndroidManifestObjectsForApk(apk);
                        PackageManagerController.this.gui.runRunnableAsync(new Runnable(){

                            @Override
                            public void run() {
                                PackageManagerController.this.gui.getPackageManagerAndroidManifestTab().loadAndroidManifestObjects(root);
                            }
                        });
                    }
                    catch (Exception e) {
                        logger.error((Object)"Could not parse the AndroidManifest.xml file: ", (Throwable)e);
                        GuiWorkshop.messageErrorThreaded(PackageManagerController.this.gui, "Could not parse the AndroidManifest.xml file: " + e.getMessage());
                    }
                    List<String> details = null;
                    try {
                        details = PackageManagerWorkshop.getDetailedPackageInfo(apk);
                    }
                    catch (Exception e) {
                        logger.error((Object)"Could not get detailed package information: ", (Throwable)e);
                        GuiWorkshop.messageErrorThreaded(PackageManagerController.this.gui, "Could not get detailed package information: " + e.getMessage());
                    }
                    final StringBuffer sb = new StringBuffer();
                    if (details != null) {
                        for (String det : details) {
                            sb.append(det).append("\n");
                        }
                    }
                    PackageManagerController.this.gui.runRunnableAsync(new Runnable(){

                        @Override
                        public void run() {
                            PackageManagerController.this.gui.getPackageManagerStyledText().setText(sb.toString());
                        }
                    });
                }
                List<FsNode> files = null;
                try {
                    files = FsWorkshop.getDirectoryRecursive("/data/data/" + bean.getClazz() + "/");
                }
                catch (Exception e) {
                    logger.error((Object)"Could not get file listing: ", (Throwable)e);
                    GuiWorkshop.messageErrorThreaded(PackageManagerController.this.gui, "Could not get file listing: " + e.getMessage());
                }
                if (files != null) {
                    PackageManagerController.this.gui.runRunnableAsync(new FsListToTreeRunnable(files, PackageManagerController.this.gui.getPackageManagerFilesTree()));
                }
                PackageManagerController.this.gui.clearStatus();
            }
        });
        details.start();
    }
}

