/*
 * Decompiled with CFR 0.152.
 */
package com.wuntee.oter.logcat;

import com.wuntee.oter.OterStatics;
import com.wuntee.oter.OterWorkshop;
import com.wuntee.oter.exception.ParseException;
import com.wuntee.oter.logcat.LogCatBean;
import com.wuntee.oter.logcat.LogCatCommand;
import com.wuntee.oter.logcat.LogCatLevelEnum;
import com.wuntee.oter.view.Gui;
import com.wuntee.oter.view.GuiWorkshop;
import java.io.BufferedReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wb.swt.SWTResourceManager;

public class LogCatController {
    private static Logger logger = Logger.getLogger(LogCatController.class);
    private LogCatCommand logcat;
    private Gui gui;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss:S");
    private List<LogCatBean> logcatCurrent;
    private int maxBufferSize;
    public static int DEFAULT_MAX_LINES = 10000;

    public LogCatController(Gui gui) {
        this.gui = gui;
        this.logcatCurrent = new LinkedList<LogCatBean>();
        try {
            this.maxBufferSize = Integer.parseInt(OterWorkshop.getProperty(OterStatics.PROPERTY_LOGCAT_MAXLINES));
        }
        catch (Exception e) {
            this.maxBufferSize = DEFAULT_MAX_LINES;
        }
    }

    public void copy() {
        TableItem[] selected = this.gui.getLogcatTable().getSelection();
        String clipboard = "";
        TableItem[] tableItemArray = selected;
        int n = selected.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            String date = item.getText(0);
            String level = item.getText(1);
            String c = item.getText(2);
            String pid = item.getText(3);
            String message = item.getText(4);
            String line = String.format("%-12s %-5s: %-15s[%5s]: %s\n", date, level, c, pid, message);
            clipboard = String.valueOf(clipboard) + line;
            ++n2;
        }
        GuiWorkshop.setClipboardContents(clipboard);
    }

    public void start() throws Exception {
        if (this.logcat != null && this.logcat.isRunning()) {
            this.logcat.close();
        }
        try {
            this.maxBufferSize = Integer.parseInt(OterWorkshop.getProperty(OterStatics.PROPERTY_LOGCAT_MAXLINES));
        }
        catch (Exception e) {
            this.maxBufferSize = DEFAULT_MAX_LINES;
        }
        this.logcat = new LogCatCommand();
        logger.debug((Object)"Clearing current list");
        this.gui.getLogcatTable().clearAll();
        logger.debug((Object)"Executing command");
        this.logcat.execute();
        BufferedReader read = this.logcat.getStdout();
        BufferedReader error = this.logcat.getStderr();
        logger.debug((Object)"Creating error thread");
        ErrorLineReaderThread errorRunnable = new ErrorLineReaderThread(error);
        Thread errorThread = new Thread(errorRunnable);
        errorThread.start();
        logger.debug((Object)"Creating adb thread");
        AdbLineReaderThread readRunnable = new AdbLineReaderThread(read);
        Thread readThread = new Thread(readRunnable);
        readThread.start();
    }

    public void stop() {
        logger.debug((Object)"Stoping logcat");
        if (this.logcat.isRunning()) {
            this.logcat.close();
        }
    }

    public void addLine(LogCatBean l) {
        this.gui.getDisplay().asyncExec((Runnable)new AddLineRunnable(l));
    }

    public void stopAutoscroll() {
        this.gui.getLogcatCheckAutoscroll().setSelection(false);
    }

    public void reFilterTable() {
        this.gui.runRunnableAsync(new ReFilterTableRunnable());
    }

    public boolean matchesFilter(LogCatBean bean) {
        String filterRegex;
        block5: {
            block4: {
                try {
                    String filter = this.gui.getLogcatTextFilter().getText().toLowerCase().trim();
                    filterRegex = ".*" + filter + ".*";
                    if (filter != "") break block4;
                    return true;
                }
                catch (Exception e) {
                    return true;
                }
            }
            if (!bean.getMessage().toLowerCase().matches(filterRegex)) break block5;
            return true;
        }
        return bean.getClazz().toLowerCase().matches(filterRegex);
    }

    public class AdbLineReaderThread
    implements Runnable {
        private BufferedReader read;

        public AdbLineReaderThread(BufferedReader read) {
            this.read = read;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            logger.debug((Object)"AdbLinReaderThread run");
            String line = null;
            try {
                while (true) {
                    if ((line = this.read.readLine()) == null) {
                        return;
                    }
                    if (line.length() == 0) continue;
                    try {
                        LogCatBean l = LogCatBean.parse(line);
                        LogCatController.this.addLine(l);
                    }
                    catch (ParseException e) {
                        logger.error((Object)("Could not parse: " + line), (Throwable)e);
                    }
                }
            }
            catch (IOException e1) {
                logger.error((Object)"Could read line", (Throwable)e1);
            }
        }
    }

    public class AddLineRunnable
    implements Runnable {
        private LogCatBean l;

        public AddLineRunnable(LogCatBean l) {
            this.l = l;
        }

        @Override
        public void run() {
            if (LogCatController.this.logcatCurrent.size() >= LogCatController.this.maxBufferSize) {
                logger.info((Object)"Max buffer reached, removing first index");
                LogCatController.this.logcatCurrent.remove(0);
            }
            LogCatController.this.logcatCurrent.add(this.l);
            if (LogCatController.this.matchesFilter(this.l)) {
                TableItem tableItem;
                Table logCatTable = LogCatController.this.gui.getLogcatTable();
                if (logCatTable.getItemCount() >= LogCatController.this.maxBufferSize) {
                    logger.info((Object)"Max buffer reached in table, removing first index");
                    logCatTable.remove(logCatTable.getTopIndex());
                }
                if (this.l.getLevel() == LogCatLevelEnum.ERROR && LogCatController.this.gui.getLogcatCheckError().getSelection()) {
                    tableItem = new TableItem(logCatTable, 0);
                    tableItem.setText(new String[]{LogCatController.this.dateFormat.format(this.l.getDate()), this.l.getLevel().toString(), this.l.getClazz(), String.valueOf(this.l.getPid()), this.l.getMessage()});
                    tableItem.setForeground(SWTResourceManager.getColor(3));
                } else if (this.l.getLevel() == LogCatLevelEnum.WARN && LogCatController.this.gui.getLogcatCheckWarn().getSelection()) {
                    tableItem = new TableItem(logCatTable, 0);
                    tableItem.setText(new String[]{LogCatController.this.dateFormat.format(this.l.getDate()), this.l.getLevel().toString(), this.l.getClazz(), String.valueOf(this.l.getPid()), this.l.getMessage()});
                    tableItem.setForeground(SWTResourceManager.getColor(255, 165, 0));
                } else if (this.l.getLevel() == LogCatLevelEnum.INFO && LogCatController.this.gui.getLogcatCheckInfo().getSelection()) {
                    tableItem = new TableItem(logCatTable, 0);
                    tableItem.setText(new String[]{LogCatController.this.dateFormat.format(this.l.getDate()), this.l.getLevel().toString(), this.l.getClazz(), String.valueOf(this.l.getPid()), this.l.getMessage()});
                    tableItem.setForeground(SWTResourceManager.getColor(9));
                } else if (this.l.getLevel() == LogCatLevelEnum.DEBUG && LogCatController.this.gui.getLogcatCheckDebug().getSelection()) {
                    tableItem = new TableItem(logCatTable, 0);
                    tableItem.setText(new String[]{LogCatController.this.dateFormat.format(this.l.getDate()), this.l.getLevel().toString(), this.l.getClazz(), String.valueOf(this.l.getPid()), this.l.getMessage()});
                    tableItem.setForeground(SWTResourceManager.getColor(2));
                } else if (this.l.getLevel() == LogCatLevelEnum.VERBOSE && LogCatController.this.gui.getLogcatCheckVerbose().getSelection()) {
                    tableItem = new TableItem(logCatTable, 0);
                    tableItem.setText(new String[]{LogCatController.this.dateFormat.format(this.l.getDate()), this.l.getLevel().toString(), this.l.getClazz(), String.valueOf(this.l.getPid()), this.l.getMessage()});
                    tableItem.setForeground(SWTResourceManager.getColor(13));
                }
                if (LogCatController.this.gui.getLogcatCheckAutoscroll().getSelection()) {
                    int bottom = LogCatController.this.gui.getLogcatTable().getItemCount();
                    LogCatController.this.gui.getLogcatTable().setTopIndex(bottom - 1);
                }
            }
        }
    }

    public class ErrorLineReaderThread
    implements Runnable {
        private BufferedReader read;

        public ErrorLineReaderThread(BufferedReader read) {
            this.read = read;
        }

        @Override
        public void run() {
            String line = null;
            try {
                while ((line = this.read.readLine()) != null) {
                    System.err.println("ERROR: " + line);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public class ReFilterTableRunnable
    implements Runnable {
        @Override
        public void run() {
            Table table = LogCatController.this.gui.getLogcatTable();
            boolean debug = LogCatController.this.gui.getLogcatCheckDebug().getSelection();
            logger.debug((Object)debug);
            boolean info = LogCatController.this.gui.getLogcatCheckInfo().getSelection();
            boolean error = LogCatController.this.gui.getLogcatCheckError().getSelection();
            boolean warn = LogCatController.this.gui.getLogcatCheckWarn().getSelection();
            boolean verbose = LogCatController.this.gui.getLogcatCheckVerbose().getSelection();
            table.removeAll();
            for (LogCatBean bean : LogCatController.this.logcatCurrent) {
                TableItem tableItem;
                if (!LogCatController.this.matchesFilter(bean)) continue;
                if (bean.getLevel() == LogCatLevelEnum.ERROR && error) {
                    tableItem = new TableItem(table, 0);
                    tableItem.setText(new String[]{LogCatController.this.dateFormat.format(bean.getDate()), bean.getLevel().toString(), bean.getClazz(), String.valueOf(bean.getPid()), bean.getMessage()});
                    tableItem.setForeground(SWTResourceManager.getColor(3));
                    continue;
                }
                if (bean.getLevel() == LogCatLevelEnum.WARN && warn) {
                    tableItem = new TableItem(table, 0);
                    tableItem.setText(new String[]{LogCatController.this.dateFormat.format(bean.getDate()), bean.getLevel().toString(), bean.getClazz(), String.valueOf(bean.getPid()), bean.getMessage()});
                    tableItem.setForeground(SWTResourceManager.getColor(255, 165, 0));
                    continue;
                }
                if (bean.getLevel() == LogCatLevelEnum.INFO && info) {
                    tableItem = new TableItem(table, 0);
                    tableItem.setText(new String[]{LogCatController.this.dateFormat.format(bean.getDate()), bean.getLevel().toString(), bean.getClazz(), String.valueOf(bean.getPid()), bean.getMessage()});
                    tableItem.setForeground(SWTResourceManager.getColor(9));
                    continue;
                }
                if (bean.getLevel() == LogCatLevelEnum.DEBUG && debug) {
                    tableItem = new TableItem(table, 0);
                    tableItem.setText(new String[]{LogCatController.this.dateFormat.format(bean.getDate()), bean.getLevel().toString(), bean.getClazz(), String.valueOf(bean.getPid()), bean.getMessage()});
                    tableItem.setForeground(SWTResourceManager.getColor(2));
                    continue;
                }
                if (bean.getLevel() != LogCatLevelEnum.VERBOSE || !verbose) continue;
                tableItem = new TableItem(table, 0);
                tableItem.setText(new String[]{LogCatController.this.dateFormat.format(bean.getDate()), bean.getLevel().toString(), bean.getClazz(), String.valueOf(bean.getPid()), bean.getMessage()});
                tableItem.setForeground(SWTResourceManager.getColor(13));
            }
            int bottom = LogCatController.this.gui.getLogcatTable().getItemCount();
            LogCatController.this.gui.getLogcatTable().setTopIndex(bottom - 1);
        }
    }
}

