/*
 * Decompiled with CFR 0.152.
 */
package com.wuntee.oter.logcat;

import com.wuntee.oter.exception.ParseException;
import com.wuntee.oter.logcat.LogCatLevelEnum;
import java.util.Date;
import org.apache.log4j.Logger;

public class LogCatBean {
    private static Logger logger = Logger.getLogger(LogCatBean.class);
    private Date date;
    private String raw;
    private LogCatLevelEnum level;
    private String clazz;
    private int pid;
    private String message;

    public LogCatBean() {
    }

    public LogCatBean(String raw) {
        this.raw = raw;
    }

    public static LogCatBean parse(String raw) throws ParseException {
        LogCatBean l = new LogCatBean(raw);
        l.parseLine();
        return l;
    }

    public void parseLine() throws ParseException {
        logger.debug((Object)("Parsing: " + this.raw));
        this.date = new Date();
        switch (this.raw.charAt(0)) {
            case 'V': {
                this.level = LogCatLevelEnum.VERBOSE;
                break;
            }
            case 'D': {
                this.level = LogCatLevelEnum.DEBUG;
                break;
            }
            case 'I': {
                this.level = LogCatLevelEnum.INFO;
                break;
            }
            case 'W': {
                this.level = LogCatLevelEnum.WARN;
                break;
            }
            case 'E': {
                this.level = LogCatLevelEnum.ERROR;
            }
        }
        try {
            this.clazz = this.raw.substring(2, this.raw.length()).split("\\(")[0];
            this.pid = Integer.valueOf(this.raw.substring(this.raw.indexOf("(") + 1, this.raw.indexOf(")")).trim());
            this.message = this.raw.substring(this.raw.indexOf(":") + 2, this.raw.length());
        }
        catch (Throwable e) {
            throw new ParseException(this.raw);
        }
    }

    public String toString() {
        return String.format("%-5s: %-15s[%5s]: %s", new Object[]{this.level, this.clazz, this.pid, this.message});
    }

    public String getRaw() {
        return this.raw;
    }

    public void setRaw(String raw) {
        this.raw = raw;
    }

    public LogCatLevelEnum getLevel() {
        return this.level;
    }

    public void setLevel(LogCatLevelEnum level) {
        this.level = level;
    }

    public String getClazz() {
        return this.clazz;
    }

    public void setClazz(String clazz) {
        this.clazz = clazz;
    }

    public int getPid() {
        return this.pid;
    }

    public void setPid(int pid) {
        this.pid = pid;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }
}

