/*
 * Decompiled with CFR 0.152.
 */
package com.wuntee.oter.javatosmali;

import com.wuntee.oter.OterStatics;
import com.wuntee.oter.OterWorkshop;
import com.wuntee.oter.command.TerminatingCommand;
import com.wuntee.oter.exception.UnknownClassnameException;
import com.wuntee.oter.javatosmali.JavaToSmaliController;
import com.wuntee.oter.smali.SmaliWorkshop;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import org.apache.log4j.Logger;

public class JavaToSmaliWorkshop {
    private static Logger logger = Logger.getLogger(JavaToSmaliController.class);

    public static boolean isValidJava(String java) {
        return true;
    }

    public static File writeJavaToFile(String javaSource) throws IOException, UnknownClassnameException {
        String className = JavaToSmaliWorkshop.findClassNameFromJavaSource(javaSource);
        if (className == null) {
            logger.error((Object)"Could not determine class name.");
            throw new UnknownClassnameException();
        }
        File tempDir = OterWorkshop.createTemporaryDirectory("otertoolCompileJava");
        tempDir.deleteOnExit();
        File javaSourceFile = new File(tempDir, String.valueOf(className) + ".java");
        BufferedWriter out = new BufferedWriter(new FileWriter(javaSourceFile));
        out.write(javaSource);
        out.close();
        return javaSourceFile;
    }

    public static String findClassNameFromJavaSource(String javaSource) {
        if ((javaSource = javaSource.replace("\n", " ")).matches(".*public\\s+class.*")) {
            int startIndex = javaSource.indexOf("class") + "class".length();
            int endIndex = javaSource.indexOf("{");
            return javaSource.substring(startIndex, endIndex).trim();
        }
        return null;
    }

    public static String javaSourceToSmali(String javaSourceText, String classpathString) throws Exception {
        File javaSource;
        String classFile;
        String className;
        try {
            className = JavaToSmaliWorkshop.findClassNameFromJavaSource(javaSourceText);
            classFile = String.valueOf(className) + ".dex";
            javaSource = JavaToSmaliWorkshop.writeJavaToFile(javaSourceText);
        }
        catch (IOException e) {
            logger.error((Object)("Could not write java file: " + e.getMessage()));
            throw new Exception("Could not write java file");
        }
        catch (UnknownClassnameException e) {
            logger.error((Object)("Could not determine the java source class name: " + e.getMessage()));
            throw new Exception("Could not determine the java class name");
        }
        logger.debug((Object)"Compiling java source.");
        TerminatingCommand javacCmd = null;
        javacCmd = classpathString != null ? new TerminatingCommand(new String[]{"javac", "-classpath", classpathString, javaSource.getAbsolutePath()}) : new TerminatingCommand(new String[]{"javac", javaSource.getAbsolutePath()});
        javacCmd.execute();
        try {
            logger.debug((Object)"Compiling class to dex.");
            TerminatingCommand dxCommand = new TerminatingCommand(new String[]{OterStatics.getDxCommand(), "-jar", String.valueOf(OterStatics.getAndroidHome()) + System.getProperty("file.separator") + "platform-tools" + System.getProperty("file.separator") + "lib" + System.getProperty("file.separator") + "dx.jar", "--dex", "--output=" + classFile, String.valueOf(className) + ".class"}, javaSource.getParentFile());
            dxCommand.execute();
        }
        catch (Exception e) {
            logger.debug((Object)("Could not compile to dex file: " + e.getMessage()));
            throw new Exception("Could not compile dex file");
        }
        try {
            String str;
            logger.debug((Object)"Decompiling dex to smali.");
            File dexFile = new File(javaSource.getParentFile() + System.getProperty("file.separator") + classFile);
            Map<String, File> smaliMap = SmaliWorkshop.getSmaliSource(dexFile, javaSource.getParentFile());
            logger.debug((Object)("Number of sources: " + smaliMap.size()));
            File smaliSourceFile = (File)smaliMap.values().toArray()[0];
            BufferedReader in = new BufferedReader(new FileReader(smaliSourceFile));
            String buf = "";
            while ((str = in.readLine()) != null) {
                buf = String.valueOf(buf) + str + "\n";
            }
            return buf;
        }
        catch (Exception e) {
            logger.debug((Object)("Could not decompile to dex: " + e.getMessage()));
            throw new Exception("Could not decompile dex");
        }
    }
}

