/*
 * Decompiled with CFR 0.152.
 */
package com.wuntee.oter.javatosmali;

import com.wuntee.oter.OterStatics;
import com.wuntee.oter.OterWorkshop;
import com.wuntee.oter.exception.CommandFailedException;
import com.wuntee.oter.javatosmali.JavaToSmaliWorkshop;
import com.wuntee.oter.view.Gui;
import org.apache.log4j.Logger;
import org.eclipse.swt.custom.StyledText;

public class JavaToSmaliController {
    private static Logger logger = Logger.getLogger(JavaToSmaliController.class);
    private Gui gui;

    public JavaToSmaliController(Gui gui) {
        this.gui = gui;
    }

    public void tryToCompileJava(StyledText javaStyledText, StyledText smaliStyledText) {
        this.gui.setStatus("Java to Smali: Compiling java to smali");
        this.gui.runRunnableAsync(new TryToCompileJavaToSmali(javaStyledText, smaliStyledText));
    }

    public class TryToCompileJavaToSmali
    implements Runnable {
        private StyledText javaStyledText;
        private StyledText smaliStyledText;

        public TryToCompileJavaToSmali(StyledText javaStyledText, StyledText smaliStyledText) {
            this.javaStyledText = javaStyledText;
            this.smaliStyledText = smaliStyledText;
        }

        @Override
        public void run() {
            this.smaliStyledText.setText("");
            try {
                this.smaliStyledText.setText(JavaToSmaliWorkshop.javaSourceToSmali(this.javaStyledText.getText(), OterWorkshop.getProperty(OterStatics.PROPERTY_JAVATOSMALI_CLASSPATH)));
                JavaToSmaliController.this.gui.clearStatus();
            }
            catch (CommandFailedException e) {
                this.smaliStyledText.setText(e.getMessage());
                JavaToSmaliController.this.gui.setStatus("Java to Smali: Could not compile java source");
            }
            catch (Exception e) {
                JavaToSmaliController.this.gui.setStatus("Java to Smali: " + e.getMessage());
            }
        }
    }
}

