/*
 * Decompiled with CFR 0.152.
 */
package com.wuntee.oter.fs;

import com.wuntee.oter.OterStatics;
import com.wuntee.oter.adb.AdbShell;
import com.wuntee.oter.exception.CommandFailedException;
import com.wuntee.oter.fs.FsNode;
import com.wuntee.oter.fs.FsWorkshop;
import com.wuntee.oter.view.Gui;
import com.wuntee.oter.view.widgets.runnable.FsListToTreeRunnable;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.wb.swt.SWTResourceManager;

public class FsDiffController {
    private static Logger logger = Logger.getLogger(FsDiffController.class);
    private Gui gui;
    private List<FsNode> first;
    private List<FsNode> second;

    public FsDiffController(Gui gui) {
        this.gui = gui;
    }

    public void scanFirst() throws Exception {
        this.gui.getFsDiffSashForm().setWeights(new int[]{1, 1, 1});
        this.gui.getFsDiffFirstTree().removeAll();
        this.gui.getFsDiffSecondTree().removeAll();
        this.gui.getFsDifferencesTree().removeAll();
        Thread first = new Thread(new FirstFsScanRunnable(this.gui.getFsDiffFirstTree()));
        first.start();
    }

    public void scanSecond() {
        this.gui.getFsDiffSecondTree().removeAll();
        Thread second = new Thread(new SecondFsScanRunnable(this.gui.getFsDiffSecondTree()));
        second.start();
    }

    public void generateDifferences() {
        this.gui.setStatus("FsDiff: Generating differences");
        logger.debug((Object)"Flattening first.");
        LinkedList<FsNode> flatFirst = new LinkedList<FsNode>();
        for (FsNode node : this.first) {
            flatFirst.addAll(this.flattenFsNode(node));
        }
        logger.debug((Object)"Flattening second.");
        LinkedList<FsNode> flatSecond = new LinkedList<FsNode>();
        for (FsNode node : this.second) {
            flatSecond.addAll(this.flattenFsNode(node));
        }
        logger.debug((Object)"Generating differences");
        LinkedList<FsNode> newNodes = new LinkedList<FsNode>();
        LinkedList<List<FsNode>> updatedNodes = new LinkedList<List<FsNode>>();
        LinkedList<FsNode> deletedNodes = new LinkedList<FsNode>();
        for (FsNode secondNode : flatSecond) {
            if (this.getNodeInList(secondNode, flatFirst) != null) continue;
            newNodes.add(secondNode);
        }
        logger.debug((Object)("New: " + newNodes.size()));
        for (FsNode firstNode : flatFirst) {
            FsNode secondNode = this.getNodeInList(firstNode, flatSecond);
            if (secondNode == null || secondNode.equals(firstNode)) continue;
            LinkedList<FsNode> update = new LinkedList<FsNode>();
            update.add(firstNode);
            update.add(secondNode);
            updatedNodes.add(update);
        }
        logger.debug((Object)("Updated: " + updatedNodes.size()));
        for (FsNode firstNode : flatFirst) {
            if (this.getNodeInList(firstNode, flatSecond) != null) continue;
            deletedNodes.add(firstNode);
        }
        logger.debug((Object)("Deleted: " + deletedNodes.size()));
        Tree tree = this.gui.getFsDifferencesTree();
        this.gui.getDisplay().asyncExec((Runnable)new ListToDiffTree(tree, newNodes, updatedNodes, deletedNodes));
        this.gui.setSashFormWeights(this.gui.getFsDiffSashForm(), new int[]{1, 1, 6});
        this.gui.setStatus("");
    }

    private FsNode getNodeInList(FsNode node, List<FsNode> list) {
        for (FsNode scanNode : list) {
            if (!node.getFullPath().equals(scanNode.getFullPath())) continue;
            return scanNode;
        }
        return null;
    }

    private List<FsNode> flattenFsNode(FsNode source) {
        LinkedList<FsNode> ret = new LinkedList<FsNode>();
        ret.add(source);
        if (source.isDirectory()) {
            for (FsNode node : source.getChildren()) {
                ret.addAll(this.flattenFsNode(node));
            }
        }
        return ret;
    }

    public List<FsNode> getFilesystem() throws Exception {
        AdbShell shell = new AdbShell();
        shell.execute();
        shell.getRootShell();
        return this.listDirectoryRecursive("/", shell);
    }

    private List<FsNode> listDirectoryRecursive(String root, AdbShell shell) throws IOException, CommandFailedException {
        List<String> lines;
        logger.debug((Object)("listDirectoryRecursive: " + root));
        LinkedList<FsNode> ret = new LinkedList<FsNode>();
        try {
            lines = shell.sendCommand("ls -l " + root);
        }
        catch (CommandFailedException e) {
            return ret;
        }
        for (String line : lines) {
            FsNode node = FsNode.getNode(line, root);
            if (FsWorkshop.isBadDirectory(node.getFullPath())) continue;
            if (node.getType().equals("d")) {
                this.gui.setStatus("FsDiff: Scanning " + node.getFullPath());
                logger.debug((Object)("Got directory, recursing: " + node.getFullPath()));
                List<FsNode> secRet = this.listDirectoryRecursive(node.getFullPath(), shell);
                for (FsNode sec : secRet) {
                    node.addChild(sec);
                }
            }
            logger.debug((Object)("Adding to return: " + node.getName() + " with children: " + node.getChildren().size()));
            ret.add(node);
        }
        return ret;
    }

    private void setFsToTree(List<FsNode> fs, Tree tree) {
        this.gui.getDisplay().asyncExec((Runnable)new FsListToTreeRunnable(fs, tree));
    }

    public class FirstFsScanRunnable
    implements Runnable {
        private Tree tree;

        public FirstFsScanRunnable(Tree tree) {
            this.tree = tree;
        }

        @Override
        public void run() {
            try {
                FsDiffController.this.first = FsDiffController.this.getFilesystem();
                FsDiffController.this.setFsToTree(FsDiffController.this.first, this.tree);
            }
            catch (Exception e) {
                FsDiffController.this.gui.messageError("Error scanning: " + e.getMessage());
                logger.error((Object)"Error scanning:", (Throwable)e);
            }
        }
    }

    public class ListToDiffTree
    implements Runnable {
        private Tree tree;
        private List<FsNode> newNodes;
        private List<List<FsNode>> updatedNodes;
        private List<FsNode> deletedNodes;

        public ListToDiffTree(Tree tree, List<FsNode> newNodes, List<List<FsNode>> updatedNodes, List<FsNode> deletedNodes) {
            this.tree = tree;
            this.newNodes = newNodes;
            this.updatedNodes = updatedNodes;
            this.deletedNodes = deletedNodes;
        }

        @Override
        public void run() {
            TreeItem trtmTest;
            for (FsNode fsNode : this.newNodes) {
                trtmTest = new TreeItem(this.tree, 0);
                trtmTest.setForeground(SWTResourceManager.getColor(6));
                if (fsNode.isLink()) {
                    trtmTest.setText(new String[]{String.valueOf(fsNode.getFullPath()) + " -> " + fsNode.getLink(), fsNode.getPermissions(), fsNode.getGroup(), fsNode.getUser(), fsNode.getSize() == -1 ? "" : String.valueOf(fsNode.getSize()), fsNode.getDate()});
                } else {
                    trtmTest.setText(new String[]{fsNode.getFullPath(), fsNode.getPermissions(), fsNode.getGroup(), fsNode.getUser(), fsNode.getSize() == -1 ? "" : String.valueOf(fsNode.getSize()), fsNode.getDate()});
                }
                if (fsNode.isDirectory()) {
                    trtmTest.setImage(SWTResourceManager.getImage(Gui.class, OterStatics.ICON_FILE));
                    continue;
                }
                trtmTest.setImage(SWTResourceManager.getImage(Gui.class, OterStatics.ICON_FILE));
            }
            for (List list : this.updatedNodes) {
                FsNode oldNode = (FsNode)list.get(0);
                FsNode newNode = (FsNode)list.get(1);
                TreeItem trtmTest2 = new TreeItem(this.tree, 0);
                trtmTest2.setForeground(SWTResourceManager.getColor(9));
                if (oldNode.isLink()) {
                    trtmTest2.setText(String.valueOf(oldNode.getFullPath()) + " -> " + oldNode.getLink());
                } else {
                    trtmTest2.setText(oldNode.getFullPath());
                }
                if (oldNode.isDirectory()) {
                    trtmTest2.setImage(SWTResourceManager.getImage(Gui.class, OterStatics.ICON_DIRECTORY));
                } else {
                    trtmTest2.setImage(SWTResourceManager.getImage(Gui.class, OterStatics.ICON_FILE));
                }
                TreeItem oldTreeItem = new TreeItem(trtmTest2, 0);
                oldTreeItem.setText(new String[]{"First", oldNode.getPermissions(), oldNode.getGroup(), oldNode.getUser(), oldNode.getSize() == -1 ? "" : String.valueOf(oldNode.getSize()), oldNode.getDate()});
                TreeItem newTreeItem = new TreeItem(trtmTest2, 0);
                newTreeItem.setText(new String[]{"Second", newNode.getPermissions(), newNode.getGroup(), newNode.getUser(), newNode.getSize() == -1 ? "" : String.valueOf(newNode.getSize()), newNode.getDate()});
            }
            for (FsNode fsNode : this.deletedNodes) {
                trtmTest = new TreeItem(this.tree, 0);
                trtmTest.setForeground(SWTResourceManager.getColor(3));
                if (fsNode.isLink()) {
                    trtmTest.setText(new String[]{String.valueOf(fsNode.getFullPath()) + " -> " + fsNode.getLink(), fsNode.getPermissions(), fsNode.getGroup(), fsNode.getUser(), fsNode.getSize() == -1 ? "" : String.valueOf(fsNode.getSize()), fsNode.getDate()});
                } else {
                    trtmTest.setText(new String[]{fsNode.getFullPath(), fsNode.getPermissions(), fsNode.getGroup(), fsNode.getUser(), fsNode.getSize() == -1 ? "" : String.valueOf(fsNode.getSize()), fsNode.getDate()});
                }
                if (fsNode.isDirectory()) {
                    trtmTest.setImage(SWTResourceManager.getImage(Gui.class, OterStatics.ICON_FILE));
                    continue;
                }
                trtmTest.setImage(SWTResourceManager.getImage(Gui.class, OterStatics.ICON_FILE));
            }
        }
    }

    public class SecondFsScanRunnable
    implements Runnable {
        private Tree tree;

        public SecondFsScanRunnable(Tree tree) {
            this.tree = tree;
        }

        @Override
        public void run() {
            try {
                FsDiffController.this.second = FsDiffController.this.getFilesystem();
                FsDiffController.this.setFsToTree(FsDiffController.this.second, this.tree);
                FsDiffController.this.generateDifferences();
            }
            catch (Exception e) {
                FsDiffController.this.gui.messageError("Error scanning: " + e.getMessage());
                logger.error((Object)"Error scanning:", (Throwable)e);
            }
        }
    }
}

