/*
 * Decompiled with CFR 0.152.
 */
package com.wuntee.oter.debugger;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Bootstrap;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.NativeMethodException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.tools.jdi.SocketAttachingConnector;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Testing {
    public static void main(String[] args) throws IOException, IllegalConnectorArgumentsException, InterruptedException, IncompatibleThreadStateException, AbsentInformationException {
        SocketAttachingConnector c = (SocketAttachingConnector)Testing.getConnector();
        Map arguments = c.defaultArguments();
        Connector.Argument hostnameArgument = (Connector.Argument)arguments.get("hostname");
        hostnameArgument.setValue("127.0.0.1");
        Connector.Argument portArgument = (Connector.Argument)arguments.get("port");
        portArgument.setValue("8603");
        arguments.put("hostname", hostnameArgument);
        arguments.put("port", portArgument);
        VirtualMachine vm = c.attach(arguments);
        EventRequestManager mgr = vm.eventRequestManager();
        for (ReferenceType rt : vm.allClasses()) {
            if (!rt.name().toLowerCase().contains("wuntee")) continue;
            System.out.println(rt.name());
            for (Method m : rt.allMethods()) {
                System.out.println(" -" + m.name());
                if (!m.name().contains("cache")) continue;
                Testing.addBreakpointToMethod(m, mgr);
            }
        }
        EventQueue q = vm.eventQueue();
        block4: while (true) {
            EventSet es = q.remove();
            Iterator it = es.iterator();
            while (true) {
                if (!it.hasNext()) continue block4;
                Event e = (Event)it.next();
                BreakpointEvent bpe = (BreakpointEvent)e;
                try {
                    System.out.println("Method: " + bpe.location().method().toString());
                    for (StackFrame sf : bpe.thread().frames()) {
                        System.out.println("Stackframe Method: " + sf.location().method().toString());
                        System.out.println("Arguments: ");
                        for (Value lv : sf.getArgumentValues()) {
                            System.out.println("\t--");
                            System.out.println("\t" + lv.toString());
                        }
                    }
                }
                catch (Exception ex) {
                    System.out.println("Error: ");
                    ex.printStackTrace();
                }
                System.out.println();
                vm.resume();
            }
            break;
        }
    }

    public static void addBreakpointToMethod(Method m, EventRequestManager mgr) {
        System.out.println("Breakpoint: " + m.toString());
        try {
            Location location = m.location();
            BreakpointRequest bpr = mgr.createBreakpointRequest(location);
            bpr.enable();
        }
        catch (NativeMethodException e) {
            System.out.println("Error: Cant add breakpoint to native method (" + m.toString() + ")");
        }
    }

    public static void printBreakpointData(BreakpointEvent e) throws IncompatibleThreadStateException, AbsentInformationException {
        System.out.println(e.location());
        System.out.println("Line number: " + e.location().lineNumber());
        System.out.println("Code index: " + e.location().codeIndex());
        try {
            System.out.println("SourceName: " + e.location().sourceName());
        }
        catch (AbsentInformationException e1) {
            System.out.println("SourceName: UNAVAILABLE");
        }
        System.out.println("Declaration type: " + e.location().declaringType());
        System.out.println("Method: " + e.location().method());
        System.out.println("Stack frames:");
        for (StackFrame sf : e.thread().frames()) {
            System.out.println("\t" + sf.toString());
            System.out.println("\t   Visible Variables:");
            for (LocalVariable localVariable : sf.visibleVariables()) {
                System.out.println("\t\t--");
                System.out.println("\t\tName: " + localVariable.name());
                System.out.println("\t\tType: " + localVariable.typeName());
                Value lvValue = sf.getValue(localVariable);
                if (lvValue == null) continue;
                System.out.println("\t\tValue: " + lvValue);
                System.out.println("\t\tValue Type:" + lvValue.type());
                System.out.println("\t\ttoString: " + localVariable);
            }
            System.out.println("\t   Argument Values:");
            for (Value value : sf.getArgumentValues()) {
                System.out.println("\t\t--");
                System.out.println("\t\t" + value.toString());
            }
        }
    }

    public static void addIntentBreakpoints(VirtualMachine vm) {
        BreakpointRequest bpr;
        Location location;
        EventRequestManager mgr = vm.eventRequestManager();
        ReferenceType intentClass = vm.classesByName("android.content.Intent").get(0);
        for (Method m : intentClass.methodsByName("<init>")) {
            System.out.println("Breakpoint: " + m.toString());
            location = m.location();
            bpr = mgr.createBreakpointRequest(location);
            bpr.enable();
        }
        for (Method m : intentClass.methodsByName("putExtra")) {
            System.out.println("Breakpoint: " + m.toString());
            location = m.location();
            bpr = mgr.createBreakpointRequest(location);
            bpr.enable();
        }
    }

    public static Connector getConnector() {
        List<Connector> connectors = Bootstrap.virtualMachineManager().allConnectors();
        for (Connector c : connectors) {
            if (!c.name().equals("com.sun.jdi.SocketAttach")) continue;
            return c;
        }
        return null;
    }
}

