/*
 * Decompiled with CFR 0.152.
 */
package com.wuntee.oter.command;

import com.wuntee.oter.command.AbstractCommand;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import org.apache.log4j.Logger;

public class BackgroundCommand
extends AbstractCommand {
    private static Logger logger = Logger.getLogger(BackgroundCommand.class);
    private boolean running = false;
    protected BufferedReader stdout;
    protected BufferedReader stderr;
    protected BufferedWriter stdin;

    public BackgroundCommand(String[] command) {
        super(command);
    }

    public BackgroundCommand(String command) {
        super(command);
    }

    @Override
    public int execute() throws Exception {
        logger.debug((Object)"Execute");
        String fullCommand = "";
        int i = 0;
        while (i < this.command.length) {
            fullCommand = String.valueOf(fullCommand) + " " + this.command[i];
            ++i;
        }
        logger.debug((Object)("Executing background: " + fullCommand));
        this.running = true;
        this.child = Runtime.getRuntime().exec(this.command);
        this.stdout = new BufferedReader(new InputStreamReader(this.child.getInputStream()));
        this.stderr = new BufferedReader(new InputStreamReader(this.child.getErrorStream()));
        this.stdin = new BufferedWriter(new OutputStreamWriter(this.child.getOutputStream()));
        logger.debug((Object)"Returning from executing background command.");
        return 0;
    }

    public void close() {
        this.running = false;
        this.child.destroy();
    }

    public BufferedReader getStdout() {
        return this.stdout;
    }

    public BufferedReader getStderr() {
        return this.stderr;
    }

    @Override
    public void checkError() {
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public BufferedWriter getStdin() {
        return this.stdin;
    }
}

