/*
 * Decompiled with CFR 0.152.
 */
package com.wuntee.oter.avd;

import com.android.prefs.AndroidLocation;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.ISdkLog;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.SdkManager;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.wuntee.oter.OterStatics;
import com.wuntee.oter.command.BackgroundCommand;
import com.wuntee.oter.exception.GenericException;
import com.wuntee.oter.view.bean.CreateAvdBean;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class AvdWorkshop {
    private static Logger logger = Logger.getLogger(AvdWorkshop.class);

    public static AvdInfo createAvd(CreateAvdBean bean) throws AndroidLocation.AndroidLocationException, IOException, GenericException {
        ISdkLog sdkLogger = AvdWorkshop.getAvdLogger();
        SdkManager sdkManager = SdkManager.createManager((String)OterStatics.getAndroidHome(), (ISdkLog)sdkLogger);
        AvdManager avdManager = new AvdManager(sdkManager, sdkLogger);
        File avdFolder = new File(String.valueOf(AndroidLocation.getFolder()) + "avd", String.valueOf(bean.getName()) + ".avd");
        IAndroidTarget target = AvdWorkshop.getAndroidTargetFromString(sdkManager, bean.getTarget());
        ISystemImage[] abiTypes = target.getSystemImages();
        if (abiTypes.length == 0) {
            throw new GenericException("There are no images associated with the target.");
        }
        String abiType = abiTypes[0].getAbiType();
        AvdInfo ret = avdManager.createAvd(avdFolder, bean.getName(), target, abiType, null, null, null, false, false, false, sdkLogger);
        if (ret == null) {
            logger.error((Object)"There was an error createing AVD, the manager returned a null info object.");
            throw new GenericException("Could not create AVD for an unknown reason.");
        }
        if (bean.isPersistant()) {
            AvdWorkshop.makeAvdPersistant(ret);
        }
        return ret;
    }

    public static boolean isAvdExist(String avd) throws AndroidLocation.AndroidLocationException {
        ISdkLog sdkLogger = AvdWorkshop.getAvdLogger();
        SdkManager sdkManager = SdkManager.createManager((String)OterStatics.getAndroidHome(), (ISdkLog)sdkLogger);
        AvdManager avdManager = new AvdManager(sdkManager, sdkLogger);
        AvdInfo[] avdInfoArray = avdManager.getAllAvds();
        int n = avdInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            AvdInfo i = avdInfoArray[n2];
            if (i.getName().equals(avd)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void makeAvdPersistant(AvdInfo info) throws IOException {
        File f;
        ISystemImage iSysImg;
        int n;
        int n2;
        ISystemImage[] iSystemImageArray;
        logger.debug((Object)("Makeing AVD: " + info.getName() + " persistant."));
        File avdPath = new File(info.getDataFolderPath());
        ISystemImage[] sysImages = null;
        if (!info.getTarget().isPlatform()) {
            iSystemImageArray = info.getTarget().getParent().getSystemImages();
            n2 = iSystemImageArray.length;
            n = 0;
            while (n < n2) {
                iSysImg = iSystemImageArray[n];
                f = new File(iSysImg.getLocation().getAbsoluteFile() + System.getProperty("file.separator") + "system.img");
                FileUtils.copyFileToDirectory((File)f, (File)avdPath);
                ++n;
            }
        }
        sysImages = info.getTarget().getSystemImages();
        iSystemImageArray = info.getTarget().getSystemImages();
        n2 = iSystemImageArray.length;
        n = 0;
        while (n < n2) {
            iSysImg = iSystemImageArray[n];
            f = new File(iSysImg.getLocation().getAbsoluteFile() + System.getProperty("file.separator") + "system.img");
            FileUtils.copyFileToDirectory((File)f, (File)avdPath);
            ++n;
        }
        File sysImg = new File(avdPath + System.getProperty("file.separator") + "system.img");
        if (sysImg.exists()) {
            sysImg.renameTo(new File(avdPath + System.getProperty("file.separator") + "system-qemu.img"));
        }
    }

    private static void copyDirContentsToDir(String firstDir, String destDir) throws IOException {
        logger.debug((Object)("Copyting '" + firstDir + "*' to '" + destDir + "'"));
        File src = new File(firstDir);
        File dst = new File(destDir);
        File[] fileArray = src.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File x = fileArray[n2];
            FileUtils.copyFileToDirectory((File)x, (File)dst);
            ++n2;
        }
    }

    public static IAndroidTarget getAndroidTargetFromString(SdkManager sdkManager, String target) {
        IAndroidTarget[] iAndroidTargetArray = sdkManager.getTargets();
        int n = iAndroidTargetArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAndroidTarget t = iAndroidTargetArray[n2];
            if (t.hashString().equals(target)) {
                return t;
            }
            ++n2;
        }
        return null;
    }

    public static void launchAvd(AvdInfo avd) throws Exception {
        String avdName = "@" + avd.getName();
        BackgroundCommand c = new BackgroundCommand(new String[]{OterStatics.getEmulatorCommand(), "-partition-size", "1024", avdName});
        c.execute();
    }

    public static void launchPersistantAvd(AvdInfo avd) throws Exception {
        String avdName = "@" + avd.getName();
        String sysImage = String.valueOf(avd.getDataFolderPath()) + System.getProperty("file.separator") + "system-qemu.img";
        BackgroundCommand c = new BackgroundCommand(new String[]{OterStatics.getEmulatorCommand(), "-system", sysImage, "-partition-size", "1024", avdName});
        c.execute();
    }

    public static ISdkLog getAvdLogger() {
        ISdkLog sdkLogger = new ISdkLog(){

            public void error(Throwable t, String errorFormat, Object[] args) {
                logger.error((Object)"Error: ", t);
            }

            public void warning(String warningFormat, Object[] args) {
                logger.warn((Object)args);
            }

            public void printf(String msgFormat, Object[] args) {
                logger.debug((Object)args);
            }
        };
        return sdkLogger;
    }
}

