/*
 * Decompiled with CFR 0.152.
 */
package com.wuntee.oter.avd;

import com.android.prefs.AndroidLocation;
import com.android.sdklib.internal.avd.AvdInfo;
import com.wuntee.oter.avd.AvdWorkshop;
import com.wuntee.oter.view.Gui;
import com.wuntee.oter.view.GuiWorkshop;
import com.wuntee.oter.view.bean.CreateAvdBean;
import java.io.IOException;
import org.apache.log4j.Logger;

public class AvdController {
    private static Logger logger = Logger.getLogger(AvdController.class);
    private Gui gui;

    public AvdController(Gui gui) {
        this.gui = gui;
    }

    public void createAvd(CreateAvdBean bean) {
        try {
            AvdInfo avd = AvdWorkshop.createAvd(bean);
            if (bean.isLaunch()) {
                if (bean.isPersistant()) {
                    AvdWorkshop.launchPersistantAvd(avd);
                } else {
                    AvdWorkshop.launchAvd(avd);
                }
            } else {
                GuiWorkshop.messageDialog(this.gui.getShell(), "The AVD '" + bean.getName() + "' has sucessfully been created!");
            }
        }
        catch (AndroidLocation.AndroidLocationException e) {
            GuiWorkshop.messageError(this.gui.getShell(), "Could not create AVD: " + e.getMessage());
            logger.error((Object)"Could not create AVD:", (Throwable)e);
        }
        catch (IOException e) {
            GuiWorkshop.messageError(this.gui.getShell(), "Could not copy base image files to AVD directory: " + e.getMessage());
            logger.error((Object)"Could not copy base image files to AVD directory: ", (Throwable)e);
        }
        catch (Exception e) {
            GuiWorkshop.messageError(this.gui.getShell(), "Could not launch the emulator: " + e.getMessage());
            logger.error((Object)"Could not launch the emulator", (Throwable)e);
        }
    }
}

