/*
 * Decompiled with CFR 0.152.
 */
package com.wuntee.oter.aapt.androidmanifest;

import com.wuntee.oter.OterStatics;
import com.wuntee.oter.aapt.androidmanifest.AndroidManifestAttribute;
import com.wuntee.oter.aapt.androidmanifest.AndroidManifestElement;
import com.wuntee.oter.aapt.androidmanifest.AndroidManifestNamespace;
import com.wuntee.oter.aapt.androidmanifest.AndroidManifestObject;
import com.wuntee.oter.command.TerminatingCommand;
import com.wuntee.oter.exception.CommandFailedException;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

public class AndroidManifestWorkshop {
    private static Logger logger = Logger.getLogger(AndroidManifestWorkshop.class);

    public static void printTree(AndroidManifestObject o) {
        AndroidManifestWorkshop.printRecur(o, "");
    }

    private static void printRecur(AndroidManifestObject o, String prefix) {
        logger.debug((Object)(String.valueOf(prefix) + o));
        if (o.getChildren().size() > 0) {
            for (AndroidManifestObject child : o.getChildren()) {
                AndroidManifestWorkshop.printRecur(child, String.valueOf(prefix) + "  ");
            }
        }
    }

    public static AndroidManifestObject getAndroidManifestObjectsForApk(File apkFile) throws CommandFailedException, InterruptedException, IOException {
        AndroidManifestObject root = null;
        TerminatingCommand cmd = new TerminatingCommand(new String[]{OterStatics.getAaptCommand(), "d", "xmltree", apkFile.getAbsolutePath(), "AndroidManifest.xml"});
        int r = cmd.executeNoErrorMonitor();
        logger.debug((Object)("Command returned: " + r));
        AndroidManifestObject lastObject = null;
        int lastDepth = 0;
        int currentDepth = 0;
        for (String line : cmd.getOutput()) {
            logger.debug((Object)line);
            while (line.charAt(currentDepth) == ' ') {
                ++currentDepth;
            }
            currentDepth /= 2;
            String trimLine = line.trim();
            AndroidManifestObject o = null;
            if (trimLine.startsWith("E:")) {
                o = AndroidManifestElement.parse(trimLine);
            } else if (trimLine.startsWith("A:")) {
                o = AndroidManifestAttribute.parse(trimLine);
            } else if (trimLine.startsWith("N:")) {
                o = AndroidManifestNamespace.parse(trimLine);
            }
            logger.debug((Object)o.toString());
            if (currentDepth == 0) {
                root = o;
            } else if (currentDepth > lastDepth) {
                o.setParent(lastObject);
                lastObject.addChild(o);
            } else if (currentDepth < lastDepth) {
                int diff = lastDepth - currentDepth;
                AndroidManifestObject peer = lastObject;
                int i = 0;
                while (i < diff) {
                    peer = peer.getParent();
                    ++i;
                }
                peer.getParent().addChild(o);
                o.setParent(peer.getParent());
            } else if (currentDepth == lastDepth) {
                o.setParent(lastObject.getParent());
                lastObject.getParent().addChild(o);
            }
            lastObject = o;
            lastDepth = currentDepth;
        }
        return root;
    }
}

