/*
 * Decompiled with CFR 0.152.
 */
package com.wuntee.oter;

import com.wuntee.oter.OterStatics;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class OterWorkshop {
    private static Logger logger = Logger.getLogger(OterWorkshop.class);

    public static void addAndroidjarToClasspath() throws Exception {
        String androidHome = OterWorkshop.getProperty(OterStatics.PROPERTY_ANDROID_HOME);
        if (androidHome == null) {
            throw new Exception("Please configure android SDK location in configuration first.");
        }
        Collection files = FileUtils.listFiles((File)new File(androidHome), (String[])new String[]{"jar"}, (boolean)true);
        for (File f : files) {
            if (!f.getAbsolutePath().endsWith("android.jar")) continue;
            Properties prop = OterWorkshop.getProperties();
            String currentClasspath = prop.getProperty(OterStatics.PROPERTY_JAVATOSMALI_CLASSPATH);
            String newClasspath = "";
            newClasspath = currentClasspath.split(":").length == 0 ? f.getAbsolutePath() : String.valueOf(currentClasspath) + ":" + f.getAbsolutePath();
            prop.setProperty(OterStatics.PROPERTY_JAVATOSMALI_CLASSPATH, newClasspath);
            OterWorkshop.writeProp(prop, new File(OterStatics.getConfigFileName()));
            return;
        }
        throw new Exception("Could not find android.jar in: " + androidHome);
    }

    public static String getProperty(String key) {
        return OterWorkshop.getProperties().getProperty(key);
    }

    public static Properties getProperties() {
        Properties prop = new Properties();
        File propFile = new File(OterStatics.getConfigFileName());
        if (!propFile.exists()) {
            OterWorkshop.writeDefaultProp(propFile);
        } else {
            logger.info((Object)("Loading prop file: " + OterStatics.getConfigFileName()));
            try {
                prop.load(new FileInputStream(OterStatics.getConfigFileName()));
            }
            catch (FileNotFoundException e) {
                logger.error((Object)("File not found: " + e.getMessage()));
            }
            catch (IOException e) {
                logger.error((Object)"Couldnt read properties file");
                prop = OterWorkshop.getDefaultProp();
            }
            if (prop.isEmpty() || prop.get(OterStatics.PROPERTY_LOGCAT_MAXLINES) == null) {
                prop = OterWorkshop.writeDefaultProp(propFile);
            }
        }
        return prop;
    }

    private static Properties writeDefaultProp(File propFile) {
        Properties prop = OterWorkshop.getDefaultProp();
        OterWorkshop.writeProp(prop, propFile);
        return prop;
    }

    private static Properties writeProp(Properties prop, File propFile) {
        try {
            prop.store(new FileOutputStream(propFile), null);
        }
        catch (Exception e) {
            logger.error((Object)"Could not write properties file:", (Throwable)e);
        }
        return prop;
    }

    private static Properties getDefaultProp() {
        Properties prop = new Properties();
        prop.put(OterStatics.PROPERTY_LOGCAT_MAXLINES, "10000");
        return prop;
    }

    public static File createTemporaryDirectory(String prefix) throws IOException {
        File tmp = File.createTempFile(prefix, Long.toString(System.nanoTime()));
        logger.debug((Object)("Creating temporary directory: " + tmp.getAbsolutePath()));
        tmp.delete();
        tmp.mkdir();
        tmp.deleteOnExit();
        return tmp;
    }

    public static File createDirectoryRecursive(String directory) throws IOException {
        File f = new File(FilenameUtils.separatorsToSystem((String)directory));
        FileUtils.forceMkdir((File)f);
        return f;
    }

    public static void unzipArchive(File archive, File outputDir) {
        try {
            ZipFile zipfile = new ZipFile(archive);
            Enumeration<? extends ZipEntry> e = zipfile.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                OterWorkshop.unzipEntry(zipfile, entry, outputDir);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Error while extracting file " + archive), (Throwable)e);
        }
    }

    private static void unzipEntry(ZipFile zipfile, ZipEntry entry, File outputDir) throws IOException {
        if (entry.isDirectory()) {
            OterWorkshop.createDir(new File(outputDir, entry.getName()));
        } else {
            File outputFile = new File(outputDir, entry.getName());
            if (!outputFile.getParentFile().exists()) {
                OterWorkshop.createDir(outputFile.getParentFile());
            }
            logger.debug((Object)("Extracting: " + entry));
            BufferedInputStream inputStream = new BufferedInputStream(zipfile.getInputStream(entry));
            BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(outputFile));
            try {
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
            finally {
                outputStream.close();
                inputStream.close();
            }
        }
    }

    private static void createDir(File dir) {
        logger.debug((Object)("Creating dir " + dir.getName()));
        dir.mkdirs();
    }

    public static void zipArchive(File destArchive, File baseDirectory) throws IOException {
        logger.debug((Object)("Creating zip file: " + destArchive + ", from base: " + baseDirectory));
        ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(destArchive)));
        OterWorkshop.addDirToZip(baseDirectory, baseDirectory, out);
        out.close();
    }

    private static void addDirToZip(File baseDirectory, File directory, ZipOutputStream zipOutputStream) throws IOException {
        String[] files;
        String[] stringArray = files = directory.list();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            String fullFilePath = directory.getAbsoluteFile() + System.getProperty("file.separator") + file;
            File fullFilePathFileObj = new File(fullFilePath);
            String zipFilePath = fullFilePath.substring(baseDirectory.getAbsolutePath().length() + 1);
            logger.debug((Object)("Adding: " + zipFilePath));
            if (fullFilePathFileObj.isDirectory()) {
                OterWorkshop.addDirToZip(baseDirectory, fullFilePathFileObj, zipOutputStream);
            } else {
                OterWorkshop.addFileToZip(zipFilePath, fullFilePath, zipOutputStream);
            }
            ++n2;
        }
    }

    private static void addFileToZip(String zipFilePath, String fullFilePath, ZipOutputStream zipOutputStream) throws IOException {
        int count;
        int BUFFER_SIZE = 2048;
        ZipEntry entry = new ZipEntry(zipFilePath);
        zipOutputStream.putNextEntry(entry);
        FileInputStream fis = new FileInputStream(fullFilePath);
        BufferedInputStream origin = new BufferedInputStream(fis, BUFFER_SIZE);
        byte[] data = new byte[BUFFER_SIZE];
        while ((count = origin.read(data, 0, BUFFER_SIZE)) != -1) {
            zipOutputStream.write(data, 0, count);
        }
        origin.close();
    }

    public static String classPathToFilePath(String clazz) {
        return clazz.replace(".", System.getProperty("file.separator"));
    }
}

