#ifndef YDWERPGScoresIncluded
#define YDWERPGScoresIncluded

#include "YDWEReplayHelper.j"

library YDWERPGScores requires YDWEReplayWriter
	private function ToLetter takes integer i returns string
		return SubString("ABCDEFGHIJKLMNOPQRSTUVWXYZ", i, i+1)
	endfunction

	function YDWERPGGetKey takes player p, string key returns integer
		return YDWEReadFromReplay(ToLetter(GetPlayerId(p)), key)
	endfunction

	function YDWERPGSetKey takes player p, string key, integer value returns nothing
		call YDWEWriteToReplay(ToLetter(GetPlayerId(p)) + "=", key, value)
	endfunction

	function YDWERPGAddKey takes player p, string key, integer value returns nothing
		call YDWEWriteToReplay(ToLetter(GetPlayerId(p)) + "+", key, value)
	endfunction

	function YDWERPGGameEnd takes nothing returns nothing
		call YDWEWriteToReplay("$", "GameEnd", 0)
	endfunction
endlibrary

#endif
