#ifndef _NETDEV_H_
#define _NETDEV_H_

#ifdef  __cplusplus
extern "C"{
#endif

#ifndef STATIC
    #define STATIC                  static
#endif

#ifndef CONST
    #define CONST                   const
#endif

#ifndef EXTERN
    #define EXTERN                  extern
#endif

#ifndef INLINE
    #define INLINE                  __inline
#endif

#ifndef UNION
    #define UNION                   union
#endif

#ifndef IN
    #define IN
#endif

#ifndef OUT
    #define OUT
#endif

#ifndef INOUT
    #define INOUT
#endif

#ifndef NEWINTERFACE
    #define NEWINTERFACE
#endif

#if defined(WIN32)  /* windows */
#if defined(NETDEV_SDK_DLL)
#define NETDEV_API                  __declspec(dllexport)
#else
#define NETDEV_API                  __declspec(dllimport)
#endif
#else
#define NETDEV_API
#endif

/* ׼Լ Standard function calling convention */
#ifdef i386
    #ifndef STDCALL
        #define STDCALL                 __attribute__((stdcall))
    #endif
#else
    #ifndef WIN32
    #ifndef STDCALL
        #define STDCALL
    #endif
#else
    #ifndef STDCALL
        #define STDCALL                 __stdcall
    #endif
#endif

#endif

#ifndef CHAR_DEF
#define CHAR_DEF
    typedef char                    CHAR;
#endif

#ifndef BYTE_DEF
#define BYTE_DEF
    typedef unsigned char           BYTE;
#endif

#ifndef UINT16_DEF
#define UINT16_DEF
    typedef unsigned short          UINT16;
#endif

#ifndef UINT_DEF
#define UINT_DEF
    typedef unsigned int            UINT32;
#endif

#ifndef INT16_DEF
#define INT16_DEF
    typedef  short                  INT16;
#endif

#ifndef INT32_DEF
#define INT32_DEF
    typedef  int                    INT32;
#endif

#ifndef LPVOID_DEF
#define LPVOID_DEF
    typedef void*                   LPVOID;
#endif

#ifndef VOID
#ifndef VOID_DEF
#define VOID_DEF
    typedef void                    VOID;
#endif
#endif

#ifndef INT64_DEF
#define INT64_DEF
    typedef long long               INT64;
#endif

#ifndef BOOL_DEF
#define BOOL_DEF
    typedef int                     BOOL;
#endif

#ifndef FLOAT
#ifndef VOID_FLOAT
#define VOID_FLOAT
    typedef float                   FLOAT;
#endif
#endif

#ifndef FALSE
    #define FALSE                   0
#endif

#ifndef TRUE
    #define TRUE                    1
#endif

#ifndef WIN32
    typedef LPVOID                 HWND;
#endif

/********************************** Ժ궨  Definition of debugging macros *************** */

/* #define __SDK_DEBUG_ENABLE__      1


/********************************** ֵ  Commonly used numerical macros *************** */

/* IDʶ  Length of stream ID*/
#define NETDEV_STREAM_ID_LEN                    32

/* ļ  Length of filename */
#define NETDEV_FILE_NAME_LEN                    (256u)

/* û󳤶  Maximum length of username */
#define NETDEV_USER_NAME_LEN                    32

/* 󳤶  Maximum length of password */
#define NETDEV_PASSWD_LEN                       64

/* û¼룬Ŀַܺ  Length of password and encrypted passcode for user login */
#define NETDEV_PASSWD_ENCRYPT_LEN               64

/* ԴϢַ  Length of resource code string */
#define NETDEV_RES_CODE_LEN                     48

/* 󳤶  Maximum length of domain name */
#define NETDEV_DOMAIN_LEN                       64

/* 豸󳤶  Maximum length of device name */
#define NETDEV_DEVICE_NAME_LEN                  32

/* ·󳤶  Maximum length of path */
#define NETDEV_PATH_LEN_WITHOUT_NAME            64

/* ·󳤶:ļ  Maximum length of path, including filename */
#define NETDEV_PATH_LEN                         128

/* Emailַ󳤶  Maximum length of email address */
#define NETDEV_EMAIL_NAME_ADDR                  32

/* Macַ  Length of MAC address */
#define NETDEV_MAC_ADDR_LEN                     6

/* gsoapendpoint  Length of endpoint called by gSOAP */
#define NETDEV_ENDPOINT_LEN                     96

/* ID󳤶  Maximum length of session ID */
#define NETDEV_SESSION_ID_LEN                   16

/* URL 󳤶  Maximum length of URL */
#define NDE_MAX_URL_LEN                         260

/* ͨó  Common length */
#define NETDEV_LEN_4                            4
#define NETDEV_LEN_8                            8
#define NETDEV_LEN_32                           32
#define NETDEV_LEN_64                           64
#define NETDEV_LEN_132                          132
#define NETDEV_LEN_260                          260

/* IP ַϢַ  Length of IP address string */
#define NETDEV_IPADDR_STR_MAX_LEN              (64u)

/* ַͨ  Length of common name string */
#define NETDEV_NAME_MAX_LEN                    (20u)

/* ͨCODE   Length of common code */
#define NETDEV_CODE_STR_MAX_LEN                (48u)

/* ַ Maximum length of date string "2008-10-02 09:25:33.001 GMT" */
#define NETDEV_MAX_DATE_STRING_LEN             (64u)

/* ʱϢַ Length of time string "hh:mm:ss" */
#define NETDEV_SIMPLE_TIME_LEN                 (12u)

/* Ϣַ Length of date string "YYYY-MM-DD"*/
#define NETDEV_SIMPLE_DATE_LEN                 (12u)

/* 澯  Maximum number of alarm inputs */
#define NETDEV_MAX_ALARM_IN_NUM                 64

/* 澯  Maximum number of alarm outputs */
#define NETDEV_MAX_ALARM_OUT_NUM                64

/* һеļƻʱ  Number of scheduled time sections in a day */
#define NETDEV_PLAN_SECTION_NUM                 8

/* һܹõļƻһպͼ  Total number of plans allowed in a week, including Monday to Sunday, and holidays */
#define NETDEV_PLAN_NUM_AWEEK                   8

/* ƶ  Maximum number of motion detection areas allowed */
#define NETDEV_MAX_MOTION_DETECT_AREA_NUM       4

/* ڸ  Maximum number of privacy mask areas allowed */
#define NETDEV_MAX_PRIVACY_MASK_AREA_NUM        4

/* ڵ  Maximum number of tamper-proof areas allowed */
#define NETDEV_MAX_TAMPER_PROOF_AREA_NUM        1

/* ַͨ  Maximum number of text overlays allowed for a channel */
#define NETDEV_MAX_TEXTOVERLAY_NUM              6

/* Ƶͨ  Maximum number of video streams */
#define NETDEV_MAX_VIDEO_STREAM_NUM             8

/* /ÿ  Month of the year */
#define NETDEV_MONTH_OF_YEAR                    12

/* /ÿ  Day of the month */
#define NETDEV_DAYS_OF_MONTH                    32

/* 豸ID  Length of device ID */
#define NETDEV_DEV_ID_LEN                       64

/* 豸кų  Length of device serial number */
#define NETDEV_SERIAL_NUMBER_LEN                32

/* ѯ  Maximum number of queries allowed at a time */
#define NETDEV_MAX_QUERY_NUM                    200

/* ܹѯ  Total number of queries allowed */
#define NETDEV_MAX_QUERY_TOTAL_NUM              2000

/* IPC  Maximum number of IP cameras */
#define NETDEV_MAX_IPC_NUM                      128

/* Ԥλ  Maximum number of presets */
#define NETDEV_MAX_PRESET_NUM                   256

/* Ѳ·Ԥλ  Maximum number of presets for preset patrol */
#define NETDEV_MAX_CRUISEPOINT_NUM              32

/* ԤλѲ·  Maximum number of routes for preset patrol */
#define NETDEV_MAX_CRUISEROUTE_NUM              16

/* ̨ƶٶ  PTZ rotating speed */
#define NETDEV_MIN_PTZ_SPEED_LEVEL              1
#define NETDEV_MAX_PTZ_SPEED_LEVEL              9

/* ͼ Աȶ ɫ Ͷȣ/Сֵ  Maximum / Minimum values for image parameters (brightness, contrast, hue, saturation) */
#define NETDEV_MIN_VIDEO_EFFECT_VALUE           0
#define NETDEV_MAX_VIDEO_EFFECT_VALUE          255

/* ͼ٤ֵֵ Minimum values for image parameters (Gama) */
#define NETDEV_MAX_VIDEO_EFFECT_GAMMA_VALUE     10

/* ӳʱʱֵ  Maximum connection timeout */
#define NETDEV_MAX_CONNECT_TIME_VALUE           75000

/* ӳʱʱСֵ  Minimum connection timeout */
#define NETDEV_MIN_CONNECT_TIME_VALUE           300

/* û  Maximum number of users */
#define NETDEV_MAX_USER_NUM                     (256 + 32)

/* ʵʱԤ·  Maximum number of channels allowed for live preview */
#define NETDEV_MAX_REALPLAY_NUM                 128

/* طŻص·  Maximum number of channels allowed for playback or download */
#define NETDEV_MAX_PALYBACK_NUM                 128

/* ͨ·  Maximum number of alarm channels */
#define NETDEV_MAX_ALARMCHAN_NUM                128

/* Ӳ̸ʽ·  Maximum number of channels allowed for formatting hard disk */
#define NETDEV_MAX_FORMAT_NUM                   128

/* ļ·  Maximum number of channels allowed for file search */
#define NETDEV_MAX_FILE_SEARCH_NUM              2000

/* ־·  Maximum number of channels allowed for log search */
#define NETDEV_MAX_LOG_SEARCH_NUM               2000

/* ͸ͨ·  Maximum number of channels allowed for creating transparent channels */
#define NETDEV_MAX_SERIAL_NUM                   2000

/* ·  Maximum number of channels allowed for upgrade */
#define NETDEV_MAX_UPGRADE_NUM                  256

/* ת·  Maximum number of channels allowed for audio forwarding */
#define NETDEV_MAX_VOICE_COM_NUM                256

/* 㲥·  Maximum number of channels allowed for audio broadcast */
#define NETDEV_MAX_VOICE_BROADCAST_NUM          256

/* ʱʱֵλ  Maximum timeout, unit: ms */
#define NETDEV_MAX_CONNECT_TIME                 75000

/* ʱʱСֵλ  Minimum timeout, unit: ms */
#define NETDEV_MIN_CONNECT_TIME                 300

/* ʱʱĬֵλ  Default timeout, unit: ms */
#define NETDEV_DEFAULT_CONNECT_TIME             3000

/* ӳԴ  Number of connection attempts */
#define NETDEV_CONNECT_TRY_TIMES                1

/* ûʧܴ  User keep-alive interval */
#define NETDEV_KEEPLIVE_TRY_TIMES               3

/* ͨ OSD ַ  Number of OSD text overlays */
#define NETDEV_OSD_TEXTOVERLAY_NUM              6

/* ͨ OSD ַ  Length of OSD texts */
#define NETDEV_OSD_TEXT_MAX_LEN                 (64u)

/* 澯澯  Maximum number of alarms a user can get */
#define NETDEV_PULL_ALARM_MAX_NUM               8

/* ֵ֧Ĺ켣Ѳ  Maximum number of patrol routes allowed  */
#define NETDEV_TRACK_CRUISE_MAXNUM               1

/* Сֵ  Minimum volume */
#define PLAYER_AUDIO_SOUND_MIN_VALUE            0

/* ֵ  Maximum volume */
#define PLAYER_AUDIO_SOUND_MAX_VALUE            255

/* ĻϢ  Screen Info Row */
#define NETDEV_SCREEN_INFO_ROW                    18

/* ĻϢ  Screen Info Column */
#define NETDEV_SCREEN_INFO_COLUMN                 22

/* BEGIN****************************  Error codes ************************************************************/
#define NETDEV_E_SUCCEED                        0           /* ɹ  Succeeded*/
#define NETDEV_E_FAILED                         -1          /* ʧ  Failed*/

/* ͨô  Common error codes */
#define NETDEV_E_COMMON_FAILED                  1           /* ͨô  Common error */
#define NETDEV_E_DEV_COMMON_FAILED              2           /* 豸صͨô  Common error returned by device */
#define NETDEV_E_SYSCALL_FALIED                 3           /* ϵͳʧܣ鿴errno  Failed to call system function. See errno */
#define NETDEV_E_NULL_POINT                     4           /* ָ  Null pointer */
#define NETDEV_E_INVALID_PARAM                  5           /* Ч  Invalid parameter */
#define NETDEV_E_INVALID_MODULEID               6           /* ЧģID  Invalid module ID */
#define NETDEV_E_NO_MEMORY                      7           /* ڴʧ  Failed to allocate memory */
#define NETDEV_E_NOT_SUPPORT                    8           /* 豸֧  Not supported by device */
#define NETDEV_E_SDK_SOCKET_LSN_FAIL            9           /* socket listenʧ  Failed to create socket listen */
#define NETDEV_E_INIT_MUTEX_FAIL                10          /* ʼʧ  Failed to initialize lock */
#define NETDEV_E_INIT_SEMA_FAIL                 11          /* ʼźʧ  Failed to initialize semaphore */
#define NETDEV_E_ALLOC_RESOURCE_ERROR           12          /* SDKԴ  Error occurred during SDK resource allocation */
#define NETDEV_E_SDK_NOINTE_ERROR               13          /* SDKδʼ  SDK not initialized */
#define NETDEV_E_ALREDY_INIT_ERROR              14          /* SDKѾʼ  SDK already initialized */
#define NETDEV_E_HAVEDATA                       15          /*    Data not all sent */
#define NETDEV_E_NEEDMOREDATA                   16          /* Ҫ  More data required  */
#define NETDEV_E_CONNECT_ERROR                  17          /* ʧ  Failed to create connection */
#define NETDEV_E_SEND_MSG_ERROR                 18          /* Ϣʧ  Failed to send request message */
#define NETDEV_E_TIMEOUT                        19          /* Ϣʱ  Message timeout */
#define NETDEV_E_DECODE_RSP_ERROR               20          /* ӦϢʧ  Failed to decode response message */
#define NETDEV_E_SOCKET_RECV_ERROR              21          /* SocketϢʧ  Socket failed to receive message */
#define NETDEV_E_NUM_MAX_ERROR                  22          /* ﵽ󡣷עԤSDKֵ֧  Maximum number reached. The assigned numbers of registration connections and preview connections reached the maximum supported by SDK */
#define NETDEV_E_GET_PORT_ERROR                 24          /* ȡض˿ںʧ  Failed to obtain local port number */
#define NETDEV_E_CREATE_THREAD_FAIL             25          /* ߳ʧ  Failed to create thread */
#define NETDEV_E_NOENOUGH_BUF                   26          /* ̫С: 豸ݵĻ  Buffer is too small for receiving device data */
#define NETDEV_E_GETLOCALIPANDMACFAIL           27          /* ñPCIPַַʧ  Failed to obtain the IP or MAC address of the local PC */
#define NETDEV_E_RESCODE_NO_EXIST               28          /* Դ벻  Resource code not exist */
#define NETDEV_E_MSG_DATA_INVALID               31          /* Ϣݴ  Incorrect message content */
#define NETDEV_E_GET_CAPABILITY_ERROR           32          /* ȡʧ  Failed to obtain capabilities */
#define NETDEV_E_USER_NOT_BIND                  33          /* ûûжĸ澯   User not subscribed to alarms */
#define NETDEV_E_AUTHORIZATIONFAIL              34          /* ûȨʧ  User authentication failed */
#define NETDEV_E_BINDNOTIFY_FAIL                35          /* 󶨸澯ʧ  Failed to bind alarms*/
#define NDEDEV_E_NOTADMIN                       36          /* Ȩ޲㣬windowsһΪǹԱʺŲ Not enough permission. In Windows, it is normally because the operator is not an administrator. */
#define NDEDEV_E_DEVICE_FACTURER_ERR            37          /* ֵ֧豸 Manufacturers that are not supported */
#define NETDEV_E_NONSUPPORT                     38          /* ù֧ܲ  Function not supported */
#define NETDEV_E_TRANSFILE_FAIL                 39          /* ļʧ  File transmission failed */
#define NETDEV_E_JSON_ERROR                     40          /* Json ͨô  Json common error */

/* ûش  User-related error codes */
#define NETDEV_E_USER_WRONG_PASSWD              101         /* û  Incorrect password */
#define NETDEV_E_USER_LOGIN_MAX_NUM             102         /* û¼Ѵ  Number of login users reached the upper limit */
#define NETDEV_E_USER_NOT_ONLINE                103         /* û  User not online */
#define NETDEV_E_USER_NO_SUCH_USER              104         /* ûиû  User not online */
#define NETDEV_E_USER_NO_AUTH                   105         /* ûȨ  User has no rights */
#define NETDEV_E_USER_MAX_NUM                   106         /* û-ٱ  Reached the upper limitCno more users can be added */
#define NETDEV_E_USER_EXIST                     107         /* ûѴ  User already exists */
#define NETDEV_E_USER_PASSWORD_CHANGE           108         /* û޸  Password changed */

/* ҵش  Service-related error codes */

/* ʵش  Live video error codes */
#define NETDEV_E_LIVE_EXISTED                   150         /* ʵҵѾ  Live video service already established */
#define NETDEV_E_LIVE_INPUT_NOT_READY           151         /* ýδ׼  Media stream not ready */
#define NETDEV_E_LIVE_OUTPUT_BUSY               152         /* ʵҵʾԴæ  Display resource is busy for live video service */
#define NETDEV_E_LIVE_CB_NOTEXIST               153         /* ʵƿ鲻  Control module for live video not exist */
#define NETDEV_E_LIVE_STREAM_FULL               154         /* ʵԴ  Live stream resource full */

/* ץش  Capture-related error codes */
#define NETDEV_E_CAPTURE_NO_SUPPORT_FORMAT      200         /* ץĸʽ֧  Format of captured image not supported */
#define NETDEV_E_CAPTURE_NO_ENOUGH_CAPACITY     201         /* Ӳ̿ռ䲻  Insufficient disk space */
#define NETDEV_E_CAPTURE_NO_DECODED_PICTURE     202         /* ûнͼƬɹץ  No decoded image for capture */
#define NETDEV_E_CAPTURE_SINGLE_FAILED          203         /* ץĲʧ  Single capture failed */

/* طش  Playback-related error codes */
#define NETDEV_E_VOD_PLAY_END                   250         /* طŽ  Playback ended */
#define NETDEV_E_VOD_NO_CM                      251         /* طſƿ鲻  Playback controlling module not exist */
#define NETDEV_E_VOD_OVER_ABILITY               252         /* ط  Beyond playback capability */
#define NETDEV_E_VOD_NO_RECORDING_CM            253         /* ¼ļƿ鲻  Recording file controlling module not exist */
#define NETDEV_E_VOD_NO_RECORDING               254         /* ¼   No recording */
#define NETDEV_E_VOD_NO_REPLAYURL               255         /* ޷ȡطŵurl   Cannot get the URL for playback*/


/* ̨ش  PTZ-related error codes */
#define NETDEV_E_PTZ_SET_PRESET_FAILED              300         /* Ԥλʧ  Failed to set preset */
#define NETDEV_E_PTZ_QUERY_PRESET_FAILED            301         /* Ԥλѯʧ  Failed to query preset */
#define NETDEV_E_PTZ_QUERY_TRACK_FAILED             302         /* 켣ѯʧ  Failed to query route */
#define NETDEV_E_PTZ_START_RECORD_TRACK_FAILED      303         /* ʼ¼ƹ켣ʧ  Failed to start route recording */
#define NETDEV_E_PTZ_STOP_RECORD_TRACK_FAILED       304         /* ¼ƹ켣ʧ  Failed to end route recording */
#define NETDEV_E_PTZ_QUERY_CRUISE_FAILED            305         /* Ѳ·ѯʧ  Failed to query patrol route */
#define NETDEV_E_PTZ_SET_CRUISE_FAILED              306         /* Ѳ·ʧ  Failed to set patrol route */
#define NETDEV_E_PTZ_CTRL_FAILED                    307         /* ̨ʧ  PTZ operation failed */
#define NETDEV_E_PTZ_PRESET_IN_CRUISE               308         /* ԤλѲ·ʹ, ޷ɾ  Preset is being used in patrol route and cannot be deleted */
#define NETDEV_E_PTZ_CRUISEPOINT_ERR                309         /* Ѳ㲻  Discontinuous presets */
#define NETDEV_E_PTZ_TRACK_ISUSED                   310         /* 켣ʹã޷ɾ  Route is in use and cannot be deleted */
#define NETDEV_E_PTZ_SERIALMODE_MISMATCH            311         /* ģʽƥ  Serial modes do not match */
#define NETDEV_E_PTZ_TRACK_NOT_EXIST                312         /* 켣  Route does not exist */
#define NETDEV_E_PTZ_MODE_CRUISE_FULL               313         /* ģʽ·켣  Route points are full */

/* Խش  Error codes related to two-way audio */
#define NETDEV_E_AUDIO_EXISTED                       350         /* ԽѴ  Two-way audio already exists */
#define NETDEV_E_AUDIO_NO_EXISTED                    351         /* ҵ񲻴  Two-way audio service does not exist */
#define NETDEV_E_AUDIO_RESCODE_INVALID               352         /* ԽԴЧ  Invalid two-way audio resource code */
#define NETDEV_E_AUDIO_RES_USED_BY_TALK              353         /* ԴѱԽʹ  Audio resource is being used by two-way audio */
#define NETDEV_E_AUDIO_FAILED                        354         /* Խʧ  Two-way audio failed */
#define NETDEV_E_AUDIO_AUDIOBCAST_FULL               355         /* ҵ  No more audio service allowed */

/* SOAPش  SOAP-related error codes */
#define NETDEV_E_DEVICE_STREAM_FULL             500         /* 豸  Device stream full */
#define NETDEV_E_DEVICE_STREAM_CLOSED           501         /* 豸ѹر  Device stream closed */
#define NETDEV_E_DEVICE_STREAM_NONEXIST         502         /* 豸  Device stream does not exist */

#define NETDEV_E_COMMON_FAIL_STAT               503         /* ȡļĿ¼״̬ʧ  Failed to read file (directory) status */
#define NETDEV_E_COMMON_FILE_NONEXIST           504         /* ļ  File does not exist */
#define NETDEV_E_COMMON_MKDIR_ERR               505         /* Ŀ¼ʧ  Failed to create directory */
#define NETDEV_E_SUBSCRIBE_FULL                 506         /* û, 豸ûĴ벻ܷ  Subscription is full for current user */
#define NETDEV_E_UPGRADE_NOTADMIN               507         /* adminû޷  Only admin can upgrade */
#define NETDEV_E_UPGRADE_INVALID                508         /*  δʼ  Upgrade not started */
#define NETDEV_E_UPGRADE_INPROCESS              509         /*    Upgrade in process */
#define NETDEV_E_UPGRADE_NOMEMORY               510         /*  ڴռ䲻  Insufficient memory for upgrade */
#define NETDEV_E_UPGRADE_FILE_OPEN_ERR          511         /*  򿪾ļ  Error occurred while opening the mirror file during upgrade */
#define NETDEV_E_UPGRADE_DEVICE_ERR             512         /*  FLASH  Error occurred while upgrading FLASH */
#define NETDEV_E_UPGRADE_BUSY                   513         /* ͬʱض  Cannot load multiple upgrade processes at the same time */
#define NETDEV_E_UPGRADE_FAIL_TIMEOUT           514         /* ʱ  Upgrade timeout */
#define NETDEV_E_INVALID_CONFIGFILE             515         /* ļЧ  Invalid configuration file */
#define NETDEV_E_STOR_RESOURCE_NOTINIT          516         /* 洢Դδ  Storage resource not allocated */

/* END*********************   Error codes *********************************************************** */

/* BEGIN:****************** öֵ  Enumeration value ***************************************************** */

/**
 * @enum tagNETDEVChannelStatus
 * @brief ͨ״̬ öٶ Channel status Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVChannelStatus
{
    NETDEV_CHL_STATUS_OFFLINE,      /* ͨ  Channel offline */
    NETDEV_CHL_STATUS_ONLINE,       /* ͨ  Channel online */
    NETDEV_CHL_STATUS_VIDEO_LOST,   /* Ƶʧ  Video lost */
    NETDEV_CHL_STATUS_MAX,

    NETDEV_CHL_STATUS_BUTT
}NETDEV_CHANNEL_STATUS_E;

/**
 * @enum tagNETDEVCameraType
 * @brief  öٶ Camera type Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVCameraType
{
    NETDEV_CAMERA_TYPE_FIX         = 0,            /* ̶  Fixed camera */
    NETDEV_CAMERA_TYPE_PTZ         = 1,            /* ̨  PTZ camera */

    NETDEV_CAMERA_TYPE_INVALID     = 0xFF          /* Чֵ  Invalid value */
}NETDEV_CAMERA_TYPE_E;

/**
 * @enum tagNETDEVLiveStreamIndex
 * @brief ʵҵ öٶ  Live stream index Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVLiveStreamIndex
{
    NETDEV_LIVE_STREAM_INDEX_MAIN  = 0,   /*   Main stream */
    NETDEV_LIVE_STREAM_INDEX_AUX   = 1,   /*   Sub stream */
    NETDEV_LIVE_STREAM_INDEX_THIRD = 2,   /*   Third stream */

    NETDEV_LIVE_STREAM_INDEX_BUTT
}NETDEV_LIVE_STREAM_INDEX_E;

/**
 * @enum tagHOSTType
 * @brief IPЭ öٶ  Protocol type Enumeration definition
 * @attention  None
 */
typedef enum tagHOSTType
{
    NETDEV_NETWORK_HOSTTYPE_IPV4 = 0,               /* IPv4 */
    NETDEV_NETWORK_HOSTTYPE_IPV6 = 1,               /* IPv6 */
    NETDEV_NETWORK_HOSTTYPE_DNS  = 2                /* DNS */
}NETDEV_HOSTTYPE_E;


/**
 * @enum tagNETDEVProtocal
 * @brief ý崫Э öٶ  Media transport protocol Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVProtocal
{
    NETDEV_TRANSPROTOCAL_RTPTCP = 1,         /* TCP */
    NETDEV_TRANSPROTOCAL_RTPUDP = 2          /* UDP */
}NETDEV_PROTOCAL_E;

/**
 * @enum tagNETDEVMediaFileFormat
 * @brief ýļʽ öٶ  Media file format Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVMediaFileFormat
{
    NETDEV_MEDIA_FILE_MP4 = 0,           /* mp4ʽýļ  mp4 media file */
    NETDEV_MEDIA_FILE_TS = 1,            /* TSʽýļ  TS media file */
    NETDEV_MEDIA_FILE_BUTT
}NETDEV_MEDIA_FILE_FORMAT_E;

/**
 * @enum tagNETDEVVideoCodeType
 * @brief Ƶʽ öٶ  Video encoding format Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVVideoCodeType
{
    NETDEV_VIDEO_CODE_MJPEG = 0,          /* MJPEG */
    NETDEV_VIDEO_CODE_H264  = 1,          /* H.264 */
    NETDEV_VIDEO_CODE_BUTT
}NETDEV_VIDEO_CODE_TYPE_E;

/**
 * @enum tagNETDEVVideoFrameType
 * @brief Ƶ֡ öٶ  Video frame type Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVVideoFrameType
{
    NETDEV_VIDEO_FRAME_I = 0,               /* Ƶ֡ΪI֡  I-frame */
    NETDEV_VIDEO_FRAME_P = 1,               /* Ƶ֡ΪP֡  P-frame */
    NETDEV_VIDEO_FRAME_B = 2                /* Ƶ֡ΪB֡  B-frame */
}NETDEV_VIDEO_FRAME_TYPE_E;

/**
 * @enum tagNETDEVRenderScale
 * @brief Ƶʾ öٶ  Video display ratio Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVRenderScale
{
    NETDEV_RENDER_SCALE_FULL       = 0,                  /* ͼ   Stretch */
    NETDEV_RENDER_SCALE_PROPORTION = 1,                  /* ͼ񰴱ʾ  Scale */

    NETDEV_RENDER_SCALE_BUTT       = 0xFF
}NETDEV_RENDER_SCALE_E;

/**
 * @enum tagNETDEVPictureFormat
 * @brief ͼƬʽ öٶ Picture type Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVPictureFormat
{
    NETDEV_PICTURE_BMP = 0,                  /* ͼƬʽΪbmpʽ  Picture format is bmp */
    NETDEV_PICTURE_JPG = 1,                  /* ͼƬʽΪjpgʽ  Picture format is jpg */

    NETDEV_PICTURE_BUTT
}NETDEV_PICTURE_FORMAT_E;

/**
 * @enum tagNETDEVVideoQuality
 * @brief Ƶͼ öٶ  Video image quality Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVVideoQuality
{
    NETDEV_VQ_L0 = 0,                    /*   Highest */
    NETDEV_VQ_L1 = 1,
    NETDEV_VQ_L2 = 4,                    /* ϸ  Higher */
    NETDEV_VQ_L3 = 8,
    NETDEV_VQ_L4 = 12,                   /*   Medium */
    NETDEV_VQ_L5 = 16,
    NETDEV_VQ_L6 = 20,                   /*   Low */
    NETDEV_VQ_L7 = 24,
    NETDEV_VQ_L8 = 28,                   /* ϵ  Lower */
    NETDEV_VQ_L9 = 31,                   /*   Lowest */

    NETDEV_VQ_LEVEL_INVALID = -1,        /* Ч  Valid */
}NETDEV_VIDEO_QUALITY_E;

/**
 * @enum tagNETDEVPictureSize
 * @brief ͼֱ öٶ Image resolution Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVPictureSize
{
    NETDEV_PICTURE_SIZE_D1     = 0,           /* D1 */
    NETDEV_PICTURE_SIZE_4CIF   = 1,           /* 4CIF */
    NETDEV_PICTURE_SIZE_2CIF   = 2,           /* 2CIF */
    NETDEV_PICTURE_SIZE_CIF    = 3,           /* CIF */
    NETDEV_PICTURE_SIZE_960H   = 4,           /* 960H */
    NETDEV_PICTURE_SIZE_QCIF   = 5,           /* QCIF */
    NETDEV_PICTURE_SIZE_HALFD1 = 6,           /* HALFD1 */
    NETDEV_PICTURE_SIZE_720    = 7,           /* 720 */
    NETDEV_PICTURE_SIZE_1080   = 8,           /* 1080 */
    NETDEV_PICTURE_SIZE_XGA    = 9,           /* 1024*768 */
    NETDEV_PICTURE_SIZE_SXGA   = 10,          /* 1280*1024 */

    NETDEV_PICTURE_SIZE_INVALID               /* Чֵ  Invalid value */
}NETDEV_PICTURE_SIZE_E;

/**
 * @enum tagNETDEVPtzCmdEnum
 * @brief ̨ öٶ PTZ commands Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVPtzCmdEnum
{
#if 0
    NETDEV_PTZ_IRISCLOSE            =0x0102,       /* Ȧ  Iris close */
    NETDEV_PTZ_IRISOPEN             =0x0104,       /* Ȧ  Iris open */
    NETDEV_PTZ_FOCUSNEAR            =0x0202,       /* ۼ  Focus near */
    NETDEV_PTZ_FOCUSFAR             =0x0204,       /* Զۼ  Focus far */
#endif
    NETDEV_PTZ_ZOOMTELE             = 0x0302,       /* Ŵ  Zoom in */
    NETDEV_PTZ_ZOOMWIDE             = 0x0304,       /* С  Zoom out */
    NETDEV_PTZ_TILTUP               = 0x0402,       /*   Tilt up */
    NETDEV_PTZ_TILTDOWN             = 0x0404,       /*   Tilt down */
    NETDEV_PTZ_PANRIGHT             = 0x0502,       /*   Pan right */
    NETDEV_PTZ_PANLEFT              = 0x0504,       /*   Pan left */
    NETDEV_PTZ_LEFTUP               = 0x0702,       /*   Move up left */
    NETDEV_PTZ_LEFTDOWN             = 0x0704,       /*   Move down left */
    NETDEV_PTZ_RIGHTUP              = 0x0802,       /*   Move up right */
    NETDEV_PTZ_RIGHTDOWN            = 0x0804,       /*   Move down right */

#if 0
    NETDEV_PTZ_PRESAVE              = 0x0601,       /* Ԥλ  Save preset */
    NETDEV_PTZ_PRECALL              = 0x0602,       /* Ԥλ  Call preset */
    NETDEV_PTZ_PREDEL               = 0x0603,       /* Ԥλɾ  Delete preset */
#endif

    NETDEV_PTZ_ALLSTOP              = 0x0901,       /* ȫͣ  All-stop command word */

    NETDEV_PTZ_TRACKCRUISE          = 0x1001,       /* ʼ켣Ѳ  Start route patrol*/
    NETDEV_PTZ_TRACKCRUISESTOP      = 0x1002,       /* ֹͣ켣Ѳ  Stop route patrol*/
    NETDEV_PTZ_TRACKCRUISEREC       = 0x1003,       /* ʼ¼ƹ켣  Start recording route */
    NETDEV_PTZ_TRACKCRUISERECSTOP   = 0x1004,       /* ֹͣ¼ƹ켣  Stop recording route */
    NETDEV_PTZ_TRACKCRUISEADD       = 0x1005,       /* Ѳ켣  Add patrol route */
    NETDEV_PTZ_TRACKCRUISEDEL       = 0x1006,       /* ɾ켣Ѳ  Delete patrol route */

    NETDEV_PTZ_AREAZOOMIN           = 0x1101,       /* Ŵ  Zoom in area */
    NETDEV_PTZ_AREAZOOMOUT          = 0x1102,       /* С  Zoom out area */
    NETDEV_PTZ_AREAZOOM3D           = 0x1103,       /* 3Dλ  3D positioning */

    NETDEV_PTZ_BRUSHON              = 0x0A01,       /* ˢ  Wiper on */
    NETDEV_PTZ_BRUSHOFF             = 0x0A02,       /* ˢ  Wiper off */

    NETDEV_PTZ_LIGHTON              = 0x0B01,       /* ƿ  Lamp on */
    NETDEV_PTZ_LIGHTOFF             = 0x0B02,       /* ƹ  Lamp off */

    NETDEV_PTZ_HEATON               = 0x0C01,       /* ȿ  Heater on */
    NETDEV_PTZ_HEATOFF              = 0x0C02,       /* ȹ  Heater off */

    NETDEV_PTZ_SNOWREMOINGON        = 0x0D01,       /* ѩ  Snowremoval on */
    NETDEV_PTZ_SNOWREMOINGOFF       = 0x0D02,       /* ѩ  Snowremoval off  */

#if 0
    NETDEV_PTZ_ABSPOSITION          = 0x0902,       /* ԽǶ  Set absolute position of camera */
    NETDEV_PTZ_GUARD                = 0x0903,       /* ؿλ̨ģ  Return to home position (this command is not implemented on the PTZ template) */
    NETDEV_PTZ_SPEEDSET             = 0x0904,       /* ٶ  Set speed */

    NETDEV_PTZ_INFRAREDON           = 0x0E01,       /* ⿪  IR on */
    NETDEV_PTZ_INFRAREDOFF          = 0x0E02,       /*   IR off */

    NETDEV_PTZ_PRESETCRUISE         = 0x1001,       /* ̨ԤλѲ ֲ̨ģ  Preset-based PTZ patrol (the command word is not implemented on the PTZ template) */
    NETDEV_PTZ_PRESETCRUISESTOP     = 0x1002,       /* ̨ԤλѲֲֹ̨ͣģ  Preset-based PTZ patrol stop (the command word is not implemented on the PTZ template) */
    NETDEV_PTZ_CRUISEDEL            = 0X1003,       /* ɾ·  Delete route */
    NETDEV_PTZ_CRUISEADDPRESET      = 0x1004,       /* ·Ԥλ  Add preset to route */
    NETDEV_PTZ_CRUISEADDSTART       = 0x1005,       /* ʼ·Ԥλ  Start adding preset to route */
    NETDEV_PTZ_CRUISEADDSTOP        = 0x1006,       /* ·Ԥλ  Stop adding preset to route */
#endif

    NETDEV_PTZ_BUTT
} NETDEV_PTZ_E;

/**
 * @enum tagNETDEVPtzPresetCmd
 * @brief ̨Ԥλ öٶ PTZ preset operation commands Enumeration Definition
 * @attention  None
 */
typedef enum tagNETDEVPtzPresetCmd
{
    NETDEV_PTZ_SET_PRESET   = 0,            /* Ԥλ  Set preset */
    NETDEV_PTZ_CLE_PRESET   = 1,            /* Ԥλ  Clear preset */
    NETDEV_PTZ_GOTO_PRESET  = 2             /* תԤλ  Go to preset */
}NETDEV_PTZ_PRESETCMD_E;

/**
 * @enum tagNETDEVPTZCruiseCmd
 * @brief ̨Ѳ öٶ PTZ patrol operation commands Enumeration Definition
 * @attention  None
 */
typedef enum tagNETDEVPTZCruiseCmd
{
    NETDEV_PTZ_ADD_CRUISE      = 0,         /* Ѳ·   Add patrol route */
    NETDEV_PTZ_MODIFY_CRUISE   = 1,         /* ༭Ѳ·  Edit patrol route */
    NETDEV_PTZ_DEL_CRUISE      = 2,         /* ɾѲ·  Delete patrol route */
    NETDEV_PTZ_RUN_CRUISE      = 3,         /* ʼѲ  Start patrol */
    NETDEV_PTZ_STOP_CRUISE     = 4          /* ֹͣѲ  Stop patrol */
}NETDEV_PTZ_CRUISECMD_E;

/**
 * @enum tagNETDEVPlayControl
 * @brief طſ öٶ Playback control commands Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVPlayControl
{
    NETDEV_PLAY_CTRL_PLAY            = 0,           /* ʼ  Play */
    NETDEV_PLAY_CTRL_PAUSE           = 1,           /* ͣ  Pause */
    NETDEV_PLAY_CTRL_RESUME          = 2,           /* ָ  Resume */
    NETDEV_PLAY_CTRL_GETPLAYTIME     = 3,           /* ȡŽ  Obtain playing time */
    NETDEV_PLAY_CTRL_SETPLAYTIME     = 4,           /* òŽ  Configure playing time */
    NETDEV_PLAY_CTRL_GETPLAYSPEED    = 5,           /* ȡٶ  Obtain playing speed */
    NETDEV_PLAY_CTRL_SETPLAYSPEED    = 6            /* òٶ  Configure playing speed */
}NETDEV_VOD_PLAY_CTRL_E;

/**
 * @enum tagNETDEVVodPlayStatus
 * @brief طš״̬ öٶ Playback and download status Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVVodPlayStatus
{
/** ״̬  Play status */
    NETDEV_PLAY_STATUS_16_BACKWARD        = 0,        /* 16ٺ˲  Backward at 16x speed */
    NETDEV_PLAY_STATUS_8_BACKWARD         = 1,        /* 8ٺ˲  Backward at 8x speed */
    NETDEV_PLAY_STATUS_4_BACKWARD         = 2,        /* 4ٺ˲  Backward at 4x speed */
    NETDEV_PLAY_STATUS_2_BACKWARD         = 3,        /* 2ٺ˲  Backward at 2x speed */
    NETDEV_PLAY_STATUS_1_BACKWARD         = 4,        /* ٶȺ˲  Backward at normal speed */
    NETDEV_PLAY_STATUS_HALF_BACKWARD      = 5,        /* 1/2ٺ˲  Backward at 1/2 speed */
    NETDEV_PLAY_STATUS_QUARTER_BACKWARD   = 6,        /* 1/4ٺ˲  Backward at 1/4 speed */
    NETDEV_PLAY_STATUS_QUARTER_FORWARD    = 7,        /* 1/4ٲ  Play at 1/4 speed */
    NETDEV_PLAY_STATUS_HALF_FORWARD       = 8,        /* 1/2ٲ  Play at 1/2 speed */
    NETDEV_PLAY_STATUS_1_FORWARD          = 9,        /* ٶǰ  Forward at normal speed */
    NETDEV_PLAY_STATUS_2_FORWARD          = 10,       /* 2ǰ  Forward at 2x speed */
    NETDEV_PLAY_STATUS_4_FORWARD          = 11,       /* 4ǰ  Forward at 4x speed */
    NETDEV_PLAY_STATUS_8_FORWARD          = 12,       /* 8ǰ  Forward at 8x speed */
    NETDEV_PLAY_STATUS_16_FORWARD         = 13,       /* 16ǰ  Forward at 16x speed */

    NETDEV_PLAY_STATUS_INVALID
}NETDEV_VOD_PLAY_STATUS_E;

/**
 * @enum tagNETDEVDownloadSpeed
 * @brief ¼ٶ  Recording download speed
 * @attention  None
 */
typedef enum tagNETDEVDownloadSpeed
{
    NETDEV_DOWNLOAD_SPEED_ONE = 0,         /* һ  1x */
    NETDEV_DOWNLOAD_SPEED_TWO,             /*   2x */
    NETDEV_DOWNLOAD_SPEED_FOUR,            /* ı  4x */
    NETDEV_DOWNLOAD_SPEED_EIGHT            /* ˱  8x */
}NETDEV_E_DOWNLOAD_SPEED_E;

/**
 * @enum tagNETDEVPLanStoreType
 * @brief ¼洢 öٶ Recording storage type Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVPLanStoreType
{
    NETDEV_TYPE_STORE_TYPE_ALL = 0,                    /* еĴ洢  All */

    NETDEV_EVENT_STORE_TYPE_MOTIONDETECTION = 4,       /* ˶¼洢  Motion detection */
    NETDEV_EVENT_STORE_TYPE_DIGITALINPUT = 5,          /* ¼洢  Digital input */
    NETDEV_EVENT_STORE_TYPE_VIDEOLOSS = 7,             /* Ƶʧ¼洢  Video loss */

    NETDEV_TYPE_STORE_TYPE_INVALID = 0xFF              /* Чֵ  Invalid value */
}NETDEV_PLAN_STORE_TYPE_E;

/**
 * @enum tagNETDEVException
 * @brief 쳣صϢ öٶ Exception callback message types Enumeration definition 
 * @attention  None
 */
typedef enum tagNETDEVException
{
    /* ʵ ҵ쳣ϱ  Live view exceptions report 200~299 */

    /* طҵ쳣ϱ  Playback exceptions report 300~399 */
    NETDEV_EXCEPTION_REPORT_VOD_END = 300,         /* طŽ  Playback ended*/
    NETDEV_EXCEPTION_REPORT_VOD_ABEND,             /* ط쳣  Playback exception occured */
    NETDEV_EXCEPTION_REPORT_BACKUP_END,            /* ݽ  Backup ended */
    NETDEV_EXCEPTION_REPORT_BACKUP_DISC_OUT,       /* ̱γ  Disk removed */
    NETDEV_EXCEPTION_REPORT_BACKUP_DISC_FULL,      /*   Disk full */
    NETDEV_EXCEPTION_REPORT_BACKUP_ABEND,          /* ԭ±ʧ   Backup failure caused by other reasons */

    NETDEV_EXCEPTION_EXCHANGE = 0x8000,            /* ûʱ쳣ûʱ45Sʱ  Exception occurred during user interaction (keep-alive timeout, 45s) */

    NETDEV_EXCEPTION_REPORT_MAX,                   /* ֵ  Maximum value */

    NETDEV_EXCEPTION_REPORT_INVALID    = 0xFFFF    /* Чֵ  Invalid value */
}NETDEV_EXCEPTION_TYPE_E;

/**
 * @enum tagNETDEVAlarmTypeEn
 * @brief 澯ò öٶ  Alarm configuration operation Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVAlarmTypeEn
{
    /*********************************************************************** */
    /* 澯 Alarm                                                            */
    /*********************************************************************** */
    /* лָ͵ĸ澯  Recoverable alarms */
    NETDEV_ALARM_MOVE_DETECT               = 1,            /* ˶澯  Motion detection alarm */
    NETDEV_ALARM_VIDEO_LOST                = 2,            /* Ƶʧ澯  Video loss alarm */
    NETDEV_ALARM_VIDEO_TAMPER_DETECT       = 3,            /* ڵ澯  Tampering detection alarm */
    NETDEV_ALARM_INPUT_SWITCH              = 4,            /* 뿪澯  boolean input alarm */
    NETDEV_ALARM_TEMPERATURE_HIGH          = 5,            /* ¸澯  High temperature alarm */
    NETDEV_ALARM_TEMPERATURE_LOW           = 6,            /* ¸澯  Low temperature alarm */
    NETDEV_ALARM_AUDIO_DETECT              = 7,            /* 澯  Audio detection alarm */

    /* NVR豸״̬ϱ  Status report of NVR and access device 100~199 */
    NETDEV_ALARM_REPORT_DEV_ONLINE         = 100,          /* 豸  Device online */
    NETDEV_ALARM_REPORT_DEV_OFFLINE,                       /* 豸  Device offline */
    NETDEV_ALARM_REPORT_DEV_VIDEO_LOSS,                    /* Ƶʧ  Video loss */
    NETDEV_ALARM_REPORT_DEV_VIDEO_LOSS_RECOVER,            /* Ƶʧָ  Video loss recover */
    NETDEV_ALARM_REPORT_DEV_REBOOT,                        /* 豸  Device restart */
    NETDEV_ALARM_REPORT_DEV_SERVICE_REBOOT,                /*   Service restart */

    /* ʵҵ쳣ϱ  Live view exception report 200~299 */

    /* طҵ쳣ϱ  Playback exception report 300~399 */
    NETDEV_ALARM_REPORT_VOD_END            = 300,          /* طŽ  Playback ended */
    NETDEV_ALARM_REPORT_VOD_ABEND,                         /* ط쳣  Playback exception occured */
    NETDEV_ALARM_REPORT_BACKUP_END,                        /* ݽ  Backup ended */
    NETDEV_ALARM_REPORT_BACKUP_DISC_OUT,                   /* ̱γ  Disk removed */
    NETDEV_ALARM_REPORT_BACKUP_DISC_FULL,                  /*   Disk full */
    NETDEV_ALARM_REPORT_BACKUP_ABEND,                      /* ԭ±ʧ  Backup failure caused by other reasons */

    /* ޲24СʱЧĸ澯  Valid alarms within 24 hours without arming schedule */
    NETDEV_ALARM_ALLTIME_FLAG_START        = 400,          /* ޲澯ʼ  Start marker of alarm without arming schedule */
    NETDEV_ALARM_STOR_ERR                  = 401,          /* 洢  Storage error */
    NETDEV_ALARM_STOR_DISOBEY_PLAN         = 402,          /* δƻ洢  Not stored as planned */

    /* ޻ָ͵ĸ澯  Unrecoverable alarms */
    NETDEV_ALARM_NO_RECOVER_FLAG_START     = 500,          /* ޻ָ͸澯ʼ  Start marker of unrecoverable alarm */
    NETDEV_ALARM_DISK_ONLINE               = 501,          /*   Disk online */
    NETDEV_ALARM_DISK_OFFLINE              = 502,          /*   Disk offline */
    NETDEV_ALARM_DISK_ERROR                = 503,          /* ̴  Disk error */
    NETDEV_ALARM_ILLEGAL_ACCESS            = 504,          /* Ƿ  Illegal access */

    NETDEV_ALARM_ALLTIME_FLAG_END          = 600,          /* ޲澯  End marker of alarm without arming schedule */

    /* 澯ָ  Alarm recover */
    NETDEV_ALARM_RECOVER_BASE              = 1000,         /* 澯ָ  Alarm recover base */
    NETDEV_ALARM_MOVE_DETECT_RECOVER       = 1001,         /* ˶澯ָ  Motion detection alarm recover */
    NETDEV_ALARM_VIDEO_LOST_RECOVER        = 1002,         /* Ƶʧ澯ָ  Video loss alarm recover */
    NETDEV_ALARM_VIDEO_TAMPER_RECOVER      = 1003,         /* ڵ澯ָ  Tampering detection alarm recover */
    NETDEV_ALARM_INPUT_SWITCH_RECOVER      = 1004,         /* 뿪澯ָ  Boolean input alarm recover */
    NETDEV_ALARM_TEMPERATURE_RECOVER       = 1005,         /* ¶ȸ澯ָ  Temperature alarm recover */
    NETDEV_ALARM_AUDIO_DETECT_RECOVER      = 1006,         /* 澯ָ  Audio detection alarm recover */
    NETDEV_ALARM_STOR_ERR_RECOVER          = 1201,         /* 洢ָ  Storage error recover */
    NETDEV_ALARM_STOR_DISOBEY_PLAN_RECOVER = 1202,         /* δƻ洢ָ  Not stored as planned recover */

    NETDEV_ALARM_BUTT                      = 0xFFFF        /* Чֵ  Invalid value */
}NETDEV_ALARM_TYPE_E;

/**
 * @enum tagNETDEVLogMainType
 * @brief ־ö öٶ Major types of logs Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVLogMainType
{
    NETDEV_LOG_MAIN_TYPE_ALL        = 0,               /* ȫ͵־  Logs of all types */
    NETDEV_LOG_MAIN_TYPE_ALARM      = 1,               /* 澯  Alarms */
    NETDEV_LOG_MAIN_TYPE_EXCEPTION  = 2,               /* 쳣  Exceptions */
    NETDEV_LOG_MAIN_TYPE_OPERATION  = 3,               /*   Operations */
    NETDEV_LOG_MAIN_TYPE_MESSAGE    = 4,               /* Ϣ  Messages */

    NETDEV_LOG_MAIN_TYPE_BUTT                          /* Чֵ  Invalid value */
}NETDEV_LOG_MAIN_TYPE_E;

/**
 * @enum tagNETDEVLogSubType
 * @brief ־ID öٶ Minor type IDs of logs Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVLogSubType
{
    NETDEV_LOG_ALL_SUB_TYPES                     = 0x0101,          /* Ϣ־  All information logs */

    /* Ϣ־  Information logs */
    NETDEV_LOG_MSG_HDD_INFO                     = 300,              /* ӲϢ  HDD information */
    NETDEV_LOG_MSG_SMART_INFO                   = 301,              /* S.M.A.R.TϢ  S.M.A.R.T information */
    NETDEV_LOG_MSG_REC_OVERDUE                  = 302,              /* ¼ɾ  Expired recording deletion */
    NETDEV_LOG_MSG_PIC_REC_OVERDUE              = 303,              /* ͼƬļɾ  Expired image deletion */

    /* 澯־־ID  Sub type log ID of alarm logs */
    NETDEV_LOG_ALARM_MOTION_DETECT              = 350,              /* ƶ澯  Motion detection alarm */
    NETDEV_LOG_ALARM_MOTION_DETECT_RESUME       = 351,              /* ƶ澯ָ  Motion detection alarm recover */
    NETDEV_LOG_ALARM_VIDEO_LOST                 = 352,              /* Ƶʧ澯  Video loss alarm */
    NETDEV_LOG_ALARM_VIDEO_LOST_RESUME          = 353,              /* Ƶʧ澯ָ  Video loss alarm recover */
    NETDEV_LOG_ALARM_VIDEO_TAMPER_DETECT        = 354,              /* ڵ澯  Tampering detection alarm */
    NETDEV_LOG_ALARM_VIDEO_TAMPER_RESUME        = 355,              /* ڵ澯ָ  Tampering detection alarm recover */
    NETDEV_LOG_ALARM_INPUT_SW                   = 356,              /* 뿪澯  Boolean input alarm */
    NETDEV_LOG_ALARM_INPUT_SW_RESUME            = 357,              /* 뿪澯ָ  Boolean input alarm recover */
    NETDEV_LOG_ALARM_IPC_ONLINE                 = 358,              /* IPC 豸  Device online */
    NETDEV_LOG_ALARM_IPC_OFFLINE                = 359,              /* IPC 豸  Device offline */

    /* 쳣־־ID  Sub type log ID of exception logs */
    NETDEV_LOG_EXCEP_DISK_ONLINE                = 400,              /*   Disk online */
    NETDEV_LOG_EXCEP_DISK_OFFLINE               = 401,              /*   Disk offline */
    NETDEV_LOG_EXCEP_DISK_ERR                   = 402,              /* 쳣  Disk exception */
    NETDEV_LOG_EXCEP_STOR_ERR                   = 403,              /* 洢  Storage error */
    NETDEV_LOG_EXCEP_STOR_ERR_RECOVER           = 404,              /* 洢ָ  Storage error recover */
    NETDEV_LOG_EXCEP_STOR_DISOBEY_PLAN          = 405,              /* δƻ洢  Not stored as planned */
    NETDEV_LOG_EXCEP_STOR_DISOBEY_PLAN_RECOVER  = 406,              /* δƻ洢ָ  Not stored as planned recover */
    NETDEV_LOG_EXCEP_ILLEGAL_ACCESS             = 407,              /* Ƿ  Illegal access */
    NETDEV_LOG_EXCEP_IP_CONFLICT                = 408,              /* IPַͻ  IP address conflict */
    NETDEV_LOG_EXCEP_NET_BROKEN                 = 409,              /* Ͽ  Network disconnection */
    NETDEV_LOG_EXCEP_PIC_REC_ERR                = 410,              /* ץͼ,ȡͼƬļʧ  Failed to get captured image */
    NETDEV_LOG_EXCEP_VIDEO_EXCEPTION            = 411,              /* Ƶ쳣(ֻģͨ)  Video input exception (for analog channel only) */
    NETDEV_LOG_EXCEP_VIDEO_MISMATCH             = 412,              /* Ƶʽƥ   Video standards do not match */
    NETDEV_LOG_EXCEP_RESO_MISMATCH              = 413,              /* ֱʺǰ˷ֱʲƥ  Encoding resolution and front-end resolution do not match */
    NETDEV_LOG_EXCEP_TEMP_EXCE                  = 414,              /* ¶쳣  Temperature exception */

    /* ־־ID  Sub type log ID of operation logs */
    /* ҵ  Services */
    NETDEV_LOG_OPSET_LOGIN                      = 450,              /* û¼  User login */
    NETDEV_LOG_OPSET_LOGOUT                     = 451,              /* ע¼  Log out */
    NETDEV_LOG_OPSET_USER_ADD                   = 452,              /* û  Add user */
    NETDEV_LOG_OPSET_USER_DEL                   = 453,              /* ûɾ  Delete user */
    NETDEV_LOG_OPSET_USER_MODIFY                = 454,              /* û޸  Modify user */

    NETDEV_LOG_OPSET_START_REC                  = 455,              /* ʼ¼  Start recording */
    NETDEV_LOG_OPSET_STOP_REC                   = 456,              /* ֹͣ¼  Stop recording */
    NETDEV_LOG_OPSETR_PLAY_DOWNLOAD             = 457,              /* ط/  Playback and download */
    NETDEV_LOG_OPSET_DOWNLOAD                   = 458,              /*   Download */
    NETDEV_LOG_OPSET_PTZCTRL                    = 459,              /* ̨  PTZ control */
    NETDEV_LOG_OPSET_PREVIEW                    = 460,              /* ʵԤ  Live preview */
    NETDEV_LOG_OPSET_REC_TRACK_START            = 461,              /* 켣¼ƿʼ  Start recording route */
    NETDEV_LOG_OPSET_REC_TRACK_STOP             = 462,              /* 켣¼ֹͣ  Stop recording route */
    NETDEV_LOG_OPSET_START_TALKBACK             = 463,              /* ʼԽ  Start two-way audio */
    NETDEV_LOG_OPSET_STOP_TALKBACK              = 464,              /* ֹͣԽ  Stop two-way audio */
    NETDEV_LOG_OPSET_IPC_ADD                    = 465,              /* IPC  Add IP camera */
    NETDEV_LOG_OPSET_IPC_DEL                    = 466,              /* ɾIPC  Delete IP camera */
    NETDEV_LOG_OPSET_IPC_SET                    = 467,              /* IPC  Modify IP camera */

    /*   Configurations */
    NETDEV_LOG_OPSET_DEV_BAS_CFG                = 500,              /* 豸Ϣ  Basic device information */
    NETDEV_LOG_OPSET_TIME_CFG                   = 501,              /* 豸ʱ  Device time */
    NETDEV_LOG_OPSET_SERIAL_CFG                 = 502,              /* 豸  Device serial port */

    NETDEV_LOG_OPSET_CHL_BAS_CFG                = 503,              /* ͨ  Basic channel configuration */
    NETDEV_LOG_OPSET_CHL_NAME_CFG               = 504,              /* ͨ  Channel name configuration */
    NETDEV_LOG_OPSET_CHL_ENC_VIDEO              = 505,              /* Ƶ  Video encoding configuration */
    NETDEV_LOG_OPSET_CHL_DIS_VIDEO              = 506,              /* ͨƵʾ  Video display configuration */
    NETDEV_LOG_OPSET_PTZ_CFG                    = 507,              /* ̨  PTZ configuration */
    NETDEV_LOG_OPSET_CRUISE_CFG                 = 508,              /* Ѳ·  Patrol route configuration */
    NETDEV_LOG_OPSET_PRESET_CFG                 = 509,              /* Ԥλ  Preset configuration */
    NETDEV_LOG_OPSET_VIDPLAN_CFG                = 510,              /* ¼ƻ  Recording schedule configuration */
    NETDEV_LOG_OPSET_MOTION_CFG                 = 511,              /* ˶  Motion detection configuration */
    NETDEV_LOG_OPSET_VIDLOSS_CFG                = 512,              /* Ƶʧ  Video loss configuration */
    NETDEV_LOG_OPSET_COVER_CFG                  = 513,              /* Ƶڵ  Tampering detection configuration */
    NETDEV_LOG_OPSET_MASK_CFG                   = 514,              /* Ƶڸ  Privacy mask configuration */
    NETDEV_LOG_OPSET_SCREEN_OSD_CFG             = 515,              /* OSD  OSD overlay configuration */

    NETDEV_LOG_OPSET_ALARMIN_CFG                = 516,              /*   Alarm input configuration */
    NETDEV_LOG_OPSET_ALARMOUT_CFG               = 517,              /*   Alarm output configuration */
    NETDEV_LOG_OPSET_ALARMOUT_OPEN_MAN          = 518,              /* ֶ,˻  Manually enable alarm output, GUI */
    NETDEV_LOG_OPSET_ALARMOUT_CLOSE_MAN         = 519,              /* ֶرձ,˻  Manually disable alarm input, GUI */

    NETDEV_LOG_OPSET_ABNORMAL_CFG               = 520,              /* 쳣  Exception configuration */
    NETDEV_LOG_OPSET_HDD_CFG                    = 521,              /* Ӳ  HDD configuration */

    NETDEV_LOG_OPSET_NET_IP_CFG                 = 522 ,             /* TCP/IP  TCP/IP configuration */
    NETDEV_LOG_OPSET_NET_PPPOE_CFG              = 523,              /* PPPOE  PPPOE configuration */
    NETDEV_LOG_OPSET_NET_PORT_CFG               = 524,              /* ˿  Port configuration */

    NETDEV_LOG_OPSET_NET_DDNS_CFG               = 525,              /* DDNS  DDNS configuration */

    /* ά Maintenance */
    NETDEV_LOG_OPSET_START_DVR                  = 600,              /*   Start up*/
    NETDEV_LOG_OPSET_STOP_DVR                   = 601,              /* ػ  Shut down */
    NETDEV_LOG_OPSET_REBOOT_DVR                 = 602,              /* 豸  Restart device */
    NETDEV_LOG_OPSET_UPGRADE                    = 603,              /* 汾  Version upgrade */
    NETDEV_LOG_OPSET_LOGFILE_EXPORT             = 604,              /* ־ļ  Export log files */
    NETDEV_LOG_OPSET_CFGFILE_EXPORT             = 605,              /* ļ  Export configuration files */
    NETDEV_LOG_OPSET_CFGFILE_IMPORT             = 606,              /* ļ  Import configuration files */
    NETDEV_LOG_OPSET_CONF_SIMPLE_INIT           = 607,              /* 򵥻ָ  Export configuration files */
    NETDEV_LOG_OPSET_CONF_ALL_INIT              = 608               /* ָ  Restore to factory settings */

}NETDEV_LOG_SUBTYPE_ID_E;

typedef enum tagNETDEVDeviceType
{
    NETDEV_DTYPE_UNKNOWN    = -1,           /* Unknown type */
    NETDEV_DTYPE_IPC        = 1,            /* IPC range [1-100] */
    NETDEV_DTYPE_NVR        = 101,          /* NVR range [101-200] */
    NETDEV_DTYPE_DC         = 201,          /* DC range [201-300] */
    NETDEV_DTYPE_EC         = 301,          /* EC range [301-400] */
    NETDEV_DTYPE_CVS        = 401,
    NETDEV_DTYPE_VMS        = 501
}NETDEV_DEVICETYPE_E;

/**
 * @enum tagNETDEVCFGCmd
 * @brief  öٶ Parameter configuration command words Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVCFGCmd
{
    NETDEV_GET_DEVICECFG              = 100,            /* ȡ豸Ϣμ#NETDEV_DEVICE_INFO_S  Get device information, see #NETDEV_DEVICE_INFO_S */
    NETDEV_SET_DEVICECFG              = 101,

    NETDEV_GET_NTPCFG                 = 110,            /* ȡNTPμ#NETDEV_SYSTEM_NTP_INFO_S  Get NTP parameter, see #NETDEV_SYSTEM_NTP_INFO_S */
    NETDEV_SET_NTPCFG                 = 111,            /* NTPμ#NETDEV_SYSTEM_NTP_INFO_S  Set NTP parameter, see #NETDEV_SYSTEM_NTP_INFO_S */

    NETDEV_GET_STREAMCFG              = 120,            /* ȡƵμ#NETDEV_VIDEO_STREAM_INFO_S  Get video encoding parameter, see #NETDEV_VIDEO_STREAM_INFO_S */
    NETDEV_SET_STREAMCFG              = 121,            /* Ƶμ#NETDEV_VIDEO_STREAM_INFO_S  Set video encoding parameter, see #NETDEV_VIDEO_STREAM_INFO_S */

    NETDEV_GET_PTZPRESETS             = 130,            /* ȡ̨Ԥλμ#NETDEV_PTZ_ALLPRESETS_S  Get PTZ preset, see #NETDEV_PTZ_ALLPRESETS_S */

    NETDEV_GET_OSDCFG                 = 140,            /* ȡOSDϢμ#NETDEV_VIDEO_OSD_CFG_S  Get OSD configuration information, see #NETDEV_VIDEO_OSD_CFG_S */
    NETDEV_SET_OSDCFG                 = 141,            /* OSDϢμ#NETDEV_VIDEO_OSD_CFG_S  Set OSD configuration information, see #NETDEV_VIDEO_OSD_CFG_S */

    NETDEV_GET_ALARM_OUTPUTCFG        = 150,            /* ȡϢμ#NETDEV_ALARM_OUTPUT_LIST_S  Get boolean configuration information, see #NETDEV_ALARM_OUTPUT_LIST_S */
    NETDEV_SET_ALARM_OUTPUTCFG        = 151,            /* ùϢμ#NETDEV_ALARM_OUTPUT_LIST_S       Set boolean configuration information, see #NETDEV_ALARM_OUTPUT_LIST_S */
    NETDEV_TRIGGER_ALARM_OUTPUT       = 152,            /* μLPNETDEV_TRIGGER_ALARM_OUTPUT_LIST_S  Trigger boolean    LPNETDEV_TRIGGER_ALARM_OUTPUT_LIST_S */
    NETDEV_GET_ALARM_INPUTCFG         = 153,            /* ȡμ#NETDEV_ALARM_INPUT_INFO_S Get the number of boolean inputs   see #NETDEV_ALARM_INPUT_INFO_S*/

    NETDEV_GET_IMAGECFG               = 160,            /* ȡͼϢμ#NETDEV_IMAGE_SETTING_S  Get image configuration information, see #NETDEV_IMAGE_SETTING_S */
    NETDEV_SET_IMAGECFG               = 161,            /* ͼϢμ#NETDEV_IMAGE_SETTING_S  Set image configuration information, see #NETDEV_IMAGE_SETTING_S */

    NETDEV_GET_NETWORKCFG             = 170,            /* ȡϢμ#NETDEV_IMAGE_SETTING_S  Get network configuration information, see #NETDEV_IMAGE_SETTING_S */
    NETDEV_SET_NETWORKCFG             = 171,            /* Ϣμ#NETDEV_IMAGE_SETTING_S  Set network configuration information, see #NETDEV_IMAGE_SETTING_S */

    NETDEV_GET_PRIVACYMASKCFG         = 180,            /* ȡ˽ڸϢμ#NETDEV_PRIVACY_MASK_CFG_S  Get privacy mask configuration information, see #NETDEV_PRIVACY_MASK_CFG_S */
    NETDEV_SET_PRIVACYMASKCFG         = 181,            /* ˽ڸϢμ#NETDEV_PRIVACY_MASK_CFG_S  Set privacy mask configuration information, see #NETDEV_PRIVACY_MASK_CFG_S */

    NETDEV_GET_TAMPERALARM            = 190,            /* ȡڵ澯Ϣ  μ#NETDEV_TAMPER_ALARM_INFO_S  Get tamper alarm configuration information, see#NETDEV_TAMPER_ALARM_INFO_S */
    NETDEV_SET_TAMPERALARM            = 191,            /* ڵ澯Ϣ  μ#NETDEV_TAMPER_ALARM_INFO_S  Set tamper alarm configuration information, see#NETDEV_TAMPER_ALARM_INFO_S */

    NETDEV_GET_MOTIONALARM            = 201,            /* ȡ˶澯Ϣ μ#NETDEV_MOTION_ALARM_INFO_S  Get motion alarm configuration information, see#NETDEV_MOTION_ALARM_INFO_S */
    NETDEV_SET_MOTIONALARM            = 202             /* ˶澯Ϣ μ#NETDEV_MOTION_ALARM_INFO_S  Set motion alarm configuration information, see#NETDEV_MOTION_ALARM_INFO_S */

}NETDEV_CONFIG_COMMAND_E;

/**
 * @enum tagNETDEVDateOSDFormateCap
 * @brief ڸʽ öٶ OSD date format capabilities enumeration 
 * @attention  None
 */
typedef enum tagNETDEVDateOSDFormateCap
{
    NETDEV_OSD_DATE_FORMAT_CAP_MD_YYYY = 0,     /* M/d/yyyy */
    NETDEV_OSD_DATE_FORMAT_CAP_MMDD_YYYY ,      /* MM/dd/yyyy */
    NETDEV_OSD_DATE_FORMAT_CAP_DDMM_YYYY ,      /* dd/MM/yyyy */
    NETDEV_OSD_DATE_FORMAT_CAP_YYYY_MMDD ,      /* yyyy/MM/dd */
    NETDEV_OSD_DATE_FORMAT_CAP_YYYYMMDDB ,      /* yyyy-MM-dd */
    NETDEV_OSD_DATE_FORMAT_CAP_XX_MMDD_YYYY ,   /* dddd, MMMM dd, yyyy  */
    NETDEV_OSD_DATE_FORMAT_CAP_MMMMDD_YYYY ,    /* MMMM dd, yyyy   */
    NETDEV_OSD_DATE_FORMAT_CAP_DDMMMM_YYYY      /* dd MMMM, yyyy   */

}NETDEV_OSD_DATE_FORMAT_CAP_E;

/**
 * @enum tagNETDEVTimeOSDFormateCap
 * @brief OSDʱʽö OSD time format capabilities enumeration
 * @attention  None
 */
typedef enum tagNETDEVTimeOSDFormateCap
{
    NETDEV_OSD_TIME_FORMAT_CAP_HHMMSS = 0,     /* HH:mm:ss */
    NETDEV_OSD_TIME_FORMAT_CAP_HH_MM_SS_PM     /* hh:mm:ss tt */

}NETDEV_OSD_TIME_FORMAT_CAP_E;

/**
 * @enum tagNETDEVBooleanMode
 * @brief 뿪ģʽ Boolean input operation mode
 * @attention  None
 */
typedef enum tagNETDEVBooleanMode
{
    NETDEV_BOOLEAN_MODE_OPEN   = 1,    /*   Always open */
    NETDEV_BOOLEAN_MODE_CLOSE  = 2,    /*   Always closed */
    NETDEV_BOOLEAN_MODE_BUTT
}NETDEV_BOOLEAN_MODE_E;

/**
 * @enum tagNETDEVTimeOSDFormateCap
 * @brief ״̬ Boolean input operation mode
 * @attention  None
 */
typedef enum tagNETDEVRelayOutPutState
{
    NETDEV_BOOLEAN_STATUS_ACTIVE    = 0,   /* ״̬  Triggered */
    NETDEV_BOOLEAN_STATUS_INACTIVE  = 1    /* Ǵ״̬ Not triggered */
}NETDEV_RELAYOUTPUT_STATE_E;

/**
* @enum tagNETDEVMediaDataFormat
* @brief ýʽ
* @attention 
*/
typedef enum tagNETDEVMediaDataFormat
{
    NETDEV_MEDIA_DATA_TS            = 0,            /* TS */
    NETDEV_MEDIA_DATA_RTP_ES        = 3             /* RTP + ES */
}NETDEV_MEDIA_DATA_FORMAT_E;
/* END************* öֵ  Enumeration value *************************** */

/* BEGIN*********** ṹ  Structure *********************************** */

/**
 * @struct tagNETDEVDeviceInfo
 * @brief 豸Ϣ ṹ嶨 Device information Structure definition
 * @attention  None
 */
typedef struct tagNETDEVDeviceInfo
{
    INT32   dwDevType;                          /* 豸,μö#NETDEV_DEVICETYPE_E  Device type, see enumeration #NETDEV_DEVICETYPE_E */
    INT16   wAlarmInPortNum;                    /*   Number of alarm inputs */
    INT16   wAlarmOutPortNum;                   /*   Number of alarm outputs */
    INT32   dwChannelNum;                       /* ͨ  Number of Channels */
    BYTE    byRes[48];                          /* ֶ  Reserved */
}NETDEV_DEVICE_INFO_S,*LPNETDEV_DEVICE_INFO_S;

/**
 * @struct tagNETDEVDeviceBasicInfo
 * @brief 豸Ϣ ṹ嶨 Basic device information Structure definition
 * @attention  None
 */
typedef struct tagNETDEVDeviceBasicInfo
{ 
    CHAR szDevModel[NETDEV_LEN_64];                     /* 豸ͺ  Device model */
    CHAR szSerialNum[NETDEV_LEN_64];                    /* Ӳк  Hardware serial number */     
    CHAR szFirmwareVersion[NETDEV_LEN_64];              /* 汾  Software version */
    CHAR szMacAddress[NETDEV_LEN_64];                   /* IPv4Macַ  MAC address of IPv4 */
    BYTE byRes[512];                                    /*   Reserved */
}NETDEV_DEVICE_BASICINFO_S, *LPNETDEV_DEVICE_BASICINFO_S;

/**
 * @struct tagNETDEVNetworkInterfaces
 * @brief Ϣ ṹ嶨 Network configuration information
 * @attention  None
 */
typedef struct tagNETDEVNetworkInterfaces
{
    INT32   dwMTU;                              /* MTUֵ  MTU value */
    INT32   dwIPv4DHCP;                         /* IPv4DHCP  DHCP of IPv4 */
    CHAR    szIpv4Address[NETDEV_LEN_32];       /* IPv4IPַ  IP address of IPv4 */
    CHAR    szIPv4GateWay[NETDEV_LEN_32];       /* IPv4صַ  Gateway of IPv4 */
    BYTE    byRes[512];                         /*   Reserved */
}NETDEV_NETWORKCFG_S, *LPNETDEV_NETWORKCFG_S;

/**
 * @struct tagSysemIPAddr
 * @brief ַ ṹ嶨 Address Structure definition 
 * @attention  None
 */
typedef struct tagSysemIPAddr
{
    INT32   eIPType;                            /* ЭͲμö#NETDEV_HOSTTYPE_E  Protocol type, see enumeration #NETDEV_HOSTTYPE_E */
    CHAR    szIPAddr[NETDEV_LEN_132];           /* IPַ  IP address */
}NETDEV_SYSTEM_IPADDR_S, *LPNETDEV_SYSTEM_IPADDR_S;

/**
 * @struct tagNETDEVSystemNTPInfo
 * @brief  NTP NTP parameter
 * @attention  None
 */
typedef struct tagNETDEVSystemNTPInfo
{
    BOOL bSupportDHCP;                      /* Ƿ֧DHCP  Support DHCP or not */
    NETDEV_SYSTEM_IPADDR_S stAddr;          /* NTP Ϣ  NTP information */
}NETDEV_SYSTEM_NTP_INFO_S, *LPNETDEV_SYSTEM_NTP_INFO_S;

/**
 * @struct tagNETDEVPriviewInfo
 * @brief ʵԤ ṹ嶨 Live view parameter Structure definition
 * @attention  None
 */
typedef struct tagNETDEVPriviewInfo
{
    INT32   dwChannelID;                    /* ͨID  Channel ID */
    INT32   dwStreamType;                   /* ͣμö#NETDEV_LIVE_STREAM_INDEX_E  Stream type, see enumeration #NETDEV_LIVE_STREAM_INDEX_E */
    INT32   dwLinkMode;                     /* Э飬μö#NETDEV_PROTOCAL_E  Transport protocol, see enumeration #NETDEV_PROTOCAL_E */
    LPVOID  hPlayWnd;                       /* Ŵھ Play window handle */ 
    BYTE    byRes[264];                     /* ֶ  Reserved */
}NETDEV_PREVIEWINFO_S, *LPNETDEV_PREVIEWINFO_S;

/**
 * @struct tagNETDEVVideoEffect
 * @brief ʵӰϢ ṹ嶨 Live image information Structure definition
 * @attention ٤Χ0-10ȡֵΧ0-255 Gamma parameter range: 0-10, other parameters: 0-255
 */
typedef struct tagNETDEVVideoEffect
{
    INT32 dwContrast;                   /* Աȶ */  /* Contrast */
    INT32 dwBrightness;                 /*   Brightness */
    INT32 dwSaturation;                 /* Ͷ */  /* Saturation */
    INT32 dwHue;                        /* ɫ  Hue */
    INT32 dwGamma;                      /* ٤ֵ */  /* Gamma */
    BYTE  byRes[16];                    /* ֶ  Reserved */
}NETDEV_VIDEO_EFFECT_S, *LPNETDEV_VIDEO_EFFECT_S;

/**
 * @struct tagNETDEVImagingSetting
 * @brief 豸ͼ ṹ嶨    Device image settings Structure definition
 * @attention ȡֵΧ0-255     parameter range: 0-255
 */
typedef struct tagNETDEVImagingSetting
{
    INT32 dwContrast;                   /* Աȶ  Contrast */
    INT32 dwBrightness;                 /*   Brightness */
    INT32 dwSaturation;                 /* Ͷ  Saturation */
    INT32 dwSharpness;                  /*   Sharpness */
    BYTE  byRes[252];                   /* ֶ */  /* Reserved */
}NETDEV_IMAGE_SETTING_S, *LPNETDEV_IMAGE_SETTING_S;

/************ طҵ Playback services***********************************************/

/**
 * @struct tagNETDEVVodFile
 * @brief ¼ļ ṹ嶨 Recording file Structure definition
 * @attention  None
 */
typedef struct tagNETDEVVodFile
{
    CHAR                        szFileName[NETDEV_LEN_64];      /* ¼ļ  Recording file name */
    NETDEV_PLAN_STORE_TYPE_E    enType;                         /* ¼洢  Recording storage type */
    INT64                       tBeginTime;                     /* ʼʱ  Start time */
    INT64                       tEndTime;                       /* ʱ  End time */
}NETDEV_VOD_FILE_S, *LPNETDEV_VOD_FILE_S;

/**
 * @struct tagNETDEVFindCond
 * @brief ¼ ṹ嶨 Recording query Structure definition
 *        ļ͡ʱ豸¼ļ Query recording files according to file type and time
 * @attention  None
 */
typedef struct tagNETDEVFindCond
{
    CHAR    szFileName[NETDEV_LEN_64];      /* ¼ļ  Recording file name */
    INT32   dwChannelID;                    /* ͨ  Channel number */
    INT32   dwFileType;                     /* ¼洢ͣμö#NETDEV_PLAN_STORE_TYPE_E  Recording storage type, see enumeration #NETDEV_PLAN_STORE_TYPE_E */
    INT64   tBeginTime;                     /* ʼʱ  Start time */
    INT64   tEndTime;                       /* ʱ  End time */
    BYTE    byRes[40];                      /* ֶ  Reserved */
}NETDEV_FILECOND_S, *LPNETDEV_FILECOND_S;

/**
 * @struct tagNETDEVFingData
 * @brief ¼ ṹ嶨 Recording query data Structure definition
 *        ȡҵļϢ Get the information of found files one by one
 * @attention  None
 */
typedef struct tagNETDEVFingData
{
    CHAR    szFileName[NETDEV_FILE_NAME_LEN];               /* ¼ļ  Recording file name */
    INT64   tBeginTime;                                     /* ʼʱ  Start time */
    INT64   tEndTime;                                       /* ʱ  End time */
    BYTE    byFileType;                                     /* ¼洢  Recording storage type */
    BYTE    byRes[171];                                     /* ֶ  Reserved */
}NETDEV_FINDDATA_S,*LPNETDEV_FINDDATA_S;

/**
 * @struct tagNETDEVPlayBackInfo
 * @brief ļط¼ ṹ嶨 Parameters of play back recordings by file name Structure definition
 * @attention  None
 */
typedef struct tagNETDEVPlayBackInfo
{
    char    szName[NETDEV_LEN_260];         /* طŵĿƿ  Playback control block name*/
    INT64   tBeginTime;                     /* طſʼʱ  Playback start time */
    INT64   tEndTime;                       /* طŽʱ  Playback end time */
    INT32   dwLinkMode;                     /* Э飬μö#NETDEV_PROTOCAL_E  Transport protocol, see enumeration #NETDEV_PROTOCAL_E */
    LPVOID  hPlayWnd;                       /* Ŵھ  Play window handle */
    INT32   dwFileType;                     /* ¼洢ͣμö#NETDEV_PLAN_STORE_TYPE_E  Recording storage type, see enumeration #NETDEV_PLAN_STORE_TYPE_E */
    INT32   dwDownloadSpeed;                /* ٶ μö#NETDEV_E_DOWNLOAD_SPEED_E  Download speed, see enumeration #NETDEV_E_DOWNLOAD_SPEED_E */
    BYTE    byRes[260];                     /* ֶ  Reserved */
}NETDEV_PLAYBACKINFO_S, *LPNETDEV_PLAYBACKINFO_S;

/**
 * @struct tagNETDEVPlayBackCondition
 * @brief ʱط¼ ṹ嶨 Parameters of play back by time Structure definition
 * @attention  None
 */
typedef struct tagNETDEVPlayBackCondition
{
    INT32   dwChannelID;                /* طŵͨ  Playback channel */
    INT64   tBeginTime;                 /* طſʼʱ  Playback start time */
    INT64   tEndTime;                   /* طŽʱ  Playback end time */
    INT32   dwLinkMode;                 /* Э飬μö#NETDEV_PROTOCAL_E  Transport protocol, see enumeration #NETDEV_PROTOCAL_E */
    LPVOID  hPlayWnd;                   /* Ŵھ  Play window handle */
    INT32   dwFileType;                 /* ¼洢ͣμö#NETDEV_PLAN_STORE_TYPE_E  Recording storage type, see enumeration #NETDEV_PLAN_STORE_TYPE_E */
    INT32   dwDownloadSpeed;            /* ٶ μö#NETDEV_E_DOWNLOAD_SPEED_E */
    BYTE    byRes[256];                 /* ֶ  Reserved */
}NETDEV_PLAYBACKCOND_S, *LPNETDEV_PLAYBACKCOND_S;

/************************************************* ̨ҵ*****************************************************/
/************************************************* PTZ services*****************************************************/
/**
 * @struct tagstNETDEVPtzPreset
 * @brief ̨ԤλϢ ṹ嶨 PTZ preset information Structure definition
 * @attention  None
 */
typedef struct tagstNETDEVPtzPreset
{
    INT32   dwPresetID;                                 /* ԤλID  Preset ID */
    CHAR    szPresetName[NETDEV_LEN_32];                /* Ԥλ  Preset name */
}NETDEV_PTZ_PRESET_S, *LPNETDEV_PTZ_PRESET_S;

/**
 * @struct tagstNETDEVPtzAllPresets
 * @brief ̨Ԥλ ṹ嶨 All PTZ presets Structure definition
 * @attention  None
 */
typedef struct tagstNETDEVPtzAllPresets
{
    INT32               dwSize;                             /* Ԥλ  Total number of presets */
    NETDEV_PTZ_PRESET_S astPreset[NETDEV_MAX_PRESET_NUM];   /* ԤλϢṹ  Structure of preset information */
}NETDEV_PTZ_ALLPRESETS_S, *LPNETDEV_PTZ_ALLPRESETS_S;

/**
 * @struct tagNETDEVCruisePointInfo
 * @brief ̨ԤλѲ켣Ϣ ṹ嶨 PTZ preset patrol point information Structure definition
 * @attention  None
 */
typedef struct tagNETDEVCruisePoint
{
    INT32   dwPresetID;                     /* ԤλID  Preset ID */
    INT32   dwStayTime;                     /* ͣʱ  Stay time */
    INT32   dwSpeed;                        /* תٶ  Speed */
    INT32   dwReserve;                      /* ֶ  Reserved */
}NETDEV_CRUISE_POINT_S, *LPNETDEV_CRUISE_POINT_S;

/**
 * @struct tagNETDEVCruiseInfo
 * @brief ̨ԤλѲ·ϸϢ ṹ嶨 PTZ preset patrol route information Structure definition 
 * @attention  None
 */
typedef struct tagNETDEVCruiseInfo
{
    INT32                   dwCuriseID;                                     /* 켣ID  Route ID */
    CHAR                    szCuriseName[NETDEV_LEN_32];                    /* 켣  Route name */
    INT32                   dwSize;                                         /* ·Ĺ켣  Number of presets included in the route */
    NETDEV_CRUISE_POINT_S   astCruisePoint[NETDEV_MAX_CRUISEPOINT_NUM];     /* ·Ĺ켣Ϣ   Information of presets included in the route */
}NETDEV_CRUISE_INFO_S, *LPNETDEV_CRUISE_INFO_S;

/**
 * @struct tagNETDEVCruiseList
 * @brief ̨ԤλѲ·б ṹ嶨 PTZ preset patrol route list Structure definition
 * @attention  None
 */
typedef struct tagNETDEVCruiseList
{
    INT32                   dwSize;                                         /* Ѳ·  Number of patrol routes */
    NETDEV_CRUISE_INFO_S    astCruiseInfo[NETDEV_MAX_CRUISEROUTE_NUM];      /* Ѳ·Ϣ  Information of patrol routes */
}NETDEV_CRUISE_LIST_S, *LPNETDEV_CRUISE_LIST_S;

/**
 * @struct tagNETDEVPtzTrackinfo
 * @brief ̨켣Ѳ·Ϣ ṹ嶨 Route information of PTZ route patrol Structure definition
 * @attention  None
 */
typedef struct tagNETDEVPtzTrackinfo
{
    INT32 dwTrackNum;                                               /* ѴڵѲ켣  Number of existing patrol routes */
    CHAR  aszTrackName[NETDEV_TRACK_CRUISE_MAXNUM][NETDEV_LEN_64];  /* 켣  Route name */
}NETDEV_PTZ_TRACK_INFO_S, *LPNETDEV_PTZ_TRACK_INFO_S;

/**
 * @struct tagNETDEVRect
 * @brief  ṹ嶨 Rectangle Area  Structure definition
 * @attention  None
 */
typedef struct tagNETDEVRect
{
    INT32   dwLeft;                               /* xֵ[0,10000]  X axis left point value [0,10000] */
    INT32   dwTop;                                /* yᶥֵ[0,10000]  Y axis top point value [0,10000] */
    INT32   dwRight;                              /* xҵֵ[0,10000]  X axis right point value [0,10000] */
    INT32   dwBottom;                             /* y׵ֵ[0,10000]  Y axis bottom point value [0,10000] */
}NETDEV_RECT_S, *LPNETDEV_RECT_S;

/**
 * @struct tagNETDEVPtzOperateAreaInfo
 * @brief ͼϢ ṹ嶨 Image area information Structure definition
 * @attention  None
 */
typedef struct tagNETDEVPtzOperateAreaInfo
{
    INT32   dwBeginPointX;                           /* ʼXֵ[0,10000]  Area start point X value [0,10000] */
    INT32   dwBeginPointY;                           /* ʼYֵ[0,10000]  Area start point Y value [0,10000] */
    INT32   dwEndPointX;                             /* Xֵ[0,10000]  Area end point X value [0,10000] */
    INT32   dwEndPointY;                             /* Yֵ [0,10000]  Area end point Y value [0,10000] */
}NETDEV_PTZ_OPERATEAREA_S, *LPNETDEV_PTZ_OPERATEAREA_S;

/**
 * @struct tagNETDEVPictureData
 * @brief ͼ ṹ嶨 Image data Structure definition
 *        ŽͼݵָͳȵϢ Storing pointer and length of decoded picture data
 * @attention  None
 */
typedef struct tagNETDEVPictureData
{
    BYTE    *pucData[4];                /* pucData[0]:Y ƽָ,pucData[1]:U ƽָ,pucData[2]:V ƽָ  pucData[0]: Y plane pointer, pucData[1]: U plane pointer, pucData[2]: V plane pointer */
    INT32   dwLineSize[4];              /* ulLineSize[0]:Yƽÿп, ulLineSize[1]:Uƽÿп, ulLineSize[2]:Vƽÿп  ulLineSize[0]: Y line spacing, ulLineSize[1]: U line spacing, ulLineSize[2]: V line spacing */
    INT32   dwPicHeight;                /* ͼƬ߶  Picture height */
    INT32   dwPicWidth;                 /* ͼƬ  Picture width */
    INT32   dwRenderTimeType;           /* Ⱦʱ  Time data type for rendering */
    INT64   tRenderTime;                /* Ⱦʱ  Time data for rendering */
}NETDEV_PICTURE_DATA_S, *LPNETDEV_PICTURE_DATA_S;

/**
 * @struct tagNETDEVWaveData
 * @brief Ƶ ṹ嶨 Audio data Structure definition
 *        ŽƵݵָͳȵϢ Storing pointer and length of decoded picture data
 * @attention  None
 */
typedef struct tagNETDEVWaveData
{
    BYTE  *pcData;                      /* Ƶָ  Audio data pointer */
    INT32 dwDataLen;                    /* Ƶݳ  Audio data length */
    INT32 dwWaveFormat;                 /* Ƶʽ  Format of decoded audio*/
}NETDEV_WAVE_DATA_S, *LPNETDEV_WAVE_DATA_S;

/**
 * @struct tagNETDEVParseVideoData
 * @brief Ƶ ṹ嶨 Video analytic data Structure definition
 *        ƴ֡ƵݵָͳȵϢ Storing pointer and length of framed video data
 * @attention  None
 */
typedef struct tagNETDEVParseVideoData
{
    BYTE   *pucData;             /* Ƶָ  Pointer to video data */
    INT32  dwDataLen;            /* Ƶݳ  Video data length */
    INT32  dwVideoFrameType;     /* Ƶ֡ͣοö#NETDEV_VIDEO_FRAME_TYPE_E  Frame type, see enumeration #NETDEV_VIDEO_FRAME_TYPE_E */
    INT32  dwVideoCodeFormat;    /* Ƶʽοö#NETDEV_VIDEO_CODE_TYPE_E  Video encoding format, see enumeration #NETDEV_VIDEO_CODE_TYPE_E */
    INT32  dwHeight;             /* Ƶͼ߶  Video image height */
    INT32  dwWidth;              /* Ƶͼ  Video image width */
    INT64  tTimeStamp;           /* ʱ룩  Time stamp (ms) */
    BYTE  byRes[8];              /* ֶ  Reserved field*/
}NETDEV_PARSE_VIDEO_DATA_S, *LPNETDEV_PARSE_VIDEO_DATA_S;


/**
 * @struct tagNETDEVVideoChlDetailInfo
 * @brief ƵͨϸϢ ṹ嶨  Structure definition
 * @attention  None
 */
typedef struct tagNETDEVVideoChlDetailInfo
{
    INT32                       dwChannelID;            /* ͨID  Channel ID */
    INT32                       dwType;                 /* ֶ  Reserved field*/
    NETDEV_CHANNEL_STATUS_E     enStatus;               /* ͨ״̬  Channel status */
    INT32                       dwStreamNum;            /*   Number of streams */
    BYTE                        byRes[68];              /* ֶ  Reserved field*/
}NETDEV_VIDEO_CHL_DETAIL_INFO_S, *LPNETDEV_VIDEO_CHL_DETAIL_INFO_S;

/**
 * @struct tagNETDEVVideoStreamInfo
 * @brief ͨƵϢ ṹ嶨 Channel video stream information Structure definition
 * @attention  None
 */
typedef struct tagNETDEVVideoStreamInfo
{
    NETDEV_LIVE_STREAM_INDEX_E  enStreamType;       /*   Stream index */
    INT32                       bEnableFlag;        /* Ƿ  Enable or not */
    INT32                       dwHeight;           /* Ƶֱ-Height  Video encoding resolution - Height */
    INT32                       dwWidth;            /* Ƶֱ-Width  Video encoding resolution - Width */
    INT32                       dwFrameRate;        /* Ƶ֡  Video encoding configuration frame rate */
    INT32                       dwBitRate;          /*   Bit rate */
    NETDEV_VIDEO_CODE_TYPE_E    enCodeType;         /* Ƶʽ  Video encoding format */
    NETDEV_VIDEO_QUALITY_E      enQuality;          /* ͼ  Image quality */
    INT32                       dwGop;              /* I֡  I-frame interval */
    BYTE                        byRes[32];          /* ֶ  Reserved */
}NETDEV_VIDEO_STREAM_INFO_S, *LPNETDEV_VIDEO_STREAM_INFO_S;


/**
 * @struct tagNETDEVLogFindCond
 * @brief ־ѯ ṹ嶨 Log query condition Structure definition
 * @attention  None
 */
typedef struct tagNETDEVLogFindCond
{
    NETDEV_LOG_MAIN_TYPE_E      enMainType;         /*   Main type */
    NETDEV_LOG_SUBTYPE_ID_E     enSubType;          /*   Sub type */
    INT64                       tBeginTime;         /* ʼʱ  Start time */
    INT64                       tEndTime;           /* ʱ  End time */
}NETDEV_LOG_FIND_COND_S, *LPNETDEV_LOG_FIND_COND_S;

/***************** 澯ҵ  Alarm services**************************************************/
/**
 * @struct tagNETDEVAlarmInfo
 * @brief 澯Ϣ ṹ嶨 Alarm information Structure definition
 * @attention  None
 */
typedef struct tagNETDEVAlarmInfo
{
    INT32   dwAlarmType;        /* 澯ͣμö#NETDEV_ALARM_TYPE_E  Alarm type, see enumeration #NETDEV_ALARM_TYPE_E */
    INT64   tAlarmTime;         /* 澯ʱ  Alarm occurrence time */
    BYTE    byRes[32];          /* ֶ  Reserved */
}NETDEV_ALARM_INFO_S, *LPNETDEV_ALARM_INFO_S;

/**
 * @struct tagNETDEVPullAlarmInfo
 * @brief  澯Ϣ ṹ嶨 Get alarm information Structure definition
 * @attention  None
 */
typedef struct tagNETDEVPullAlarmInfo
{
    NETDEV_ALARM_TYPE_E   enAlarm;         /* 澯  Alarm type */
    INT32   dwChancelId;                   /* ͨţNVR  Channel number for NVR */
}NETDEV_PULLALARM_INFO_S, *LPNETDEV_PULLALARM_INFO_S;

/***********************   Boolean configuration***************************** */

/**
 * @struct tagNETDEVAlarmInputInfo
 * @brief  澯Ϣ ṹ嶨  Alarm boolean inputs info Structure definition
 * @attention  None
 */
typedef struct tagNETDEVAlarmInputInfo
{
    CHAR  szName[NETDEV_LEN_64];                                                  /* 뿪   Name of input alarm */
}NETDEV_ALARM_INPUT_INFO_S, *LPNETDEV_ALARM_INPUT_INFO_S;

/**
 * @struct tagNETDEVAlarmInputInfoList
 * @brief  и澯Ϣ ṹ嶨  All Alarm boolean inputs info Structure definition
 * @attention  None
 */
typedef struct tagNETDEVAlarmInputInfoList
{
    INT32                        dwSize;                                           /* 뿪  Number of input alarms */
    NETDEV_ALARM_INPUT_INFO_S    astAlarmInputInfo[NETDEV_MAX_ALARM_IN_NUM];       /* 뿪Ϣ  Configuration information of input alarms */
}NETDEV_ALARM_INPUT_LIST_S, *LPNETDEV_ALARM_INPUT_LIST_S;

/**
 * @struct tagNETDEVAlarmOutputInfo
 * @brief  澯Ϣ ṹ嶨 Alarm boolean outputs info Structure definition
 * @attention  None
 */
typedef struct tagNETDEVAlarmOutputInfo
{   
    CHAR    szName[NETDEV_LEN_64];                  /*   Boolean name */
    INT32   dwChancelId;                            /* ͨ Channel number */
    INT32   enDefaultStatus;                        /* Ĭ״̬ μ#NETDEV_BOOLEAN_MODE_E  Default status of boolean output, see enumeration #NETDEV_BOOLEAN_MODE_E */
    INT32   dwDurationSec;                          /* 澯ʱ λ S  Alarm duration (s) */
} NETDEV_ALARM_OUTPUT_INFO_S, *LPNETDEV_ALARM_OUTPUT_INFO_S;

/**
 * @struct tagNETDEVAlarmOutputList
 * @brief  и澯Ϣ ṹ嶨 All Alarm boolean outputs info Structure definition
 * @attention  None
 */
typedef struct tagNETDEVAlarmOutputList
{   
    INT32                       dwSize;                                                 /*    Number of booleans  */
    NETDEV_ALARM_OUTPUT_INFO_S  astAlarmOutputInfo[NETDEV_MAX_ALARM_OUT_NUM];           /* Ϣ  Boolean configuration information */
} NETDEV_ALARM_OUTPUT_LIST_S, *LPNETDEV_ALARM_OUTPUT_LIST_S;

/**
 * @struct tagNETDEVTriggerAlarmOutput
 * @brief  澯 ṹ嶨 Trigger boolean output alarm Structure definition
 * @attention  None
 */
typedef struct tagNETDEVTriggerAlarmOutput
{   
    CHAR                        szName[NETDEV_LEN_64];          /*   Boolean name */
    NETDEV_RELAYOUTPUT_STATE_E  enOutputState;                  /* ״̬,οö#NETDEV_RELAYOUTPUT_STATE_E  Trigger status, see enumeration #NETDEV_RELAYOUTPUT_STATE_E */
} NETDEV_TRIGGER_ALARM_OUTPUT_S, *LPNETDEV_TRIGGER_ALARM_OUTPUT_S;

/************************************************ OSD********************************************************/

/**
 * @struct tagNETDEVAreaScope
 * @brief   Area
 * @attention  None
 */
typedef struct tagNETDEVAreaScope
{
    INT32  dwLocateX;             /** xֵ[0,10000] * Coordinates of top point x [0,10000] */
    INT32  dwLocateY;             /** yֵ[0,10000] * Coordinates of top point y [0,10000] */
}NETDEV_AREA_SCOPE_S, *LPNETDEV_AREA_SCOPE_S;

/**
 * @struct tagNETDEVOsdTime
 * @brief OSDʱϢ OSD time configuration information
 * @attention  None
 */
typedef struct tagNETDEVOsdTime
{
    BOOL                    bEnableFlag;        /** ʱOSDʹܣ BOOL_TRUEΪʹܣBOOL_FALSEΪʹ * Enable time OSD, BOOL_TRUE means enable and BOOL_FALSE means disable */
    BOOL                    bWeekEnableFlag;    /** Ƿʾ(Ԥ) * Display week or not (reserved) */
    NETDEV_AREA_SCOPE_S     stAreaScope;        /**  * Area coordinates */
    UINT32                  udwTimeFormat;      /** ʱOSDʱʽNETDEV_OSD_TIME_FORMAT_E * Time OSD format, see NETDEV_OSD_TIME_FORMAT_E */
    UINT32                  udwDateFormat;      /** OSDʱʽNETDEV_OSD_DATE_FMT_E * Date OSD format, see NETDEV_OSD_TIME_FORMAT_E */

}NETDEV_OSD_TIME_S, *LPNETDEV_OSD_TIME_S;

/**
 * @struct tagNETDEVOsdTextOverlay
 * @brief OSDַϢ OSD text overlay information
 * @attention
 */
typedef struct tagNETDEVOsdTextOverlay
{
    BOOL                    bEnableFlag;                /** OSDַʹܣ BOOL_TRUEΪʹܣBOOL_FALSEΪʹ * Enable OSD text overlay, BOOL_TRUE means enable and BOOL_FALSE means disable */
    NETDEV_AREA_SCOPE_S     stAreaScope;                /** OSDַ * OSD text overlay area coordinates */
    CHAR                    szOSDText[NETDEV_OSD_TEXT_MAX_LEN];    /** OSDַַ * OSD text overlay name strings */
    BYTE                    byRes[4];                               /* ֶ  Reserved */
}NETDEV_OSD_TEXT_OVERLAY_S, *LPNETDEV_OSD_TEXT_OVERLAY_S;

/**
 * @struct tagNETDEVOsdCfgInfo
 * @brief ͨOSDĻϢ Basic channel OSD information
 * @attention
 */
typedef struct tagNETDEVOsdCfgInfo
{
    NETDEV_OSD_TIME_S         stTimeOSD;        /* ͨʱOSDϢ  Information of channel time OSD */  
    NETDEV_OSD_TEXT_OVERLAY_S stNameOSD;        /* ͨOSDϢ  Information of channel name OSD */   
    INT16                     wTextNum;         /* ַOSD  Text OSD number */    
    NETDEV_OSD_TEXT_OVERLAY_S astTextOverlay[NETDEV_OSD_TEXTOVERLAY_NUM];   /** ͨOSDַϢ * Information of channel OSD text overlay */
}NETDEV_VIDEO_OSD_CFG_S, *LPNETDEV_VIDEO_OSD_CFG_S;

/**
 * @struct tagAreaInfo
 * @brief ýṹ嶨 Definition of area configuration structure 
 * @attention
 */
typedef struct tagAreaInfo
{
    INT32   bIsEanbled;          /* Ƿ  Enable or not. */
    INT32   dwTopLeftX;           /* ϽX [0, 10000]  Upper left corner X [0, 10000]  */
    INT32   dwTopLeftY;           /* ϽY [0, 10000]  Upper left corner Y [0, 10000]  */
    INT32   dwBottomRightX;       /* ½X [0, 10000]  Lower right corner x [0, 10000] */
    INT32   dwBottomRightY;       /* ½Y [0, 10000]  Lower right corner y [0, 10000] */
}NETDEV_PRIVACY_MASK_AREA_INFO_S;

/**
 * @struct tagPrivacyMaskPara
 * @brief ˽ڸϢ Privacy mask configuration information
 * @attention
 */
typedef struct tagPrivacyMaskPara
{
    INT32                                  dwSize;                                     /*   Mask area number */ 
    NETDEV_PRIVACY_MASK_AREA_INFO_S        astArea[NETDEV_MAX_PRIVACY_MASK_AREA_NUM];  /**< ڸ *< Mask area parameters */
}NETDEV_PRIVACY_MASK_CFG_S, *LPNETDEV_PRIVACY_MASK_CFG_S;

/************************************************ Ƶ********************************************************/

/**
 * @struct tagNETDEVTamperAlarmInfo
 * @brief ڵϢ
 * @attention  None
 */
typedef struct tagNETDEVTamperAlarmInfo
{
    INT32  dwSensitivity;                               /*   Sensitivity */
    BYTE    byRes[256];                                /* ֶ  Reserved */
}NETDEV_TAMPER_ALARM_INFO_S, *LPNETDEV_TAMPER_ALARM_INFO_S;

/**
 * @struct tagNETDEVMotionAlarmInfo
 * @brief ˶Ϣ
 * @attention  None
 */
typedef struct tagNETDEVMotionAlarmInfo
{
    INT32  dwSensitivity;                                                     /*   Sensitivity */
    INT32  dwObjectSize;                                                      /* С  Objection Size */
    INT32  dwHistory;                                                         /* ʱ  History */
    INT16  awScreenInfo[NETDEV_SCREEN_INFO_ROW][NETDEV_SCREEN_INFO_COLUMN];   /* ĻϢ  Screen Info */
    BYTE   byRes[64];                                                         /* ֶ  Reserved */
}NETDEV_MOTION_ALARM_INFO_S, *LPNETDEV_MOTION_ALARM_INFO_S;

/* END************************************************ ṹ************************************************** */


/**
* ƴ֡ǰýݻصָ  Type of pointer to media stream data callback function before being framed 
* @param [IN] lpRealHandle      ǰʵž Current live playing handle
* @param [IN] pucBuffer         ƴ֡ǰýݻָ Pointer to buffer that stores stream data that is not framed
* @param [IN] dwBufSize         С Buffer size
* @param [IN] dwMediaDataType   ýͣμýöٶ#NETDEV_MEDIAFORMAT_E Media data type, see definitions of enumeration #NETDEV_MEDIA_DATA_TYPE_E
* @param [IN] lpUserParam       ûòûڵ#NDPlayer_SetSourceMediaDataCBʱָû User-set parameters, specified by users when they call the #NDPlayer_SetSourceMediaDataCB function
* @return ޡ None.
* @note  ûӦʱýݣȷ췵أӰ첥ڵý Users should handle output stream data in a timely manner so that functions can be returned quickly. Otherwise, stream processing in the player will be affected.
*/
typedef void (STDCALL *NETDEV_SOURCE_DATA_CALLBACK_PF)(IN LPVOID        lpRealHandle,
                                                       IN const BYTE    *pucBuffer,
                                                       IN INT32         dwBufSize,
                                                       IN INT32         dwMediaDataType,
                                                       IN LPVOID        lpUserParam
                                                       );

/**
* ƴ֡Ƶݻصָ  Type of pointer to callback function for framed stream data 
* @param [IN] lpRealHandle          ǰʵž Current live playing handle
* @param [IN] pstParseVideoData     ƴ֡ƵϢָ Pointer to buffer that stores framed video stream data
* @param [IN] lUserParam            ûòûڵ#NDPlayer_SetParseVideoDataCBʱָû User-set parameters, specified by users when they call the #NDPlayer_SetParseVideoDataCB function
* @return ޡ None.
* @note
* -     ûӦʱݣȷ췵أӰ첥ڵý Users should handle output stream data in a timely manner so that functions can be returned quickly. Otherwise, stream processing in the player will be affected.
*/
typedef void (STDCALL *NETDEV_PARSE_VIDEO_DATA_CALLBACK_PF)(IN LPVOID lpRealHandle,
                                                            IN const NETDEV_PARSE_VIDEO_DATA_S *pstParseVideoData,
                                                            IN LPVOID lpUserParam
                                                            );

/**
* Ƶݻصָ  Type of pointer to callback function for decoded video stream data 
* @param [IN] lpRealHandle      ǰʵž Current live playing handle
* @param [IN] pstPictureData    ŽƵϢָ Pointer to buffer that stores decoded video stream data
* @param [IN] lpUserParam       ûòûڵ#NDPlayer_SetDecodeVideoDataCBʱָû User-set parameters, specified by users when they call the #NDPlayer_SetDecodeVideoDataCB function
* @return ޡ None.
* @note
* -     1ûӦʱƵݣȷ췵أӰ첥ڵý
* -     1. Users should handle output stream data in a timely manner so that functions can be returned quickly. Otherwise, stream processing in the player will be affected.
* -     2Ƶyv12ʽ˳Y0-Y1-......U0-U1-......V0-V1-......
* -     2. Video data is in yv12 format in sequence of Y0-Y1-......, U0-U1-......, V0-V1-......
*/
typedef void (STDCALL* NETDEV_DECODE_VIDEO_DATA_CALLBACK_PF)(IN LPVOID lpRealHandle,
                                                             IN const NETDEV_PICTURE_DATA_S *pstPictureData,
                                                             IN LPVOID lpUserParam
                                                             );

/**
* Ƶݻصָ  Type of pointer to callback function for decoded audio stream data 
* @param [IN] lpRealHandle   ǰʵž Current live playing handle
* @param [IN] pstWaveData    ŽƵϢָ Pointer to buffer that stores decoded audio stream data
* @param [IN] lpUserParam    ûòûڵ#NDPlayer_SetDecodeAudioDataCBʱָû User-set parameters, specified by users when they call the #NDPlayer_SetDecodeAudioDataCB function
* @return ޡ None.
* @note
* -     ûӦʱƵݣȷ췵أӰ첥ڵý
* -     Users should handle output stream data in a timely manner so that functions can be returned quickly. Otherwise, stream processing in the player will be affected.
*/
typedef void (STDCALL* NETDEV_DECODE_AUDIO_DATA_CALLBACK_PF)(IN LPVOID lpRealHandle,
                                                             IN const NETDEV_WAVE_DATA_S *pstWaveData,
                                                             IN LPVOID lpUserParam
                                                             );

/**
* ʾݻصָ Type of pointer to display data callback function
* @param [IN] lpHandle       ǰʵž Current live playing handle
* @param [IN] hdc            ʾhdcûhdc ͼ Display superficial hdc which can be used for drawing graphics.
* @param [IN] lpUserParam    ûòûڵ#NETDEV_SetPlayDisplayCBʱָû User-set parameters, specified by users when they call the #NETDEV_SetPlayDisplayCB
* @return ޡ
* @note
* -     ûӦʱƵݣȷ췵أӰ첥ڵý
* -     Users should handle output stream data in a timely manner so that functions can be returned quickly. Otherwise, stream processing in the player will be affected.
*/
typedef void (STDCALL* NETDEV_DISPLAY_CALLBACK_PF)(IN LPVOID lpHandle,
                                                   IN LPVOID hdc,
                                                   IN LPVOID lpUserParam
                                                   );

/**
* ո澯ϢĻص  Callback function to receive alarm information
* @param [IN] lpUserID              û¼ID User login ID
* @param [IN] dwChannelID           ͨ Channel number
* @param [IN] NETDEV_ALARM_INFO_S   澯Ϣ Alarm information
* @param [IN] lpBuf                 ָ Pointer to buffer
* @param [IN] dwBufLen              澯ϢӦṹĳ Length of structure for alarm information
* @param [IN] dwBufLen              û User data
* @note
*/
typedef void(STDCALL *NETDEV_AlarmMessCallBack_PF)(IN LPVOID    lpUserID,
                                                   IN INT32     dwChannelID,
                                                   IN NETDEV_ALARM_INFO_S   stAlarmInfo,
                                                   IN LPVOID    lpBuf,
                                                   IN INT32     dwBufLen,
                                                   IN LPVOID    lpUserData
                                                   );

/**
* 쳣ϢĻص  Callback function to receive exception and reconnection messages
* @param [IN] lpUserID     û¼ID User login ID
* @param [IN] dwType       쳣Ϣ:NETDEV_EXCEPTION_TYPE_E Type of exception or reconnection message: NETDEV_EXCEPTION_TYPE_E
* @param [IN] lpExpHandle  쳣Ӧ͵ľ Exception type handle
* @param [IN] lpUserData   û User data
* @note
*/
typedef void(STDCALL *NETDEV_ExceptionCallBack_PF)(IN LPVOID    lpUserID,
                                                   IN INT32     dwType,
                                                   IN LPVOID    lpExpHandle,
                                                   IN LPVOID    lpUserData
                                                   );

/**
* עصձϢȣͬʱص¼IDֲͬ豸 Register callback function and receive alarm information, etc. (Call back login ID at the same time to distinguish different devices)\n
* @param [IN] lpUserID              û¼ID User login ID
* @param [IN] cbAlarmMessCallBack   ص Callback function
* @param [IN] lpUserData            û User data
* @return TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_SetAlarmCallBack(IN LPVOID lpUserID,
                                                             IN NETDEV_AlarmMessCallBack_PF cbAlarmMessCallBack,
                                                             IN LPVOID lpUserData
                                                             );

/**
* עsdk쳣ϢĻص  Callback function to register SDK, receive exception and reconnection messages, etc.
* @param [IN] cbExceptionCallBack       쳣ϢĻصصǰ쳣Ϣ Callback function to receive exception messages, used to call back information about current exceptions
* @param [IN] lpUserData                û User data
* @return TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_SetExceptionCallBack(IN NETDEV_ExceptionCallBack_PF cbExceptionCallBack,
                                                                 IN LPVOID lpUserData
                                                                 );

/**
* SDK ʼ  SDK initialization
* @return TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* @note ̲߳ȫ Thread not safe
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_Init(void);

/**
* SDK   SDK cleaning
* @return TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_Cleanup(void);

/**
* ȡSDKİ汾Ϣ Get SDK version information 
* @return SDK汾Ϣ SDK version information
* @note
* - 2ֽڱʾ汾2ֽڱʾΰ汾0x00030000ʾ汾Ϊ3.0
* - The two high bytes indicate the major version, and the two low bytes indicate the minor version. For example, 0x00030000 means version 3.0.
*/
NETDEV_API NEWINTERFACE INT32 STDCALL NETDEV_GetSDKVersion(void);



/**
* û¼  User login
* @param [IN]  pszDevIP         豸IP Device IP
* @param [IN]  wDevPort         豸˿ Device server port
* @param [IN]  pszUserName      û Username
* @param [IN]  pszPassword       Password
* @param [OUT] pstDevInfo       豸Ϣṹָ Pointer to device information structure
* @return صû¼ID, 0 ʾʧܣֵʾصûIDֵ Returned user login ID. 0 indicates failure, and other values indicate the user ID.
* @note
*/
NETDEV_API NEWINTERFACE LPVOID STDCALL NETDEV_Login(IN char *pszDevIP,
                                                    IN INT16 wDevPort,
                                                    IN char *pszUserName,
                                                    IN char *pszPassword,
                                                    OUT LPNETDEV_DEVICE_INFO_S pstDevInfo
                                                    );

/**
* ûע  User logout
* @param [IN] lpUserID    û¼ID User login ID
* @return TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_Logout(IN LPVOID lpUserID);

/**
* ѯͨ  Query channel capabilities
* @param [IN]    lpUserID           û¼ID User login ID
* @param [INOUT] pdwChlCount        ͨ Number of channels
* @param [OUT]   pstVideoChlList    ͨб List of channel capabilities
* @return TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_QueryVideoChlDetailList(IN LPVOID   lpUserID,
                                                                    INOUT INT32 *pdwChlCount,
                                                                    OUT LPNETDEV_VIDEO_CHL_DETAIL_INFO_S pstVideoChlList
                                                                    );


/*************** Beginʵҵ  Begin live view services*********************************************/

/**
* ʵʱԤ  Start live preview
* @param [IN]  lpUserID             û¼ID User login ID
* @param [IN]  pstPreviewInfo       Ԥοö٣NETDEV_PROTOCAL_ENETDEV_LIVE_STREAM_INDEX_E Preview parameter, see enumeration: NETDEV_PROTOCAL_E, NETDEV_LIVE_STREAM_INDEX_E.
* @param [IN]  cbRealDataCallBack   ݻصָ Pointer to callback function of stream data
* @param [IN]  lpUserData           û User data
* @return صû¼ID, 0 ʾʧܣֵʾصûIDֵ Returned user login ID. 0 indicates failure, and other values indicate the user ID.
* @note
*/
NETDEV_API NEWINTERFACE LPVOID STDCALL NETDEV_RealPlay(IN LPVOID lpUserID,
                                                       IN LPNETDEV_PREVIEWINFO_S pstPreviewInfo,
                                                       IN NETDEV_SOURCE_DATA_CALLBACK_PF cbPlayDataCallBack,
                                                       IN LPVOID lpUserData
                                                       );

/**
* ֹͣʵʱԤ  Stop live preview
* @param [IN]  lpRealHandle     Ԥ Preview handle
* @return TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* @note ӦرNETDEV_RealPlayʵ Stop the live view started by NETDEV_RealPlay
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_StopRealPlay(IN LPVOID lpRealHandle);

/**
* ¼  Local recording
* @param [IN]  lpRealHandle         Ԥ Preview handle
* @param [IN]  pszSaveFileName      ļ Name of saved file
* @param [IN]  dwFormat             Format of saved file, see #NETDEV_MEDIA_FILE_FORMAT_E 
* @return TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_SaveRealData(IN LPVOID  lpRealHandle,
                                                         IN CHAR    *pszSaveFileName,
                                                         IN INT32   dwFormat
                                                         );

/**
* ֹͣ¼ Stop local recording
* @param [IN]  lpRealHandle     Ԥ Preview handle
* @return TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_StopSaveRealData(IN LPVOID lpRealHandle);

/**
*   Enable sound
* @param [IN]  lpRealHandle   Ԥ Preview handle
* @return TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_OpenSound(IN LPVOID lpRealHandle);

/**
* 
* @param [IN]  lpRealHandle   Ԥ Preview handle
* @param [IN]  dwVolume        Volume
* @return TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_SoundVolumeControl(IN LPVOID lpRealHandle, 
                                                               IN INT32 dwVolume
                                                               );

/**
* ر Mute
* @param [IN]  lpRealHandle   Ԥ Preview handle
* @return TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_CloseSound(IN LPVOID lpRealHandle);


/**
* ȡ  Get window bit rate
* @param [IN]  lpPlayHandle     Ԥ\طž Preview\playback handle
* @param [OUT] pdwBitRate       ȡָ Pointer to obtained bit rate
* @return TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_GetBitRate(IN LPVOID lpPlayHandle,
                                                       OUT INT32 *pdwBitRate
                                                       );

/*
* ȡ֡  Get window frame rate
* @param [IN]  lpPlayHandle     Ԥ\طž Preview\playback handle
* @param [OUT] pdwFrameRate     ȡָ֡ Pointer to obtained frame rate
* @return TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_GetFrameRate(IN LPVOID lpPlayHandle,
                                                         OUT INT32 *pdwFrameRate
                                                         );

/**
* ȡڱʽ  Get window encoding format
* @param [IN]  lpPlayHandle         Ԥ\طž Preview\playback handle
* @param [OUT] pdwVideoEncFmt       ȡƵʽָ Pointer to obtained encoding format
* @return TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_GetVideoEncodeFmt(IN LPVOID lpPlayHandle,
                                                              OUT INT32 *pdwVideoEncFmt
                                                              );


/**
* ȡƵֱ  Get video resolution
* @param [IN]  lpPlayHandle     Ԥ\طž Preview\playback handle
* @param [OUT] pdwWidth         ȡķֱ-ָ Pointer to obtained resolution C width
* @param [OUT] pdwHeight        ȡķֱ-߶ָ Pointer to obtained resolution C height
* @return TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_GetResolution(IN LPVOID lpPlayHandle,
                                                          OUT INT32 *pdwWidth,
                                                          OUT INT32 *pdwHeight
                                                          );

/**
* ȡڶ  Get window packet loss rate
* @param [IN]  lpPlayHandle     Ԥ\طž Preview\playback handle
* @param [OUT] pulRecvPktNum    յݰָ Pointer to number of received packets
* @param [OUT] pulLostPktNum    ʧݰָ Pointer to number of lost packets
* @return TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_GetLostPacketRate(IN LPVOID lpPlayHandle,
                                                              OUT INT32 *pulRecvPktNum,
                                                              OUT INT32 *pulLostPktNum
                                                              );

/**
* ôڶ  Reset window packet loss rate
* @param [IN]  lpPlayHandle   Ԥ\طž Preview\playback handle
* @return TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_ResetLostPacketRate(IN LPVOID lpPlayHandle);

/**
* ʵץ  Live view snapshot
* @param [IN]  lpPlayHandle     Ԥ\طž Preview\playback handle
* @param [IN]  pszFileName      ͼļ·ļ File path to save images (including file name)
* @param [IN]  dwCaptureMode    ͼʽμ#NETDEV_PICTURE_FORMAT_E   Image saving format, see #NETDEV_PICTURE_FORMAT_E
* @return TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* @note ļпԲЯץĸʽĺ׺ File format suffix is not required in the file name
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_CapturePicture(IN LPVOID    lpPlayHandle,
                                                           IN char      *pszFileName,
                                                           IN INT32     dwCaptureMode
                                                           );

/**
* Ƶͼʾ  Modify image display ratio
* @param [IN]  lpPlayHandle   Ԥ\طž Preview\playback handle
* @param [IN]  enRenderScale  Ƶͼʾ Image display ratio
* @return TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_SetRenderScale(IN LPVOID lpPlayHandle,
                                                           IN NETDEV_RENDER_SCALE_E enRenderScale
                                                           );

/**
* Ӱȡ,ֻȡǰ  Get the current image info
* @param [IN]  lpPlayHandle   Ԥ\طž Preview\playback handle
* @param [IN]  pstImageInfo   ͼϢб Image information list
* @return TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_GetVideoEffect(IN LPVOID lpPlayHandle, 
                                                           OUT LPNETDEV_VIDEO_EFFECT_S pstImageInfo
                                                           );

/**
* Ӱ,ֻı䵱ǰ  Adjust the current image
* @param [IN]  lpPlayHandle   Ԥ\طž Preview\playback handle
* @param [IN]  pstImageInfo   ͼϢб Image information list
* @return TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_SetVideoEffect(IN LPVOID lpPlayHandle, 
                                                           IN LPNETDEV_VIDEO_EFFECT_S pstImageInfo
                                                           );

/**
* ַŴ  Set Digital zoom
* @param [IN] lpPlayHandle   Ԥ\طž Preview\playback handle
* @param [IN] hWnd           ھ  window handle 
* @param [IN] pstRect         Rectangle Area
* @return TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_SetDigitalZoom(IN LPVOID          lpPlayHandle, 
                                                           IN LPVOID          hWnd,
                                                           IN LPNETDEV_RECT_S pstRect
                                                           );

/**
* עص:ԭʼ  Callback function to register streams (original stream)
* @param [IN]  lpRealHandle               ʵʱԤ Live preview handle
* @param [IN]  cbSourceDataCallBack       ݻص Callback function for stream data
* @param [IN]  bContinue                  Ƿкƴ֡ʾ Whether to continue to following framing, decoding and displaying operations.
* @param [IN]  lpUser                     û User data
* @return TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE  BOOL STDCALL NETDEV_SetPlayDataCallBack(IN LPVOID lpPlayHandle,
                                                                 IN NETDEV_SOURCE_DATA_CALLBACK_PF cbPlayDataCallBack,
                                                                 IN INT32 bContinue,
                                                                 IN LPVOID lpUser);

/**
* עʵص:ƴ֡  Callback function to register live stream (framed stream data)
* @param [IN]  lpPlayHandle              Ԥ\طž Preview\playback handle
* @param [IN]  cbParsePlayDataCallBack   ݻص Data callback function
* @param [IN]  bContinue                 Ƿ Continue or not
* @param [IN]  lpUserData                û User data
* @return TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* @note
* - رջصڶΪNULL
* - To shut the callback function, set the second parameter as NULL.
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_SetPlayParseCB(IN LPVOID    lpPlayHandle,
                                                           IN NETDEV_PARSE_VIDEO_DATA_CALLBACK_PF cbParsePlayDataCallBack,
                                                           IN INT32     bContinue,
                                                           IN LPVOID    lpUserData
                                                           );

/**
* עʵʱصƵý  Callback function to register live stream (decoded media stream data)
* @param [IN]  lpPlayHandle                 Ԥ\طž Preview\playback handle
* @param [IN]  cbPlayDecodeVideoCALLBACK    ݻص Data callback function
* @param [IN]  bContinue                    Ƿ Continue or not
* @param [IN]  lpUserData                   û User data
* @return TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* @note
* - رջصڶΪNULL
* - To shut the callback function, set the second parameter as NULL.
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_SetPlayDecodeVideoCB(IN LPVOID  lpPlayHandle,
                                                                 IN NETDEV_DECODE_VIDEO_DATA_CALLBACK_PF cbPlayDecodeVideoCALLBACK,
                                                                 IN INT32   bContinue,
                                                                 IN LPVOID  lpUserData
                                                                 );

/**
* ʾݻص  Modify displayed data callback
* @param [IN]  lpPlayHandle             Ԥ\طž Preview\playback handle
* @param [IN]  cbPlayDisplayCallBack    ݻص Data callback function
* @param [IN]  lpUserData               û User data
* @return TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* @note
* - رջصڶΪNULL
* - To shut the callback function, set the second parameter as NULL.
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_SetPlayDisplayCB(IN LPVOID lpPlayHandle,
                                                             IN NETDEV_DISPLAY_CALLBACK_PF cbPlayDisplayCallBack,
                                                             IN LPVOID lpUserData
                                                             );

/***************ʵҵ live view service*************************************************/

/***************طҵ Begin playback service********************************************/

/**
* ļ͡ʱ豸¼ļ  Query recording files according to file type and time
* @param [IN]  lpUserID     û¼ID User login ID
* @param [IN]  pstFindCond    ¼ѯ Search condition
* @return ¼ѯҵ,0ʾʧܣֵΪNETDEV_FindCloseȺĲ
Recording search service number. 0 means failure. Other values are used as the handle parameters of functions like NETDEV_FindClose.
* @note
*/
NETDEV_API NEWINTERFACE LPVOID STDCALL NETDEV_FindFile(IN LPVOID lpUserID,
                                                       IN LPNETDEV_FILECOND_S pstFindCond
                                                       );

/**
* ȡҵļϢ  Obtain the information of found files one by one.
* @param [IN]  lpFindHandle     ļҾ File search handle
* @param [OUT] pstFindData       ļϢָ Pointer to save file information
* @return TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* @note ʧ˵ѯ A returned failure indicates the end of search.
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_FindNextFile(IN LPVOID lpFindHandle,
                                                         OUT LPNETDEV_FINDDATA_S pstFindData
                                                         );

/**
* رļңͷԴ  Close file search and release resources
* @param [IN] lpFindHandle  ļҾ File search handle
* @return TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_FindClose(IN LPVOID lpFindHandle);


/**
* ƻط¼ļ  Play back recording files by name
* @param [IN] lpUserID          û¼ID User login ID
* @param [IN] pstPlayBackInfo   ¼طŽṹָ룬ο LPNETDEV_PLAYBACKINFO_S Pointer to recording playback structure, see LPNETDEV_PLAYBACKINFO_S
* @return TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* @note
*/
NEWINTERFACE LPVOID STDCALL NETDEV_PlayBackByName(IN LPVOID lpUserID,
                                                  IN LPNETDEV_PLAYBACKINFO_S pstPlayBackInfo
                                                  );

/**
* ʱط¼ļ  Play back recording by time. 
* @param [IN] lpUserID          û¼ID User login ID
* @param [IN] pstPlayBackCond   ʱ¼طŽṹָ  ο LPNETDEV_PLAYBACKCOND_S Pointer to playback-by-time structure, see LPNETDEV_PLAYBACKCOND_S
* @return TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE LPVOID STDCALL NETDEV_PlayBackByTime(IN LPVOID lpUserID,
                                                             IN LPNETDEV_PLAYBACKCOND_S pstPlayBackInfo
                                                             );

/**
* ֹͣطҵ  Stop playback service
* @param [IN] lpPlayHandle  طž Playback handle
* @return TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_StopPlayBack(IN LPVOID lpPlayHandle);

/**
* ļ¼ļ Download recordings by file name
* @param [IN]  lpUserID             û¼ID User login ID
* @param [IN]  pstPlayBackInfo      ¼طŽṹָ룬ο LPNETDEV_PLAYBACKINFO_S Pointer to recording playback structure, see LPNETDEV_PLAYBACKINFO_S
* @param [IN]  *pszSaveFileName     غ󱣴浽PCļ·Ϊ·ļ Downloaded file save path on PC, must be an absolute path (including file name)
* @param [IN]  dwFormat             ¼ļʽ Recording file saving format
* @return ؾ 0ʾʧܣֵΪNETDEV_StopGetFileȺĲ Download handle. 0 means failure. Other values are used as the handle parameters of functions like NETDEV_StopGetFile.
* @note
*/
NEWINTERFACE LPVOID STDCALL NETDEV_GetFileByName(IN LPVOID  lpUserID,
                                                 IN LPNETDEV_PLAYBACKINFO_S pstPlayBackInfo,
                                                 IN char    *pszSaveFileName,
                                                 IN INT32   dwFormat
                                                 );


/**
* ʱ¼ļ Download recordings by time
* @param [IN]  lpUserID                û¼ID User login ID
* @param [IN]  pstPlayBackCond   ʱ¼طŽṹָ룬ο LPNETDEV_PLAYBACKCOND_S Pointer to playback-by-time structure, see LPNETDEV_PLAYBACKCOND_S
* @param [IN]  *pszSaveFileName        غ󱣴浽PCļ·Ϊ·ļ Downloaded file save path on PC, must be an absolute path (including file name)
* @param [IN]  dwFormat                ¼ļʽ Recording file saving format
* @return ؾ 0ʾʧܣֵΪNETDEV_StopGetFileȺĲ Download handle. 0 means failure. Other values are used as the handle parameters of functions like NETDEV_StopGetFile.
* @note
*/
NETDEV_API NEWINTERFACE LPVOID STDCALL NETDEV_GetFileByTime(IN LPVOID lpUserID, 
                                                            IN LPNETDEV_PLAYBACKCOND_S pstPlayBackCond, 
                                                            IN char *pszSaveFileName, 
                                                            IN INT32 dwFormat
                                                            );

/**
* ֹͣ¼ļ Stop downloading recording files
* @param [IN]  lpPlayHandle  طž Playback handle
* @return TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_StopGetFile(IN LPVOID lpPlayHandle);


/**
* ¼طŵ״̬  Control recording playback status.
* @param [IN]  lpPlayHandle     طŻؾ Playback or download handle
* @param [IN]  dwControlCode    ¼ط״̬ οö٣NETDEV_VOD_PLAY_CTRL_E Command for controlling recording playback status, see NETDEV_VOD_PLAY_CTRL_E
* @param [INOUT]  lpBuffer     ָ/ָ, ٶȲοö٣NETDEV_VOD_PLAY_STATUS_EʱΪINT64 Pointer to input/output parameters. For playing speed, see NETDEV_VOD_PLAY_STATUS_E. The type of playing time: INT64.
* @return TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* @note ʼָͣʱlpBufferΪNULL When playing, pause or resume videos, set IpBuffer as NULL.
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_PlayBackControl(IN LPVOID   lpPlayHandle,
                                                            IN INT32    dwControlCode,
                                                            INOUT LPVOID lpBuffer
                                                            );




/***********طҵ End playback service ************************************************ */

/*********** ̨  Begin PTZ control ************************************************* */
/**
* ̨Ԥλ(Ԥ)  PTZ preset operation (preview required)
* @param [IN]  lpRealHandle         ʵʱԤ Live preview handle
* @param [IN]  dwPTZPresetCmd       ̨Ԥλ,οöNETDEV_PTZ_PRESETCMD_E  PTZ preset operation commands, see NETDEV_PTZ_PRESETCMD_E
* @param [IN]  pszPresetName        Ԥλ Preset name
* @param [IN]  dwPresetID           Ԥλţ1ʼ֧255Ԥλ Preset number (starting from 1). Up to 255 presets are supported.
* @return TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_PTZPreset(IN LPVOID lpRealHandle,
                                                      IN INT32  dwPTZPresetCmd,
                                                      IN CHAR   *pszPresetName,
                                                      IN INT32  dwPresetID
                                                      );

/**
* ̨Ԥλ(ҪԤ)  PTZ preset operation (preview not required)
* @param [IN]  lpUserID             û¼ID User login ID
* @param [IN]  dwChannelID          ͨ Channel number
* @param [IN]  dwPTZPresetCmd       ̨Ԥλ,οöNETDEV_PTZ_PRESETCMD_E PTZ preset operation commands, see NETDEV_PTZ_PRESETCMD_E
* @param [IN]  pszPresetName        Ԥλ Preset name
* @param [IN]  dwPresetID           Ԥλţ1ʼ֧255Ԥλ Preset number (starting from 1). Up to 255 presets are supported.
* @return TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_PTZPreset_Other(IN LPVOID   lpUserID,
                                                            IN INT32    dwChannelID,
                                                            IN INT32    dwPTZPresetCmd,
                                                            IN CHAR     *pszPresetName,
                                                            IN INT32    dwPresetID
                                                            );

/**
* ̨Ʋ(ʵԤ)  PTZ control operation (preview required)
* @param [IN]  lpRealHandle         ʵʱԤ Live preview handle
* @param [IN]  dwPTZCommand         ̨μ#NETDEV_PTZ_E PTZ control commands, see #NETDEV_PTZ_E
* @param [IN]  dwSpeed              ̨ƵٶȣûͬٶȿֵáȡֵΧ[1,9] Speed of PTZ control, which is configured according to the speed control value of different decoders. Value ranges from 1 to 9.
* @return TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_PTZControl(IN LPVOID    lpRealHandle,
                                                       IN INT32     dwPTZCommand,
                                                       IN INT32     dwSpeed
                                                       );


/**
* ̨Ʋ(ʵԤ)  PTZ control operation (preview not required)
* @param [IN]  lpUserID             û¼ID User login ID
* @param [IN]  dwChannelID          ͨ Channel Number
* @param [IN]  dwPTZCommand         ̨μ#NETDEV_PTZ_E
PTZ control commands, see #NETDEV_PTZ_E
* @param [IN]  dwSpeed              ̨ƵٶȣûͬٶȿֵáȡֵΧ[1,9] Speed of PTZ control, which is configured according to the speed control value of different decoders. Value ranges from 1 to 9.
* @return TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_PTZControl_Other(IN LPVOID  lpUserID,
                                                             IN INT32   dwChannelID,
                                                             IN INT32   dwPTZCommand,
                                                             IN INT32   dwSpeed
                                                             );

/**
* ȡ̨ԤλѲ·  Get PTZ preset patrol route
* @param [IN]   lpUserID            û¼ID User login ID
* @param [IN]   dwChannelID         ͨ Channel number
* @param [OUT]  pstCruiseList        Ѳ·б Patrol route list
* @return  TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_PTZGetCruise(IN LPVOID  lpUserID,
                                                         IN INT32   dwChannelID,
                                                         OUT LPNETDEV_CRUISE_LIST_S pstCruiseList
                                                         );

/**
* ̨ԤλѲ(ҪԤ)  PTZ preset patrol operation (preview not required)
* @param [IN]  lpUserID             û¼ID User login ID
* @param [IN]  dwChannelID          ͨ Channel number
* @param [IN]  dwPTZCruiseCmd       ̨Ѳ,ο#NETDEV_PTZ_CRUISECMD_E  PTZ patrol operation commands, see #NETDEV_PTZ_CRUISECMD_E
* @param [IN]  pstCruiseInfo         ̨Ѳ·Ϣ,ο#LPNETDEV_CRUISE_INFO_S  PTZ patrol route information, see #LPNETDEV_CRUISE_INFO_S
* @return  TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* @note
* - 1Ѳ·֧16·Ŵ1ʼ Patrol route. Up to 16 routes are supported (starting from 1).
* - 2Ѳ㣬֧32㣨Ŵ1ʼ Patrol point. Up to 32 points are supported (starting from 1).
* - 3Ԥλ(255)ʱ(255)ٶ(40)  Preset (max 255), time (max 255) and speed (max 40).
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_PTZCruise_Other(IN LPVOID lpUserID,
                                                            IN INT32 dwChannelID,
                                                            IN INT32 dwPTZCruiseCmd,
                                                            IN LPNETDEV_CRUISE_INFO_S pstCruiseInfo
                                                            );


/**
* ̨ԤλѲ(Ԥ)  PTZ preset patrol operation (preview required)
* @param [IN]  lpRealHandle         ʵʱԤ Live preview handle
* @param [IN]  dwPTZCruiseCmd       ̨Ѳ,οö٣NETDEV_PTZ_CRUISECMD_E  PTZ patrol operation commands, see NETDEV_PTZ_CRUISECMD_E
* @param [IN]  pstCruiseInfo         ̨Ѳ·Ϣ,ο#LPNETDEV_CRUISE_INFO_S  PTZ patrol route information, see #LPNETDEV_CRUISE_INFO_S
* @return  TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* @note
* - 1Ѳ·ID޸ġ Patrol route ID cannot be modified.
* - 2Ѳ·ʱĬϰ˳  New routes are added one after another.
* - 3ɾʼֹͣѲ·ʱpstCruiseInfoֻҪдѲ·IDɡ  When deleting, starting or stopping patrol, enter patrol route ID in pstCruiseInfo.
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_PTZCruise(IN LPVOID lpRealHandle,
                                                      IN INT32 dwPTZCruiseCmd,
                                                      IN LPNETDEV_CRUISE_INFO_S pstCruiseInfo
                                                      );


/**
* ȡ̨켣Ѳ·  Get PTZ patrol route
* @param [IN]   lpUserID            û¼ID User login ID
* @param [IN]   dwChannelID         ͨ Channel number
* @param [OUT]  pstTrackCruiseInfo        Ѳ·б,ο#LPNETDEV_PTZ_TRACK_INFO_S  Patrol route list, see #LPNETDEV_PTZ_TRACK_INFO_S
* @return  TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_PTZGetTrackCruise(IN LPVOID  lpUserID,
                                                              IN INT32   dwChannelID,
                                                              OUT LPNETDEV_PTZ_TRACK_INFO_S pstTrackCruiseInfo
                                                              );

/**
* ̨켣Ѳ(ҪԤ)   PTZ route patrol operation (preview not required)
* @param [IN]  lpUserID             û¼ID User login ID
* @param [IN]  dwChannelID          ͨ Channel number
* @param [IN]  dwPTZCruiseCmd       ̨켣Ѳ,ο#NETDEV_PTZ_TRACKCMD_E  PTZ route patrol operation commands, see #NETDEV_PTZ_TRACKCMD_E
* @param [INOUT]  pszTrackCruiseName         켣Ѳ,鳤#NETDEV_LEN_64  Route patrol name, suggested length #NETDEV_LEN_64
* @return  TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* @note
* - 1Ѳ켣·֧1·  Only one patrol route allowed.
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_PTZTrackCruise(IN LPVOID lpUserID,
                                                           IN INT32 dwChannelID,
                                                           IN INT32 dwPTZTrackCruiseCmd,
                                                           INOUT CHAR *pszTrackCruiseName
                                                           );

/**
* ŴС(Ԥ)   Drag to zoom in and out (preview required)
* @param [IN]  lpRealHandle         ʵʱԤ Live preview handle
* @param [IN]  pstPtzOperateArea    ŴṹϢ Drag-to-zoom structure information
* @return TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* @note ˾NVR£ͨ˽Э˾IPCָ֧ýӿ  In our NVR, this interface is supported only when our camera is connected through private protocol.
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_PTZSelZoomIn(IN LPVOID lpRealHandle, 
                                                         IN LPNETDEV_PTZ_OPERATEAREA_S pstPtzOperateArea
                                                         );

/**
* ŴС(ҪԤ)   Drag to zoom in and out(preview not required)
* @param lpUserID                   û¼ID User login ID
* @param [IN]  dwChannelID          ͨ Channel number
* @param [IN]  pstPtzOperateArea    ŴṹϢ Drag-to-zoom structure information
* @return TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* @note ˾NVR£ͨ˽Э˾IPCָ֧ýӿ  In our NVR, this interface is supported only when our camera is connected through private protocol.
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_PTZSelZoomIn_Other(IN LPVOID lpUserID,
                                                               IN INT32 dwChannelID,
                                                               IN LPNETDEV_PTZ_OPERATEAREA_S pstPtzOperateArea
                                                               );

/**********̨  End PTZ control ************************************************/

/********** Զ̲ Begin remote parameter configuration ***********************/

/**
* ȡ豸Ϣ  Get configuration information of device
* @param [IN]   lpUserID                û¼ID User login ID
* @param [IN]   dwChannelID             ͨ Channel number
* @param [IN]   dwCommand               豸μ#NETDEV_CONFIG_COMMAND_E  Device configuration commands, see #NETDEV_CONFIG_COMMAND_E
* @param [OUT]  lpOutBuffer             ݵĻָ Pointer to buffer that receives data
* @param [OUT]  dwOutBufferSize         ݵĻ峤(ֽΪλ)Ϊ0 Length (in byte) of buffer that receives data, cannot be 0.
* @param [OUT]  pdwBytesReturned        ʵյݳָ룬ΪNULL  Pointer to length of received data, cannot be NULL.
* @return TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* @note
* - 1Ѳ·ID޸ġ  Route ID cannot be modified.
* - 2Ѳ·ʱĬϰ˳  New routes are added one after another.
* - 3ɾʼֹͣѲ·ʱpstCruiseInfoֻҪдѲ·IDɡ  When deleting, starting or stoping a patrol route, enter route ID in pstCruiseInfo.
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_GetDevConfig(IN LPVOID  lpUserID,
                                                         IN INT32   dwChannelID,
                                                         IN INT32   dwCommand,
                                                         OUT LPVOID lpOutBuffer,
                                                         OUT INT32  dwOutBufferSize,
                                                         OUT INT32  *pdwBytesReturned
                                                         );

/**
* 豸Ϣ  Modify device configuration information
* @param [IN]   lpUserID            û¼ID User login ID
* @param [IN]   dwChannelID         ͨ Channel number
* @param [IN]   dwCommand           豸μ#NETDEV_CONFIG_COMMAND_E  Device configuration commands, see #NETDEV_CONFIG_COMMAND_E
* @param [IN]   lpInBuffer          ݵĻָ Pointer to buffer of input data
* @param [IN]   dwInBufferSize      ݵĻ峤(ֽΪλ) Length of input data buffer (byte)
* @return TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_SetDevConfig(IN LPVOID  lpUserID,
                                                         IN INT32   dwChannelID,
                                                         IN INT32   dwCommand,
                                                         IN LPVOID  lpInBuffer,
                                                         IN INT32   dwInBufferSize
                                                         );

/**************Զ̲  End remote parameter configuration ******************************/
/**
* 豸\n
* Restart device\n
* @param [IN]  lpUserID     û¼ID User login ID
* @return TRUEʾɹʾʧ TRUE means success, and any other value means failure.
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_Reboot(IN LPVOID lpUserID);

/**
* ָ  Restore to factory default settings
* @param [IN]  lpUserID     û¼ID User login ID
* @return TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* @note úûãָá Restore all parameters to factory settings, except network settings and user settings.
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_RestoreConfig(IN LPVOID lpUserID);

/**
* ȡ  Get error codes
* @return  Error codes
*/
NETDEV_API NEWINTERFACE INT32 STDCALL NETDEV_GetLastError();

/**
* ȡ豸澯Ϣ  Get alarm information from the device
* @param [IN]  lpUserID        û¼ID User login ID
* @param [IN]  dwPullWaitTime  澯ȴʱ䣬λs Alarm wait time (s)
* @param [INOUT] pdwListCnt     澯ʱʾ澯ϢбСʱʾʵʸ澯Maximum number of alarms. When working as an input parameter, it indicates the length of alarm information list; when working as an output parameter, it indicates the actual number of alarms.
* @param [OUT]   pstPullAlarmList   澯ϢбڴԤȷ List of alarm information. The memory should be allocated in advance.
* @return TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* note: ûloginlogout 鳤ʱȴ Calling the function will block login and logout. It is not recommended to wait for a long time.
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_PullAlarm(IN LPVOID lpUserID, 
                                                      IN INT32 dwPullWaitTime, 
                                                      INOUT INT32 *pdwListCnt, 
                                                      OUT LPNETDEV_PULLALARM_INFO_S pstPullAlarmList
                                                      );

/**
* Ԥץ  Snapshot without preview
* @param [IN]  lpUserID             û¼ID User login ID
* @param [IN]  dwChannelID          ͨ Channel number
* @param [IN]  dwStreamType;        ͣμö#NETDEV_LIVE_STREAM_INDEX_E  Stream type, see enumeration #NETDEV_LIVE_STREAM_INDEX_E 
* @param [IN]  pszFileName          ͼļ·ļ File path to save images (including file name)
* @param [IN]  dwCaptureMode        ͼʽμ#NETDEV_PICTURE_FORMAT_E   Image saving format, see #NETDEV_PICTURE_FORMAT_E
* @return  TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* @note
        ֧JPGʽ
        Only JPG format is supported.
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_CaptureNoPreview(IN LPVOID lpUserID,
                                                             IN INT32 dwChannelID,
                                                             IN INT32 dwStreamType,
                                                             IN CHAR *pszFileName,
                                                             IN INT32 dwCaptureMode
                                                             );

#ifdef  __cplusplus
}
#endif  /* end of __cplusplus */

#endif  /* end of _NETDEV_NET_SDK_H_ */

