// PtzCtrlDlg.cpp 
//

#include "stdafx.h"
#include "NetDemo.h"
#include "PtzCtrlDlg.h"
#include <string.h>

IMPLEMENT_DYNAMIC(CPtzCtrlDlg, CDialog)

CPtzCtrlDlg::CPtzCtrlDlg(CWnd* pParent /*=NULL*/)
    : CDialog(CPtzCtrlDlg::IDD, pParent)
{
  
}

CPtzCtrlDlg::~CPtzCtrlDlg()
{
}

void CPtzCtrlDlg::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    DDX_Text(pDX, IDC_EDIT_PRESET_ID, m_lPresetID);  
    DDX_Text(pDX, IDC_EDIT_PATROL_ID, m_lCruiseID);
    DDX_Control(pDX,IDC_SLIDER_PTZSPEED,m_oPtzSpeedSld) ;
    DDX_Text(pDX,IDC_STATIC_PTZ_SPEED,m_dwPtzSpeed) ;
}


BEGIN_MESSAGE_MAP(CPtzCtrlDlg, CDialog)
    ON_BN_CLICKED(IDC_BTN_PTZCTRL_NW, &CPtzCtrlDlg::OnBnClickedBtnPtzctrlNw)
    ON_BN_CLICKED(IDC_BTN_PTZCTRL_UP, &CPtzCtrlDlg::OnBnClickedBtnPtzctrlUp)
    ON_BN_CLICKED(IDC_BTN_PTZCTRL_NE, &CPtzCtrlDlg::OnBnClickedBtnPtzctrlNe)
    ON_BN_CLICKED(IDC_BTN_PTZCTRL_LEFT, &CPtzCtrlDlg::OnBnClickedBtnPtzctrlLeft)
    ON_BN_CLICKED(IDC_BTN_PTZCTRL_STOP, &CPtzCtrlDlg::OnBnClickedBtnPtzctrlStop)
    ON_BN_CLICKED(IDC_BTN_PTZCTRL_RIGHT, &CPtzCtrlDlg::OnBnClickedBtnPtzctrlRight)
    ON_BN_CLICKED(IDC_BTN_PTZCTRL_SW, &CPtzCtrlDlg::OnBnClickedBtnPtzctrlSw)
    ON_BN_CLICKED(IDC_BTN_PTZCTRL_DOWN, &CPtzCtrlDlg::OnBnClickedBtnPtzctrlDown)
    ON_BN_CLICKED(IDC_BTN_PTZCTRL_SE, &CPtzCtrlDlg::OnBnClickedBtnPtzctrlSe)
    ON_BN_CLICKED(IDC_BTN_FOCUS_OUT, &CPtzCtrlDlg::OnBnClickedBtnFocusOut)
    ON_BN_CLICKED(IDC_BTN_GET_PRESET, &CPtzCtrlDlg::OnBnClickedBtnGetPreset)
    ON_BN_CLICKED(IDC_BTN_SET_PRESET_, &CPtzCtrlDlg::OnBnClickedBtnSetPreset)
    ON_BN_CLICKED(IDC_BTN_DELETE_PRESET, &CPtzCtrlDlg::OnBnClickedBtnDeletePreset)
    ON_BN_CLICKED(IDC_BTN_GO_TO_PRESET, &CPtzCtrlDlg::OnBnClickedBtnGoToPreset)
    ON_BN_CLICKED(IDC_BTN_GET_PATROL, &CPtzCtrlDlg::OnBnClickedBtnGetPatrol)
    ON_BN_CLICKED(IDC_BTN_EDIT_PATROL, &CPtzCtrlDlg::OnBnClickedBtnEditPatrol)
    ON_BN_CLICKED(IDC_BTN_ADD_PATROL, &CPtzCtrlDlg::OnBnClickedBtnAddCurise)
    ON_BN_CLICKED(IDC_BTN_START_PATROL, &CPtzCtrlDlg::OnBnClickedBtnStartPatrol)
    ON_BN_CLICKED(IDC_BTN_STOP_PATROL, &CPtzCtrlDlg::OnBnClickedBtnStopPatrol)
    ON_BN_CLICKED(IDC_BTN_DELETE_PATROL, &CPtzCtrlDlg::OnBnClickedBtnDeletePatrol)
    ON_BN_CLICKED(IDC_BTN_PTZ_SEL_ZOOM_IN, &CPtzCtrlDlg::OnBnClickedBtnPtzSelZoomIn)
    ON_BN_CLICKED(IDC_BTN_PTZ_SEL_ZOOM_OUT, &CPtzCtrlDlg::OnBnClickedBtnPtzSelZoomOut)
    ON_BN_CLICKED(IDC_BTN_3D_POSITION, &CPtzCtrlDlg::OnBnClickedBtn3dPosition)
    ON_NOTIFY(NM_CUSTOMDRAW, IDC_SLIDER_PTZSPEED, &CPtzCtrlDlg::OnNMCustomdrawSliderPtzspeed)
    ON_BN_CLICKED(IDC_BTN_FOCUS_IN, &CPtzCtrlDlg::OnBnClickedBtnFocusIn)
    ON_BN_CLICKED(IDC_BTN_GET_ROUTE, &CPtzCtrlDlg::OnBnClickedBtnGetRoute)
    ON_BN_CLICKED(IDC_BTN_START_RECORD_ROUTE, &CPtzCtrlDlg::OnBnClickedBtnStartRecordRoute)
    ON_BN_CLICKED(IDC_BTN_STOP_RECORD_ROUTE, &CPtzCtrlDlg::OnBnClickedBtnStopRecordRoute)
    ON_BN_CLICKED(IDC_BTN_START_ROUTE_PATROL, &CPtzCtrlDlg::OnBnClickedBtnStartRoutePatrol)
    ON_BN_CLICKED(IDC_BTN_STOP_RECORD_PATROL, &CPtzCtrlDlg::OnBnClickedBtnStopRecordPatrol)
    ON_BN_CLICKED(IDC_BTN_PTZ_WIPER_ON, &CPtzCtrlDlg::OnBnClickedBtnPtzWiperOn)
    ON_BN_CLICKED(IDC_BTN_PTZ_WIPER_OFF, &CPtzCtrlDlg::OnBnClickedBtnPtzWiperOff)
    ON_BN_CLICKED(IDC_BTN_PTZ_LIGHT_ON, &CPtzCtrlDlg::OnBnClickedBtnPtzLightOn)
    ON_BN_CLICKED(IDC_BTN_PTZ_LIGHT_OFF, &CPtzCtrlDlg::OnBnClickedBtnPtzLightOff)
    ON_BN_CLICKED(IDC_BTN_PTZ_HEATER_ON, &CPtzCtrlDlg::OnBnClickedBtnPtzHeaterOn)
    ON_BN_CLICKED(IDC_BTN_PTZ_HEATER_OFF, &CPtzCtrlDlg::OnBnClickedBtnPtzHeaterOff)
    ON_BN_CLICKED(IDC_BTN_PTZ_SNOWREMOVAL_OFF, &CPtzCtrlDlg::OnBnClickedBtnPtzSnowremovalOff)
    ON_BN_CLICKED(IDC_BTN_PTZ_SNOWREMOVAL_ON, &CPtzCtrlDlg::OnBnClickedBtnPtzSnowremovalOn)
END_MESSAGE_MAP()

BOOL CPtzCtrlDlg::OnInitDialog()
{
    CDialog::OnInitDialog() ;
    m_oPtzSpeedSld.SetRange(1,9) ;
    m_oPtzSpeedSld.SetPos(5) ;
    m_dwPtzSpeed = 5 ;

    m_bRouteRecording = FALSE;
    m_bTracking = FALSE;

     return TRUE ;
}

/* PTZ control: upper left */
void CPtzCtrlDlg::OnBnClickedBtnPtzctrlNw()
{
    BOOL bRet = NETDEV_PTZControl_Other(m_lpDevHandle, m_lChannelID, NETDEV_PTZ_LEFTUP,m_dwPtzSpeed);
    if(TRUE != bRet)
    {
        MessageBox("PTZ control left-up failed.");
    }

    return;
}

/* PTZ control: upward */
void CPtzCtrlDlg::OnBnClickedBtnPtzctrlUp()
{
    BOOL bRet = NETDEV_PTZControl_Other(m_lpDevHandle, m_lChannelID, NETDEV_PTZ_TILTUP,m_dwPtzSpeed);
    if(TRUE != bRet)
    {
        MessageBox("PTZ control tilt-up failed.");
    }

    return;
}

/* PTZ control: upper right */
void CPtzCtrlDlg::OnBnClickedBtnPtzctrlNe()
{    
    BOOL bRet = NETDEV_PTZControl_Other(m_lpDevHandle, m_lChannelID, NETDEV_PTZ_RIGHTUP,m_dwPtzSpeed);
    if(TRUE != bRet)
    {
        MessageBox("PTZ control right-up failed.");
    }

     return;
}

/* PTZ control: left */
void CPtzCtrlDlg::OnBnClickedBtnPtzctrlLeft()
{
    BOOL bRet = NETDEV_PTZControl_Other(m_lpDevHandle, m_lChannelID, NETDEV_PTZ_PANLEFT, m_dwPtzSpeed);
    if(TRUE != bRet)
    {
        MessageBox("PTZ control left failed.");
    }

     return;
}

/* PTZ control: right */
void CPtzCtrlDlg::OnBnClickedBtnPtzctrlRight()
{
    BOOL bRet = NETDEV_PTZControl_Other(m_lpDevHandle, m_lChannelID, NETDEV_PTZ_PANRIGHT,m_dwPtzSpeed);
    if(TRUE != bRet)
    {
        MessageBox("PTZ control right failed.");
    }

    return;
}

/* PTZ control: lower left */
void CPtzCtrlDlg::OnBnClickedBtnPtzctrlSw()
{    
    BOOL bRet = NETDEV_PTZControl_Other(m_lpDevHandle, m_lChannelID, NETDEV_PTZ_LEFTDOWN,m_dwPtzSpeed);
    if(TRUE != bRet)
    {
        MessageBox("PTZ control left-down failed.");
    }

     return;
}

/* PTZ control: downward */
void CPtzCtrlDlg::OnBnClickedBtnPtzctrlDown()
{
    BOOL bRet = NETDEV_PTZControl_Other(m_lpDevHandle, m_lChannelID, NETDEV_PTZ_TILTDOWN,m_dwPtzSpeed);
    if(TRUE != bRet)
    {
        MessageBox("PTZ control down failed.");
    }

    return;
}

/* PTZ control: lower right */
void CPtzCtrlDlg::OnBnClickedBtnPtzctrlSe()
{    
    BOOL bRet = NETDEV_PTZControl_Other(m_lpDevHandle, m_lChannelID, NETDEV_PTZ_RIGHTDOWN,m_dwPtzSpeed);
    if(TRUE != bRet)
    {
        MessageBox("PTZ control right-down failed.");
    }

    return;
}

/* PTZ control: stop */
void CPtzCtrlDlg::OnBnClickedBtnPtzctrlStop()
{
    BOOL bRet = NETDEV_PTZControl_Other(m_lpDevHandle, m_lChannelID, NETDEV_PTZ_ALLSTOP, 0);
    if(TRUE != bRet)
    {
        MessageBox("PTZ control all stop failed.");
    }

    return;
}

/* PTZ control: focus in */
void CPtzCtrlDlg::OnBnClickedBtnFocusIn()
{    
    BOOL bRet = NETDEV_PTZControl_Other(m_lpDevHandle, m_lChannelID, NETDEV_PTZ_ZOOMTELE,m_dwPtzSpeed);
    if(TRUE != bRet)
    {
        MessageBox("PTZ control zoom-tele failed.");
    }

    return;
}

/* PTZ control: focus out */
void CPtzCtrlDlg::OnBnClickedBtnFocusOut()
{    
    BOOL bRet = NETDEV_PTZControl_Other(m_lpDevHandle, m_lChannelID, NETDEV_PTZ_ZOOMWIDE,m_dwPtzSpeed);
    if(TRUE != bRet)
    {
        MessageBox("PTZ control zoom-wide failed.");
    }

    return;
}

/* Get preset information */
void CPtzCtrlDlg::OnBnClickedBtnGetPreset()
{
    NETDEV_PTZ_ALLPRESETS_S stPtzPresets;
    memset(&stPtzPresets, 0, sizeof(stPtzPresets));

    INT32 dwBytesReturned = 0;
    BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_PTZPRESETS, (LPVOID)&stPtzPresets, sizeof(NETDEV_PTZ_ALLPRESETS_S), &dwBytesReturned);
    if(TRUE != bRet)
    {
        MessageBox("Get presets failed.");
    }
    else
    {
        CString strTemp, strOut;

        for(INT32 i = 0; i < stPtzPresets.dwSize; i++)
        {
            strTemp.Format("NO.%d   ID%d  Name %s\n", i, stPtzPresets.astPreset[i].dwPresetID, stPtzPresets.astPreset[i].szPresetName);
            strOut += strTemp;
        }

        MessageBox(strOut);
    }

    return;
}

/* Set Preset */
void CPtzCtrlDlg::OnBnClickedBtnSetPreset()
{
    UpdateData();
    if(0 > m_lPresetID || m_lPresetID >= NETDEV_MAX_PRESET_NUM)
    {
        MessageBox("Preset ID invalid.");
    }

    CHAR szPresetName[NETDEV_LEN_32];
    memset(szPresetName, 0, NETDEV_LEN_32 - 1);
    (VOID)_snprintf(szPresetName, (NETDEV_LEN_32 - 1), "%u", m_lPresetID);

    BOOL bRet = NETDEV_PTZPreset_Other(m_lpDevHandle, m_lChannelID, NETDEV_PTZ_SET_PRESET, szPresetName, m_lPresetID);
    if(TRUE != bRet)
    {
        MessageBox("Set preset failed.");
    }
    else
    {
        OnBnClickedBtnGetPreset();
    }
}

/* Delete preset */
void CPtzCtrlDlg::OnBnClickedBtnDeletePreset()
{
    UpdateData();
    if(0 > m_lPresetID || m_lPresetID >= NETDEV_MAX_PRESET_NUM)
    {
        MessageBox("Preset ID invalid.");
    }

    CHAR strPresetName[NETDEV_NAME_MAX_LEN] = "";

    BOOL bRet = NETDEV_PTZPreset_Other(m_lpDevHandle, m_lChannelID, NETDEV_PTZ_CLE_PRESET, strPresetName, m_lPresetID);
    if(TRUE != bRet)
    {
        MessageBox("Delete preset failed.");
    }  
    else
    {
        OnBnClickedBtnGetPreset();
    }
}

/* Go to preset */
void CPtzCtrlDlg::OnBnClickedBtnGoToPreset()
{
    UpdateData();
    if(0 > m_lPresetID  && m_lPresetID >= NETDEV_MAX_PRESET_NUM)
    {
        MessageBox("Preset ID invalid.");
    }

    CHAR strPresetName[64] = "";

    BOOL bRet = NETDEV_PTZPreset_Other(m_lpDevHandle, m_lChannelID, NETDEV_PTZ_GOTO_PRESET, strPresetName, m_lPresetID);
    if(TRUE != bRet)
    {
        MessageBox("Go to preset failed.");
    }

    return;
}

/* Get preset patrol route */
void CPtzCtrlDlg::OnBnClickedBtnGetPatrol()
{
    NETDEV_CRUISE_LIST_S stCuriseList;
    memset(&stCuriseList, 0, sizeof(NETDEV_CRUISE_LIST_S));

    BOOL bRet = NETDEV_PTZGetCruise(m_lpDevHandle, m_lChannelID, &stCuriseList);
    if(TRUE != bRet)
    {
        MessageBox("Get Cruise failed.");
    }  
    else
    {
        CString strTemp, strOut;
        for(INT32 i = 0; i < stCuriseList.dwSize; i++)
        {
            strTemp.Format("[Cruise]NO.%d   ID%d  Name %s\n", i, stCuriseList.astCruiseInfo[i].dwCuriseID, stCuriseList.astCruiseInfo[i].szCuriseName);
            strOut += strTemp;

            for(INT32 k = 0; k < stCuriseList.astCruiseInfo[i].dwSize; k++)
            {
                strTemp.Format("\t [Preset] NO.%d   ID%d  StayTime %d\n", k, stCuriseList.astCruiseInfo[i].astCruisePoint[k].dwPresetID, stCuriseList.astCruiseInfo[i].astCruisePoint[k].dwStayTime);
                strOut += strTemp;
            }
        }

        MessageBox(strOut);
    }

    return;
}

/* Edit preset patrol route */
void CPtzCtrlDlg::OnBnClickedBtnEditPatrol()
{
    UpdateData();

    NETDEV_CRUISE_INFO_S stCruiseInfo;
    memset(&stCruiseInfo, 0, sizeof(NETDEV_CRUISE_INFO_S));

    stCruiseInfo.dwCuriseID = m_lCruiseID;
    (VOID)_snprintf(stCruiseInfo.szCuriseName, (NETDEV_LEN_32 - 1), "%u", stCruiseInfo.dwCuriseID);
    stCruiseInfo.dwSize = 3;

    stCruiseInfo.astCruisePoint[0].dwPresetID = 3;
    stCruiseInfo.astCruisePoint[0].dwStayTime = 14000;

    stCruiseInfo.astCruisePoint[1].dwPresetID = 4;
    stCruiseInfo.astCruisePoint[1].dwStayTime = 15000;

    stCruiseInfo.astCruisePoint[2].dwPresetID = 5;
    stCruiseInfo.astCruisePoint[2].dwStayTime = 16000;

    BOOL bRet = NETDEV_PTZCruise_Other(m_lpDevHandle, m_lChannelID, NETDEV_PTZ_MODIFY_CRUISE, &stCruiseInfo);
    if(TRUE != bRet)
    {
        MessageBox("Edit Cruise failed.");
    }
    else
    {
        OnBnClickedBtnGetPatrol();
    }

    return;
}

/* Add preset patrol route */
void CPtzCtrlDlg::OnBnClickedBtnAddCurise()
{
    UpdateData();

    NETDEV_CRUISE_INFO_S stCruiseInfo;
    memset(&stCruiseInfo, 0, sizeof(NETDEV_CRUISE_INFO_S));

    (VOID)_snprintf(stCruiseInfo.szCuriseName, (NETDEV_LEN_32 - 1), "%u", stCruiseInfo.dwCuriseID);

    stCruiseInfo.dwSize = 2;
    stCruiseInfo.astCruisePoint[0].dwPresetID = 1;
    stCruiseInfo.astCruisePoint[0].dwStayTime = 11000;

    stCruiseInfo.astCruisePoint[1].dwPresetID = 2;
    stCruiseInfo.astCruisePoint[1].dwStayTime = 12000;

    BOOL bRet = NETDEV_PTZCruise_Other(m_lpDevHandle, m_lChannelID, NETDEV_PTZ_ADD_CRUISE,&stCruiseInfo);
    if(TRUE != bRet)
    {
        MessageBox("Add Cruise failed.");
    }
    else
    {
        OnBnClickedBtnGetPatrol();
    }

    return;
}

/* Delete preset patrol route */
void CPtzCtrlDlg::OnBnClickedBtnDeletePatrol()
{
    UpdateData();
    NETDEV_CRUISE_INFO_S stCruiseInfo;
    memset(&stCruiseInfo, 0, sizeof(NETDEV_CRUISE_INFO_S));
    stCruiseInfo.dwCuriseID = m_lCruiseID;

    BOOL bRet = NETDEV_PTZCruise_Other(m_lpDevHandle, m_lChannelID, NETDEV_PTZ_DEL_CRUISE,&stCruiseInfo);
    if(TRUE != bRet)
    {
        MessageBox("failed.");
    }
    else
    {
        OnBnClickedBtnGetPatrol();
    }

    return;
}

/* Start preset patrol */
void CPtzCtrlDlg::OnBnClickedBtnStartPatrol()
{
    UpdateData();

    NETDEV_CRUISE_INFO_S stCruiseInfo;
    memset(&stCruiseInfo, 0, sizeof(NETDEV_CRUISE_INFO_S));
    stCruiseInfo.dwCuriseID = m_lCruiseID;

    BOOL bRet = NETDEV_PTZCruise_Other(m_lpDevHandle, m_lChannelID, NETDEV_PTZ_RUN_CRUISE,&stCruiseInfo);
    if(TRUE != bRet)
    {
        MessageBox("Start Curise failed.");
    }

    return;
}

/* Stop preset patrol */
void CPtzCtrlDlg::OnBnClickedBtnStopPatrol()
{
    UpdateData();
    NETDEV_CRUISE_INFO_S stCruiseInfo;
    memset(&stCruiseInfo, 0, sizeof(NETDEV_CRUISE_INFO_S));
    stCruiseInfo.dwCuriseID = m_lCruiseID;

    BOOL bRet = NETDEV_PTZCruise_Other(m_lpDevHandle, m_lChannelID, NETDEV_PTZ_STOP_CRUISE,&stCruiseInfo);
    if(TRUE != bRet)
    {
        MessageBox("Stop Cruise failed.");
    }

    return;
}

/* Get route */
void CPtzCtrlDlg::OnBnClickedBtnGetRoute()
{
    NETDEV_PTZ_TRACK_INFO_S stTrackCruiseInfo;
    memset(&stTrackCruiseInfo, 0, sizeof(NETDEV_PTZ_TRACK_INFO_S));

    BOOL bRet = NETDEV_PTZGetTrackCruise(m_lpDevHandle, m_lChannelID, &stTrackCruiseInfo);
    if(TRUE != bRet)
    {
        MessageBox("Get Route failed.");
        return;
    }
    else
    {
        CString strOut;
        strOut.Format("Track name: %s", stTrackCruiseInfo.aszTrackName[0]);
        MessageBox(strOut);
    }

    return;
}

/* Strat recording route */
void CPtzCtrlDlg::OnBnClickedBtnStartRecordRoute()
{

    NETDEV_PTZ_TRACK_INFO_S stTrackCruiseInfo;
    memset(&stTrackCruiseInfo, 0, sizeof(NETDEV_PTZ_TRACK_INFO_S));

    BOOL bRet = NETDEV_PTZGetTrackCruise(m_lpDevHandle, m_lChannelID, &stTrackCruiseInfo);
    if(TRUE != bRet)
    {

        /* Get error codes */
        INT32 iRet = NETDEV_GetLastError();
        if(NETDEV_E_NONSUPPORT == iRet)
        {
            MessageBox("Get Route failed.");
            return;
        }
        else
        {
            /* If route patrol is supported, an empty route will be created. */
            bRet = NETDEV_PTZTrackCruise(m_lpDevHandle, m_lChannelID, NETDEV_PTZ_TRACKCRUISEADD, stTrackCruiseInfo.aszTrackName[0]);
            if(TRUE != bRet)
            {
                MessageBox("Creat Route failed.");
                return;
            }
        }
    }

    /* Use PTZ to record route */
    bRet = NETDEV_PTZTrackCruise(m_lpDevHandle, m_lChannelID, NETDEV_PTZ_TRACKCRUISEREC, stTrackCruiseInfo.aszTrackName[0]);
    if(TRUE != bRet)
    {
        MessageBox("Start Recording Route failed.");
    }
    else
    {
        MessageBox("Succeed,Please Recording Route.");
    }

    m_bRouteRecording = TRUE;
    return;
}

/* Stop recording route */
void CPtzCtrlDlg::OnBnClickedBtnStopRecordRoute()
{
    if(TRUE != m_bRouteRecording)
    {
        MessageBox("Start Route patrol first");
        return;
    }

    NETDEV_PTZ_TRACK_INFO_S stTrackCruiseInfo;
    memset(&stTrackCruiseInfo, 0, sizeof(NETDEV_PTZ_TRACK_INFO_S));

    BOOL bRet = NETDEV_PTZGetTrackCruise(m_lpDevHandle, m_lChannelID, &stTrackCruiseInfo);
    if(TRUE != bRet)
    {
        MessageBox("Get Route failed.");
        return;
    }

    bRet = NETDEV_PTZTrackCruise(m_lpDevHandle, m_lChannelID, NETDEV_PTZ_TRACKCRUISERECSTOP, stTrackCruiseInfo.aszTrackName[0]);
    if(TRUE != bRet)
    {
        MessageBox("Stop Recording Route failed.");
        return;
    }
    else
    {
        MessageBox("Stop Recording Route Succeed.");
    }

    m_bRouteRecording = FALSE;
    return;
}

/* Start route patrol */
void CPtzCtrlDlg::OnBnClickedBtnStartRoutePatrol()
{
    NETDEV_PTZ_TRACK_INFO_S stTrackCruiseInfo;
    memset(&stTrackCruiseInfo, 0, sizeof(NETDEV_PTZ_TRACK_INFO_S));

    BOOL bRet = NETDEV_PTZGetTrackCruise(m_lpDevHandle, m_lChannelID, &stTrackCruiseInfo);
    if(TRUE != bRet)
    {
        MessageBox("Get Route failed.");
        return;
    }

    bRet = NETDEV_PTZTrackCruise(m_lpDevHandle, m_lChannelID, NETDEV_PTZ_TRACKCRUISE, stTrackCruiseInfo.aszTrackName[0]);
    if(TRUE != bRet)
    {
        MessageBox("Start Route patrol failed.");
    }

    m_bTracking = TRUE;
    return;
}

/* Stop route patrol */
void CPtzCtrlDlg::OnBnClickedBtnStopRecordPatrol()
{
    if(TRUE != m_bTracking)
    {
        MessageBox("Start Route first");
        return;
    }

    NETDEV_PTZ_TRACK_INFO_S stTrackCruiseInfo;
    memset(&stTrackCruiseInfo, 0, sizeof(NETDEV_PTZ_TRACK_INFO_S));

    BOOL bRet = NETDEV_PTZGetTrackCruise(m_lpDevHandle, m_lChannelID, &stTrackCruiseInfo);
    if(TRUE != bRet)
    {
        MessageBox("Get Route failed.");
        return;
    }

    bRet = NETDEV_PTZTrackCruise(m_lpDevHandle, m_lChannelID, NETDEV_PTZ_TRACKCRUISESTOP, stTrackCruiseInfo.aszTrackName[0]);
    if(TRUE != bRet)
    {
        MessageBox("Stop Route patrol failed.");
        return;
    }
    else
    {
        MessageBox("Stop Route patrol Succeed.");
    }

    m_bTracking = FALSE;
    return;
}

/* Drag to zoom in */
void CPtzCtrlDlg::OnBnClickedBtnPtzSelZoomIn()
{
    NETDEV_PTZ_OPERATEAREA_S stPtzAreaOperate;
    memset(&stPtzAreaOperate, 0, sizeof(NETDEV_PTZ_OPERATEAREA_S));

    /* Take the upper left corner of the window for playing as a start point, and the parameter value range from 0 to 10000. */
    stPtzAreaOperate.dwBeginPointX = 2000;
    stPtzAreaOperate.dwBeginPointY = 2000;
    stPtzAreaOperate.dwEndPointX = 4000;
    stPtzAreaOperate.dwEndPointY = 4000;

    BOOL bRet = NETDEV_PTZSelZoomIn_Other(m_lpDevHandle, m_lChannelID, &stPtzAreaOperate);
    if(TRUE != bRet)
    {
        MessageBox("Operate Area Failed");
    }

    return;
}

/* Drag to zoom out */
void CPtzCtrlDlg::OnBnClickedBtnPtzSelZoomOut()
{
    NETDEV_PTZ_OPERATEAREA_S stPtzAreaOperate;
    memset(&stPtzAreaOperate, 0, sizeof(NETDEV_PTZ_OPERATEAREA_S));

    /* Take the upper left corner of the window for playing as a start point, and the parameter value range from 0 to 10000. */
    stPtzAreaOperate.dwEndPointX = 2000;
    stPtzAreaOperate.dwEndPointY = 2000;
    stPtzAreaOperate.dwBeginPointX = 4000;
    stPtzAreaOperate.dwBeginPointY = 4000;

    BOOL bRet = NETDEV_PTZSelZoomIn_Other(m_lpDevHandle, m_lChannelID, &stPtzAreaOperate);
    if(TRUE != bRet)
    {
        MessageBox("Operate Area Failed");
    }

    return;
}

/* 3D positioning */
void CPtzCtrlDlg::OnBnClickedBtn3dPosition()
{
    NETDEV_PTZ_OPERATEAREA_S stPtzAreaOperate;
    memset(&stPtzAreaOperate, 0, sizeof(NETDEV_PTZ_OPERATEAREA_S));

    /* Take the upper left corner of the window for playing as a start point, and the parameter value range from 0 to 10000. */
    stPtzAreaOperate.dwBeginPointX = 7500;
    stPtzAreaOperate.dwBeginPointY = 9000;
    stPtzAreaOperate.dwEndPointX = 7500;
    stPtzAreaOperate.dwEndPointY = 9000;

    BOOL bRet = NETDEV_PTZSelZoomIn_Other(m_lpDevHandle, m_lChannelID, &stPtzAreaOperate);
    if(TRUE != bRet)
    {
        MessageBox("Operate Area Failed");
    }

    return;
}

/* PTZ speed control */
void CPtzCtrlDlg::OnNMCustomdrawSliderPtzspeed(NMHDR *pNMHDR, LRESULT *pResult)
{
    LPNMCUSTOMDRAW pNMCD = reinterpret_cast<LPNMCUSTOMDRAW>(pNMHDR) ;
    UpdateData(TRUE);
    m_dwPtzSpeed = m_oPtzSpeedSld.GetPos();
    UpdateData(FALSE); 
    *pResult = 0;

    return;
}

/* Wiper On */
void CPtzCtrlDlg::OnBnClickedBtnPtzWiperOn()
{
    BOOL bRet = NETDEV_PTZControl_Other(m_lpDevHandle, m_lChannelID, NETDEV_PTZ_BRUSHON, m_dwPtzSpeed);
    if(TRUE != bRet)
    {
        MessageBox("Open Wiper Failed");
    }

    return;
}

/* Wiper Off */
void CPtzCtrlDlg::OnBnClickedBtnPtzWiperOff()
{
    BOOL bRet = NETDEV_PTZControl_Other(m_lpDevHandle, m_lChannelID, NETDEV_PTZ_BRUSHOFF, m_dwPtzSpeed);
    if(TRUE != bRet)
    {
        MessageBox("Close Wiper Failed");
    }

    return;
}

/* Light On */
void CPtzCtrlDlg::OnBnClickedBtnPtzLightOn()
{
    BOOL bRet = NETDEV_PTZControl_Other(m_lpDevHandle, m_lChannelID, NETDEV_PTZ_LIGHTON, m_dwPtzSpeed);
    if(TRUE != bRet)
    {
        MessageBox("Open Lamp Failed");
    }

    return;
}

/* Light Off */
void CPtzCtrlDlg::OnBnClickedBtnPtzLightOff()
{
    BOOL bRet = NETDEV_PTZControl_Other(m_lpDevHandle, m_lChannelID, NETDEV_PTZ_LIGHTOFF, m_dwPtzSpeed);
    if(TRUE != bRet)
    {
        MessageBox("Close Lamp Failed");
    }

    return;
}

/* Heater On */
void CPtzCtrlDlg::OnBnClickedBtnPtzHeaterOn()
{
    BOOL bRet = NETDEV_PTZControl_Other(m_lpDevHandle, m_lChannelID, NETDEV_PTZ_HEATON, m_dwPtzSpeed);
    if(TRUE != bRet)
    {
        MessageBox("Open Heater Failed");
    }

    return;
}

/* Heater Off */
void CPtzCtrlDlg::OnBnClickedBtnPtzHeaterOff()
{
    BOOL bRet = NETDEV_PTZControl_Other(m_lpDevHandle, m_lChannelID, NETDEV_PTZ_HEATOFF, m_dwPtzSpeed);
    if(TRUE != bRet)
    {
        MessageBox("Close Heater Failed");
    }

    return;
}

/* Snowremoval On */
void CPtzCtrlDlg::OnBnClickedBtnPtzSnowremovalOn()
{
    BOOL bRet = NETDEV_PTZControl_Other(m_lpDevHandle, m_lChannelID, NETDEV_PTZ_SNOWREMOINGON, m_dwPtzSpeed);
    if(TRUE != bRet)
    {
        MessageBox("Open Snowmoving Failed");
    }

    return;
}

/* Snowremoval Off */
void CPtzCtrlDlg::OnBnClickedBtnPtzSnowremovalOff()
{
    BOOL bRet = NETDEV_PTZControl_Other(m_lpDevHandle, m_lChannelID, NETDEV_PTZ_SNOWREMOINGOFF, m_dwPtzSpeed);
    if(TRUE != bRet)
    {
        MessageBox("Close Snowmoving Failed");
    }

    return;
}

