// PlayBackDlg.cpp
//

#include "stdafx.h"
#include "NetDemo.h"
#include "PlayBackDlg.h"

#define PLAYBACK_TIME_ID 101

// CPlayBackDlg

IMPLEMENT_DYNAMIC(CPlayBackDlg, CDialog)

CPlayBackDlg::CPlayBackDlg(CWnd* pParent /*=NULL*/)
    : CDialog(CPlayBackDlg::IDD, pParent)
    , m_strPlayTime(_T(""))
    , m_lEventType(4)
{
}

CPlayBackDlg::~CPlayBackDlg()
{
}

void CPlayBackDlg::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    DDX_Text(pDX, IDC_STATIC_PLAYTIME, m_strPlayTime);
    DDX_Control(pDX, IDC_COMBO_EVENT_LIST, m_cBoxEventList);
    DDX_Control(pDX, IDC_COMBO_DIGITALINPUT_LIST, m_cBoxAlarmInputList);
}


BEGIN_MESSAGE_MAP(CPlayBackDlg, CDialog)
    ON_BN_CLICKED(IDC_BTN_QUERY_RECORD, &CPlayBackDlg::OnBnClickedBtnQueryRecord)
    ON_BN_CLICKED(IDC_BTN_STOP_DOWNLOAD, &CPlayBackDlg::OnBnClickedBtnStopDownload)
    ON_BN_CLICKED(IDC_BTN_PLAYBACK_CTRL_BACK, &CPlayBackDlg::OnBnClickedBtnPlaybackCtrlBack)
    ON_BN_CLICKED(IDC_BTN_PLAYBACK_STRL_FORWARD, &CPlayBackDlg::OnBnClickedBtnPlaybackStrlForward)
    ON_BN_CLICKED(IDC_BTN_PLAY_CTRL_PAUSE, &CPlayBackDlg::OnBnClickedBtnPlayCtrlPause)
    ON_BN_CLICKED(IDC_BTN_PLAY_CTRL_RESUME, &CPlayBackDlg::OnBnClickedBtnPlayCtrlResume)
    ON_BN_CLICKED(IDC_BTN_PLAY_CTRL_SETTIME, &CPlayBackDlg::OnBnClickedBtnPlayCtrlSettime)
    ON_BN_CLICKED(IDC_BTN_PLAY_CTRL_GETTIME, &CPlayBackDlg::OnBnClickedBtnPlayCtrlGettime)
    ON_BN_CLICKED(IDC_BTN_PLAYBACKCTRL_SOUND, &CPlayBackDlg::OnBnClickedBtnPlaybackctrlSound)
    ON_BN_CLICKED(IDC_BTN_SOUND_OFF, &CPlayBackDlg::OnBnClickedBtnSoundOff)
    ON_BN_CLICKED(IDC_BTN_PLAYBACKBYNAME, &CPlayBackDlg::OnBnClickedBtnPlaybackbyname)
    ON_BN_CLICKED(IDC_BTN_PLAYBACKBYTIME, &CPlayBackDlg::OnBnClickedBtnPlaybackbytime)
    ON_BN_CLICKED(IDC_BTN_DOWNLOADBYNAME, &CPlayBackDlg::OnBnClickedBtnDownloadbyname)
    ON_BN_CLICKED(IDC_BTN_DOWNLOADBYTIME, &CPlayBackDlg::OnBnClickedBtnDownloadbytime)
    ON_WM_TIMER()
    ON_BN_CLICKED(IDC_BTN_STOP_PLAYBACK, &CPlayBackDlg::OnBnClickedBtnStopPlayback)
    ON_BN_CLICKED(IDC_BTN_EVENT_QUERY_RECORD, &CPlayBackDlg::OnBnClickedBtnEventQueryRecord)
    ON_CBN_SELCHANGE(IDC_COMBO_EVENT_LIST, &CPlayBackDlg::OnCbnSelchangeComboEventList)
    ON_CBN_SELCHANGE(IDC_COMBO_DIGITALINPUT_LIST, &CPlayBackDlg::OnCbnSelchangeComboDigitalinputList)
END_MESSAGE_MAP()

/* Query recordings */
void CPlayBackDlg::OnBnClickedBtnQueryRecord()
{
    NETDEV_FILECOND_S stFileCond = {0};
    stFileCond.dwChannelID = m_lChannelID;
    LPVOID dwFileHandle = 0;

    /* UTC time. The found period of time is 24 hours from current system time. */
    stFileCond.tBeginTime = time(NULL) - 24 * 3600;
    stFileCond.tEndTime = time(NULL);
    CString strTime;

    dwFileHandle = NETDEV_FindFile(m_lpDevHandle,&stFileCond);
    if(NULL == dwFileHandle)
    {
        MessageBox("Query failed.");
        return;
    }
    else
    {
        NETDEV_FINDDATA_S stVodFile = {0};
        for(INT32 i = 0; i < 10; i++)
        {
            BOOL bRet = NETDEV_FindNextFile(dwFileHandle, &stVodFile);
            if(TRUE != bRet)
            {
                break;
            }
            else
            {
                /* Save each recording found */
                strncpy(m_astVodFile[i].szFileName, stVodFile.szFileName, NETDEV_FILE_NAME_LEN - 1);
                m_astVodFile[i].tBeginTime = stVodFile.tBeginTime;
                m_astVodFile[i].tEndTime = stVodFile.tEndTime;
                m_astVodFile[i].byFileType = stVodFile.byFileType;

                CString strBeginLocalTime, strEndLocalTime;
                {
                    tm *pTime = localtime((time_t*)&stVodFile.tBeginTime);
                    strBeginLocalTime.Format("%d/%d/%d %d:%d:%d",pTime->tm_year + 1900,pTime->tm_mon+1,pTime->tm_mday,
                        pTime->tm_hour,pTime->tm_min,pTime->tm_sec);
                }
                {
                    tm *pTime = localtime((time_t*)&stVodFile.tEndTime);
                    strEndLocalTime.Format("%d/%d/%d %d:%d:%d",pTime->tm_year + 1900,pTime->tm_mon+1,pTime->tm_mday,
                        pTime->tm_hour,pTime->tm_min,pTime->tm_sec);
                }

                CString strOut;
                strOut = strOut + strBeginLocalTime + "---" + strEndLocalTime + "\n";
                strTime += strOut;
            }
        }   
    }

    MessageBox(strTime);

    NETDEV_FindClose(dwFileHandle);
    return;
}

void CPlayBackDlg::OnCbnSelchangeComboEventList()
{
    m_cBoxAlarmInputList.ResetContent();
    INT32 index = m_cBoxEventList.GetCurSel();
    switch(index)
    {
    case 0:
        {
            m_lEventType = NETDEV_EVENT_STORE_TYPE_MOTIONDETECTION;
        }
        break;
    case 1:
        {
            UpdateData();

            m_lEventType = NETDEV_EVENT_STORE_TYPE_DIGITALINPUT;

            NETDEV_ALARM_INPUT_LIST_S stAlarmInputList[NETDEV_LEN_32];
            memset(stAlarmInputList, 0, sizeof(NETDEV_ALARM_INPUT_LIST_S));

            INT32 dwBytesReturned = 0;
            BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_ALARM_INPUTCFG, &stAlarmInputList, sizeof(NETDEV_VIDEO_STREAM_INFO_S), &dwBytesReturned);
            if(TRUE == bRet && stAlarmInputList->dwSize != 0)
            {
                m_cBoxAlarmInputList.Clear();
                CString strTemp;
                for(INT32 i = 0; i < stAlarmInputList->dwSize; i++)
                {
                    strTemp.Format("%s", stAlarmInputList->astAlarmInputInfo[i].szName);
                    m_cBoxAlarmInputList.AddString(_T(strTemp));
                }

                m_cBoxAlarmInputList.GetLBText(0, m_strAlarmName);
                m_cBoxAlarmInputList.SetCurSel(0);
            }
        }
        break;
    case 2:
        {
            m_lEventType = NETDEV_EVENT_STORE_TYPE_VIDEOLOSS;
        }
        break;
    default:
        break;
    }

    return;
}

void CPlayBackDlg::OnCbnSelchangeComboDigitalinputList()
{
    INT32 dwIndex = m_cBoxAlarmInputList.GetCurSel();
    m_cBoxAlarmInputList.GetLBText(dwIndex, m_strAlarmName);

    return;
}

/* Query by event */
void CPlayBackDlg::OnBnClickedBtnEventQueryRecord()
{
    NETDEV_FILECOND_S stFileCond = {0};
    stFileCond.dwChannelID = m_lChannelID;
    LPVOID dwFileHandle = 0;

    /* UTC time. The found period of time is 24 hours from current system time. */
    stFileCond.tBeginTime = time(NULL) - 24 * 3600;
    stFileCond.tEndTime = time(NULL);

    stFileCond.dwFileType = m_lEventType;
    strncpy(stFileCond.szFileName, m_strAlarmName, NETDEV_LEN_64 - 1);
    CString strTime;

    dwFileHandle = NETDEV_FindFile(m_lpDevHandle, &stFileCond);
    if(NULL == dwFileHandle)
    {
        MessageBox("Query failed.");
        return;
    }
    else
    {
        NETDEV_FINDDATA_S stVodFile = {0};

        for(INT32 i = 0; i < 10; i++)
        {
            BOOL bRet = NETDEV_FindNextFile(dwFileHandle, &stVodFile);
            if(TRUE != bRet)
            {
                break;
            }
            else
            {
                /* Save each recording found */
                strncpy(m_astVodFile[i].szFileName, stVodFile.szFileName, NETDEV_FILE_NAME_LEN - 1);
                m_astVodFile[i].tBeginTime = stVodFile.tBeginTime;
                m_astVodFile[i].tEndTime = stVodFile.tEndTime;
                m_astVodFile[i].byFileType = stVodFile.byFileType;

                CString strBeginLocalTime, strEndLocalTime;
                {
                    tm *pTime = localtime((time_t*)&stVodFile.tBeginTime);
                    strBeginLocalTime.Format("%d/%d/%d %d:%d:%d",pTime->tm_year + 1900,pTime->tm_mon+1,pTime->tm_mday,
                        pTime->tm_hour,pTime->tm_min,pTime->tm_sec);
                }
                {
                    tm *pTime = localtime((time_t*)&stVodFile.tEndTime);
                    strEndLocalTime.Format("%d/%d/%d %d:%d:%d",pTime->tm_year + 1900,pTime->tm_mon+1,pTime->tm_mday,
                        pTime->tm_hour,pTime->tm_min,pTime->tm_sec);
                }

                CString strOut;
                strOut = strOut + strBeginLocalTime + "---" + strEndLocalTime + "\n";
                strTime += strOut;
            }
        }   
    }

    MessageBox(strTime);

    NETDEV_FindClose(dwFileHandle);
    return;
}

/* Play back recordings by name*/
void CPlayBackDlg::OnBnClickedBtnPlaybackbyname()
{
    if(NULL == m_lpDevHandle)
    {
        return;
    }

    if(NULL != m_lpPlayHandle)
    {
        BOOL bRet = NETDEV_StopPlayBack(m_lpPlayHandle);
        if(TRUE == bRet)
        {
            m_lpPlayHandle = NULL;
        }
    }

    if(NULL != m_lpPlayHandle)
    {
        BOOL bRet = NETDEV_StopRealPlay(m_lpPlayHandle);
        if(TRUE == bRet)
        {
            m_lpPlayHandle = NULL;
        }
    }

    CHAR strName[260] = "";
    strncpy(strName, m_astVodFile[0].szFileName, 260);

    NETDEV_PLAYBACKINFO_S stPlayBackInfo = {0};

    /* Assume to play the first recording found */
    stPlayBackInfo.tBeginTime = m_astVodFile[0].tBeginTime;
    stPlayBackInfo.tEndTime = m_astVodFile[0].tEndTime;
    strncpy(stPlayBackInfo.szName, strName, NETDEV_LEN_260 - 1);

    stPlayBackInfo.hPlayWnd = m_hPic.m_hWnd;
    stPlayBackInfo.dwLinkMode = NETDEV_TRANSPROTOCAL_RTPTCP;

    m_lpPlayHandle = NETDEV_PlayBackByName(m_lpDevHandle, &stPlayBackInfo);
    if(NULL == m_lpPlayHandle)
    {
        MessageBox("Play the video failed.");
    }

    SetTimer(PLAYBACK_TIME_ID,1000,NULL);

    return;
}

/* Play back recordings by time */
void CPlayBackDlg::OnBnClickedBtnPlaybackbytime()
{
    if(NULL == m_lpDevHandle)
    {
        return;
    }

    if(NULL != m_lpPlayHandle)
    {
        BOOL bRet = NETDEV_StopPlayBack(m_lpPlayHandle);
        if(TRUE == bRet)
        {
            m_lpPlayHandle = NULL;
        }
    }

    if(NULL != m_lpPlayHandle) 
    {
        BOOL bRet = NETDEV_StopRealPlay(m_lpPlayHandle);
        if(TRUE == bRet)
        {
            m_lpPlayHandle = NULL;
        }
    } 

    NETDEV_PLAYBACKCOND_S stPlayBackByTimeInfo = {0};

    /* Assume to play the first recording found */
    stPlayBackByTimeInfo.tBeginTime = m_astVodFile[0].tBeginTime;
    stPlayBackByTimeInfo.tEndTime = m_astVodFile[0].tEndTime;
    stPlayBackByTimeInfo.dwChannelID = m_lChannelID;

    stPlayBackByTimeInfo.hPlayWnd = m_hPic.m_hWnd;
    stPlayBackByTimeInfo.dwLinkMode = NETDEV_TRANSPROTOCAL_RTPTCP;

    m_lpPlayHandle = NETDEV_PlayBackByTime(m_lpDevHandle, &stPlayBackByTimeInfo);
    if(NULL == m_lpPlayHandle)
    {
        MessageBox("Play the video failed.");
    }

    SetTimer(PLAYBACK_TIME_ID,1000,NULL);

    return;
}


/* Stop recording playback */
void CPlayBackDlg::OnBnClickedBtnStopPlayback()
{
    if(NULL == m_lpDevHandle)
    {
        return;
    }

    if(NULL == m_lpPlayHandle)
    {
        return;
    }

    BOOL bRet = NETDEV_StopPlayBack(m_lpPlayHandle);
    if (TRUE != bRet)
    {
        MessageBox("Stop play failed.");
    }

    m_lpPlayHandle = NULL;

    KillTimer(PLAYBACK_TIME_ID);
    return;
}

/* Download recordings by name */
void CPlayBackDlg::OnBnClickedBtnDownloadbyname()
{
    if(NULL == m_lpDevHandle)
    {
        return;
    }

    NETDEV_PLAYBACKINFO_S stPlayBackInfo = {0};
    stPlayBackInfo.hPlayWnd = m_hPic.m_hWnd;
    stPlayBackInfo.dwLinkMode = NETDEV_TRANSPROTOCAL_RTPTCP;
    stPlayBackInfo.dwDownloadSpeed = NETDEV_DOWNLOAD_SPEED_EIGHT;

    /* Assume to play the first recording found */
    strncpy(stPlayBackInfo.szName, m_astVodFile[0].szFileName, NETDEV_LEN_260);
    stPlayBackInfo.tBeginTime = m_astVodFile[0].tBeginTime;
    stPlayBackInfo.tEndTime = m_astVodFile[0].tEndTime;

    /* Please choose a different path for each operation, otherwise the file will be overwritten. */
    CHAR szPath[NETDEV_LEN_260] = "C:\\NetDEVSDK\\DownLoad\\netDev";

    /* Non-English characters included in the path. Please convert to UTF-8. */
    //MBToUTF8(szPath, szPath, NETDEV_LEN_260);

    m_lpDownloadHandle = NETDEV_GetFileByName(m_lpDevHandle, &stPlayBackInfo, szPath, NETDEV_MEDIA_FILE_MP4);
    if(NULL != m_lpDownloadHandle)
    {
        CString strOut;
        strOut.Format("Downloading, path: %s", szPath);
        MessageBox(strOut);
    }
    else
    {
        MessageBox("failed");
    }

    return;
}

/* Download recordings by time */
void CPlayBackDlg::OnBnClickedBtnDownloadbytime()
{
    if(NULL == m_lpDevHandle)
    {
        return;
    }

    NETDEV_PLAYBACKCOND_S stPlayBackInfo = {0};
    stPlayBackInfo.hPlayWnd = m_hPic.m_hWnd;
    stPlayBackInfo.dwDownloadSpeed = NETDEV_DOWNLOAD_SPEED_EIGHT;

    /* Assume to play the first recording found */
    stPlayBackInfo.tBeginTime = m_astVodFile[0].tBeginTime;
    stPlayBackInfo.tEndTime = m_astVodFile[0].tEndTime;
    stPlayBackInfo.dwChannelID = m_lChannelID;

    /* Please choose a different path for each operation, otherwise the file will be overwritten. */
    CHAR szPath[NETDEV_LEN_260] = "C:\\NetDEVSDK\\DownLoad\\netDev";

    /* Non-English characters included in the path. Please convert to UTF-8. */
    //MBToUTF8(szPath, szPath, NETDEV_LEN_260);

    m_lpDownloadHandle = NETDEV_GetFileByTime(m_lpDevHandle, &stPlayBackInfo, szPath, NETDEV_MEDIA_FILE_MP4);
    if(NULL != m_lpDownloadHandle)
    {
        CString strOut;
        strOut.Format("Downloading, path: %s", szPath);
        MessageBox(strOut);
    }
    else
    {
        MessageBox("failed");
    }

    return;
}

/* Stop downloading recordings */
void CPlayBackDlg::OnBnClickedBtnStopDownload()
{
    if(NULL == m_lpDevHandle)
    {
        return;
    }
    BOOL bRet = NETDEV_StopGetFile(m_lpDownloadHandle);
    if(TRUE != bRet)
    {
        MessageBox("Download failed.");
    }
    else
    {
        MessageBox("Download succeed.");
    }

    m_lpDownloadHandle = NULL;
    return;
}

/* Recording playing control: rewind */
void CPlayBackDlg::OnBnClickedBtnPlaybackCtrlBack()
{
    INT32 enSpeed = 0;
    BOOL bRet = NETDEV_PlayBackControl(m_lpPlayHandle, NETDEV_PLAY_CTRL_GETPLAYSPEED, &enSpeed);
    if (TRUE != bRet)
    {
        MessageBox("Get play speed failed.");
    }

    enSpeed = enSpeed - 1 >= NETDEV_PLAY_STATUS_16_BACKWARD ? (enSpeed - 1) : enSpeed;

    while((enSpeed <= NETDEV_PLAY_STATUS_HALF_FORWARD) && (enSpeed >= NETDEV_PLAY_STATUS_HALF_BACKWARD))
    {
        enSpeed--;
    }

    bRet = NETDEV_PlayBackControl(m_lpPlayHandle, NETDEV_PLAY_CTRL_SETPLAYSPEED, &enSpeed);
    if(TRUE != bRet)
    {
        MessageBox("Set play speed failed.");
    }

    return;
}

/* Recording playing control: forward */
void CPlayBackDlg::OnBnClickedBtnPlaybackStrlForward()
{
    INT32 enSpeed = 0;
    BOOL bRet = NETDEV_PlayBackControl(m_lpPlayHandle, NETDEV_PLAY_CTRL_GETPLAYSPEED, &enSpeed);
    if(TRUE != bRet)
    {
        MessageBox("Get play speed failed.");
    }

    enSpeed = enSpeed + 1 <= NETDEV_PLAY_STATUS_16_FORWARD ? (enSpeed + 1) : enSpeed;

    while((enSpeed <= NETDEV_PLAY_STATUS_HALF_FORWARD) && (enSpeed >= NETDEV_PLAY_STATUS_HALF_BACKWARD))
    {
        enSpeed++;
    }

    bRet = NETDEV_PlayBackControl(m_lpPlayHandle, NETDEV_PLAY_CTRL_SETPLAYSPEED, &enSpeed);
    if(TRUE != bRet)
    {
        MessageBox("Set play speed failed.");
    }

    return;
}

/* Recording playing control: pause */
void CPlayBackDlg::OnBnClickedBtnPlayCtrlPause()
{
    if(NULL == m_lpDevHandle)
    {
        return ;
    }

    if(NULL == m_lpPlayHandle)
    {
        return ;
    }

    BOOL bRet = NETDEV_PlayBackControl(m_lpPlayHandle, NETDEV_PLAY_CTRL_PAUSE, NULL);
    if(TRUE != bRet)
    {
        MessageBox("Pause failed.");
    }

    return;
}

/* Recording playing control: resume */
void CPlayBackDlg::OnBnClickedBtnPlayCtrlResume()
{
    if(NULL == m_lpDevHandle)
    {
        return;
    }

    if(NULL == m_lpPlayHandle)
    {
        return;
    }

    BOOL bRet = NETDEV_PlayBackControl(m_lpPlayHandle, NETDEV_PLAY_CTRL_RESUME, NULL);
    if(TRUE != bRet)
    {
        MessageBox("Resume failed.");
    }
    
    return;
}

/* Recording playing control: get playing speed */
void CPlayBackDlg::OnBnClickedBtnPlayCtrlGettime()
{
    INT64 iTime = 0;
    BOOL bRet = NETDEV_PlayBackControl(m_lpPlayHandle, NETDEV_PLAY_CTRL_GETPLAYTIME, &(iTime));
    if (TRUE != bRet)
    {
        MessageBox(" Get playtime failed.");
    }
    else
    {
        CString strOut;
        CString strTime;
        {
            /* UTC */
            tm *pTime = localtime((time_t*)&iTime);
            strTime.Format("%d/%d/%d %d:%d:%d",pTime->tm_year + 1900,pTime->tm_mon+1,pTime->tm_mday,
                pTime->tm_hour,pTime->tm_min,pTime->tm_sec);
        }
        strOut += strTime;

        MessageBox(strOut);
    }

    return;
}

/* Recording playing control: modify playing progress */
void CPlayBackDlg::OnBnClickedBtnPlayCtrlSettime()
{
    INT64 iTime = 0;
    BOOL bRet = NETDEV_PlayBackControl(m_lpPlayHandle, NETDEV_PLAY_CTRL_GETPLAYTIME, &iTime);
    if (TRUE != bRet)
    {
        MessageBox("Get playtime failed.");
        return;
    }

    iTime += 20;

    bRet = NETDEV_PlayBackControl(m_lpPlayHandle, NETDEV_PLAY_CTRL_SETPLAYTIME, &iTime);
    if(TRUE != bRet)
    {
        MessageBox("Set Play time failed.");
    }

    return;
}

/* Enable sound */
void CPlayBackDlg::OnBnClickedBtnPlaybackctrlSound()
{
    if(NULL == m_lpPlayHandle)
    {
        return ;
    }

    BOOL bRet = NETDEV_OpenSound(m_lpPlayHandle);
    if(TRUE != bRet)
    {
        MessageBox("play sound failed.");
    }

    return;
}


/* Mute */
void CPlayBackDlg::OnBnClickedBtnSoundOff()
{
    if(NULL == m_lpPlayHandle)
    {
        return;
    }

    BOOL bRet = NETDEV_CloseSound(m_lpPlayHandle);
    if(TRUE != bRet)
    {
        MessageBox("stop play sound failed.");
    }

    return;
}

void CPlayBackDlg::OnTimer(UINT_PTR nIDEvent)
{
    if(PLAYBACK_TIME_ID == nIDEvent)
    {
        INT64 iPlayTime = 0;
        NETDEV_PlayBackControl(m_lpPlayHandle,NETDEV_PLAY_CTRL_GETPLAYTIME, &iPlayTime);

        {
            tm *pTime = localtime((time_t*)&iPlayTime);
            m_strPlayTime.Format("PlayTime: %d/%d/%d %d:%d:%d",pTime->tm_year + 1900, pTime->tm_mon + 1, pTime->tm_mday,
                pTime->tm_hour, pTime->tm_min, pTime->tm_sec);
        }
        UpdateData(FALSE);
    }

    CDialog::OnTimer(nIDEvent);
}
