// NetDemoDlg.h
//

#pragma once
#include "afxwin.h"
#include "NetDEVSDK.h"
#include "afxcmn.h"
#include "LiveViewDlg.h"
#include "PtzCtrlDlg.h"
#include "PlayBackDlg.h"
#include "ConfigDlg.h"
#include "AlarmInfoDlg.h"

/**
 * @enum tagTabIndex
 * @brief Tab index Enumeration definition
 * @attention 
 */
typedef enum tagTabIndex
{
    TAB_INDEX_LIVEVIEW = 0,                       /* Live view */
    TAB_INDEX_PTZCTRL,                            /* PTZ control */
    TAB_INDEX_PLAYBACK,                           /* Playback */
    TAB_INDEX_CONFIG,                             /* Configuration */
    TAB_INDEX_ALARMINFO                           /* Alarm info */
}TAB_INDEX_E;

// CNetDemoDlg Dialog
class CNetDemoDlg : public CDialog
{

public:
    CNetDemoDlg(CWnd* pParent = NULL);
     void DeliverAlarmInfo(CString strAlarmInfo);

    enum{IDD = IDD_NETDEMO_DLG};

    protected:
    virtual void DoDataExchange(CDataExchange* pDX);

protected:
    HICON m_hIcon;

    virtual BOOL OnInitDialog();
    afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
    afx_msg void OnPaint();
    afx_msg HCURSOR OnQueryDragIcon();
    DECLARE_MESSAGE_MAP()

public:
    CString m_DevIP;
    CString m_strUser;
    CString m_strPwd;
    CLiveViewDlg m_oLiveViewDlg;
    CPtzCtrlDlg m_oPtzCtrlDlg;
    CPlayBackDlg m_oPlayBackDlg;
    CConfigDlg m_oConfigDlg;
    CAlarmInfoDlg m_oAlramInfoDlg;

public:
    afx_msg void OnBnClickedBtnLogin();
    afx_msg void OnBnClickedBtnLogout();
    afx_msg void OnBnClickedBtnGetVersion();
    afx_msg void OnCbnSelchangeComboChlList();
    afx_msg void OnBnClickedBtnGetCurise();
    CTabCtrl NETDEV_CTRLTAB;
    afx_msg void OnTcnSelchangeNetdevTab(NMHDR *pNMHDR, LRESULT *pResult);
};
