// LiveViewDlg.cpp 
//

#include "stdafx.h"
#include "NetDemo.h"
#include"NetDemoDlg.h"
#include "LiveViewDlg.h"


// CLiveViewDlg

IMPLEMENT_DYNAMIC(CLiveViewDlg, CDialog)

CLiveViewDlg::CLiveViewDlg(CWnd* pParent /*=NULL*/)
    : CDialog(CLiveViewDlg::IDD, pParent)
{
}

CLiveViewDlg::~CLiveViewDlg()
{
}

void CLiveViewDlg::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
}


BEGIN_MESSAGE_MAP(CLiveViewDlg, CDialog)

    ON_BN_CLICKED(IDC_BTN_START_LIVE_VIEW, &CLiveViewDlg::OnBnClickedBtnStartLiveView)
    ON_BN_CLICKED(IDC_BTN_STOP_LIVE_VIEW, &CLiveViewDlg::OnBnClickedBtnStopLiveView)
    ON_BN_CLICKED(IDC_BTN_START_RECORD, &CLiveViewDlg::OnBnClickedBtnStartRecord)
    ON_BN_CLICKED(IDC_BTN_STOP_RECORD, &CLiveViewDlg::OnBnClickedBtnStopRecord)
    ON_BN_CLICKED(IDC_BTN_DISP_FULL_SCREEN, &CLiveViewDlg::OnBnClickedBtnDispFullScreen)
    ON_BN_CLICKED(IDC_BTN_DISP_RATIO, &CLiveViewDlg::OnBnClickedBtnDispRatio)
    ON_BN_CLICKED(IDC_BTN_SNAPSHOT, &CLiveViewDlg::OnBnClickedBtnSnapshot)
    ON_BN_CLICKED(IDC_BTN_REG_STREAM_CB, &CLiveViewDlg::OnBnClickedBtnRegStreamCb)
    ON_BN_CLICKED(IDC_BTN_CLOSE_STREAM_CB, &CLiveViewDlg::OnBnClickedBtnCloseStreamCb)
    ON_BN_CLICKED(IDC_BTN_REG_DECODED_VIDEO_CB, &CLiveViewDlg::OnBnClickedBtnRegDecodedVideoCb)
    ON_BN_CLICKED(IDC_BTN_CLOSE_DECODED_VIDEO_CB, &CLiveViewDlg::OnBnClickedBtnCloseDecodedVideoCb)
    ON_BN_CLICKED(IDC_BTN_REG_DISPLAY_CB, &CLiveViewDlg::OnBnClickedBtnRegDisplayCb)
    ON_BN_CLICKED(IDC_BTN_CLOSE_DISPLAY_CB, &CLiveViewDlg::OnBnClickedBtnCloseDisplayCb)
    ON_BN_CLICKED(IDC_BTN_REG_FREAMED_VIDEO_CB, &CLiveViewDlg::OnBnClickedBtnRegFreamedVideoCb)
    ON_BN_CLICKED(IDC_BTN_CLOSE_FREAMED_VIDEO_CB, &CLiveViewDlg::OnBnClickedBtnCloseFreamedVideoCb)
    ON_BN_CLICKED(IDC_BTN_CAMERA_INFO, &CLiveViewDlg::OnBnClickedBtnCameraInfo)
    ON_BN_CLICKED(IDC_BTN_SOUND_ON, &CLiveViewDlg::OnBnClickedBtnSoundOn)
    ON_BN_CLICKED(IDC_BTN_SOUND_CLOSE, &CLiveViewDlg::OnBnClickedBtnSoundClose)
    ON_BN_CLICKED(IDC_BTN_VIDEO_EFFECT, &CLiveViewDlg::OnBnClickedBtnVideoEffect)
    ON_BN_CLICKED(IDC_BTN_GET_VIDEO_EFFECT, &CLiveViewDlg::OnBnClickedBtnGetVideoEffect)
    ON_BN_CLICKED(IDC_BTN_RESET_LOST_PACKET_RATE, &CLiveViewDlg::OnBnClickedBtnResetLostPacketRate)
    ON_BN_CLICKED(IDC_BTN_SET_DIGITAL_ZOOM, &CLiveViewDlg::OnBnClickedBtnSetDigitalZoom)
    ON_BN_CLICKED(IDC_BTN_SOUND_VOLUME_CONTROL, &CLiveViewDlg::OnBnClickedBtnSoundVolumeControl)
    ON_BN_CLICKED(IDC_BTN_SNAPSHOT_NO_PREVIEW, &CLiveViewDlg::OnBnClickedBtnSnapshotNoPreview)
END_MESSAGE_MAP()

void STDCALL NETDEV_SOURCE_DATA_CALLBACK(IN LPVOID dwHandle,
                                         IN const BYTE *pucBuffer,
                                         IN INT32 dwBufSize,
                                         IN INT32 dwMediaDataType,
                                         IN LPVOID dwUserParam
                                         )
{
    CString strOut;
    strOut.Format("----- source buflen is [%d],the type is %d    -----\n",dwBufSize,dwMediaDataType);
    OutputDebugString(strOut);
}

void STDCALL NETDEV_DECODE_VIDEO_DATA_CALLBACK(IN LPVOID dwHandle,
                                               IN const NETDEV_PICTURE_DATA_S *pstPictureData,
                                               IN LPVOID dwUserParam
                                               )
{
    CString strOut;
    strOut.Format("------- video height is [%d],the linesize is [%d]    ------\n",pstPictureData->dwPicHeight,pstPictureData->dwLineSize[0]);
    OutputDebugString(strOut);
}

void STDCALL NETDEV_DISPLAY_CALLBACK(IN LPVOID dwHandle,
                                     IN LPVOID hdc,
                                     IN LPVOID dwUserParam
                                     )
{
    CString strOut;
    strOut.Format("----------display is [%d]---------\n",hdc);
    OutputDebugString(strOut);
}

void STDCALL NETDEV_PARSE_VIDEO_DATA_CALLBACK(IN LPVOID dwHandle,
                                              IN const NETDEV_PARSE_VIDEO_DATA_S *pstParseVideoData,
                                              IN LPVOID dwUserParam
                                              )
{
    CString strOut;
    /*strOut.Format("------- parse buflen is [%d],the height is %d    ----\n",pstParseVideoData->dwDataLen,pstParseVideoData->dwHeight); */
    strOut.Format("------- parse time is [%u]    ----\n",pstParseVideoData->tTimeStamp);
    OutputDebugString(strOut);
}

/* Start live view */
void CLiveViewDlg::OnBnClickedBtnStartLiveView()
{
    if(NULL == m_lpDevHandle)
    {
        return;
    }

    BOOL bRet = FALSE;
    if(NULL != m_lpPlayHandle)
    {
        bRet = NETDEV_StopRealPlay(m_lpPlayHandle);
        if (TRUE == bRet)
        {
            m_lpPlayHandle = NULL;
        }
    }

    if(NULL !=  m_lpPlayHandle)
    {
        bRet = NETDEV_StopPlayBack(m_lpPlayHandle);
        if (TRUE == bRet)
        {
            m_lpPlayHandle = NULL;
        }
    }

    NETDEV_PREVIEWINFO_S stNetInfo = {0};

    stNetInfo.dwChannelID = m_lChannelID;
    stNetInfo.hPlayWnd = m_hPic.m_hWnd;
    stNetInfo.dwStreamType = NETDEV_LIVE_STREAM_INDEX_MAIN;
    stNetInfo.dwLinkMode = NETDEV_TRANSPROTOCAL_RTPTCP;

    m_lpPlayHandle = NETDEV_RealPlay(m_lpDevHandle, &stNetInfo, NULL, 0);
    if(NULL ==  m_lpPlayHandle)
    {
        MessageBox("Realplay fail");
    }

    return;
}

/* Stop live view */
void CLiveViewDlg::OnBnClickedBtnStopLiveView()
{
    if(NULL == m_lpDevHandle) 
    {
        return;
    }

    if(NULL !=  m_lpPlayHandle)
    {
        BOOL bRet = NETDEV_StopRealPlay(m_lpPlayHandle);
        if (TRUE != bRet)
        {
            MessageBox("Stop RealPlay failed");
            return;
        }
    }

    m_lpPlayHandle = NULL;
    return;
}

/* Start local recording */
void CLiveViewDlg::OnBnClickedBtnStartRecord()
{
    /* Please choose a different path for each operation, otherwise the file will be overwritten. */
    CHAR szSavePath[NETDEV_LEN_260] = "C:\\NetDEVSDK\\Record\\netDev";

    if(NULL != m_lpPlayHandle)
    {
        CString strOut;
        BOOL bRet = NETDEV_SaveRealData(m_lpPlayHandle, szSavePath, NETDEV_MEDIA_FILE_MP4);
        if(TRUE != bRet)
        {
            strOut.Format("start record failed.");
        }   
        else
        {
            strOut.Format("Start record succeed. Path: %s", szSavePath);
        }
        MessageBox(strOut);
    }

    return;
}

/* Stop local recording */
void CLiveViewDlg::OnBnClickedBtnStopRecord()
{
    if(NULL != m_lpPlayHandle)
    {
        CString strOut;

        BOOL bRet = NETDEV_StopSaveRealData(m_lpPlayHandle);
        if(TRUE != bRet)
        {
            strOut.Format("Stop record failed.");
        }
        else
        {
            strOut.Format("Stop record succeed!");
        }
        MessageBox(strOut);
    }

    return;
}

/* Full screen */
void CLiveViewDlg::OnBnClickedBtnDispFullScreen()
{
    if(NULL != m_lpPlayHandle)
    {
        NETDEV_SetRenderScale(m_lpPlayHandle, NETDEV_RENDER_SCALE_FULL);
    }

    return;
}

/* Scale */
void CLiveViewDlg::OnBnClickedBtnDispRatio()
{
    if(NULL != m_lpPlayHandle)
    {
        NETDEV_SetRenderScale(m_lpPlayHandle, NETDEV_RENDER_SCALE_PROPORTION);
    }

    return;
}

/* Snapshot */
void CLiveViewDlg::OnBnClickedBtnSnapshot()
{
    /* Please choose a different path for each operation, otherwise the file will be overwritten. */
    CHAR szPath[NETDEV_LEN_260] = "C:\\NetDEVSDK\\Pic\\netDev";

    /* Non-English characters included in the path. Please convert to UTF-8. */
    //MBToUTF8(szPath, szPath, NETDEV_LEN_260);

    if(NULL != m_lpPlayHandle)
    {
        CString strOut;

        BOOL bRet = NETDEV_CapturePicture(m_lpPlayHandle, szPath, NETDEV_PICTURE_BMP);
        if(TRUE != bRet)
        {
            strOut.Format("Get capture failed.");
        }   
        else
        {
            strOut.Format("Get capture succeed! Path: %s", szPath);
        }

        MessageBox(strOut);
    }

    return;
}

/* Register callback function for live stream */
void CLiveViewDlg::OnBnClickedBtnRegStreamCb()
{
    if(NULL != m_lpPlayHandle)
    {
        BOOL iRet = NETDEV_SetPlayDataCallBack(m_lpPlayHandle, NETDEV_SOURCE_DATA_CALLBACK, TRUE, 0);
        if(TRUE == iRet)
        {
            MessageBox("Register succeed");
        }
        else
        {
            MessageBox("Register failed");
        }
    }
    else
    {
        MessageBox("Please start the real play first.");
    }

    return;
}


/* Close callback function for live stream */
void CLiveViewDlg::OnBnClickedBtnCloseStreamCb()
{
    if(NULL != m_lpPlayHandle)
    { 
        BOOL bRet = NETDEV_SetPlayDataCallBack(m_lpPlayHandle, NULL, TRUE, 0);
        if(TRUE == bRet)
        {
            MessageBox("Close succeed");
        }
        else
        {
            MessageBox("Close failed");
        }
    }
    else
    {
        MessageBox("Please start the real play first.");
    }

    return;
}


/* Register callback function for decoded video */
void CLiveViewDlg::OnBnClickedBtnRegDecodedVideoCb()
{
    if(NULL != m_lpPlayHandle)
    {   
        BOOL bRet = NETDEV_SetPlayDecodeVideoCB(m_lpPlayHandle, NETDEV_DECODE_VIDEO_DATA_CALLBACK, TRUE, 0);
        if(TRUE == bRet)
        {
            MessageBox("Register succeed");
        }
        else
        {
            MessageBox("Register failed");
        }
    }
    else
    {
        MessageBox("Please start the real play first.");
    }

    return;
}

/* Close callback function for decoded video */
void CLiveViewDlg::OnBnClickedBtnCloseDecodedVideoCb()
{
    if(NULL != m_lpPlayHandle)
    {
        BOOL iRet = NETDEV_SetPlayDecodeVideoCB(m_lpPlayHandle, NULL, TRUE, 0);
        if(TRUE == iRet)
        {
            MessageBox("Close succeed");
        }
        else
        {
            MessageBox("Close failed");
        }
    }
    else
    {
        MessageBox("Please start the real play first.");
    }

    return;
}


/* Register callback function for displayed data */
void CLiveViewDlg::OnBnClickedBtnRegDisplayCb()
{
    if(NULL != m_lpPlayHandle)
    {   
        BOOL iRet = NETDEV_SetPlayDisplayCB(m_lpPlayHandle, NETDEV_DISPLAY_CALLBACK, 0);
        if(TRUE == iRet)
        {
            MessageBox("Register succeed");
        }
        else
        {
            MessageBox("Register failed");
        }
    }
    else
    {
        MessageBox("Please start the real play first.");
    }

    return;
}

/* Close callback function for displayed data */
void CLiveViewDlg::OnBnClickedBtnCloseDisplayCb()
{
    if(NULL != m_lpPlayHandle)
    {   
        BOOL iRet = NETDEV_SetPlayDisplayCB(m_lpPlayHandle, NULL, 0);
        if(TRUE == iRet)
        {
            MessageBox("Close succeed");
        }
        else
        {
            MessageBox("Close failed");
        }
    }
    else
    {
        MessageBox("Please start the real play first.");
    }

    return;
}

/* Register callback function for framed data */
void CLiveViewDlg::OnBnClickedBtnRegFreamedVideoCb()
{
    if(NULL != m_lpPlayHandle)
    {
        BOOL iRet = NETDEV_SetPlayParseCB(m_lpPlayHandle, NETDEV_PARSE_VIDEO_DATA_CALLBACK, TRUE, 0);
        if(TRUE == iRet)
        {
            MessageBox("Register succeed");
        }
        else
        {
            MessageBox("Register failed");
        }

    }
    else
    {
        MessageBox("Please start the real play first.");
    }

    return;
}

/* Close callback function for framed data */
void CLiveViewDlg::OnBnClickedBtnCloseFreamedVideoCb()
{
    if(NULL != m_lpPlayHandle)
    {
        BOOL iRet = NETDEV_SetPlayParseCB(m_lpPlayHandle, NULL, TRUE, 0);
        if(TRUE == iRet)
        {
            MessageBox("Close succeed");
        }
        else
        {
            MessageBox("Close failed");
        }
    }
    else
    {
        MessageBox("Please start the real play first.");
    }

    return;
}

/* Get video image info */
void CLiveViewDlg::OnBnClickedBtnGetVideoEffect()
{
    UpdateData();
    NETDEV_VIDEO_EFFECT_S stImageInfo;
    memset(&stImageInfo, 0, sizeof(NETDEV_VIDEO_EFFECT_S));

    BOOL bRet = NETDEV_GetVideoEffect(m_lpPlayHandle, &stImageInfo);
    if(TRUE != bRet)
    {
        MessageBox("Get video adjust failed.");
    }
    else
    {
        CString strTemp;
        CString strOut;

        strTemp.Format("Contrast        \t %d \n", stImageInfo.dwContrast);
        strOut += strTemp;
        strTemp.Format("Brightness      \t %d \n", stImageInfo.dwBrightness);
        strOut += strTemp;
        strTemp.Format("ColorSaturation \t %d \n", stImageInfo.dwSaturation);
        strOut += strTemp;
        strTemp.Format("Hue             \t %d \n", stImageInfo.dwHue);
        strOut += strTemp;
        strTemp.Format("Gamma           \t %d \n", stImageInfo.dwGamma);
        strOut += strTemp;

        MessageBox(strOut);
    }

    return;
}

/* Adjust image */
void CLiveViewDlg::OnBnClickedBtnVideoEffect()
{
    UpdateData();
    NETDEV_VIDEO_EFFECT_S stImageInfo;
    memset(&stImageInfo, 0, sizeof(NETDEV_VIDEO_EFFECT_S));

    /* Gamma :0~10, others:0~255 */
    stImageInfo.dwContrast = 150;
    stImageInfo.dwBrightness = 150;
    stImageInfo.dwHue = 50;
    stImageInfo.dwSaturation = 150;
    stImageInfo.dwGamma = 5;

    BOOL bRet = NETDEV_SetVideoEffect(m_lpPlayHandle, &stImageInfo);
    if(TRUE != bRet)
    {
        MessageBox("Set video adjust failed.");
    }
    else
    {
        MessageBox("Set video adjust succeed.");
    }

    return;
}


/* Get camera info */
void CLiveViewDlg::OnBnClickedBtnCameraInfo()
{
    if(NULL != m_lpPlayHandle)
    {
        CString strTemp;
        CString strOut;

        /* Bit rate */
        INT32 ulBitRate = 0;
        BOOL bRet = NETDEV_GetBitRate(m_lpPlayHandle, &ulBitRate);
        if(TRUE != bRet)
        {
            strTemp.Format("Get Bit Rate failed.\n");
        }  
        else
        {
            strTemp.Format("Bit Rate         \t %d \n", ulBitRate);
        }
        strOut += strTemp;


        /* Frame rate */
        INT32 ulFrameRate = 0;
        bRet= NETDEV_GetFrameRate(m_lpPlayHandle, &ulFrameRate);
        if(TRUE != bRet)
        {
            strTemp.Format("Get Frame Rate failed\n");
        }  
        else
        {
            strTemp.Format("Frame Rate       \t %d\n", ulFrameRate);
        }
        strOut += strTemp;


        /* Encode format */
        INT32 dwFormat = 0;
        bRet = NETDEV_GetVideoEncodeFmt(m_lpPlayHandle, &dwFormat);
        if(TRUE != bRet)
        {
            strTemp.Format("Get Format failed.\n");
        }  
        else
        {
            strTemp.Format("Format           \t %d\n", dwFormat);
        }
        strOut += strTemp;

        /* Resolution */
        INT32 dwWidth = 0;
        INT32 dwHeight = 0;
        bRet = NETDEV_GetResolution(m_lpPlayHandle,&dwWidth, &dwHeight);
        if(TRUE != bRet)
        {
            strTemp.Format("Get Resolution failed.\n");
        }  
        else
        {
            strTemp.Format("Resolution        \t %d*%d\n",dwWidth, dwHeight);
        }
        strOut += strTemp;

        /* Lost packet rate */
        INT32 ulRecvPktNum = 0;
        INT32 ulLostPktNum = 0;
        bRet = NETDEV_GetLostPacketRate(m_lpPlayHandle,&ulRecvPktNum, &ulLostPktNum);
        if(TRUE != bRet)
        {
            strTemp.Format("Get Packet Rate failed\n");
        }  
        else
        {
            strTemp.Format("Lost Packet Rate  \t (%d/%d)\n", ulLostPktNum, ulRecvPktNum);
        }
        strOut += strTemp;

        MessageBox(strOut);
    }
    else
    {
        MessageBox("Realplay or playback first.");
    }

    return;
}

/* Enable sound */
void CLiveViewDlg::OnBnClickedBtnSoundOn()
{
    if(NULL == m_lpPlayHandle)
    {
        return;
    }

    BOOL bRet = NETDEV_OpenSound(m_lpPlayHandle);
    if(TRUE != bRet)
    {
        MessageBox("Play sound failed.");
    }

    return;
}

/* Sound Volume control */
void CLiveViewDlg::OnBnClickedBtnSoundVolumeControl()
{
    if(NULL == m_lpPlayHandle)
    {
        return;
    }

    INT32 dwVolume = 200;
    BOOL bRet = NETDEV_SoundVolumeControl(m_lpPlayHandle, dwVolume);
    if(TRUE != bRet)
    {
        MessageBox("Play sound failed.");
    }

    return;
}

/* Sound off */
void CLiveViewDlg::OnBnClickedBtnSoundClose()
{
    if(NULL == m_lpPlayHandle)
    {
        return;
    }

    BOOL bRet = NETDEV_CloseSound(m_lpPlayHandle);
    if(TRUE != bRet)
    {
        MessageBox("Close sound failed.");
    }

    return;
}

/* Reset Lost packet rate */
void CLiveViewDlg::OnBnClickedBtnResetLostPacketRate()
{
    if(NULL == m_lpPlayHandle)
    {
        return;
    }

    BOOL bRet = NETDEV_ResetLostPacketRate(m_lpPlayHandle);
    if(TRUE != bRet)
    {
        MessageBox("Reset failed.");
    }  
    else
    {
        MessageBox("Reset succeed.");
    }

    return;
}

/* Digital Zoom */
void CLiveViewDlg::OnBnClickedBtnSetDigitalZoom()
{
    UpdateData();
    if(NULL == m_lpPlayHandle)
    {
        return;
    }

    NETDEV_RECT_S stRect;
    memset(&stRect, 0, sizeof(NETDEV_RECT_S));

    /* Take the upper left corner of the window for playing as a start point, and the parameter value range from 0 to 10000. */
    stRect.dwLeft = 2500;
    stRect.dwRight = 7500;
    stRect.dwTop = 8000;
    stRect.dwBottom = 2000;


    BOOL bRet = NETDEV_SetDigitalZoom(m_lpPlayHandle, m_hWnd, &stRect);
    if (TRUE != bRet)
    {
        MessageBox("Set Digital zoom failed.");
    }
}

/* Non-preview Snapshot */
void CLiveViewDlg::OnBnClickedBtnSnapshotNoPreview()
{
    /* Please choose a different path for each operation, otherwise the file will be overwritten. */
    CHAR szPath[NETDEV_LEN_260] = "C:\\NetDEVSDK\\Pic\\netDev";

    /* Non-English characters included in the path. Please convert to UTF-8. */
    //MBToUTF8(szPath, szPath, NETDEV_LEN_260);

    CString strOut;
    BOOL bRet = NETDEV_CaptureNoPreview(m_lpDevHandle, m_lChannelID, NETDEV_LIVE_STREAM_INDEX_MAIN, szPath, NETDEV_PICTURE_JPG);
    if(TRUE != bRet)
    {
        strOut.Format("Get capture failed.");
    }   
    else
    {
        strOut.Format("Get capture succeed! Path: %s", szPath);
    }

    MessageBox(strOut);
    return;
}
