// SetGetCfgDlg.cpp
//

#include "stdafx.h"
#include "NetDemo.h"
#include "ConfigDlg.h"

// CConfigDlg

IMPLEMENT_DYNAMIC(CConfigDlg, CDialog)

CConfigDlg::CConfigDlg(CWnd* pParent /*=NULL*/)
    : CDialog(CConfigDlg::IDD, pParent)
{

}

CConfigDlg::~CConfigDlg()
{
}

void CConfigDlg::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    DDX_Text(pDX, IDC_EDIT_IPV4_ADDRESS, m_strIPv4Addr);
    DDX_Text(pDX, IDC_EDIT_IPV4_GATEWAY, m_strIPv4Gateway);
}


BEGIN_MESSAGE_MAP(CConfigDlg, CDialog)
    ON_BN_CLICKED(IDC_BTN_REBOOT, &CConfigDlg::OnBnClickedBtnReboot)
    ON_BN_CLICKED(IDC_BNT_FACTORY_DEFAULT, &CConfigDlg::OnBnClickedBntFactoryDefault)
    ON_BN_CLICKED(IDC_BTN_GET_STREAM_INFO, &CConfigDlg::OnBnClickedBtnGetStreamInfo)
    ON_BN_CLICKED(IDC_BTN_SET_STREAM_INFO, &CConfigDlg::OnBnClickedBtnSetStreamInfo)
    ON_BN_CLICKED(IDC_BTN_GET_IMAGE_INFO, &CConfigDlg::OnBnClickedBtnGetImageInfo)
    ON_BN_CLICKED(IDC_BTN_SET_IMAGE_INFO, &CConfigDlg::OnBnClickedBtnSetImageInfo) 
    ON_BN_CLICKED(IDC_BTN_GET_NETWORK_CFG, &CConfigDlg::OnBnClickedBtnGetNetworkCfg)
    ON_BN_CLICKED(IDC_BTN_SET_NETWORK_CFG, &CConfigDlg::OnBnClickedBtnSetNetworkCfg)
    ON_BN_CLICKED(IDC_BNT_GET_DEVICE_INFO, &CConfigDlg::OnBnClickedBntGetDeviceInfo)
    ON_BN_CLICKED(IDC_BTN_GET_ALARM_INPUT, &CConfigDlg::OnBnClickedBtnGetAlarmInput)
    ON_BN_CLICKED(IDC_BTN_GET_ALARM_OUTPUT, &CConfigDlg::OnBnClickedBtnGetAlarmOutput)
    ON_BN_CLICKED(IDC_BTN_SET_ALARM_OUTPUT, &CConfigDlg::OnBnClickedBtnSetAlarmOutput)
    ON_BN_CLICKED(IDC_BTN_TRIGGER_ALARM_OUTPUT, &CConfigDlg::OnBnClickedBtnTriggerAlarmOutput)
    ON_BN_CLICKED(IDC_BTN_GET_OSD, &CConfigDlg::OnBnClickedBtnGetOsd)
    ON_BN_CLICKED(IDC_BTN_SET_OSD, &CConfigDlg::OnBnClickedBtnSetOsd)
    ON_BN_CLICKED(IDC_BTN_GET_NTP_CFG, &CConfigDlg::OnBnClickedBtnGetNtpCfg)
    ON_BN_CLICKED(IDC_BTN_SET_NTP_CFG, &CConfigDlg::OnBnClickedBtnSetNtpCfg)
    ON_BN_CLICKED(IDC_BTN_GET_PRIVACYMASK, &CConfigDlg::OnBnClickedBtnGetPrivacymask)
    ON_BN_CLICKED(IDC_BTN_GET_MOTION_ALARM_INFO, &CConfigDlg::OnBnClickedBtnGetMotionAlarmInfo)
    ON_BN_CLICKED(IDC_BTN_SET_MOTION_ALARM_INFO, &CConfigDlg::OnBnClickedBtnSetMotionAlarmInfo)
    ON_BN_CLICKED(IDC_BTN_GET_TAMPER_ALARM_INFO, &CConfigDlg::OnBnClickedBtnGetTamperAlarmInfo)
    ON_BN_CLICKED(IDC_BTN_SET_TAMPER_ALARM_INFO, &CConfigDlg::OnBnClickedBtnSetTamperAlarmInfo)
    ON_BN_CLICKED(IDC_BTN_SET_PRIVACY_MASK, &CConfigDlg::OnBnClickedBtnSetPrivacyMask)
END_MESSAGE_MAP()

/* Restart */
void CConfigDlg::OnBnClickedBtnReboot()
{
    if(NULL == m_lpDevHandle)
    {
        return;
    }

    BOOL bRet = NETDEV_Reboot(m_lpDevHandle);
    if(TRUE != bRet)
    {
        MessageBox("Reboot Failed.");
    }
    else
    {
        MessageBox("Reboot Succeed.");
    }

    m_lpDevHandle = NULL;
    return;
}

/* Restore factory default settings */
void CConfigDlg::OnBnClickedBntFactoryDefault()
{
    if(NULL == m_lpDevHandle)
    {
        return;
    }

    BOOL bRet = NETDEV_RestoreConfig(m_lpDevHandle);
    if(TRUE !=bRet)
    {
        MessageBox("Factory Default Failed.");
    }
    else
    {
        MessageBox("Factory Default Succeed.");
    }

    return;
}

/* Get stream info */
void CConfigDlg::OnBnClickedBtnGetStreamInfo()
{
    INT32 dwBytesReturned = 0;
    NETDEV_VIDEO_STREAM_INFO_S stStreamInfo;

    memset(&stStreamInfo, 0, sizeof(stStreamInfo));
    stStreamInfo.enStreamType = NETDEV_LIVE_STREAM_INDEX_MAIN;
 
    BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_STREAMCFG, &stStreamInfo, sizeof(NETDEV_VIDEO_STREAM_INFO_S), &dwBytesReturned);
    if (TRUE != bRet)
    {
        MessageBox("Get Video Stream Info failed.");
    }
    else
    {
        CString strTemp, strOut;

        strTemp.Format("Stream Type      \t %d \n",NETDEV_LIVE_STREAM_INDEX_MAIN);
        strOut += strTemp;
        strTemp.Format("Enable           \t %d \n",stStreamInfo.bEnableFlag);
        strOut += strTemp;
        strTemp.Format("Bit rate         \t %d \n",stStreamInfo.dwBitRate);
        strOut += strTemp;
        strTemp.Format("Frame rate       \t %d \n",stStreamInfo.dwFrameRate);
        strOut += strTemp;
        strTemp.Format("Resolution       \t %d * %d \n",stStreamInfo.dwWidth, stStreamInfo.dwHeight);
        strOut += strTemp;
        strTemp.Format("Format           \t %d\n",stStreamInfo.enCodeType);
        strOut += strTemp;
        strTemp.Format("I Frame Interval \t %d\n",stStreamInfo.dwGop);
        strOut += strTemp;

        MessageBox(strOut);
    }

    return;
}

/* Set stream info */
void CConfigDlg::OnBnClickedBtnSetStreamInfo()
{
    INT32 dwBytesReturned = 0;
    NETDEV_VIDEO_STREAM_INFO_S stStreamInfo;

    /* Get bit stream parameters */
    memset(&stStreamInfo, 0, sizeof(stStreamInfo));
    stStreamInfo.enStreamType = NETDEV_LIVE_STREAM_INDEX_MAIN;

    BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_STREAMCFG, &stStreamInfo, sizeof(NETDEV_VIDEO_STREAM_INFO_S), &dwBytesReturned);
    if(TRUE != bRet)
    {
        return;
    }

    /* Modify bit stream parameters */
    stStreamInfo.bEnableFlag = true;
    stStreamInfo.dwFrameRate = 20;
    stStreamInfo.dwBitRate = 4095;
    stStreamInfo.dwGop = 24;
    stStreamInfo.enCodeType = NETDEV_VIDEO_CODE_H264;

    bRet = NETDEV_SetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_SET_STREAMCFG, &stStreamInfo, sizeof(NETDEV_VIDEO_STREAM_INFO_S));
    if(TRUE != bRet)
    {
        MessageBox("Set Video Stream Info failed.");
    }
    else
    {
        MessageBox("Set Video Stream Info succeed.");
    }

    return;
}

/* Get image info */
void CConfigDlg::OnBnClickedBtnGetImageInfo()
{
    UpdateData();
    INT32 dwBytesReturned = 0;
    NETDEV_IMAGE_SETTING_S stImageInfo;
    memset(&stImageInfo, 0, sizeof(NETDEV_IMAGE_SETTING_S));

    BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_IMAGECFG, &stImageInfo, sizeof(NETDEV_IMAGE_SETTING_S), &dwBytesReturned);
    if(TRUE != bRet)
    {
        MessageBox("get imaging settings failed.");
    }
    else
    {
        CString strTemp, strOut;

        strTemp.Format("Brightness      \t %d \n",stImageInfo.dwBrightness);
        strOut += strTemp;
        strTemp.Format("ColorSaturation \t %d \n",stImageInfo.dwSaturation);
        strOut += strTemp;
        strTemp.Format("Contrast        \t %d \n",stImageInfo.dwContrast);
        strOut += strTemp;
        strTemp.Format("Sharpness       \t %d \n",stImageInfo.dwSharpness);
        strOut += strTemp;

        MessageBox(strOut);
    }

    return;
}

/* Set image information */
void CConfigDlg::OnBnClickedBtnSetImageInfo()
{
    NETDEV_IMAGE_SETTING_S stImageInfo;
    memset(&stImageInfo, 0, sizeof(NETDEV_IMAGE_SETTING_S));

    /* Adjust the image settings. The parameter value range from 0 to 255. */
    stImageInfo.dwContrast = 100;
    stImageInfo.dwBrightness = 110;
    stImageInfo.dwSaturation = 120;
    stImageInfo.dwSharpness = 130;

    BOOL bRet = NETDEV_SetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_SET_IMAGECFG, &stImageInfo, sizeof(NETDEV_IMAGE_SETTING_S));
    if(TRUE != bRet)
    {
        MessageBox("Set imaging settings failed.");
    }
    else
    {
        MessageBox("Set imaging settings succeed.");
    }

    return;
}

/* Get network settings */
void CConfigDlg::OnBnClickedBtnGetNetworkCfg()
{
    NETDEV_NETWORKCFG_S stNetworkcfg;
    memset(&stNetworkcfg, 0, sizeof(NETDEV_NETWORKCFG_S));

    INT32 dwBytesReturned = 0;
    BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_NETWORKCFG, &stNetworkcfg, sizeof(NETDEV_NETWORKCFG_S), &dwBytesReturned);
    if(TRUE != bRet)
    {
        MessageBox("Get Network Interfaces failed.");
    }
    else
    {
        m_strIPv4Addr = stNetworkcfg.szIpv4Address;
        m_strIPv4Gateway = stNetworkcfg.szIPv4GateWay;
        UpdateData(FALSE);

        CString strTemp, strOut;

        strTemp.Format("IPv4DHCP    \t %d \n", stNetworkcfg.dwIPv4DHCP);
        strOut += strTemp;
        strTemp.Format("Ipv4Address \t %s \n", stNetworkcfg.szIpv4Address);
        strOut += strTemp;
        strTemp.Format("IPv4GateWay \t %s \n", stNetworkcfg.szIPv4GateWay);
        strOut += strTemp;
        strTemp.Format("MTU         \t %d \n", stNetworkcfg.dwMTU);
        strOut += strTemp;

        MessageBox(strOut);
    }

    return;
}

/* Configure network settings */
void CConfigDlg::OnBnClickedBtnSetNetworkCfg()
{
    NETDEV_NETWORKCFG_S stNetworkSetcfg;
    memset(&stNetworkSetcfg, 0, sizeof(NETDEV_NETWORKCFG_S));

    INT32 dwBytesReturned =0;
    BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_NETWORKCFG, &stNetworkSetcfg, sizeof(NETDEV_NETWORKCFG_S), &dwBytesReturned);
    if(TRUE != bRet)
    {
        MessageBox("Get Network Interfaces failed.");
        return;
    }

    UpdateData(TRUE);
    if("" != m_strIPv4Addr)
    {
        strncpy(stNetworkSetcfg.szIpv4Address, m_strIPv4Addr, NETDEV_LEN_32  -1);
    }
    if("" != m_strIPv4Gateway)
    {
        strncpy(stNetworkSetcfg.szIPv4GateWay, m_strIPv4Gateway, NETDEV_LEN_32  -1);
    }

    /* IP or gateway must be modified in compliance with each other */
    bRet = NETDEV_SetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_SET_NETWORKCFG, &stNetworkSetcfg, sizeof(NETDEV_NETWORKCFG_S));
    if(TRUE != bRet)
    {
        MessageBox("Set Network Interfaces failed.");
    }
    else
    {
        MessageBox("Set Network Interfaces succeed.");
    }

    return;
}

/* Get device info */
void CConfigDlg::OnBnClickedBntGetDeviceInfo()
{
    NETDEV_DEVICE_BASICINFO_S stDeviceInfo;
    memset(&stDeviceInfo, 0, sizeof(NETDEV_DEVICE_BASICINFO_S));

    INT32 dwBytesReturned = 0;
    BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_DEVICECFG, &stDeviceInfo, sizeof(NETDEV_DEVICE_BASICINFO_S), &dwBytesReturned);
    if(TRUE != bRet)
    {
        MessageBox("Get Device Info failed.");
    }
    else
    {
        CString strTemp, strOut;

        strTemp.Format("DevModel:           %s \n", stDeviceInfo.szDevModel);
        strOut += strTemp;
        strTemp.Format("SerialNum:          %s \n", stDeviceInfo.szSerialNum);
        strOut += strTemp;
        strTemp.Format("FirmwareVersion:    %s \n", stDeviceInfo.szFirmwareVersion);
        strOut += strTemp;
        strTemp.Format("MacAddress:         %s \n", stDeviceInfo.szMacAddress);
        strOut += strTemp;

        MessageBox(strOut);
    }

    return;
}

/* Get Alarm input info */
void CConfigDlg::OnBnClickedBtnGetAlarmInput()
{
    NETDEV_ALARM_INPUT_LIST_S stAlarmInputList;
    memset(&stAlarmInputList, 0, sizeof(NETDEV_ALARM_INPUT_LIST_S));

    INT32 dwBytesReturned =0;
    BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_ALARM_INPUTCFG, &stAlarmInputList, sizeof(NETDEV_ALARM_INPUT_LIST_S), &dwBytesReturned);
    if(TRUE != bRet)
    {
        MessageBox("Get alarm input info failed.");
        return;
    }
    else
    {
        CString strTemp, strOut;
        for(INT32 i = 0; i < stAlarmInputList.dwSize; i++)
        {
            strTemp.Format("name:\t %s \n", stAlarmInputList.astAlarmInputInfo[i].szName);
            strOut += strTemp;
        }
        MessageBox(strOut);
    }

    return;
}

/* Get Alarm output info */
void CConfigDlg::OnBnClickedBtnGetAlarmOutput()
{
    NETDEV_ALARM_OUTPUT_LIST_S stAlarmOutputList;
    memset(&stAlarmOutputList, 0, sizeof(NETDEV_ALARM_INPUT_LIST_S));

    INT32 dwBytesReturned =0;
    BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_ALARM_OUTPUTCFG, &stAlarmOutputList, sizeof(NETDEV_ALARM_INPUT_LIST_S), &dwBytesReturned);
    if(TRUE != bRet)
    {
        MessageBox("Get alarm output info failed.");
        return;
    }
    else
    {
        CString strTemp, strOut;
        for(INT32 i = 0; i < stAlarmOutputList.dwSize; i++)
        {
            strTemp.Format("Name:\t %s \n", stAlarmOutputList.astAlarmOutputInfo[i].szName);
            strOut += strTemp;
            strTemp.Format("Channel id:\t %d \n", stAlarmOutputList.astAlarmOutputInfo[i].dwChancelId);
            strOut += strTemp;
            strTemp.Format("Status:\t %d \n", stAlarmOutputList.astAlarmOutputInfo[i].enDefaultStatus);
            strOut += strTemp;
            strTemp.Format("Duration:\t %d \n", stAlarmOutputList.astAlarmOutputInfo[i].dwDurationSec);
            strOut += strTemp;
        }
        MessageBox(strOut);
    }

    return;
}

/* Set Alarm output info */
void CConfigDlg::OnBnClickedBtnSetAlarmOutput()
{
    NETDEV_ALARM_OUTPUT_LIST_S stAlarmOutputList;
    memset(&stAlarmOutputList, 0, sizeof(NETDEV_ALARM_INPUT_LIST_S));

    INT32 dwBytesReturned = 0;
    BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_ALARM_OUTPUTCFG, &stAlarmOutputList, sizeof(NETDEV_ALARM_INPUT_LIST_S), &dwBytesReturned);
    if(TRUE != bRet)
    {
        MessageBox("Get alarm output info failed.");
        return;
    }

    NETDEV_ALARM_OUTPUT_INFO_S stAlarmOutputInfo;
    memset(&stAlarmOutputInfo, 0, sizeof(NETDEV_ALARM_OUTPUT_INFO_S));

    stAlarmOutputInfo = stAlarmOutputList.astAlarmOutputInfo[0];
    stAlarmOutputInfo.dwDurationSec = 15;

    bRet = NETDEV_SetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_SET_ALARM_OUTPUTCFG, &stAlarmOutputInfo, sizeof(NETDEV_ALARM_INPUT_INFO_S));
    if(TRUE != bRet)
    {
        MessageBox("Set alarm output info failed.");
    }
    else
    {
        MessageBox("Set alarm output info succeed.");
    }

    return;
}

/* Trigger Alarm output */
void CConfigDlg::OnBnClickedBtnTriggerAlarmOutput()
{
    NETDEV_ALARM_OUTPUT_LIST_S stAlarmOutputList;
    memset(&stAlarmOutputList, 0, sizeof(NETDEV_ALARM_INPUT_LIST_S));

    INT32 dwBytesReturned = 0;
    BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_ALARM_OUTPUTCFG, &stAlarmOutputList, sizeof(NETDEV_ALARM_INPUT_LIST_S), &dwBytesReturned);
    if(TRUE != bRet)
    {
        MessageBox("Get alarm output info failed.");
        return;
    }

    NETDEV_TRIGGER_ALARM_OUTPUT_S stTriggerAlarmOutput;
    memset(&stTriggerAlarmOutput, 0, sizeof(NETDEV_TRIGGER_ALARM_OUTPUT_S));
    strncpy(stTriggerAlarmOutput.szName, stAlarmOutputList.astAlarmOutputInfo[0].szName, NETDEV_LEN_64 - 1);

    stTriggerAlarmOutput.enOutputState = NETDEV_BOOLEAN_STATUS_ACTIVE;

    bRet = NETDEV_SetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_TRIGGER_ALARM_OUTPUT, &stTriggerAlarmOutput, sizeof(NETDEV_TRIGGER_ALARM_OUTPUT_S));
    if(TRUE != bRet)
    {
        MessageBox("Trigger alarm output failed.");
    }
    else
    {
        MessageBox("Trigger alarm output succeed.");
    }

    return;
}

/* Get OSD Info */
void CConfigDlg::OnBnClickedBtnGetOsd()
{
    NETDEV_VIDEO_OSD_CFG_S stChannelOSDInfo;
    memset(&stChannelOSDInfo, 0, sizeof(NETDEV_VIDEO_OSD_CFG_S));

    INT32 dwBytesReturned = 0;
    BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_OSDCFG, &stChannelOSDInfo, sizeof(NETDEV_VIDEO_OSD_CFG_S), &dwBytesReturned);
    if(TRUE != bRet)
    {
        MessageBox("Get OSD Info failed.");
        return;
    }
    else
    {
        CString strOut, strTemp;
        strTemp.Format("Channel name OSD:\t %s \n", stChannelOSDInfo.stNameOSD.szOSDText);
        strOut += strTemp;
        strTemp.Format("OSD text:\t %s \n", stChannelOSDInfo.astTextOverlay[0].szOSDText);
        strOut += strTemp;
        MessageBox(strOut);
    }

    return;
}

/* Set OSD Info */
void CConfigDlg::OnBnClickedBtnSetOsd()
{
    NETDEV_VIDEO_OSD_CFG_S stChannelOSDInfo;
    memset(&stChannelOSDInfo, 0, sizeof(NETDEV_VIDEO_OSD_CFG_S));

    INT32 dwBytesReturned = 0;
    BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_OSDCFG, &stChannelOSDInfo, sizeof(NETDEV_VIDEO_OSD_CFG_S), &dwBytesReturned);
    if(TRUE != bRet)
    {
        MessageBox("Get OSD Info failed.");
        return;
    }

    /* time */
    stChannelOSDInfo.stTimeOSD.bEnableFlag = TRUE;
    stChannelOSDInfo.stTimeOSD.stAreaScope.dwLocateX = 1000;
    stChannelOSDInfo.stTimeOSD.stAreaScope.dwLocateY = 1000;
    stChannelOSDInfo.stTimeOSD.udwTimeFormat = NETDEV_OSD_TIME_FORMAT_CAP_HHMMSS;

    /* name */
    stChannelOSDInfo.stNameOSD.bEnableFlag = TRUE;
    stChannelOSDInfo.stNameOSD.stAreaScope.dwLocateX = 2000;
    stChannelOSDInfo.stNameOSD.stAreaScope.dwLocateY = 8000;
    strncpy(stChannelOSDInfo.stNameOSD.szOSDText, "Camera", NETDEV_LEN_64 - 1);

    /* text */
    stChannelOSDInfo.astTextOverlay[0].bEnableFlag = TRUE;
    stChannelOSDInfo.astTextOverlay[0].stAreaScope.dwLocateX = 5000;
    stChannelOSDInfo.astTextOverlay[0].stAreaScope.dwLocateY = 5000;
    stChannelOSDInfo.wTextNum = 1;
    strncpy(stChannelOSDInfo.astTextOverlay[0].szOSDText, "Welcome", NETDEV_LEN_64 - 1);

    bRet = NETDEV_SetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_SET_OSDCFG, &stChannelOSDInfo, sizeof(NETDEV_VIDEO_OSD_CFG_S));
    if(TRUE != bRet)
    {
        MessageBox("Set OSD info failed.");
    }
    else
    {
        MessageBox("Set OSD info Succeed.");
    }

    return;
}

/* Get NTP */
void CConfigDlg::OnBnClickedBtnGetNtpCfg()
{
    NETDEV_SYSTEM_NTP_INFO_S stNTPInfo;
    memset(&stNTPInfo, 0, sizeof(NETDEV_SYSTEM_NTP_INFO_S));

    /* Failed to return Get information when NTP is not enabled for the NVR. Please perform Set operation first. */
    INT32 dwBytesReturned = 0;
    BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_NTPCFG, &stNTPInfo, sizeof(NETDEV_SYSTEM_NTP_INFO_S), &dwBytesReturned);
    if(TRUE != bRet)
    {
        MessageBox("Get NTP Info failed.");
    }
    else
    {
        CString strTemp, strOut;
        strTemp.Format("Support DHCP:\t %d \n", stNTPInfo.bSupportDHCP);
        strOut += strTemp;
        strTemp.Format("IP Type:\t %d \n", stNTPInfo.stAddr.eIPType);
        strOut += strTemp;
        strTemp.Format("NTP Server address:\t %s \n", stNTPInfo.stAddr.szIPAddr);
        strOut += strTemp;

        MessageBox(strOut);
    }

    return;
}

/* Set NTP */
void CConfigDlg::OnBnClickedBtnSetNtpCfg()
{
    NETDEV_SYSTEM_NTP_INFO_S stNTPInfo;
    memset(&stNTPInfo, 0, sizeof(NETDEV_SYSTEM_NTP_INFO_S));

    stNTPInfo.bSupportDHCP = 0;
    stNTPInfo.stAddr.eIPType = NETDEV_NETWORK_HOSTTYPE_IPV4;
    strncpy(stNTPInfo.stAddr.szIPAddr, "192.168.0.14", NETDEV_LEN_132 - 1);

    BOOL bRet = NETDEV_SetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_SET_NTPCFG, &stNTPInfo, sizeof(NETDEV_SYSTEM_NTP_INFO_S));
    if(TRUE != bRet)
    {
        MessageBox("Set NTP Info failed.");
    }

    return;
}

/* Get Privacy mask Cfg */
void CConfigDlg::OnBnClickedBtnGetPrivacymask()
{
    NETDEV_PRIVACY_MASK_CFG_S stPrivacyMaskInfo;
    memset(&stPrivacyMaskInfo, 0, sizeof(NETDEV_PRIVACY_MASK_CFG_S));

    INT32 dwBytesReturned = 0;
    BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_PRIVACYMASKCFG, &stPrivacyMaskInfo, sizeof(NETDEV_PRIVACY_MASK_CFG_S), &dwBytesReturned);
    if(TRUE != bRet)
    {
        MessageBox("Get Privacymask Info failed.");
    }
    else
    {
        CString strTemp,strOut;

        for(INT32 i = 0; i < stPrivacyMaskInfo.dwSize; i++)
        {
            strTemp.Format("Area[%d]:\n",  i+1);
            strOut += strTemp;
            strTemp.Format("  TopLeftX: %d \t TopLeftY: %d\n  BottomRightX: %d BottomRightY: %d\n", stPrivacyMaskInfo.astArea[i].dwTopLeftX, stPrivacyMaskInfo.astArea[i].dwTopLeftY, stPrivacyMaskInfo.astArea[i].dwBottomRightX, stPrivacyMaskInfo.astArea[i].dwBottomRightY);
            strOut += strTemp;
        }

        MessageBox(strOut);
    }

    return;
}

/* Set Privacy mask Cfg */
void CConfigDlg::OnBnClickedBtnSetPrivacyMask()
{
    NETDEV_PRIVACY_MASK_CFG_S stPrivacyMaskInfo;
    memset(&stPrivacyMaskInfo, 0, sizeof(NETDEV_PRIVACY_MASK_CFG_S));

    INT32 dwBytesReturned = 0;
    BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_PRIVACYMASKCFG, &stPrivacyMaskInfo, sizeof(NETDEV_PRIVACY_MASK_CFG_S), &dwBytesReturned);
    if(TRUE != bRet)
    {
        MessageBox("Get Privacymask Info failed.");
        return;
    }

    stPrivacyMaskInfo.astArea[0].bIsEanbled = TRUE;
    stPrivacyMaskInfo.astArea[0].dwBottomRightX = 0;
    stPrivacyMaskInfo.astArea[0].dwBottomRightY = 0;
    stPrivacyMaskInfo.astArea[0].dwTopLeftX = 1000;
    stPrivacyMaskInfo.astArea[0].dwTopLeftY = 1000;

    stPrivacyMaskInfo.astArea[1].bIsEanbled = TRUE;
    stPrivacyMaskInfo.astArea[1].dwBottomRightX = 4000;
    stPrivacyMaskInfo.astArea[1].dwBottomRightY = 4000;
    stPrivacyMaskInfo.astArea[1].dwTopLeftX = 5000;
    stPrivacyMaskInfo.astArea[1].dwTopLeftY = 5000;


    bRet = NETDEV_SetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_SET_PRIVACYMASKCFG, &stPrivacyMaskInfo, sizeof(NETDEV_PRIVACY_MASK_CFG_S));
    if(TRUE != bRet)
    {
        MessageBox("Set Privacymask Info failed.");
    }
    else
    {
        MessageBox("Set Privacymask Info succeed.");
    }

    return;
}

/* Get Motion Alarm Info */
void CConfigDlg::OnBnClickedBtnGetMotionAlarmInfo()
{
    NETDEV_MOTION_ALARM_INFO_S stMotionAlarmInfo;
    memset(&stMotionAlarmInfo, 0, sizeof(NETDEV_MOTION_ALARM_INFO_S));

    INT32 dwBytesReturned = 0;
    BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_MOTIONALARM, &stMotionAlarmInfo, sizeof(NETDEV_MOTION_ALARM_INFO_S), &dwBytesReturned);
    if(TRUE != bRet)
    {
        MessageBox("Get Motion Alarm Info failed.");
    }
    else
    {
        CString strTemp, strOut;
        strTemp.Format("Sensitivity: %d\n", stMotionAlarmInfo.dwSensitivity);
        strOut += strTemp;
        strTemp.Format("Objection Size: %d\n", stMotionAlarmInfo.dwObjectSize);
        strOut += strTemp;
        strTemp.Format("History: %d\n", stMotionAlarmInfo.dwHistory);
        strOut += strTemp;

        MessageBox(strOut);
    }

    return;
}

/* Set Motion Alarm Info */
void CConfigDlg::OnBnClickedBtnSetMotionAlarmInfo()
{
    NETDEV_MOTION_ALARM_INFO_S stMotionAlarmInfo;
    memset(&stMotionAlarmInfo, 0, sizeof(NETDEV_MOTION_ALARM_INFO_S));

    INT32 dwBytesReturned = 0;
    BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_MOTIONALARM, &stMotionAlarmInfo, sizeof(NETDEV_MOTION_ALARM_INFO_S), &dwBytesReturned);
    if(TRUE != bRet)
    {
        MessageBox("Get Motion Alarm Info failed.");
        return;
    }

    stMotionAlarmInfo.dwSensitivity = 88;
    stMotionAlarmInfo.dwObjectSize = 88;
    stMotionAlarmInfo.dwHistory = 2;

    memset(&stMotionAlarmInfo.awScreenInfo, 0,sizeof(stMotionAlarmInfo.awScreenInfo));
    for(INT32 i = 0; i < 18; i++)
    {
        for(INT32 j = 0; j < 22; j++)
        {
            stMotionAlarmInfo.awScreenInfo[i][j] = 1;
        }
    }

    bRet = NETDEV_SetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_SET_MOTIONALARM, &stMotionAlarmInfo, sizeof(NETDEV_MOTION_ALARM_INFO_S));
    if(TRUE != bRet)
    {
        MessageBox("Set Motion Alarm Info failed.");
    }
    else
    {
        MessageBox("Set Motion Alarm Info succeed.");
    }

    return;
}

/* Get Tamper Alarm Info */
void CConfigDlg::OnBnClickedBtnGetTamperAlarmInfo()
{
    NETDEV_TAMPER_ALARM_INFO_S stTamperAlarmInfo;
    memset(&stTamperAlarmInfo, 0, sizeof(NETDEV_TAMPER_ALARM_INFO_S));

    INT32 dwBytesReturned = 0;
    BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_TAMPERALARM, &stTamperAlarmInfo, sizeof(NETDEV_TAMPER_ALARM_INFO_S), &dwBytesReturned);
    if(TRUE != bRet)
    {
        MessageBox("Get Tamper Alarm Info failed.");
    }
    else
    {
        CString strTemp, strOut;
        strTemp.Format("Sensitivity: \t %d\n", stTamperAlarmInfo.dwSensitivity);
        strOut += strTemp;

        MessageBox(strOut);
    }

    return;
}

/* Set Tamper Alarm Info */
void CConfigDlg::OnBnClickedBtnSetTamperAlarmInfo()
{
    NETDEV_TAMPER_ALARM_INFO_S stTamperAlarmInfo;
    memset(&stTamperAlarmInfo, 0, sizeof(NETDEV_TAMPER_ALARM_INFO_S));

    INT32 dwBytesReturned = 0;
    BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_TAMPERALARM, &stTamperAlarmInfo, sizeof(NETDEV_TAMPER_ALARM_INFO_S), &dwBytesReturned);
    if(TRUE != bRet)
    {
        MessageBox("Get Tamper Alarm Info failed.");
    }

    stTamperAlarmInfo.dwSensitivity = 88;
    bRet = NETDEV_SetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_SET_TAMPERALARM, &stTamperAlarmInfo, sizeof(NETDEV_TAMPER_ALARM_INFO_S));
    if(TRUE != bRet)
    {
        MessageBox("Set Tamper Alarm Info failed.");
    }
    else
    {
        MessageBox("Set Tamper Alarm Info succeed.");
    }

    return;
}
