﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using NETSDKHelper;
using System.Runtime.InteropServices;

namespace NetDemo
{
    public partial class Form1 : Form
    {
        public IntPtr m_lpDevHandle;

        public IntPtr m_lpRealHanel;
        public IntPtr m_lpDownloadHandle;

        public int m_dwPtzSpeed;

        public class ComboBoxItem
        {
            public string _text = null;
            public string _value = null;

            public Int64 endTime;
            public Int64 beginTime;

            public override string ToString()
            {
                return this._text;
            }
        }

        //回调函数指针
        private static Dictionary<object, NETDEVSDK.NETDEV_AlarmMessCallBack_PF> _sdkCallBackFuncList = new Dictionary<object, NETDEVSDK.NETDEV_AlarmMessCallBack_PF>();

        private static Dictionary<object, NETDEVSDK.NETDEV_ExceptionCallBack_PF> _sdkExcepCallBackFuncList = new Dictionary<object, NETDEVSDK.NETDEV_ExceptionCallBack_PF>();


        //alarm output 
        private void AlarmMessCallBack(IntPtr lpUserID, Int32 dwChannelID, NETDEV_ALARM_INFO_S stAlarmInfo, IntPtr lpBuf, Int32 dwBufLen, IntPtr lpUserData)
        {
            if (lpUserID == m_lpDevHandle)
            {
                MessageBox.Show(stAlarmInfo.dwAlarmType.ToString());
            }
        }

        private void ExceptionCallBack(IntPtr lpUserID, Int32 dwType, IntPtr stAlarmInfo, IntPtr lpExpHandle, IntPtr lpUserData)
        {
            if ((int)NETDEV_EXCEPTION_TYPE_E.NETDEV_EXCEPTION_EXCHANGE == dwType)
            {
                MessageBox.Show("the device is offline");
            }
        }

        public Form1()
        {
            InitializeComponent();

            int iRet = NETDEVSDK.NETDEV_Init();
            if (NETDEVSDK.TRUE != iRet)
            {
                MessageBox.Show("it is not a admin oper");
            }

            _sdkCallBackFuncList.Add(this, this.AlarmMessCallBack);

            _sdkExcepCallBackFuncList.Add(this, this.ExceptionCallBack);

        }


        private void login_Click(object sender, EventArgs e)
        {
            //first logout

            if (IntPtr.Zero != m_lpRealHanel)
            {
                NETDEVSDK.NETDEV_StopRealPlay(m_lpRealHanel);
            }

            NETDEVSDK.NETDEV_Logout(m_lpDevHandle);

            channel.Items.Clear();
            records.Items.Clear();

            m_lpRealHanel = IntPtr.Zero;
            m_lpDevHandle = IntPtr.Zero;

            //then login

            String strIP = IP.Text;
            String strUser = USER.Text;
            String strPasswd = Pwd.Text;

            IntPtr pstDevInfo = Marshal.AllocHGlobal(Marshal.SizeOf(typeof(NETDEV_DEVICE_INFO_S)));

            m_lpDevHandle = NETDEVSDK.NETDEV_Login(strIP, 0, strUser, strPasswd, pstDevInfo);
            if (m_lpDevHandle == IntPtr.Zero)
            {
                MessageBox.Show("login failed,the error is [" + NETDEVSDK.NETDEV_GetLastError().ToString() + "]");
            }
            else
            {
                //set alarm、exception callback

                IntPtr ptrAlarmCB = Marshal.GetFunctionPointerForDelegate(_sdkCallBackFuncList[this]);

                NETDEVSDK.NETDEV_SetAlarmCallBack(m_lpDevHandle, ptrAlarmCB, IntPtr.Zero);

                IntPtr ptrExcepCB = Marshal.GetFunctionPointerForDelegate(_sdkExcepCallBackFuncList[this]);

                NETDEVSDK.NETDEV_SetExceptionCallBack(ptrExcepCB, IntPtr.Zero);

                //get the channel list

                int pdwChlCount = 32;

                IntPtr pstVideoChlList = new IntPtr();
                pstVideoChlList = Marshal.AllocHGlobal(32 * Marshal.SizeOf(typeof(NETDEV_VIDEO_CHL_DETAIL_INFO_S)));

                int bRet = NETDEVSDK.NETDEV_QueryVideoChlDetailList(m_lpDevHandle, ref pdwChlCount, pstVideoChlList);
                if (NETDEVSDK.TRUE == bRet)
                {
                    NETDEV_VIDEO_CHL_DETAIL_INFO_S stCHLItem;
                    int channelflag = 0;
                    for (int i = 0; i < pdwChlCount; i++)
                    {
                        IntPtr ptrTemp = new IntPtr(pstVideoChlList.ToInt32() + Marshal.SizeOf(typeof(NETDEV_VIDEO_CHL_DETAIL_INFO_S)) * i);
                        stCHLItem = (NETDEV_VIDEO_CHL_DETAIL_INFO_S)Marshal.PtrToStructure(ptrTemp, typeof(NETDEV_VIDEO_CHL_DETAIL_INFO_S));

                        if (stCHLItem.enStatus == (int)NETDEV_CHANNEL_STATUS_E.NETDEV_CHL_STATUS_ONLINE)
                        {
                            ComboBoxItem item = new ComboBoxItem();
                            item._text = "Input" + stCHLItem.dwChannelID.ToString();
                            item._value = stCHLItem.dwChannelID.ToString();
                            channel.Items.Add(item);
                            channelflag = 1;
                        }
                    }
                    if (1 == channelflag)
                    {
                        channel.SelectedIndex = 0;
                    }
                }
                Marshal.FreeHGlobal(pstVideoChlList);
            }

            Marshal.FreeHGlobal(pstDevInfo);
            m_dwPtzSpeed = 5;
        }

        private void logout_Click(object sender, EventArgs e)
        {
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }

            if (IntPtr.Zero != m_lpRealHanel)
            {
                NETDEVSDK.NETDEV_StopRealPlay(m_lpRealHanel);
            }

            NETDEVSDK.NETDEV_Logout(m_lpDevHandle);

            channel.Items.Clear();
            records.Items.Clear();

            m_lpRealHanel = IntPtr.Zero;
            m_lpDevHandle = IntPtr.Zero;
        }

        private void reboot_Click(object sender, EventArgs e)
        {
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }

            int bRet = NETDEVSDK.NETDEV_Reboot(m_lpDevHandle);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("Reboot Failed.");
            }
            else
            {
                MessageBox.Show("Reboot Succeed.");
            }

            m_lpDevHandle = IntPtr.Zero;
        }

        private void StartLive_Click(object sender, EventArgs e)
        {
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }

            int bRet;
            if (IntPtr.Zero != m_lpRealHanel)
            {
                bRet = NETDEVSDK.NETDEV_StopRealPlay(m_lpRealHanel);
                if (NETDEVSDK.TRUE == bRet)
                {
                    m_lpRealHanel = IntPtr.Zero;
                }
            }

            if (IntPtr.Zero != m_lpRealHanel)
            {
                //bRet = NETDEV_StopPlayBack(m_lpPlayHanel);
                //if (NETDEVSDK.TRUE == bRet)
                //{
                //    m_lpPlayHanel = IntPtr.Zero;
                //}
            }

            NETDEV_PREVIEWINFO_S stNetInfo = new NETDEV_PREVIEWINFO_S();

            stNetInfo.dwChannelID = int.Parse(((ComboBoxItem)channel.SelectedItem)._value);
            stNetInfo.hPlayWnd = render.Handle;
            stNetInfo.dwStreamType = (Int32)NETDEV_LIVE_STREAM_INDEX_E.NETDEV_LIVE_STREAM_INDEX_MAIN;
            stNetInfo.dwLinkMode = (Int32)NETDEV_PROTOCAL_E.NETDEV_TRANSPROTOCAL_RTPTCP;//only support

            m_lpRealHanel = NETDEVSDK.NETDEV_RealPlay(m_lpDevHandle, ref stNetInfo, IntPtr.Zero, IntPtr.Zero);
            if (IntPtr.Zero == m_lpRealHanel)
            {
                MessageBox.Show("Realplay failed.");
            }
        }

        private void StopLive_Click(object sender, EventArgs e)
        {
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }

            if (IntPtr.Zero == m_lpRealHanel)
            {
                return;
            }

            int bRet = NETDEVSDK.NETDEV_StopRealPlay(m_lpRealHanel);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("Stop RealPlay failed");
            }

            m_lpRealHanel = IntPtr.Zero;
        }

        private void Snapshot_Click(object sender, EventArgs e)
        {
            String strSavePath = "C:\\NetDEVSDK\\Pic\\netDev";

            if (IntPtr.Zero != m_lpRealHanel)
            {
                String strOut;
                int bRet = NETDEVSDK.NETDEV_CapturePicture(m_lpRealHanel, strSavePath, (int)NETDEV_PICTURE_FORMAT_E.NETDEV_PICTURE_JPG);
                if (NETDEVSDK.TRUE != bRet)
                {
                    strOut = "Get capture failed.";
                }
                else
                {
                    strOut = "Get capture succeed, the path is " + strSavePath + ".jpg";
                }
                MessageBox.Show(strOut);
            }
        }

        private void StartRecord_Click(object sender, EventArgs e)
        {
            String strSavePath = "C:\\NetDEVSDK\\Record\\netDev";

            if (IntPtr.Zero != m_lpRealHanel)
            {
                String strOut;
                int bRet = NETDEVSDK.NETDEV_SaveRealData(m_lpRealHanel, strSavePath, 0);
                if (NETDEVSDK.TRUE != bRet)
                {
                    strOut = "start record failed.";
                }
                else
                {
                    strOut = "Start record succeed, the path is " + strSavePath + ".ts";
                }
                MessageBox.Show(strOut);
            }
        }

        private void StopRecord_Click(object sender, EventArgs e)
        {
            if (IntPtr.Zero != m_lpRealHanel)
            {
                String strOut;
                int bRet = NETDEVSDK.NETDEV_StopSaveRealData(m_lpRealHanel);
                if (NETDEVSDK.TRUE != bRet)
                {
                    strOut = ("Stop record failed.");
                }
                else
                {
                    strOut = ("Stop record succeed.");
                }
                MessageBox.Show(strOut);
            }
        }

        private void GetCamerInfo_Click(object sender, EventArgs e)
        {
            string strOut;
            string strTemp;

            if (IntPtr.Zero != m_lpRealHanel)
            {
                /* Bit rate */
                int ulBitRate = 0;
                int bRet = NETDEVSDK.NETDEV_GetBitRate(m_lpRealHanel, ref ulBitRate);
                if (NETDEVSDK.TRUE != bRet)
                {
                    strTemp = ("Bit rate: failed.\n");
                }
                else
                {
                    strTemp = ("Bit rate " + ulBitRate.ToString() + "\n");
                }
                strOut = strTemp;

                /* Frame rate */
                int ulFrameRate = 0;
                bRet = NETDEVSDK.NETDEV_GetFrameRate(m_lpRealHanel, ref ulFrameRate);
                if (NETDEVSDK.TRUE != bRet)
                {
                    strTemp = ("Frame Rate: failed\n");
                }
                else
                {
                    strTemp = ("Frame Rate: " + ulFrameRate.ToString() + "\n");
                }
                strOut += strTemp;

                /* encode format */
                int dwFormat = 0;
                bRet = NETDEVSDK.NETDEV_GetVideoEncodeFmt(m_lpRealHanel, ref dwFormat);
                if (NETDEVSDK.TRUE != bRet)
                {
                    strTemp = ("Format: failed.\n");
                }
                else
                {
                    strTemp = ("Format: " + dwFormat.ToString() + "\n");
                }
                strOut += strTemp;

                /* resolution */
                int dwWidth = 0;
                int dwHeight = 0;
                bRet = NETDEVSDK.NETDEV_GetResolution(m_lpRealHanel, ref dwWidth, ref dwHeight);
                if (NETDEVSDK.TRUE != bRet)
                {
                    strTemp = ("Resolution: failed.\n");
                }
                else
                {
                    strTemp = ("Resolution: width = " + dwWidth.ToString() + ",height = " + dwHeight.ToString() + "\n");
                }
                strOut += strTemp;

                /* Lost packet rate */
                int ulRecvPktNum = 0;
                int ulLostPktNum = 0;
                bRet = NETDEVSDK.NETDEV_GetLostPacketRate(m_lpRealHanel, ref ulRecvPktNum, ref ulLostPktNum);
                if (NETDEVSDK.TRUE != bRet)
                {
                    strTemp = ("Packet Rate:  failed\n");
                }
                else
                {
                    strTemp = ("loss Packet Rate: " + ulLostPktNum.ToString() + "/" + ulRecvPktNum.ToString() + "\n");
                }
                strOut += strTemp;

                MessageBox.Show(strOut);
            }
            else
            {
                MessageBox.Show("Realplay or playback first.");
            }
        }

        private void getStream_Click(object sender, EventArgs e)
        {
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }
            IntPtr lpOutBuffer = new IntPtr();

            lpOutBuffer = Marshal.AllocHGlobal(Marshal.SizeOf(typeof(NETDEV_VIDEO_STREAM_INFO_S)));

            NETDEV_VIDEO_STREAM_INFO_S stStreamInfo = new NETDEV_VIDEO_STREAM_INFO_S();

            stStreamInfo.enStreamType = (int)NETDEV_LIVE_STREAM_INDEX_E.NETDEV_LIVE_STREAM_INDEX_MAIN;

            Marshal.StructureToPtr(stStreamInfo, lpOutBuffer, true);

            int dwBytesReturned = 0;

            int dwOutBufferSize = Marshal.SizeOf(typeof(NETDEV_VIDEO_STREAM_INFO_S));

            int lChannelD = int.Parse(((ComboBoxItem)channel.SelectedItem)._value);

            int bRet = NETDEVSDK.NETDEV_GetDevConfig(m_lpDevHandle, lChannelD, (int)NETDEV_CONFIG_COMMAND_E.NETDEV_GET_STREAMCFG, lpOutBuffer, dwOutBufferSize, ref dwBytesReturned);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("Get Video Stream Info failed.");
            }
            else
            {
                String strTemp;
                String strOut;

                stStreamInfo = (NETDEV_VIDEO_STREAM_INFO_S)Marshal.PtrToStructure(lpOutBuffer, typeof(NETDEV_VIDEO_STREAM_INFO_S));

                strTemp = ("Stream Type \t " + ((Int32)NETDEV_LIVE_STREAM_INDEX_E.NETDEV_LIVE_STREAM_INDEX_MAIN).ToString() + "\n");
                strOut = strTemp;
                strTemp = ("Enable \t " + stStreamInfo.bEnableFlag.ToString() + "\n");
                strOut += strTemp;
                strTemp = ("Bit rate \t " + stStreamInfo.dwBitRate.ToString() + "\n");
                strOut += strTemp;
                strTemp = ("Frame rate \t " + stStreamInfo.dwFrameRate.ToString() + "\n");
                strOut += strTemp;
                strTemp = ("Resolution \t " + "width = " + stStreamInfo.dwWidth.ToString() + " height = " + stStreamInfo.dwHeight.ToString() + "\n");
                strOut += strTemp;
                strTemp = ("Format \t " + stStreamInfo.enCodeType.ToString() + "\n");
                strOut += strTemp;
                strTemp = ("I Frame Interval \t " + stStreamInfo.dwGop.ToString() + "\n");
                strOut += strTemp;
                MessageBox.Show(strOut);
            }

            Marshal.FreeHGlobal(lpOutBuffer);
        }

        private void QueryRecord_Click(object sender, EventArgs e)
        {
            //clear the records
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }
            records.Items.Clear();

            NETDEV_FILECOND_S stFileCond = new NETDEV_FILECOND_S();
            stFileCond.szFileName = new char[64];
            stFileCond.szReserve = new byte[104];

            stFileCond.dwChannelID = int.Parse(((ComboBoxItem)channel.SelectedItem)._value);

            //now utc seconds

            DateTime begin = new DateTime(1970, 1, 1);
            DateTime now = DateTime.UtcNow;
            long time = now.Ticks - begin.Ticks;//100 nanosecond elapsed since 1970,1,1    

            stFileCond.tEndTime = time / 10000000;

            //today's utc seconds

            DateTime today = new DateTime(DateTime.UtcNow.Year, DateTime.UtcNow.Month, DateTime.UtcNow.Day);
            time = today.Ticks - begin.Ticks;

            stFileCond.tBeginTime = time / 10000000;


            IntPtr dwFileHandle = IntPtr.Zero;

            dwFileHandle = NETDEVSDK.NETDEV_FindFile(m_lpDevHandle, ref stFileCond);
            if (IntPtr.Zero == dwFileHandle)
            {
                MessageBox.Show("Query failed.");
                return;
            }
            else
            {
                NETDEV_FINDDATA_S stVodFile = new NETDEV_FINDDATA_S();

                for (; ; )
                {
                    int bRet = NETDEVSDK.NETDEV_FindNextFile(dwFileHandle, ref stVodFile);
                    if (NETDEVSDK.TRUE != bRet)
                    {
                        break;
                    }
                    else
                    {
                        ComboBoxItem item = new ComboBoxItem();
                        item._value = System.Text.Encoding.Default.GetString(stVodFile.szFileName).TrimEnd('\0');

                        string strBegin = null;
                        {
                            DateTime s = new DateTime(1970, 1, 1);
                            s = s.AddSeconds(stVodFile.tBeginTime);
                            s = s.ToUniversalTime();
                            strBegin = s.ToString("MM/dd HH:mm:ss");

                        }

                        string strEnd = null;
                        {
                            DateTime s = new DateTime(1970, 1, 1);
                            s = s.AddSeconds(stVodFile.tEndTime);
                            s = s.ToUniversalTime();
                            strEnd = s.ToString("MM/dd HH:mm:ss");
                        }

                        item._text = strBegin + "-" + strEnd;
                        item.endTime = stVodFile.tEndTime;
                        item.beginTime = stVodFile.tBeginTime;

                        records.Items.Add(item);
                    }

                    records.SelectedIndex = 0;
                }
            }

            NETDEVSDK.NETDEV_FindClose(dwFileHandle);
        }

        private void playback_Click(object sender, EventArgs e)
        {
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }

            if (IntPtr.Zero != m_lpRealHanel)
            {
                NETDEVSDK.NETDEV_StopRealPlay(m_lpRealHanel);

                m_lpRealHanel = IntPtr.Zero;
            }

            ComboBoxItem item = (ComboBoxItem)records.SelectedItem;

            String strFilename = item._value;

            NETDEV_PLAYBACKINFO_S stPlayBackInfo = new NETDEV_PLAYBACKINFO_S();

            stPlayBackInfo.tBeginTime = item.beginTime;
            stPlayBackInfo.tEndTime = item.endTime;
            stPlayBackInfo.hPlayWnd = render.Handle;
            stPlayBackInfo.dwLinkMode = (Int32)NETDEV_PROTOCAL_E.NETDEV_TRANSPROTOCAL_RTPTCP;//only support

            m_lpRealHanel = NETDEVSDK.NETDEV_PlayBackByName(m_lpDevHandle, ref stPlayBackInfo);
            if (IntPtr.Zero == m_lpRealHanel)
            {
                MessageBox.Show("Play the video failed.");
            }
        }

        private void stopback_Click(object sender, EventArgs e)
        {
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }

            if (IntPtr.Zero != m_lpRealHanel)
            {
                NETDEVSDK.NETDEV_StopRealPlay(m_lpRealHanel);

                m_lpRealHanel = IntPtr.Zero;
            }
        }

        private void SnapshotNoPreview_Click(object sender, EventArgs e)
        {
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }
            String strSavePath = "C:\\NetDEVSDK\\Pic\\netDev";

            if (IntPtr.Zero != m_lpDevHandle)
            {
                String strOut;
                int lChannelD = int.Parse(((ComboBoxItem)channel.SelectedItem)._value);
                int bRet = NETDEVSDK.NETDEV_CaptureNoPreview(m_lpDevHandle, lChannelD, (int)NETDEV_LIVE_STREAM_INDEX_E.NETDEV_LIVE_STREAM_INDEX_MAIN, strSavePath, (int)NETDEV_PICTURE_FORMAT_E.NETDEV_PICTURE_JPG);
                if (NETDEVSDK.TRUE != bRet)
                {
                    strOut = "Get capture failed.";
                }
                else
                {
                    strOut = "Get capture succeed, the path is " + strSavePath + ".jpg";
                }
                MessageBox.Show(strOut);
            }
        }

        private void Soundon_Click(object sender, EventArgs e)
        {
            if (IntPtr.Zero == m_lpRealHanel)
            {
                return;
            }

            int bRet = NETDEVSDK.NETDEV_OpenSound(m_lpRealHanel);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("Play sound failed.");
            }

            return;
        }

        private void soundoff_Click(object sender, EventArgs e)
        {
            if (IntPtr.Zero == m_lpRealHanel)
            {
                return;
            }

            int bRet = NETDEVSDK.NETDEV_CloseSound(m_lpRealHanel);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("Close sound failed.");
            }

            return;
        }

        private void PTZCTR_NW_Click(object sender, EventArgs e)
        {
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }
            int lChannelD = int.Parse(((ComboBoxItem)channel.SelectedItem)._value);
            int bRet = NETDEVSDK.NETDEV_PTZControl_Other(m_lpDevHandle, lChannelD, (int)NETDEV_PTZ_E.NETDEV_PTZ_LEFTUP, m_dwPtzSpeed);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("PTZ control left-up failed.");
            }

            return;
        }

        private void PTZCTR_L_Click(object sender, EventArgs e)
        {
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }
            int lChannelD = int.Parse(((ComboBoxItem)channel.SelectedItem)._value);
            int bRet = NETDEVSDK.NETDEV_PTZControl_Other(m_lpDevHandle, lChannelD, (int)NETDEV_PTZ_E.NETDEV_PTZ_PANLEFT, m_dwPtzSpeed);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("PTZ control left failed.");
            }

            return;
        }

        private void PTZCTR_SW_Click(object sender, EventArgs e)
        {
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }
            int lChannelD = int.Parse(((ComboBoxItem)channel.SelectedItem)._value);
            int bRet = NETDEVSDK.NETDEV_PTZControl_Other(m_lpDevHandle, lChannelD, (int)NETDEV_PTZ_E.NETDEV_PTZ_LEFTDOWN, m_dwPtzSpeed);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("PTZ control left-down failed.");
            }

            return;
        }

        private void PTZCTR_UP_Click(object sender, EventArgs e)
        {
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }
            int lChannelD = int.Parse(((ComboBoxItem)channel.SelectedItem)._value);
            int bRet = NETDEVSDK.NETDEV_PTZControl_Other(m_lpDevHandle, lChannelD, (int)NETDEV_PTZ_E.NETDEV_PTZ_TILTUP, m_dwPtzSpeed);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("PTZ control tilt-up failed.");
            }

            return;
        }

        private void PTZCTR_STOP_Click(object sender, EventArgs e)
        {
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }
            int lChannelD = int.Parse(((ComboBoxItem)channel.SelectedItem)._value);
            int bRet = NETDEVSDK.NETDEV_PTZControl_Other(m_lpDevHandle, lChannelD, (int)NETDEV_PTZ_E.NETDEV_PTZ_ALLSTOP, 0);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("PTZ control all stop failed.");
            }

            return;
        }

        private void PTZCTR_DN_Click(object sender, EventArgs e)
        {
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }
            int lChannelD = int.Parse(((ComboBoxItem)channel.SelectedItem)._value);
            int bRet = NETDEVSDK.NETDEV_PTZControl_Other(m_lpDevHandle, lChannelD, (int)NETDEV_PTZ_E.NETDEV_PTZ_TILTDOWN, m_dwPtzSpeed);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("PTZ control down failed.");
            }

            return;
        }

        private void PTZCTR_NE_Click(object sender, EventArgs e)
        {
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }
            int lChannelD = int.Parse(((ComboBoxItem)channel.SelectedItem)._value);
            int bRet = NETDEVSDK.NETDEV_PTZControl_Other(m_lpDevHandle, lChannelD, (int)NETDEV_PTZ_E.NETDEV_PTZ_RIGHTUP, m_dwPtzSpeed);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("PTZ control right-up failed.");
            }

            return;
        }

        private void PTZCTR_R_Click(object sender, EventArgs e)
        {
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }
            int lChannelD = int.Parse(((ComboBoxItem)channel.SelectedItem)._value);
            int bRet = NETDEVSDK.NETDEV_PTZControl_Other(m_lpDevHandle, lChannelD, (int)NETDEV_PTZ_E.NETDEV_PTZ_PANRIGHT, m_dwPtzSpeed);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("PTZ control right failed.");
            }

            return;
        }

        private void PTZCTR_SE_Click(object sender, EventArgs e)
        {
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }
            int lChannelD = int.Parse(((ComboBoxItem)channel.SelectedItem)._value);
            int bRet = NETDEVSDK.NETDEV_PTZControl_Other(m_lpDevHandle, lChannelD, (int)NETDEV_PTZ_E.NETDEV_PTZ_RIGHTDOWN, m_dwPtzSpeed);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("PTZ control right-down failed.");
            }

            return;
        }

        private void FocusIn_Click(object sender, EventArgs e)
        {
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }
            int lChannelD = int.Parse(((ComboBoxItem)channel.SelectedItem)._value);
            int bRet = NETDEVSDK.NETDEV_PTZControl_Other(m_lpDevHandle, lChannelD, (int)NETDEV_PTZ_E.NETDEV_PTZ_ZOOMTELE, m_dwPtzSpeed);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("PTZ control zoom-tele failed.");
            }

            return;
        }

        private void FocusOut_Click(object sender, EventArgs e)
        {
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }
            int lChannelD = int.Parse(((ComboBoxItem)channel.SelectedItem)._value);
            int bRet = NETDEVSDK.NETDEV_PTZControl_Other(m_lpDevHandle, lChannelD, (int)NETDEV_PTZ_E.NETDEV_PTZ_ZOOMWIDE, m_dwPtzSpeed);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("PTZ control zoom-wide failed.");
            }

            return;
        }

        private void WiperOn_Click(object sender, EventArgs e)
        {
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }
            int lChannelD = int.Parse(((ComboBoxItem)channel.SelectedItem)._value);
            int bRet = NETDEVSDK.NETDEV_PTZControl_Other(m_lpDevHandle, lChannelD, (int)NETDEV_PTZ_E.NETDEV_PTZ_BRUSHON, m_dwPtzSpeed);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("Open Wiper Failed.");
            }

            return;
        }

        private void WiperOff_Click(object sender, EventArgs e)
        {
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }
            int lChannelD = int.Parse(((ComboBoxItem)channel.SelectedItem)._value);
            int bRet = NETDEVSDK.NETDEV_PTZControl_Other(m_lpDevHandle, lChannelD, (int)NETDEV_PTZ_E.NETDEV_PTZ_BRUSHOFF, m_dwPtzSpeed);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("Close Wiper Failed.");
            }

            return;
        }

        private void LightOn_Click(object sender, EventArgs e)
        {
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }
            int lChannelD = int.Parse(((ComboBoxItem)channel.SelectedItem)._value);
            int bRet = NETDEVSDK.NETDEV_PTZControl_Other(m_lpDevHandle, lChannelD, (int)NETDEV_PTZ_E.NETDEV_PTZ_LIGHTON, m_dwPtzSpeed);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("Open Lamp Failed.");
            }

            return;
        }

        private void LightOff_Click(object sender, EventArgs e)
        {
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }
            int lChannelD = int.Parse(((ComboBoxItem)channel.SelectedItem)._value);
            int bRet = NETDEVSDK.NETDEV_PTZControl_Other(m_lpDevHandle, lChannelD, (int)NETDEV_PTZ_E.NETDEV_PTZ_LIGHTOFF, m_dwPtzSpeed);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("Close Lamp Failed.");
            }

            return;
        }

        private void HeaterOn_Click(object sender, EventArgs e)
        {
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }
            int lChannelD = int.Parse(((ComboBoxItem)channel.SelectedItem)._value);
            int bRet = NETDEVSDK.NETDEV_PTZControl_Other(m_lpDevHandle, lChannelD, (int)NETDEV_PTZ_E.NETDEV_PTZ_HEATON, m_dwPtzSpeed);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("Open Heater Failed.");
            }

            return;
        }

        private void HeaterOff_Click(object sender, EventArgs e)
        {
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }
            int lChannelD = int.Parse(((ComboBoxItem)channel.SelectedItem)._value);
            int bRet = NETDEVSDK.NETDEV_PTZControl_Other(m_lpDevHandle, lChannelD, (int)NETDEV_PTZ_E.NETDEV_PTZ_HEATOFF, m_dwPtzSpeed);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("Close Heater Failed.");
            }

            return;
        }

        private void SnowremovalOn_Click(object sender, EventArgs e)
        {
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }
            int lChannelD = int.Parse(((ComboBoxItem)channel.SelectedItem)._value);
            int bRet = NETDEVSDK.NETDEV_PTZControl_Other(m_lpDevHandle, lChannelD, (int)NETDEV_PTZ_E.NETDEV_PTZ_SNOWREMOINGON, m_dwPtzSpeed);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("Open Snowmoving Failed.");
            }

            return;
        }

        private void SnowremovalOff_Click(object sender, EventArgs e)
        {
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }
            int lChannelD = int.Parse(((ComboBoxItem)channel.SelectedItem)._value);
            int bRet = NETDEVSDK.NETDEV_PTZControl_Other(m_lpDevHandle, lChannelD, (int)NETDEV_PTZ_E.NETDEV_PTZ_SNOWREMOINGOFF, m_dwPtzSpeed);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("Close Snowmoving Failed.");
            }

            return;
        }

        private void Position_Click(object sender, EventArgs e)
        {
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }
            NETDEV_PTZ_OPERATEAREA_S stPtzAreaOperate = new NETDEV_PTZ_OPERATEAREA_S();

            /* 以播放窗口左上角为原点，参数值范围[0,10000] */
            /* Take the upper left corner of the window for playing as a start point, and the parameter value range from 0 to 10000. */
            stPtzAreaOperate.dwBeginPointX = 7500;
            stPtzAreaOperate.dwBeginPointY = 9000;
            stPtzAreaOperate.dwEndPointX = 7500;
            stPtzAreaOperate.dwEndPointY = 9000;
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }
            int lChannelD = int.Parse(((ComboBoxItem)channel.SelectedItem)._value);
            int bRet = NETDEVSDK.NETDEV_PTZSelZoomIn_Other(m_lpDevHandle, lChannelD, ref stPtzAreaOperate);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("Operate Area Failed");
            }

            return;
        }

        private void SelZoomOut_Click(object sender, EventArgs e)
        {
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }
            NETDEV_PTZ_OPERATEAREA_S stPtzAreaOperate = new NETDEV_PTZ_OPERATEAREA_S();

            /* 以播放窗口左上角为原点，参数值范围[0,10000] */
            /* Take the upper left corner of the window for playing as a start point, and the parameter value range from 0 to 10000. */
            stPtzAreaOperate.dwBeginPointX = 4000;
            stPtzAreaOperate.dwBeginPointY = 4000;
            stPtzAreaOperate.dwEndPointX = 2000;
            stPtzAreaOperate.dwEndPointY = 2000;
            int lChannelD = int.Parse(((ComboBoxItem)channel.SelectedItem)._value);
            int bRet = NETDEVSDK.NETDEV_PTZSelZoomIn_Other(m_lpDevHandle, lChannelD, ref stPtzAreaOperate);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("Operate Area Failed");
            }

            return;
        }

        private void SelZoomIn_Click(object sender, EventArgs e)
        {
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }
            NETDEV_PTZ_OPERATEAREA_S stPtzAreaOperate = new NETDEV_PTZ_OPERATEAREA_S();

            /* 以播放窗口左上角为原点，参数值范围[0,10000] */
            /* Take the upper left corner of the window for playing as a start point, and the parameter value range from 0 to 10000. */
            stPtzAreaOperate.dwBeginPointX = 2000;
            stPtzAreaOperate.dwBeginPointY = 2000;
            stPtzAreaOperate.dwEndPointX = 4000;
            stPtzAreaOperate.dwEndPointY = 4000;
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }
            int lChannelD = int.Parse(((ComboBoxItem)channel.SelectedItem)._value);
            int bRet = NETDEVSDK.NETDEV_PTZSelZoomIn_Other(m_lpDevHandle, lChannelD, ref stPtzAreaOperate);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("Operate Area Failed");
            }

            return;
        }

        private void SetPreset_Click(object sender, EventArgs e)
        {
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }
            Int32 l_PresetID = Convert.ToInt32(PresetID.Text);
            if (0 > l_PresetID || l_PresetID >= NETDEVSDK.NETDEV_MAX_PRESET_NUM)
            {
                MessageBox.Show("Preset ID invalid.");
            }
            String szPresetName = PresetID.Text + "\0";
            //(VOID)_snprintf(szPresetName, (NETDEV_LEN_32 - 1), "%u", m_lPresetID);
            int lChannelD = int.Parse(((ComboBoxItem)channel.SelectedItem)._value);
            int bRet = NETDEVSDK.NETDEV_PTZPreset_Other(m_lpDevHandle, lChannelD, (int)NETDEV_PTZ_PRESETCMD_E.NETDEV_PTZ_SET_PRESET, szPresetName, l_PresetID);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("Set preset failed.");
            }
            else
            {
                GetPreset_Click(sender, e);
            }
        }

        private void GetPreset_Click(object sender, EventArgs e)
        {
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }
            NETDEV_PTZ_ALLPRESETS_S stPtzPresets = new NETDEV_PTZ_ALLPRESETS_S();
            stPtzPresets.astPreset = new NETDEV_PTZ_PRESET_S[32];

            Int32 dwBytesReturned = 0;
            int lChannelD = int.Parse(((ComboBoxItem)channel.SelectedItem)._value);
            int bRet = NETDEVSDK.NETDEV_GetDevConfig(m_lpDevHandle, lChannelD, (int)NETDEV_CONFIG_COMMAND_E.NETDEV_GET_PTZPRESETS, ref stPtzPresets, Marshal.SizeOf(stPtzPresets), ref dwBytesReturned);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("Get presets failed.");
            }
            else
            {
                String strTemp;
                String strOut = ""; ;

                for (Int32 i = 0; i < stPtzPresets.dwSize; i++)
                {
                    strTemp = "NO." + i + "   ID：" + stPtzPresets.astPreset[i].dwPresetID.ToString() + "\n";
                    strOut += strTemp;
                }

                MessageBox.Show(strOut);
            }

            return;
        }

        private void GotoPreset_Click(object sender, EventArgs e)
        {
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }
            Int32 l_PresetID = Convert.ToInt32(PresetID.Text);
            if (0 > l_PresetID && l_PresetID >= NETDEVSDK.NETDEV_MAX_PRESET_NUM)
            {
                MessageBox.Show("Preset ID invalid.");
            }

            String strPresetName = "";

            int lChannelD = int.Parse(((ComboBoxItem)channel.SelectedItem)._value);
            int bRet = NETDEVSDK.NETDEV_PTZPreset_Other(m_lpDevHandle, lChannelD, (int)NETDEV_PTZ_PRESETCMD_E.NETDEV_PTZ_GOTO_PRESET, strPresetName, l_PresetID);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("Go to preset failed.");
            }

            return;
        }

        private void DeletePreset_Click(object sender, EventArgs e)
        {
            Int32 l_PresetID = Convert.ToInt32(PresetID.Text);
            if (0 > l_PresetID && l_PresetID >= NETDEVSDK.NETDEV_MAX_PRESET_NUM)
            {
                MessageBox.Show("Preset ID invalid.");
            }

            String strPresetName = "";
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }
            int lChannelD = int.Parse(((ComboBoxItem)channel.SelectedItem)._value);
            int bRet = NETDEVSDK.NETDEV_PTZPreset_Other(m_lpDevHandle, lChannelD, (int)NETDEV_PTZ_PRESETCMD_E.NETDEV_PTZ_CLE_PRESET, strPresetName, l_PresetID);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("Delete preset failed.");
            }
            else
            {
                GetPreset_Click( sender, e);
            }
        }

        private void GetPatrol_Click(object sender, EventArgs e)
        {
            NETDEV_CRUISE_LIST_S stCuriseList = new NETDEV_CRUISE_LIST_S();
            stCuriseList.astCruiseInfo = new NETDEV_CRUISE_INFO_S[16];
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }
            int lChannelD = int.Parse(((ComboBoxItem)channel.SelectedItem)._value);
            int bRet = NETDEVSDK.NETDEV_PTZGetCruise(m_lpDevHandle, lChannelD, ref stCuriseList);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("Get Cruise failed.");
            }
            else
            {
                String strTemp;
                String strOut = "";
                for (Int32 i = 0; i < stCuriseList.dwSize; i++)
                {
                    strTemp = "[Cruise]NO." + i + "   ID：" + stCuriseList.astCruiseInfo[i].dwCuriseID.ToString() + "\n";
                    strOut += strTemp;

                    for (Int32 k = 0; k < stCuriseList.astCruiseInfo[i].dwSize; k++)
                    {
                        strTemp = "\t [Preset] NO." + k + "   ID：" + stCuriseList.astCruiseInfo[i].astCruisePoint[k].dwPresetID.ToString() + "  StayTime： " + stCuriseList.astCruiseInfo[i].astCruisePoint[k].dwStayTime.ToString() + "\n";
                        strOut += strTemp;
                    }
                }

                MessageBox.Show(strOut);
            }

            return;
        }

        private void EditPatrol_Click(object sender, EventArgs e)
        {
            Int32 m_lCruiseID = Convert.ToInt32(PatrolID.Text);

            NETDEV_CRUISE_INFO_S stCruiseInfo = new NETDEV_CRUISE_INFO_S();
            stCruiseInfo.szCuriseName = new char[32];
            stCruiseInfo.astCruisePoint = new NETDEV_CRUISE_POINT_S[32];
            stCruiseInfo.dwCuriseID = m_lCruiseID;
            //(VOID)_snprintf(stCruiseInfo.szCuriseName, (NETDEV_LEN_32 - 1), "%u", stCruiseInfo.dwCuriseID);
            stCruiseInfo.dwSize = 3;

            stCruiseInfo.astCruisePoint[0].dwPresetID = 3;
            stCruiseInfo.astCruisePoint[0].dwStayTime = 14000;

            stCruiseInfo.astCruisePoint[1].dwPresetID = 4;
            stCruiseInfo.astCruisePoint[1].dwStayTime = 15000;

            stCruiseInfo.astCruisePoint[2].dwPresetID = 5;
            stCruiseInfo.astCruisePoint[2].dwStayTime = 16000;
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }
            int lChannelD = int.Parse(((ComboBoxItem)channel.SelectedItem)._value);
            int bRet = NETDEVSDK.NETDEV_PTZCruise_Other(m_lpDevHandle, lChannelD, (int)NETDEV_PTZ_CRUISECMD_E.NETDEV_PTZ_MODIFY_CRUISE, ref stCruiseInfo);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("Edit Cruise failed.");
            }
            else
            {
                GetPatrol_Click( sender, e);
            }

            return;
        }

        private void AddPatrol_Click(object sender, EventArgs e)
        {

            NETDEV_CRUISE_INFO_S stCruiseInfo = new NETDEV_CRUISE_INFO_S();
            stCruiseInfo.szCuriseName = new char[32];
            stCruiseInfo.astCruisePoint = new NETDEV_CRUISE_POINT_S[32];

            stCruiseInfo.dwSize = 2;
            stCruiseInfo.astCruisePoint[0].dwPresetID = 1;
            stCruiseInfo.astCruisePoint[0].dwStayTime = 11000;

            stCruiseInfo.astCruisePoint[1].dwPresetID = 2;
            stCruiseInfo.astCruisePoint[1].dwStayTime = 12000;
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }
            int lChannelD = int.Parse(((ComboBoxItem)channel.SelectedItem)._value);
            int bRet = NETDEVSDK.NETDEV_PTZCruise_Other(m_lpDevHandle, lChannelD, (int)NETDEV_PTZ_CRUISECMD_E.NETDEV_PTZ_ADD_CRUISE, ref stCruiseInfo);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("Add Cruise failed.");
            }
            else
            {
                GetPatrol_Click(sender, e);
            }

            return;
        }

        private void DeletePatrol_Click(object sender, EventArgs e)
        {
            Int32 m_lCruiseID = Convert.ToInt32(PatrolID.Text);
            NETDEV_CRUISE_INFO_S stCruiseInfo = new NETDEV_CRUISE_INFO_S();
            stCruiseInfo.dwCuriseID = m_lCruiseID;
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }
            int lChannelD = int.Parse(((ComboBoxItem)channel.SelectedItem)._value);
            int bRet = NETDEVSDK.NETDEV_PTZCruise_Other(m_lpDevHandle, lChannelD, (int)NETDEV_PTZ_CRUISECMD_E.NETDEV_PTZ_DEL_CRUISE, ref stCruiseInfo);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("failed.");
            }
            else
            {
                GetPatrol_Click(sender, e);
            }

            return;
        }

        private void StartPatrol_Click(object sender, EventArgs e)
        {
            Int32 m_lCruiseID = Convert.ToInt32(PatrolID.Text);
            NETDEV_CRUISE_INFO_S stCruiseInfo = new NETDEV_CRUISE_INFO_S();
            stCruiseInfo.dwCuriseID = m_lCruiseID;
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }
            int lChannelD = int.Parse(((ComboBoxItem)channel.SelectedItem)._value);
            int bRet = NETDEVSDK.NETDEV_PTZCruise_Other(m_lpDevHandle, lChannelD, (int)NETDEV_PTZ_CRUISECMD_E.NETDEV_PTZ_RUN_CRUISE, ref stCruiseInfo);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("Start Curise failed.");
            }

            return;
        }

        private void StopPatrol_Click(object sender, EventArgs e)
        {
            Int32 m_lCruiseID = Convert.ToInt32(PatrolID.Text);
            NETDEV_CRUISE_INFO_S stCruiseInfo = new NETDEV_CRUISE_INFO_S();
            stCruiseInfo.dwCuriseID = m_lCruiseID;
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }
            int lChannelD = int.Parse(((ComboBoxItem)channel.SelectedItem)._value);
            int bRet = NETDEVSDK.NETDEV_PTZCruise_Other(m_lpDevHandle, lChannelD, (int)NETDEV_PTZ_CRUISECMD_E.NETDEV_PTZ_STOP_CRUISE, ref stCruiseInfo);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("Stop Cruise failed.");
            }

            return;
        }

        private void RunRoute_Click(object sender, EventArgs e)
        {
            NETDEV_PTZ_TRACK_INFO_S stTrackCruiseInfo = new NETDEV_PTZ_TRACK_INFO_S();
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }
            int lChannelD = int.Parse(((ComboBoxItem)channel.SelectedItem)._value);
            int bRet = NETDEVSDK.NETDEV_PTZGetTrackCruise(m_lpDevHandle, lChannelD, ref stTrackCruiseInfo);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("Get Route failed.");
                return;
            }

            bRet = NETDEVSDK.NETDEV_PTZTrackCruise(m_lpDevHandle, lChannelD, (int)NETDEV_PTZ_E.NETDEV_PTZ_TRACKCRUISE, ref stTrackCruiseInfo.aszTrackName[0]);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("Start Route patrol failed.");
            }

            NETDEVSDK.m_bTracking = NETDEVSDK.TRUE;
            return;
        }

        private void StopRoute_Click(object sender, EventArgs e)
        {
            if (NETDEVSDK.TRUE != NETDEVSDK.m_bTracking)
            {
                MessageBox.Show("Start Route first");
                return;
            }

            NETDEV_PTZ_TRACK_INFO_S stTrackCruiseInfo = new NETDEV_PTZ_TRACK_INFO_S();
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }
            int lChannelD = int.Parse(((ComboBoxItem)channel.SelectedItem)._value);
            int bRet = NETDEVSDK.NETDEV_PTZGetTrackCruise(m_lpDevHandle, lChannelD, ref stTrackCruiseInfo);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("Get Route failed.");
                return;
            }

            bRet = NETDEVSDK.NETDEV_PTZTrackCruise(m_lpDevHandle, lChannelD, (int)NETDEV_PTZ_E.NETDEV_PTZ_TRACKCRUISESTOP, ref stTrackCruiseInfo.aszTrackName[0]);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("Stop Route patrol failed.");
                return;
            }
            else
            {
                MessageBox.Show("Stop Route patrol Succeed.");
            }

            NETDEVSDK.m_bTracking = NETDEVSDK.FALSE;
            return;
        }

        private void StopRecordRoute_Click(object sender, EventArgs e)
        {
            if (NETDEVSDK.TRUE != NETDEVSDK.m_bRouteRecording)
            {
                MessageBox.Show("Start Route patrol first");
                return;
            }

            NETDEV_PTZ_TRACK_INFO_S stTrackCruiseInfo = new NETDEV_PTZ_TRACK_INFO_S();

            int lChannelD = int.Parse(((ComboBoxItem)channel.SelectedItem)._value);
            int bRet = NETDEVSDK.NETDEV_PTZGetTrackCruise(m_lpDevHandle, lChannelD, ref stTrackCruiseInfo);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("Get Route failed.");
                return;
            }

            bRet = NETDEVSDK.NETDEV_PTZTrackCruise(m_lpDevHandle, lChannelD, (int)NETDEV_PTZ_E.NETDEV_PTZ_TRACKCRUISERECSTOP, ref stTrackCruiseInfo.aszTrackName[0]);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("Stop Recording Route failed.");
                return;
            }
            else
            {
                MessageBox.Show("Stop Recording Route Succeed.");
            }

            NETDEVSDK.m_bRouteRecording = NETDEVSDK.FALSE;
            return;

        }

        private void StartRecordRoute_Click(object sender, EventArgs e)
        {
            NETDEV_PTZ_TRACK_INFO_S stTrackCruiseInfo = new NETDEV_PTZ_TRACK_INFO_S();
            stTrackCruiseInfo.aszTrackName = new byte[64];
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }
            int lChannelD = int.Parse(((ComboBoxItem)channel.SelectedItem)._value);
            int bRet = NETDEVSDK.NETDEV_PTZGetTrackCruise(m_lpDevHandle, lChannelD, ref stTrackCruiseInfo);
            if (NETDEVSDK.TRUE != bRet)
            {

                /* 获取错误码 */
                /* Get error codes */
                Int32 iRet = NETDEVSDK.NETDEV_GetLastError();
                if (NETDEVSDK.NETDEV_E_NONSUPPORT == iRet)
                {
                    MessageBox.Show("Get Route failed.");
                    return;
                }
                else
                {
                    /* 如果设备支持轨迹巡航，没有路径时自动创建一条空路径 */
                    /* If route patrol is supported, an empty route will be created. */
                    bRet = NETDEVSDK.NETDEV_PTZTrackCruise(m_lpDevHandle, lChannelD, (int)NETDEV_PTZ_E.NETDEV_PTZ_TRACKCRUISEADD, ref stTrackCruiseInfo.aszTrackName[0]);
                    if (NETDEVSDK.TRUE != bRet)
                    {
                        MessageBox.Show("Creat Route failed.");
                        return;
                    }
                }
            }

            bRet = NETDEVSDK.NETDEV_PTZTrackCruise(m_lpDevHandle, lChannelD, (int)NETDEV_PTZ_E.NETDEV_PTZ_TRACKCRUISEREC, ref stTrackCruiseInfo.aszTrackName[0]);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("Start Recording Route failed.");
            }
            else
            {
                MessageBox.Show("Succeed,Please Recording Route.");
            }

            NETDEVSDK.m_bRouteRecording = NETDEVSDK.TRUE;
            return;
        }

        private void GetRoute_Click(object sender, EventArgs e)
        {
            NETDEV_PTZ_TRACK_INFO_S stTrackCruiseInfo = new NETDEV_PTZ_TRACK_INFO_S();
            stTrackCruiseInfo.aszTrackName = new byte[64];
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }
            int lChannelD = int.Parse(((ComboBoxItem)channel.SelectedItem)._value);
            int bRet = NETDEVSDK.NETDEV_PTZGetTrackCruise(m_lpDevHandle, lChannelD, ref stTrackCruiseInfo);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("Get Route failed.");
                return;
            }
            else
            {
                String strOut;
                strOut = "Track name: " + System.Text.Encoding.Default.GetString(stTrackCruiseInfo.aszTrackName);
                MessageBox.Show(strOut);
            }
            return;
        }

        private void PlaybackCtrlBack_Click(object sender, EventArgs e)
        {
            Int32 enSpeed = 0;
            int bRet = NETDEVSDK.NETDEV_PlayBackControl(m_lpRealHanel, (int)NETDEV_VOD_PLAY_CTRL_E.NETDEV_PLAY_CTRL_GETPLAYSPEED, ref enSpeed);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("Get play speed failed.");
            }

            enSpeed = enSpeed - 1 >= (Int32)NETDEV_VOD_PLAY_STATUS_E.NETDEV_PLAY_STATUS_16_BACKWARD ? (enSpeed - 1) : enSpeed;

            while ((enSpeed <= (Int32)NETDEV_VOD_PLAY_STATUS_E.NETDEV_PLAY_STATUS_HALF_FORWARD) && (enSpeed >= (Int32)NETDEV_VOD_PLAY_STATUS_E.NETDEV_PLAY_STATUS_HALF_BACKWARD))
            {
                enSpeed--;
            }

            bRet = NETDEVSDK.NETDEV_PlayBackControl(m_lpRealHanel, (int)NETDEV_VOD_PLAY_CTRL_E.NETDEV_PLAY_CTRL_SETPLAYSPEED, ref enSpeed);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("Set play speed failed.");
            }

            return;
        }

        private void PlaybackStrlForward_Click(object sender, EventArgs e)
        {
            Int32 enSpeed = 0;
            int bRet = NETDEVSDK.NETDEV_PlayBackControl(m_lpRealHanel, (int)NETDEV_VOD_PLAY_CTRL_E.NETDEV_PLAY_CTRL_GETPLAYSPEED, ref enSpeed);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("Get play speed failed.");
            }

            enSpeed = enSpeed + 1 <= (Int32)NETDEV_VOD_PLAY_STATUS_E.NETDEV_PLAY_STATUS_16_FORWARD ? (enSpeed + 1) : enSpeed;

            while ((enSpeed <= (Int32)NETDEV_VOD_PLAY_STATUS_E.NETDEV_PLAY_STATUS_HALF_FORWARD) && (enSpeed >= (Int32)NETDEV_VOD_PLAY_STATUS_E.NETDEV_PLAY_STATUS_HALF_BACKWARD))
            {
                enSpeed++;
            }

            bRet = NETDEVSDK.NETDEV_PlayBackControl(m_lpRealHanel, (int)NETDEV_VOD_PLAY_CTRL_E.NETDEV_PLAY_CTRL_SETPLAYSPEED, ref enSpeed);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("Set play speed failed.");
            }

            return;
        }

        private void GetStreamInfo_Click(object sender, EventArgs e)
        {
            Int32 dwBytesReturned = 0;
            NETDEV_VIDEO_STREAM_INFO_S stStreamInfo = new NETDEV_VIDEO_STREAM_INFO_S();

            stStreamInfo.enStreamType = (int)NETDEV_LIVE_STREAM_INDEX_E.NETDEV_LIVE_STREAM_INDEX_MAIN;
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }
            int lChannelD = int.Parse(((ComboBoxItem)channel.SelectedItem)._value);
            int bRet = NETDEVSDK.NETDEV_GetDevConfig(m_lpDevHandle, lChannelD, (int)NETDEV_CONFIG_COMMAND_E.NETDEV_GET_STREAMCFG, ref stStreamInfo, Marshal.SizeOf(stStreamInfo), ref dwBytesReturned);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("Get Video Stream Info failed.");
            }
            else
            {
                String strTemp;
                String strOut = "";
                strTemp = "Stream Type      \t " + (stStreamInfo.enStreamType).ToString() + "\n";
                strOut += strTemp;
                strTemp = "Enable           \t " + stStreamInfo.bEnableFlag.ToString() + "\n";
                strOut += strTemp;
                strTemp = "Bit rate         \t " + stStreamInfo.dwBitRate.ToString() + "\n";
                strOut += strTemp;
                strTemp = "Frame rate       \t " + stStreamInfo.dwFrameRate.ToString() + "\n";
                strOut += strTemp;
                strTemp = "Resolution       \t " + stStreamInfo.dwWidth.ToString() + "*" + stStreamInfo.dwHeight.ToString() + "\n";
                strOut += strTemp;
                strTemp = "Format           \t " + stStreamInfo.enCodeType.ToString() + "\n";
                strOut += strTemp;
                strTemp = "I Frame Interval \t " + stStreamInfo.dwGop.ToString() + "\n";
                strOut += strTemp;

                MessageBox.Show(strOut);
            }

            return;
        }

        private void SetStreamInfo_Click(object sender, EventArgs e)
        {
            Int32 dwBytesReturned = 0;
            NETDEV_VIDEO_STREAM_INFO_S stStreamInfo = new NETDEV_VIDEO_STREAM_INFO_S();

            /* 获取码流参数信息 */
            /* Get bit stream parameters */
            stStreamInfo.enStreamType = (int)NETDEV_LIVE_STREAM_INDEX_E.NETDEV_LIVE_STREAM_INDEX_MAIN;
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }
            int lChannelD = int.Parse(((ComboBoxItem)channel.SelectedItem)._value);
            int bRet = NETDEVSDK.NETDEV_GetDevConfig(m_lpDevHandle, lChannelD, (int)NETDEV_CONFIG_COMMAND_E.NETDEV_GET_STREAMCFG, ref stStreamInfo, Marshal.SizeOf(stStreamInfo), ref dwBytesReturned);
            if (NETDEVSDK.TRUE != bRet)
            {
                return;
            }

            /* 修改码流参数信息 */
            /* Modify bit stream parameters */
            stStreamInfo.bEnableFlag = NETDEVSDK.TRUE;
            stStreamInfo.dwFrameRate = 20;
            stStreamInfo.dwBitRate = 4095;
            stStreamInfo.dwGop = 24;
            stStreamInfo.enCodeType = (int)NETDEV_VIDEO_CODE_TYPE_E.NETDEV_VIDEO_CODE_H264;

            bRet = NETDEVSDK.NETDEV_SetDevConfig(m_lpDevHandle, lChannelD, (int)NETDEV_CONFIG_COMMAND_E.NETDEV_SET_STREAMCFG, ref stStreamInfo, Marshal.SizeOf(stStreamInfo));
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("Set Video Stream Info failed.");
            }
            else
            {
                MessageBox.Show("Set Video Stream Info succeed.");
            }

            return;
        }

        private void GetImageInfo_Click(object sender, EventArgs e)
        {
            int dwBytesReturned = 0;
            NETDEV_IMAGE_SETTING_S stImageInfo = new NETDEV_IMAGE_SETTING_S();
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }
            int lChannelD = int.Parse(((ComboBoxItem)channel.SelectedItem)._value);
            int bRet = NETDEVSDK.NETDEV_GetDevConfig(m_lpDevHandle, lChannelD, (int)NETDEV_CONFIG_COMMAND_E.NETDEV_GET_IMAGECFG, ref stImageInfo, Marshal.SizeOf(stImageInfo), ref dwBytesReturned);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("get imaging settings failed.");
            }
            else
            {
                String strTemp;
                String strOut = "";
                strTemp = "Brightness      \t " + stImageInfo.dwBrightness.ToString() + "\n";
                strOut += strTemp;
                strTemp = "ColorSaturation \t " + stImageInfo.dwSaturation.ToString() + "\n";
                strOut += strTemp;
                strTemp = "Contrast        \t " + stImageInfo.dwContrast.ToString() + "\n";
                strOut += strTemp;
                strTemp = "Sharpness        \t " + stImageInfo.dwSharpness.ToString() + "\n";
                strOut += strTemp;

                MessageBox.Show(strOut);
            }

            return;
        }

        private void SetImageInfo_Click(object sender, EventArgs e)
        {
            NETDEV_IMAGE_SETTING_S stImageInfo = new NETDEV_IMAGE_SETTING_S();

            /* 修改图像参数信息，参数值范围为0~255 */
            /* Adjust the image settings. The parameter value range from 0 to 255. */
            stImageInfo.dwContrast = 100;
            stImageInfo.dwBrightness = 110;
            stImageInfo.dwSaturation = 120;
            stImageInfo.dwSharpness = 130;
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }
            int lChannelD = int.Parse(((ComboBoxItem)channel.SelectedItem)._value);
            int bRet = NETDEVSDK.NETDEV_SetDevConfig(m_lpDevHandle, lChannelD, (int)NETDEV_CONFIG_COMMAND_E.NETDEV_SET_IMAGECFG, ref stImageInfo, Marshal.SizeOf(stImageInfo));
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("Set imaging settings failed.");
            }
            else
            {
                MessageBox.Show("Set imaging settings succeed.");
            }

            return;
        }

        private void GetNtpCfg_Click(object sender, EventArgs e)
        {
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }
            NETDEV_SYSTEM_NTP_INFO_S stNTPInfo = new NETDEV_SYSTEM_NTP_INFO_S();
            stNTPInfo.stAddr = new NETDEV_SYSTEM_IPADDR_S();
            stNTPInfo.stAddr.szIPAddr = new char[132];
            Int32 dwBytesReturned = 0;
            int lChannelD = int.Parse(((ComboBoxItem)channel.SelectedItem)._value);
            int bRet = NETDEVSDK.NETDEV_GetDevConfig(m_lpDevHandle, lChannelD, (int)NETDEV_CONFIG_COMMAND_E.NETDEV_GET_NTPCFG, ref stNTPInfo, Marshal.SizeOf(stNTPInfo), ref dwBytesReturned);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("Get NTP Info failed.");
            }
            else
            {
                String strTemp;
                String strOut = "";
                strTemp = "Support DHCP:\t " + stNTPInfo.bSupportDHCP.ToString() + "\n";
                strOut += strTemp;
                strTemp = "IP Type:\t " + stNTPInfo.stAddr.eIPType.ToString() + "\n";
                strOut += strTemp;
                String IPAddr = new String(stNTPInfo.stAddr.szIPAddr);
                strTemp = "NTP Server address:\t " + IPAddr + "\n";
                strOut += strTemp;

                MessageBox.Show(strOut);
            }

            return;
        }

        private void SetNtpCfg_Click(object sender, EventArgs e)
        {
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }
            NETDEV_SYSTEM_NTP_INFO_S stNTPInfo = new NETDEV_SYSTEM_NTP_INFO_S();
            stNTPInfo.stAddr = new NETDEV_SYSTEM_IPADDR_S();
            stNTPInfo.stAddr.szIPAddr = new char[132];

            Int32 dwBytesReturned = 0;
            int lChannelD = int.Parse(((ComboBoxItem)channel.SelectedItem)._value);
            int bRet = NETDEVSDK.NETDEV_GetDevConfig(m_lpDevHandle, lChannelD, (int)NETDEV_CONFIG_COMMAND_E.NETDEV_GET_NTPCFG, ref stNTPInfo, Marshal.SizeOf(stNTPInfo), ref dwBytesReturned);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("Get OSD Info failed.");
                return;
            }

            stNTPInfo.bSupportDHCP = false;
            stNTPInfo.stAddr.eIPType = (int)NETDEV_HOSTTYPE_E.NETDEV_NETWORK_HOSTTYPE_IPV4;
            stNTPInfo.stAddr.szIPAddr [0]= '1';
            stNTPInfo.stAddr.szIPAddr[1] = '9';
            stNTPInfo.stAddr.szIPAddr[2] = '2';
            stNTPInfo.stAddr.szIPAddr[3] = '.';
            stNTPInfo.stAddr.szIPAddr[4] = '1';
            stNTPInfo.stAddr.szIPAddr[5] = '6';
            stNTPInfo.stAddr.szIPAddr[6] = '8';
            stNTPInfo.stAddr.szIPAddr[7] = '.';
            stNTPInfo.stAddr.szIPAddr[8] = '0';
            stNTPInfo.stAddr.szIPAddr[9] = '.';
            stNTPInfo.stAddr.szIPAddr[10] = '1';
            stNTPInfo.stAddr.szIPAddr[11] = '4';


            bRet = NETDEVSDK.NETDEV_SetDevConfig(m_lpDevHandle, lChannelD, (int)NETDEV_CONFIG_COMMAND_E.NETDEV_SET_NTPCFG, ref stNTPInfo, Marshal.SizeOf(stNTPInfo));
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("Set NTP Info failed.");
            }

            return;
        }

        private void GetNetworkCfg_Click(object sender, EventArgs e)
        {
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }
            NETDEV_NETWORKCFG_S stNetworkcfg = new NETDEV_NETWORKCFG_S();
            stNetworkcfg.szIpv4Address = new char[32];
            stNetworkcfg.szIPv4GateWay = new char[32];
            stNetworkcfg.byRes = new byte[512];

            Int32 dwBytesReturned = 0;
            int lChannelD = int.Parse(((ComboBoxItem)channel.SelectedItem)._value);
            int bRet = NETDEVSDK.NETDEV_GetDevConfig(m_lpDevHandle, lChannelD, (int)NETDEV_CONFIG_COMMAND_E.NETDEV_GET_NETWORKCFG, ref stNetworkcfg, Marshal.SizeOf(stNetworkcfg), ref dwBytesReturned);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("Get Network Interfaces failed.");
            }
            else
            {
                String Ipv4Address = new String(stNetworkcfg.szIpv4Address);
                int i;
                for (i = 0; i < 32;i++)
                {
                    if ('\0' == stNetworkcfg.szIpv4Address[i])
                    {
                        break;
                    }
                }
                Ipv4Address = Ipv4Address.Remove(i, 32 - i);
                IPv4Addr.Text = Ipv4Address;

                String IPv4GateWay = new String(stNetworkcfg.szIPv4GateWay);
                for (i = 0; i < 32; i++)
                {
                    if ('\0' == stNetworkcfg.szIPv4GateWay[i])
                    {
                        break;
                    }
                }
                IPv4GateWay = IPv4GateWay.Remove(i, 32 - i);
                IPv4Gateway.Text = IPv4GateWay;

                String strTemp;
                String strOut = "";
                strTemp = "IPv4DHCP    \t " + stNetworkcfg.dwIPv4DHCP.ToString() + "\n";
                strOut += strTemp;
                strTemp = "Ipv4Address \t " + Ipv4Address + "\n";
                strOut += strTemp;
                strTemp = "IPv4GateWay \t " + IPv4GateWay + "\n";
                strOut += strTemp;
                strTemp = "MTU         \t " + stNetworkcfg.dwMTU.ToString() + "\n";
                strOut += strTemp;

                MessageBox.Show(strOut);
            }

            return;
        }

        private void SetNetworkCfg_Click(object sender, EventArgs e)
        {
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }
            NETDEV_NETWORKCFG_S stNetworkSetcfg = new NETDEV_NETWORKCFG_S();
            stNetworkSetcfg.szIpv4Address =new char[32];
            stNetworkSetcfg.szIPv4GateWay = new char[32];
            stNetworkSetcfg.byRes = new byte[512];

            Int32 dwBytesReturned = 0;
            int lChannelD = int.Parse(((ComboBoxItem)channel.SelectedItem)._value);
            int bRet = NETDEVSDK.NETDEV_GetDevConfig(m_lpDevHandle, lChannelD, (int)NETDEV_CONFIG_COMMAND_E.NETDEV_GET_NETWORKCFG, ref stNetworkSetcfg, Marshal.SizeOf(stNetworkSetcfg), ref dwBytesReturned);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("Get Network Interfaces failed.");
                return;
            }

            if ("" != IPv4Addr.Text)
            {
                IPv4Addr.Text = (stNetworkSetcfg.szIpv4Address).ToString();
            }
            if ("" != IPv4Gateway.Text)
            {
                IPv4Gateway.Text = stNetworkSetcfg.szIPv4GateWay.ToString();
            }

            /* 修改IP或者网关都要与彼此相互对应 */
            /* IP or gateway must be modified in compliance with each other */
            bRet = NETDEVSDK.NETDEV_SetDevConfig(m_lpDevHandle, lChannelD, (int)NETDEV_CONFIG_COMMAND_E.NETDEV_SET_NETWORKCFG, ref stNetworkSetcfg, Marshal.SizeOf(stNetworkSetcfg));
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("Set Network Interfaces failed.");
            }
            else
            {
                MessageBox.Show("Set Network Interfaces succeed.");
            }

            return;
        }

        private void GetAlarmInput_Click(object sender, EventArgs e)
        {
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }
            NETDEV_ALARM_INPUT_LIST_S stAlarmInputList = new NETDEV_ALARM_INPUT_LIST_S();
            stAlarmInputList.astAlarmInputInfo = new NETDEV_ALARM_INPUT_INFO_S[64];
            for (int i = 0; i < 64;i++ )
            {
                stAlarmInputList.astAlarmInputInfo[i].szName = new char[64];
            }

            Int32 dwBytesReturned = 0;
            int lChannelD = int.Parse(((ComboBoxItem)channel.SelectedItem)._value);
            int bRet = NETDEVSDK.NETDEV_GetDevConfig(m_lpDevHandle, lChannelD, (int)NETDEV_CONFIG_COMMAND_E.NETDEV_GET_ALARM_INPUTCFG, ref stAlarmInputList, Marshal.SizeOf(stAlarmInputList), ref dwBytesReturned);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("Get alarm input info failed.");
                return;
            }
            else
            {
                String strTemp;
                String strOut = "";
                for (Int32 i = 0; i < stAlarmInputList.dwSize; i++)
                {
                    int count;
                    String AlarmInputInfoName = new String(stAlarmInputList.astAlarmInputInfo[i].szName);
                    for (count = 0; count < 64; count++)
                    {
                        if ('\0' == stAlarmInputList.astAlarmInputInfo[i].szName[count])
                        {
                            break;
                        }
                    }
                    AlarmInputInfoName = AlarmInputInfoName.Remove(count, 64 - count);
                    strTemp = "name:\t " + AlarmInputInfoName + "\n";
                    strOut += strTemp;
                }
                MessageBox.Show(strOut);
            }

            return;
        }

        private void GetAlarmOutput_Click(object sender, EventArgs e)
        {
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }
            NETDEV_ALARM_OUTPUT_LIST_S stAlarmOutputList = new NETDEV_ALARM_OUTPUT_LIST_S();
            stAlarmOutputList.astAlarmOutputInfo = new NETDEV_ALARM_OUTPUT_INFO_S[64];
            for (Int32 i = 0; i < 64; i++ )
            {
                stAlarmOutputList.astAlarmOutputInfo[i].szName = new char[64];
            }

            Int32 dwBytesReturned = 0;
            int lChannelD = int.Parse(((ComboBoxItem)channel.SelectedItem)._value);
            int bRet = NETDEVSDK.NETDEV_GetDevConfig(m_lpDevHandle, lChannelD, (int)NETDEV_CONFIG_COMMAND_E.NETDEV_GET_ALARM_OUTPUTCFG, ref stAlarmOutputList, Marshal.SizeOf(stAlarmOutputList), ref dwBytesReturned);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("Get alarm output info failed.");
                return;
            }
            else
            {
                String strTemp;
                String strOut = "";
                for (Int32 i = 0; i < stAlarmOutputList.dwSize; i++)
                {
                    int count;
                    String AlarmOutputInfoName = new String(stAlarmOutputList.astAlarmOutputInfo[i].szName);
                    for (count = 0; count < 64; count++)
                    {
                        if ('\0' == stAlarmOutputList.astAlarmOutputInfo[i].szName[count])
                        {
                            break;
                        }
                    }
                    AlarmOutputInfoName = AlarmOutputInfoName.Remove(count, 64 - count);
                    strTemp = "Name:\t " + AlarmOutputInfoName + "\n";
                    strOut += strTemp;
                    strTemp = "Channel id:\t " + stAlarmOutputList.astAlarmOutputInfo[i].dwChancelId.ToString() + "\n";
                    strOut += strTemp;
                    strTemp = "Status:\t " + stAlarmOutputList.astAlarmOutputInfo[i].enDefaultStatus.ToString() + "\n";
                    strOut += strTemp;
                    strTemp = "Duration:\t " + stAlarmOutputList.astAlarmOutputInfo[i].dwDurationSec.ToString() + "\n";
                    strOut += strTemp;
                }
                MessageBox.Show(strOut);
            }

            return;
        }

        private void SetAlarmOutput_Click(object sender, EventArgs e)
        {
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }
            NETDEV_ALARM_OUTPUT_LIST_S stAlarmOutputList = new NETDEV_ALARM_OUTPUT_LIST_S();
            stAlarmOutputList.astAlarmOutputInfo = new NETDEV_ALARM_OUTPUT_INFO_S[64];

            Int32 dwBytesReturned = 0;
            int lChannelD = int.Parse(((ComboBoxItem)channel.SelectedItem)._value);
            int bRet = NETDEVSDK.NETDEV_GetDevConfig(m_lpDevHandle, lChannelD, (int)NETDEV_CONFIG_COMMAND_E.NETDEV_GET_ALARM_OUTPUTCFG, ref stAlarmOutputList, Marshal.SizeOf(stAlarmOutputList), ref dwBytesReturned);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("Get alarm output info failed.");
                return;
            }

            NETDEV_ALARM_OUTPUT_INFO_S stAlarmOutputInfo = new NETDEV_ALARM_OUTPUT_INFO_S();

            stAlarmOutputInfo = stAlarmOutputList.astAlarmOutputInfo[0];
            stAlarmOutputInfo.dwDurationSec = 15;

            bRet = NETDEVSDK.NETDEV_SetDevConfig(m_lpDevHandle, lChannelD, (int)NETDEV_CONFIG_COMMAND_E.NETDEV_SET_ALARM_OUTPUTCFG, ref stAlarmOutputInfo, Marshal.SizeOf(stAlarmOutputInfo));
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("Set alarm output info failed.");
            }
            else
            {
                MessageBox.Show("Set alarm output info succeed.");
            }

            return;
        }

        private void TriggerAlarmOutput_Click(object sender, EventArgs e)
        {
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }
            NETDEV_ALARM_OUTPUT_LIST_S stAlarmOutputList = new NETDEV_ALARM_OUTPUT_LIST_S();
            stAlarmOutputList.astAlarmOutputInfo = new NETDEV_ALARM_OUTPUT_INFO_S[64];

            Int32 dwBytesReturned = 0;
            int lChannelD = int.Parse(((ComboBoxItem)channel.SelectedItem)._value);
            int bRet = NETDEVSDK.NETDEV_GetDevConfig(m_lpDevHandle, lChannelD, (int)NETDEV_CONFIG_COMMAND_E.NETDEV_GET_ALARM_OUTPUTCFG, ref stAlarmOutputList, Marshal.SizeOf(stAlarmOutputList), ref dwBytesReturned);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("Get alarm output info failed.");
                return;
            }

            NETDEV_TRIGGER_ALARM_OUTPUT_S stTriggerAlarmOutput = new NETDEV_TRIGGER_ALARM_OUTPUT_S ();
            stTriggerAlarmOutput.szName = stAlarmOutputList.astAlarmOutputInfo[0].szName;
            //strncpy(stTriggerAlarmOutput.szName, stAlarmOutputList.astAlarmOutputInfo[0].szName, NETDEV_LEN_64 - 1);

            stTriggerAlarmOutput.enOutputState = (int)NETDEV_RELAYOUTPUT_STATE_E.NETDEV_BOOLEAN_STATUS_ACTIVE;

            bRet = NETDEVSDK.NETDEV_SetDevConfig(m_lpDevHandle, lChannelD, (int)NETDEV_CONFIG_COMMAND_E.NETDEV_TRIGGER_ALARM_OUTPUT, ref stTriggerAlarmOutput, Marshal.SizeOf(stTriggerAlarmOutput));
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("Trigger alarm output failed.");
            }
            else
            {
                MessageBox.Show("Trigger alarm output succeed.");
            }

            return;
        }

        private void GETOSD_Click(object sender, EventArgs e)
        {
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }
            NETDEV_VIDEO_OSD_CFG_S stChannelOSDInfo = new NETDEV_VIDEO_OSD_CFG_S();
            stChannelOSDInfo.stTimeOSD = new NETDEV_OSD_TIME_S();
            stChannelOSDInfo.stNameOSD = new NETDEV_OSD_TEXT_OVERLAY_S();
            stChannelOSDInfo.stNameOSD.szOSDText = new char[64];
            stChannelOSDInfo.stNameOSD.byRes = new byte[4];
            stChannelOSDInfo.astTextOverlay = new NETDEV_OSD_TEXT_OVERLAY_S[6];
            for (Int32 i = 0; i < 6;i++)
            {
                stChannelOSDInfo.astTextOverlay[i].szOSDText = new char[64];
                stChannelOSDInfo.astTextOverlay[i].byRes = new byte[4];
            }

            Int32 dwBytesReturned = 0;
            int lChannelD = int.Parse(((ComboBoxItem)channel.SelectedItem)._value);
            int bRet = NETDEVSDK.NETDEV_GetDevConfig(m_lpDevHandle, lChannelD, (int)NETDEV_CONFIG_COMMAND_E.NETDEV_GET_OSDCFG, ref stChannelOSDInfo, Marshal.SizeOf(stChannelOSDInfo), ref dwBytesReturned);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("Get OSD Info failed.");
                return;
            }
            else
            {
                int i;
                String NameOSD = new String(stChannelOSDInfo.stNameOSD.szOSDText);
                for (i = 0; i < 64; i++)
                {
                    if ('\0' == stChannelOSDInfo.stNameOSD.szOSDText[i])
                    {
                        break;
                    }
                }
                NameOSD = NameOSD.Remove(i, 64 - i);

                String TextOverlay = new String(stChannelOSDInfo.astTextOverlay[0].szOSDText);
                for (i = 0; i < 64; i++)
                {
                    if ('\0' == stChannelOSDInfo.astTextOverlay[0].szOSDText[i])
                    {
                        break;
                    }
                }
                TextOverlay = TextOverlay.Remove(i, 64 - i);

                String strOut = "";
                String strTemp;
                strTemp = "Channel name OSD:\t " + NameOSD + "\n";
                strOut += strTemp;
                strTemp = "OSD text:\t " + TextOverlay + "\n";
                strOut += strTemp;
                MessageBox.Show(strOut);
            }

            return;
        }

        private void SETOSD_Click(object sender, EventArgs e)
        {
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }
            NETDEV_VIDEO_OSD_CFG_S stChannelOSDInfo = new NETDEV_VIDEO_OSD_CFG_S();
            stChannelOSDInfo.stTimeOSD = new NETDEV_OSD_TIME_S();
            stChannelOSDInfo.stNameOSD = new NETDEV_OSD_TEXT_OVERLAY_S();
            stChannelOSDInfo.astTextOverlay = new NETDEV_OSD_TEXT_OVERLAY_S[6];
            stChannelOSDInfo.stNameOSD.szOSDText = new char[64];
            stChannelOSDInfo.stNameOSD.byRes = new byte[4];
            stChannelOSDInfo.astTextOverlay = new NETDEV_OSD_TEXT_OVERLAY_S[6];
            for (Int32 i = 0; i < 6; i++)
            {
                stChannelOSDInfo.astTextOverlay[i].szOSDText = new char[64];
                stChannelOSDInfo.astTextOverlay[i].byRes = new byte[4];
            }

            Int32 dwBytesReturned = 0;
            int lChannelD = int.Parse(((ComboBoxItem)channel.SelectedItem)._value);
            int bRet = NETDEVSDK.NETDEV_GetDevConfig(m_lpDevHandle, lChannelD, (int)NETDEV_CONFIG_COMMAND_E.NETDEV_GET_OSDCFG, ref stChannelOSDInfo, Marshal.SizeOf(stChannelOSDInfo), ref dwBytesReturned);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("Get OSD Info failed.");
                return;
            }

            /* 时间 */
            /* time */
            stChannelOSDInfo.stTimeOSD.bEnableFlag = true;
            stChannelOSDInfo.stTimeOSD.stAreaScope.dwLocateX = 3000;
            stChannelOSDInfo.stTimeOSD.stAreaScope.dwLocateY = 6000;
            stChannelOSDInfo.stTimeOSD.udwTimeFormat = (int)NETDEV_OSD_TIME_FORMAT_CAP_E.NETDEV_OSD_TIME_FORMAT_CAP_HHMMSS;

            /* 名称 */
            /* name */
            stChannelOSDInfo.stNameOSD.bEnableFlag = true;
            stChannelOSDInfo.stNameOSD.stAreaScope.dwLocateX = 8000;
            stChannelOSDInfo.stNameOSD.stAreaScope.dwLocateY = 7000;
            stChannelOSDInfo.stNameOSD.szOSDText[0] = 'C';
            stChannelOSDInfo.stNameOSD.szOSDText[1] = 'a';
            stChannelOSDInfo.stNameOSD.szOSDText[2] = 'm';
            stChannelOSDInfo.stNameOSD.szOSDText[3] = 'e';
            stChannelOSDInfo.stNameOSD.szOSDText[4] = 'r';
            stChannelOSDInfo.stNameOSD.szOSDText[5] = 'a';
            for (Int32 i = 6; i < 64; i++)
            {
                stChannelOSDInfo.stNameOSD.szOSDText[i] = '\0';
            }


            /* 文本 */
            /* text */
            stChannelOSDInfo.astTextOverlay[0].bEnableFlag = true;
            stChannelOSDInfo.astTextOverlay[0].stAreaScope.dwLocateX = 0;
            stChannelOSDInfo.astTextOverlay[0].stAreaScope.dwLocateY = 0;
            stChannelOSDInfo.wTextNum = 1;
            stChannelOSDInfo.astTextOverlay[0].szOSDText[0] = 'W';
            stChannelOSDInfo.astTextOverlay[0].szOSDText[1] = 'e';
            stChannelOSDInfo.astTextOverlay[0].szOSDText[2] = 'l';
            stChannelOSDInfo.astTextOverlay[0].szOSDText[3] = 'c';
            stChannelOSDInfo.astTextOverlay[0].szOSDText[4] = 'o';
            stChannelOSDInfo.astTextOverlay[0].szOSDText[5] = 'm';
            stChannelOSDInfo.astTextOverlay[0].szOSDText[6] = 'e';
            for (Int32 i = 7; i < 64; i++)
            {
                stChannelOSDInfo.astTextOverlay[0].szOSDText[i] = '\0';
            }


            bRet = NETDEVSDK.NETDEV_SetDevConfig(m_lpDevHandle, lChannelD, (int)NETDEV_CONFIG_COMMAND_E.NETDEV_SET_OSDCFG, ref stChannelOSDInfo, Marshal.SizeOf(stChannelOSDInfo));
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("Set OSD info failed.");
            }
            else
            {
                MessageBox.Show("Set OSD info Succeed.");
            }

            return;
        }

        private void GetDeviceInfo_Click(object sender, EventArgs e)
        {
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }
            NETDEV_DEVICE_BASICINFO_S stDeviceInfo = new NETDEV_DEVICE_BASICINFO_S();
            stDeviceInfo.szDevModel = new char[64];
            stDeviceInfo.szFirmwareVersion = new char[64];
            stDeviceInfo.szMacAddress = new char[64];
            stDeviceInfo.szSerialNum = new char[64];
            stDeviceInfo.byRes = new byte[512];

            Int32 dwBytesReturned = 0;
            int lChannelD = int.Parse(((ComboBoxItem)channel.SelectedItem)._value);
            int bRet = NETDEVSDK.NETDEV_GetDevConfig(m_lpDevHandle, lChannelD, (int)NETDEV_CONFIG_COMMAND_E.NETDEV_GET_DEVICECFG, ref stDeviceInfo, Marshal.SizeOf(stDeviceInfo), ref dwBytesReturned);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("Get Device Info failed.");
            }
            else
            {
                int i;
                String DevModel = new String(stDeviceInfo.szDevModel);
                for (i = 0; i < 64; i++)
                {
                    if ('\0' == stDeviceInfo.szDevModel[i])
                    {
                        break;
                    }
                }
                DevModel = DevModel.Remove(i, 64 - i);

                String SerialNum = new String(stDeviceInfo.szSerialNum);
                for (i = 0; i < 64; i++)
                {
                    if ('\0' == stDeviceInfo.szDevModel[i])
                    {
                        break;
                    }
                }
                SerialNum = SerialNum.Remove(i, 64 - i);

                String FirmwareVersion = new String(stDeviceInfo.szFirmwareVersion);
                for (i = 0; i < 64; i++)
                {
                    if ('\0' == stDeviceInfo.szFirmwareVersion[i])
                    {
                        break;
                    }
                }
                FirmwareVersion = FirmwareVersion.Remove(i, 64 - i);

                String MacAddress = new String(stDeviceInfo.szMacAddress);
                for (i = 0; i < 64; i++)
                {
                    if ('\0' == stDeviceInfo.szMacAddress[i])
                    {
                        break;
                    }
                }
                MacAddress = MacAddress.Remove(i, 64 - i);
                string strTemp;
                String strOut = "";
                strTemp = "DevModel:           " + DevModel + "\n";
                strOut += strTemp;
                strTemp = "SerialNum:           " + SerialNum + "\n";
                strOut += strTemp;
                strTemp = "FirmwareVersion:     " + FirmwareVersion + "\n";
                strOut += strTemp;
                strTemp = "MacAddress:           " + MacAddress + "\n";
                strOut += strTemp;

                MessageBox.Show(strOut);
            }

            return;
        }

        private void FactoryDefault_Click(object sender, EventArgs e)
        {
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }

            int bRet = NETDEVSDK.NETDEV_RestoreConfig(m_lpDevHandle);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("Factory Default Failed.");
            }
            else
            {
                MessageBox.Show("Factory Default Succeed.");
            }

            return;
        }

        private void downloadbytime_Click(object sender, EventArgs e)
        {
             if(IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }

             ComboBoxItem item = (ComboBoxItem)records.SelectedItem;
             String strFilename = item._value;

            NETDEV_PLAYBACKCOND_S stPlayBackInfo  = new NETDEV_PLAYBACKCOND_S();
            stPlayBackInfo.byRes = new byte[260];
            stPlayBackInfo.hPlayWnd = render.Handle;
            stPlayBackInfo.dwDownloadSpeed = (int)NETDEV_E_DOWNLOAD_SPEED_E.NETDEV_DOWNLOAD_SPEED_EIGHT;

            /* Assume to play the first recording found */
            stPlayBackInfo.tBeginTime = item.beginTime;
            stPlayBackInfo.tEndTime = item.endTime;
            int lChannelD = int.Parse(((ComboBoxItem)channel.SelectedItem)._value);
            stPlayBackInfo.dwChannelID = lChannelD;

            /* Please choose a different path for each operation, otherwise the file will be overwritten. */
            String szPath = "C:\\NetDEVSDK\\DownLoad\\netDev";

            m_lpDownloadHandle = NETDEVSDK.NETDEV_GetFileByTime(m_lpDevHandle, ref stPlayBackInfo, szPath, (int)NETDEV_MEDIA_FILE_FORMAT_E.NETDEV_MEDIA_FILE_MP4);
            if(IntPtr.Zero != m_lpDownloadHandle)
            {
                String strOut;
                strOut = "Downloading, path:"  + szPath;
                MessageBox.Show(strOut);
            }
            else
            {
                MessageBox.Show("failed");
            }

            return;
                }

        private void stopdownload_Click(object sender, EventArgs e)
        {
            if (IntPtr.Zero == m_lpDevHandle)
            {
                return;
            }
            int bRet = NETDEVSDK.NETDEV_StopGetFile(m_lpDownloadHandle);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("Download failed.");
            }
            else
            {
                MessageBox.Show("Download succeed.");
            }

            m_lpDownloadHandle = IntPtr.Zero;
            return;
        }

        private void getprogress_Click(object sender, EventArgs e)
        {
            Int32 iTime = 0;
            Int32 bRet = NETDEVSDK.NETDEV_PlayBackControl(m_lpRealHanel, (int)NETDEV_VOD_PLAY_CTRL_E.NETDEV_PLAY_CTRL_GETPLAYTIME, ref iTime);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show(" Get playtime failed.");
            }
            else
            {
                String strOut = " ";
                String strTime;
                {
                    strTime = DateTime.Now.Year.ToString() + "/" + DateTime.Now.Month.ToString() + "/" +
                        (DateTime.Now.Day - 1).ToString() + " " + DateTime.Now.Hour.ToString() + ":" +
                        DateTime.Now.Minute.ToString() + ":" + DateTime.Now.Second.ToString();
                }
                strOut += strTime;

                MessageBox.Show(strOut);
            }

            return;
        }

        private void setprogress_Click(object sender, EventArgs e)
        {
            Int32 iTime = 0;
            int bRet = NETDEVSDK.NETDEV_PlayBackControl(m_lpRealHanel, (int)NETDEV_VOD_PLAY_CTRL_E.NETDEV_PLAY_CTRL_GETPLAYTIME, ref iTime);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("Get playtime failed.");
                return;
            }

            iTime += 20;

            bRet = NETDEVSDK.NETDEV_PlayBackControl(m_lpRealHanel, (int)NETDEV_VOD_PLAY_CTRL_E.NETDEV_PLAY_CTRL_SETPLAYTIME, ref iTime);
            if (NETDEVSDK.TRUE != bRet)
            {
                MessageBox.Show("Set Play time failed.");
            }

            return;
        }

    }
}