local B, C, L, DB = unpack(select(2, ...))
-------------------------------------
-- Pet Quick Filter, by Windrunner
-- NDui MOD
-------------------------------------
local function loadPetFilter()
	-- Move the pet list down
	PetJournalListScrollFrame:SetPoint("TOPLEFT", PetJournalLeftInset, 3, -60)
	-- PetJournalEnhanced draws their own ScrollFrame
	if PetJournalEnhancedListScrollFrame then
		PetJournalEnhancedListScrollFrame:SetPoint("TOPLEFT", PetJournalLeftInset, 3, -60)
	end

	local QuickFilter_Function = function(self, button)
		local activeCount = 0
		for petType, _ in ipairs(PET_TYPE_SUFFIX) do
			local btn = _G["PetJournalQuickFilterButton"..petType]
			if "LeftButton" == button then
				if self == btn then
					btn.isActive = not btn.isActive
				elseif not IsShiftKeyDown() then
					btn.isActive = false
				end
			elseif "RightButton" == button and (self == btn) then
				btn.isActive = not btn.isActive
			end

			if btn.isActive then
				btn.Shadow:SetBackdropBorderColor(1, 1, 0)
				activeCount = activeCount + 1
			else
				btn.Shadow:SetBackdropBorderColor(0, 0, 0)
			end
			C_PetJournal.SetPetTypeFilter(btn.petType, btn.isActive)
		end

		if 0 == activeCount then
			C_PetJournal.SetAllPetTypesChecked(true)
		end

		-- PetJournalEnhanced support
		if PetJournalEnhanced then
			local PJE = PetJournalEnhanced
			if PJE.modules and PJE.modules.Sorting then
				PJE.modules.Sorting:UpdatePets()
			elseif PJE.UpdatePets then
				PJE:UpdatePets()
			end
		end
	end

	-- Create the pet type buttons, sorted according weakness
	-- Humanoid > Dragonkin > Magic > Flying > Aquatic > Elemental > Mechanical > Beast > Critter > Undead
	local activeCount = 0
	for petIndex, petType in ipairs({1, 2, 6, 3, 9, 7, 10, 8, 5, 4}) do
		local btn = CreateFrame("Button", "PetJournalQuickFilterButton"..petIndex, PetJournal)
		btn:SetSize(24, 24)
		btn:SetPoint("TOPLEFT", PetJournalLeftInset, 6 + 25 * (petIndex-1), -33)

		local icon = btn:CreateTexture(nil, "ARTWORK")
		icon:SetTexture("Interface\\PetBattles\\PetIcon-"..PET_TYPE_SUFFIX[petType])
		icon:SetTexCoord(.56, .73, .54, .62)
		icon:SetPoint("TOPLEFT", 2, -2)
		icon:SetPoint("BOTTOMRIGHT", -2, 2)
		B.CreateSD(btn, 1, 3)

		if C_PetJournal.IsPetTypeChecked(petType) then
			btn.isActive = true
			btn.Shadow:SetBackdropBorderColor(1, 1, 0)
			activeCount = activeCount + 1
		else
			btn.isActive = false
		end
		btn.petType = petType

		btn:SetScript("OnMouseUp", QuickFilter_Function)
	end

	if #PET_TYPE_SUFFIX == activeCount then
		for petIndex, _ in ipairs(PET_TYPE_SUFFIX) do
			local btn = _G["PetJournalQuickFilterButton"..petIndex]
			btn.isActive = false
			btn.Shadow:SetBackdropBorderColor(0, 0, 0)
		end
	end
end

local event = CreateFrame("Frame")
event:RegisterEvent("ADDON_LOADED")
event:SetScript("OnEvent", function(self, event, addon)
	if addon == "Blizzard_Collections" then
		loadPetFilter()
		self:UnregisterAllEvents()
	end
end)