local B, C, L, DB = unpack(select(2, ...))
if not C.Tooltip.Enable then return end

-- main
local classification = {
	elite = " |cffcc8800"..ELITE.."|r",
	rare = " |cffff99cc"..L["Rare"].."|r",
	rareelite = " |cffff99cc"..L["Rare"].."|r ".."|cffcc8800"..ELITE.."|r",
	worldboss = " |cffff0000"..BOSS.."|r",
}
local find = string.find
local format = string.format
local COALESCED_REALM_TOOLTIP1 = string.split(FOREIGN_SERVER_LABEL, COALESCED_REALM_TOOLTIP)
local INTERACTIVE_REALM_TOOLTIP1 = string.split(INTERACTIVE_SERVER_LABEL, INTERACTIVE_REALM_TOOLTIP)

local function getUnit(self)
	local _, unit = self and self:GetUnit()
	if(not unit) then
		local mFocus = GetMouseFocus()
		unit = mFocus and (mFocus.unit or mFocus:GetAttribute("unit"))	or "mouseover"
	end
	return unit
end

local function hideLines(self)
    for i = 3, self:NumLines() do
        local tiptext = _G["GameTooltipTextLeft"..i]
		local linetext = tiptext:GetText()
		if linetext then
			if NDuiDB["Tooltip"]["HidePVP"] and linetext == PVP_ENABLED then
				tiptext:SetText(nil)
				tiptext:Hide()
			elseif linetext:find(COALESCED_REALM_TOOLTIP1) or linetext:find(INTERACTIVE_REALM_TOOLTIP1) then
				tiptext:SetText(nil)
				tiptext:Hide()
				local pretiptext = _G["GameTooltipTextLeft"..i-1]
				pretiptext:SetText(nil)
				pretiptext:Hide()
				self:Show()
			elseif linetext == FACTION_HORDE then
				if NDuiDB["Tooltip"]["HideFaction"] then
					tiptext:SetText(nil)
					tiptext:Hide()
				else
					tiptext:SetText("|cffff5040"..linetext.."|r")
				end
			elseif linetext == FACTION_ALLIANCE then
				if NDuiDB["Tooltip"]["HideFaction"] then
					tiptext:SetText(nil)
					tiptext:Hide()
				else
					tiptext:SetText("|cff4080ff"..linetext.."|r")
				end
			end
		end
    end
end

local function getTarget(unit)
    if UnitIsUnit(unit, "player") then
        return ("|cffff0000%s|r"):format(">"..string.upper(YOU).."<")
    else
        return B.HexRGB(B.UnitColor(unit))..UnitName(unit).."|r"
    end
end

local function GameTooltipInsertFrame(self, faction)
	if not self.factionFrame then
		local f = self:CreateTexture(nil, "OVERLAY")
		f:SetPoint("TOPRIGHT", 0, -5)
		f:SetBlendMode("ADD")
		self.factionFrame = f
	end
	self.factionFrame:SetTexture("Interface\\FriendsFrame\\PlusManz-"..faction)
	self.factionFrame:SetAlpha(.5)
end

GameTooltip:HookScript("OnTooltipCleared", function(self)
	if self.factionFrame then
		self.factionFrame:SetAlpha(0)
	end
end)

GameTooltip:HookScript("OnTooltipSetUnit", function(self)
	if NDuiDB["Tooltip"]["CombatHide"] and InCombatLockdown() then
		return self:Hide()
	end
	hideLines(self)

	local unit = getUnit(self)
    if UnitExists(unit) then
        local hexColor = B.HexRGB(B.UnitColor(unit))
        local ricon = GetRaidTargetIndex(unit)
        if ricon then
            local text = GameTooltipTextLeft1:GetText()
            GameTooltipTextLeft1:SetFormattedText(("%s %s"), ICON_LIST[ricon].."18|t", text)
        end

        if UnitIsPlayer(unit) then
			local unitName
			if NDuiDB["Tooltip"]["HideTitle"] and NDuiDB["Tooltip"]["HideRealm"] then
				unitName = UnitName(unit)
			elseif NDuiDB["Tooltip"]["HideTitle"] then
				unitName = GetUnitName(unit, true)
			elseif NDuiDB["Tooltip"]["HideRealm"] then
				unitName = UnitPVPName(unit) or UnitName(unit)
			end
			if unitName then GameTooltipTextLeft1:SetText(unitName) end

			local relationship = UnitRealmRelationship(unit)
			if(relationship == LE_REALM_RELATION_VIRTUAL) then
				self:AppendText(("|cffcccccc%s|r"):format(INTERACTIVE_SERVER_LABEL))
			end

			local status = (UnitIsAFK(unit) and AFK) or (UnitIsDND(unit) and DND) or (not UnitIsConnected(unit) and PLAYER_OFFLINE)
			if status then
				self:AppendText((" |cff00cc00<%s>|r"):format(status))
			end

			if NDuiDB["Tooltip"]["FactionIcon"] then
				local faction = UnitFactionGroup(unit)
				if faction and faction ~= "Neutral" then
					GameTooltipInsertFrame(self, faction)
				end
			end

			local unitGuild, tmp, tmp2 = GetGuildInfo(unit)
			local text = GameTooltipTextLeft2:GetText()
			if tmp then
				tmp2 = tmp2 + 1
				if NDuiDB["Tooltip"]["HideRank"] then
					GameTooltipTextLeft2:SetText("<"..text..">")
				else
					GameTooltipTextLeft2:SetText("<"..text..">  "..tmp.."("..tmp2..")")
				end
				if IsInGuild() and unitGuild == GetGuildInfo("player") then
					GameTooltipTextLeft2:SetTextColor(.25, 1, .25)
				else
					GameTooltipTextLeft2:SetTextColor(1, .1, .8)
				end
			end
		end

		local line1 = GameTooltipTextLeft1:GetText()
		GameTooltipTextLeft1:SetFormattedText("%s", hexColor..line1)

        local alive = not UnitIsDeadOrGhost(unit)
		local level
		if UnitIsWildBattlePet(unit) or UnitIsBattlePetCompanion(unit) then
			level = UnitBattlePetLevel(unit)
		else
			level = UnitLevel(unit)
		end

        if level then
			local boss
            if level == -1 then boss = "|cffff0000Boss|r" end

            local diff = GetCreatureDifficultyColor(level)
            local classify = UnitClassification(unit)
            local textLevel = ("%s%s%s|r"):format(B.HexRGB(diff), boss or ("%d"):format(level), classification[classify] or "")
			local tiptextLevel
			for i = 2, self:NumLines() do
                local tiptext = _G["GameTooltipTextLeft"..i]
				local linetext = tiptext:GetText()
				if(linetext and linetext:find(LEVEL)) then
					tiptextLevel = tiptext
				end
            end

			local creature = not UnitIsPlayer(unit) and UnitCreatureType(unit) or ""
            local unitClass = UnitIsPlayer(unit) and ("%s %s"):format(UnitRace(unit) or "", hexColor..(UnitClass(unit) or "").."|r") or ""
			if(tiptextLevel) then
				tiptextLevel:SetFormattedText(("%s %s%s %s"), textLevel, creature, unitClass, (not alive and "|cffCCCCCC"..DEAD.."|r" or ""))
			end
        end

        if UnitExists(unit.."target") then
			local tarRicon = GetRaidTargetIndex(unit.."target")
			local tar = ("%s%s"):format((tarRicon and ICON_LIST[tarRicon].."10|t") or "", getTarget(unit.."target"))
			self:AddLine(TARGET..": "..tar)
        end

		if alive then
			GameTooltipStatusBar:SetStatusBarColor(B.UnitColor(unit))
		else
			GameTooltipStatusBar:Hide()
		end
    else
        GameTooltipStatusBar:SetStatusBarColor(0, .9, 0)
    end

    if GameTooltipStatusBar:IsShown() then
        GameTooltipStatusBar:ClearAllPoints()
        GameTooltipStatusBar:SetPoint("TOPLEFT", self, "TOPLEFT", 3, 10)
        GameTooltipStatusBar:SetPoint("TOPRIGHT", self, -3, 0)
    end
end)

GameTooltipStatusBar:SetStatusBarTexture(DB.normTex)
GameTooltipStatusBar:SetHeight(5)
B.CreateSD(GameTooltipStatusBar, 3, 3)
local bg = GameTooltipStatusBar:CreateTexture(nil, "BACKGROUND")
bg:SetAllPoints()
bg:SetTexture(DB.normTex)
bg:SetVertexColor(0, 0, 0, .6)

GameTooltipStatusBar:SetScript("OnValueChanged", function(self, value)
    if not value then return end
    local min, max = self:GetMinMaxValues()
    if (value < min) or (value > max) then return end
    local _, unit = GameTooltip:GetUnit()
    if unit then
        min, max = UnitHealth(unit), UnitHealthMax(unit)
        if not self.text then
            self.text = self:CreateFontString(nil, "OVERLAY")
            self.text:SetPoint("CENTER", GameTooltipStatusBar)
            self.text:SetFont(unpack(DB.Font))
        end
        self.text:Show()
        local hp = B.Numb(min).." / "..B.Numb(max)
        self.text:SetText(hp)
    end
end)

hooksecurefunc("GameTooltip_SetDefaultAnchor", function(tooltip, parent)
    local frame = GetMouseFocus()
    if NDuiDB["Tooltip"]["Cursor"] then
        tooltip:SetOwner(parent, "ANCHOR_CURSOR_RIGHT")
	else
        tooltip:SetOwner(parent, "ANCHOR_NONE")	
        tooltip:SetPoint(C.Tooltip.Pos[1], UIParent, C.Tooltip.Pos[2], C.Tooltip.Pos[3], C.Tooltip.Pos[4])
    end
end)

local function style(frame)
	if not frame then return end
	frame:SetScale(NDuiDB["Tooltip"]["Scale"])

	if not frame.bg then
		frame:SetBackdrop(nil)
		local bg = CreateFrame("Frame", nil, frame)
		bg:SetAllPoints()
		bg:SetFrameLevel(frame:GetFrameLevel())
		B.CreateBD(bg, .7, 3)
		B.CreateTex(bg)
		frame.bg = bg

		-- other gametooltip-like support
		local function getBackdrop() return bg:GetBackdrop() end
		frame.GetBackdrop = getBackdrop

		local function getBackdropColor() return 0, 0, 0, .7 end
		frame.GetBackdropColor = getBackdropColor

		local function getBackdropBorderColor() return 0, 0, 0 end
		frame.GetBackdropBorderColor = getBackdropBorderColor
	end

	frame.bg:SetBackdropBorderColor(0, 0, 0)
	if NDuiDB["Tooltip"]["ClassColor"] and frame.GetItem then
		local _, item = frame:GetItem()
		if item then
			local quality = select(3, GetItemInfo(item))
			local color = BAG_ITEM_QUALITY_COLORS[quality or 1]
			if color then
				frame.bg:SetBackdropBorderColor(color.r, color.g, color.b)
			end
		end
	end

    if frame.NumLines then
        for index = 1, frame:NumLines() do
            if index == 1 then
                _G[frame:GetName().."TextLeft"..index]:SetFont(DB.TipFont[1], DB.TipFont[2] + 2, DB.TipFont[3])
            else
                _G[frame:GetName().."TextLeft"..index]:SetFont(unpack(DB.TipFont))
            end
            _G[frame:GetName().."TextRight"..index]:SetFont(unpack(DB.TipFont))
        end
    end
end

local function extrastyle(f)
	if not f.styled then
		f:SetBackdrop(nil)
		f:DisableDrawLayer("BACKGROUND")
		local bg = CreateFrame("Frame", nil, f)
		bg:SetAllPoints()
		bg:SetFrameLevel(f:GetFrameLevel())
		style(bg)
		f.styled = true
	end
end

local Event = CreateFrame("Frame")
Event:RegisterEvent("ADDON_LOADED")
Event:SetScript("OnEvent", function(self, event, addon)
	if addon == "Blizzard_DebugTools" and not IsAddOnLoaded("Aurora") then
		FrameStackTooltip:HookScript("OnShow", style)
		EventTraceTooltip:HookScript("OnShow", style)
	end

	if addon == "NDui" then
		local tooltips = {
			ChatMenu,
			EmoteMenu,
			LanguageMenu,
			VoiceMacroMenu,
			GameTooltip,
			ItemRefTooltip,
			ItemRefShoppingTooltip1,
			ItemRefShoppingTooltip2,
			ShoppingTooltip1,
			ShoppingTooltip2,
			AutoCompleteBox,
			FriendsTooltip,
			WorldMapTooltip,
			WorldMapCompareTooltip1,
			WorldMapCompareTooltip2,
			WorldMapCompareTooltip3,
			DropDownList1MenuBackdrop,
			DropDownList2MenuBackdrop,
			DropDownList3MenuBackdrop,
			FriendsMenuXPMenuBackdrop,
			FriendsMenuXPSecureMenuBackdrop,
			QuestScrollFrame.StoryTooltip,
			GeneralDockManagerOverflowButtonList,
		}
		for _, f in pairs(tooltips) do
			if f then
				f:HookScript("OnShow", style)
			end
		end

		local extra = {
			QueueStatusFrame,
			FloatingGarrisonFollowerTooltip,
			FloatingGarrisonFollowerAbilityTooltip,
			FloatingGarrisonMissionTooltip,
			GarrisonFollowerAbilityTooltip,
			GarrisonFollowerTooltip,
			FloatingGarrisonShipyardFollowerTooltip,
			GarrisonShipyardFollowerTooltip,
			BattlePetTooltip,
			PetBattlePrimaryAbilityTooltip,
			PetBattlePrimaryUnitTooltip,
			FloatingBattlePetTooltip,
			FloatingPetBattleAbilityTooltip,
			IMECandidatesFrame
		}
		for _, f in pairs(extra) do
			if f then
				f:HookScript("OnShow", extrastyle)
			end
		end

		local r, g, b = DB.cc.r, DB.cc.g, DB.cc.b
		IMECandidatesFrame.selection:SetVertexColor(r, g, b)
	end

	if addon == "Blizzard_Collections" then
		local pet = {
			PetJournalPrimaryAbilityTooltip,
			PetJournalSecondaryAbilityTooltip,
		}
		for _, f in pairs(pet) do
			if f then
				f:HookScript("OnShow", extrastyle)
			end
		end
	end

	if addon == "Blizzard_GarrisonUI" then
		local gt = {
			GarrisonMissionMechanicTooltip,
			GarrisonMissionMechanicFollowerCounterTooltip,
			GarrisonShipyardMapMissionTooltip,
			GarrisonBonusAreaTooltip,
			GarrisonBuildingFrame.BuildingLevelTooltip
		}
		for _, f in pairs(gt) do
			if f then
				f:HookScript("OnShow", extrastyle)
			end
		end
	end

	if addon == "Blizzard_OrderHallUI" then
		local gt = {
			GarrisonFollowerAbilityWithoutCountersTooltip,
			GarrisonFollowerMissionAbilityWithoutCountersTooltip,
		}
		for _, f in pairs(gt) do
			if f then
				f:HookScript("OnShow", extrastyle)
			end
		end
	end

	if addon == "Blizzard_PVPUI" then
		local gt = {
			ConquestTooltip,
			PVPRewardTooltip,
		}
		for _, f in pairs(gt) do
			if f then
				f:HookScript("OnShow", style)
			end
		end
	end
end)

-- Reskin Closebutton
if IsAddOnLoaded("Aurora") then
	local F, C = unpack(Aurora)
	F.ReskinClose(FloatingBattlePetTooltip.CloseButton)
	F.ReskinClose(FloatingPetBattleAbilityTooltip.CloseButton)
	F.ReskinClose(FloatingGarrisonMissionTooltip.CloseButton)
end