local B, C, L, DB = unpack(select(2, ...))
------------------------
-- Tipachu, by Tuller
-- NDui MOD
------------------------
if not C.Tooltip.Enable then return end

local function setTooltipIcon(self, icon)
	local title = icon and _G[self:GetName() .. "TextLeft1"]
	if title then
		title:SetFormattedText("|T%s:20:20:0:0:64:64:5:59:5:59:%d|t %s", icon, 20, title:GetText())
	end
end

local function newTooltipHooker(method, func)
	return function(tooltip)
		local modified = false
		tooltip:HookScript("OnTooltipCleared", function(self, ...)
			modified = false
		end)
		tooltip:HookScript(method, function(self, ...)
			if not modified  then
				modified = true
				func(self, ...)
			end
		end)
	end
end

local hookItem = newTooltipHooker("OnTooltipSetItem", function(self, ...)
	local name, link = self:GetItem()
	if link then
		setTooltipIcon(self, GetItemIcon(link))
	end
end)

local hookSpell = newTooltipHooker("OnTooltipSetSpell", function(self, ...)
	local name, rank, id = self:GetSpell()
	if id then
		setTooltipIcon(self, GetSpellTexture(id))
	end
end)

for _, tooltip in pairs{GameTooltip, ItemRefTooltip} do
	hookItem(tooltip)
	hookSpell(tooltip)
end

-- WorldQuest Tooltip
hooksecurefunc("EmbeddedItemTooltip_SetItemByQuestReward", function(self)
	if self.Icon then
		self.Icon:SetTexCoord(unpack(DB.TexCoord))
		self.IconBorder:Hide()
	end
end)
BONUS_OBJECTIVE_REWARD_WITH_COUNT_FORMAT = "|T%1$s:16:16:0:0:64:64:5:59:5:59|t |cffffffff%2$d|r %3$s"

-- PVPReward Tooltip
hooksecurefunc("EmbeddedItemTooltip_SetItemByID", function(self)
	if self.Icon then
		self.Icon:SetTexCoord(unpack(DB.TexCoord))
		self.IconBorder:Hide()
	end
end)