local B, C, L, DB = unpack(select(2, ...))

local cr, cg, cb = DB.cc.r, DB.cc.g, DB.cc.b
local faction = UnitFactionGroup("player")
local MB = CreateFrame("Frame", nil, UIParent)
MB:SetSize(210, 20)
MB:SetPoint(unpack(C.Skins.MicroMenuPos))
MB:RegisterEvent("PLAYER_ENTERING_WORLD")
MB:SetScript("OnEvent", function()
	MB:UnregisterEvent("PLAYER_ENTERING_WORLD")
	--in case of first call in combat
	ToggleAllBags()
	ToggleAllBags()
	if not NDuiDB["Skins"]["MicroMenu"] then MB:Hide() return end
end)

local function key(text, action)
	if GetBindingKey(action) then
		return text.." ("..GetBindingText(GetBindingKey(action))..")", cr, cg, cb
	else
		return text, cr, cg, cb
	end
end

local MB1 = CreateFrame("Frame", nil, MB)
MB1:SetPoint("CENTER", MB, "CENTER", -50, 0)
B.CreateMM(MB1, "micro_player")
local MB1BG = CreateFrame("Button", nil, MB1)
B.CreateMB(MB1BG, MB1, 35, 20, -6, 0)
MB1BG:SetScript("OnEnter", function(self)
	self:SetAlpha(0.7)
	GameTooltip:SetOwner(self, "ANCHOR_TOP")
	GameTooltip:AddLine(key(CHARACTER_BUTTON, "TOGGLECHARACTER0"))
	GameTooltip:Show()
end)
MB1BG:SetScript("OnLeave", function(self)
	GameTooltip:Hide()
	self:SetAlpha(0)
end)
MB1BG:SetScript("OnClick", function(self)
	ToggleFrame(CharacterFrame)
end)

local MB2 = CreateFrame("Frame", nil, MB)
MB2:SetPoint("CENTER", MB, "CENTER", -24, 0)
B.CreateMM(MB2, "micro_spellbook")
local MB2BG = CreateFrame("Button", nil, MB2)
B.CreateMB(MB2BG, MB2, 24, 20, 0, 0)
MB2BG:SetScript("OnEnter", function(self)
	self:SetAlpha(0.7)
	GameTooltip:SetOwner(self, "ANCHOR_TOP")
	GameTooltip:AddLine(key(SPELLBOOK_ABILITIES_BUTTON, "TOGGLESPELLBOOK"))
	GameTooltip:Show()
end)
MB2BG:SetScript("OnLeave", function(self)
	GameTooltip:Hide()
	self:SetAlpha(0)
end)
ToggleFrame(SpellBookFrame)	-- prevent taint
MB2BG:SetScript("OnClick", function(self)
	ToggleFrame(SpellBookFrame)
end)

local MB3 = CreateFrame("Frame", nil, MB)
MB3:SetPoint("CENTER", MB, "CENTER", 2, 0)
B.CreateMM(MB3, "micro_talents")
local MB3BG = CreateFrame("Button", nil, MB3)
B.CreateMB(MB3BG, MB3, 24, 20, 0, 0)
MB3BG:SetScript("OnEnter", function(self)
	self:SetAlpha(0.7)
	GameTooltip:SetOwner(self, "ANCHOR_TOP")
	GameTooltip:AddLine(key(TALENTS_BUTTON, "TOGGLETALENTS"))
	GameTooltip:Show()
end)
MB3BG:SetScript("OnLeave", function(self)
	GameTooltip:Hide()
	self:SetAlpha(0)
end)
MB3BG:SetScript("OnClick", function(self)
	if not PlayerTalentFrame then LoadAddOn("Blizzard_TalentUI") end
	if UnitLevel("player") < SHOW_SPEC_LEVEL then
		UIErrorsFrame:AddMessage(DB.InfoColor..format(FEATURE_BECOMES_AVAILABLE_AT_LEVEL, SHOW_SPEC_LEVEL))
	else
		ToggleFrame(PlayerTalentFrame)
	end
end)

local MB4 = CreateFrame("Frame", nil, MB)
MB4:SetPoint("CENTER", MB, "CENTER", 28, 0)
B.CreateMM(MB4, "micro_achievements")
local MB4BG = CreateFrame("Button", nil, MB4)
B.CreateMB(MB4BG, MB4, 24, 20, 0, 0)
MB4BG:SetScript("OnEnter", function(self)
	self:SetAlpha(0.7)
	GameTooltip:SetOwner(self, "ANCHOR_TOP")
	GameTooltip:AddLine(key(ACHIEVEMENT_BUTTON, "TOGGLEACHIEVEMENT"))
	GameTooltip:Show()
end)
MB4BG:SetScript("OnLeave", function(self)
	GameTooltip:Hide()
	self:SetAlpha(0)
end)
MB4BG:SetScript("OnClick", function(self)
	ToggleAchievementFrame()
end)

local MB5 = CreateFrame("Frame", nil, MB)
MB5:SetPoint("CENTER", MB, "CENTER", 54, 0)
B.CreateMM(MB5, "micro_quests")
local MB5BG = CreateFrame("Button", nil, MB5)
B.CreateMB(MB5BG, MB5, 24, 20, 0, 0)
MB5BG:SetScript("OnEnter", function(self)
	self:SetAlpha(0.7)
	GameTooltip:SetOwner(self, "ANCHOR_TOP")
	GameTooltip:AddLine(key(QUESTLOG_BUTTON, "TOGGLEQUESTLOG"))
	GameTooltip:Show()
end)
MB5BG:SetScript("OnLeave", function(self)
	GameTooltip:Hide()
	self:SetAlpha(0)
end)
MB5BG:SetScript("OnClick", function(self)
	ToggleFrame(WorldMapFrame)
end)

local MB6 = CreateFrame("Frame", nil, MB)
MB6:SetPoint("CENTER", MB, "CENTER", 80, 0)
B.CreateMM(MB6, "micro_guild")
local MB6BG = CreateFrame("Button", nil, MB6)
B.CreateMB(MB6BG, MB6, 24, 20, 0, 0)
MB6BG:SetScript("OnEnter", function(self)
	self:SetAlpha(0.7)
	GameTooltip:SetOwner(self, "ANCHOR_TOP")
	if IsInGuild() then
		GameTooltip:AddLine(key(GUILD, "TOGGLEGUILDTAB"))
	else
		GameTooltip:AddLine(key(LOOKINGFORGUILD, "TOGGLEGUILDTAB"))
	end
	GameTooltip:Show()
end)
MB6BG:SetScript("OnLeave", function(self)
	GameTooltip:Hide()
	self:SetAlpha(0)
end)
MB6BG:SetScript("OnClick", function(self)
	if IsTrialAccount() then
		UIErrorsFrame:AddMessage(DB.InfoColor..ERR_GUILD_TRIAL_ACCOUNT_TRIAL)
	elseif faction == "Neutral" then
		UIErrorsFrame:AddMessage(DB.InfoColor..FEATURE_NOT_AVAILBLE_PANDAREN)
	elseif IsInGuild() then
		if not GuildFrame then LoadAddOn("Blizzard_GuildUI") end
		ToggleFrame(GuildFrame)
	else
		ToggleGuildFinder()
	end
end)

local MB7 = CreateFrame("Frame", nil, MB)
MB7:SetPoint("CENTER", MB, "CENTER", 106, 0)
B.CreateMM(MB7, "micro_pvp")
local MB7BG = CreateFrame("Button", nil, MB7)
B.CreateMB(MB7BG, MB7, 24, 20, 0, 0)
MB7BG:SetScript("OnEnter", function(self)
	self:SetAlpha(0.7)
	GameTooltip:SetOwner(self, "ANCHOR_TOP")
	GameTooltip:AddLine(key(PLAYER_V_PLAYER, "TOGGLECHARACTER4"))
	GameTooltip:Show()
end)
MB7BG:SetScript("OnLeave", function(self)
	GameTooltip:Hide()
	self:SetAlpha(0)
end)
MB7BG:SetScript("OnClick", function(self)
	if faction == "Neutral" then
		UIErrorsFrame:AddMessage(DB.InfoColor..FEATURE_NOT_AVAILBLE_PANDAREN)
	elseif UnitLevel("player") < LFDMicroButton.minLevel then
		UIErrorsFrame:AddMessage(DB.InfoColor..format(FEATURE_BECOMES_AVAILABLE_AT_LEVEL, LFDMicroButton.minLevel))
	else
		TogglePVPUI()
	end
end)

local MB8 = CreateFrame("Frame", nil, MB)
MB8:SetPoint("CENTER", MB, "CENTER", 132, 0)
B.CreateMM(MB8, "micro_LFD")
local MB8BG = CreateFrame("Button", nil, MB8)
B.CreateMB(MB8BG, MB8, 24, 20, 0, 0)
MB8BG:SetScript("OnEnter", function(self)
	self:SetAlpha(0.7)
	GameTooltip:SetOwner(self, "ANCHOR_TOP")
	GameTooltip:AddLine(key(DUNGEONS_BUTTON, "TOGGLEGROUPFINDER"))
	GameTooltip:Show()
end)
MB8BG:SetScript("OnLeave", function(self)
	GameTooltip:Hide()
	self:SetAlpha(0)
end)
MB8BG:SetScript("OnClick", function(self)
	if faction == "Neutral" then
		UIErrorsFrame:AddMessage(DB.InfoColor..FEATURE_NOT_AVAILBLE_PANDAREN)
	elseif UnitLevel("player") < LFDMicroButton.minLevel then
		UIErrorsFrame:AddMessage(DB.InfoColor..format(FEATURE_BECOMES_AVAILABLE_AT_LEVEL, LFDMicroButton.minLevel))
	else
		PVEFrame_ToggleFrame()
	end
end)

local MB9 = CreateFrame("Frame", nil, MB)
MB9:SetPoint("CENTER", MB, "CENTER", 158, 0)
B.CreateMM(MB9, "micro_encounter")
local MB9BG = CreateFrame("Button", nil, MB9)
B.CreateMB(MB9BG, MB9, 24, 20, 0, 0)
MB9BG:SetScript("OnEnter", function(self)
	self:SetAlpha(0.7)
	GameTooltip:SetOwner(self, "ANCHOR_TOP")
	GameTooltip:AddLine(key(ENCOUNTER_JOURNAL, "TOGGLEENCOUNTERJOURNAL"))
	GameTooltip:Show()
end)
MB9BG:SetScript("OnLeave", function(self)
	GameTooltip:Hide()
	self:SetAlpha(0)
end)
MB9BG:SetScript("OnClick", function(self)
	if not EncounterJournal then LoadAddOn("Blizzard_EncounterJournal") end
	ToggleFrame(EncounterJournal)
end)

local MB10 = CreateFrame("Frame", nil, MB)
MB10:SetPoint("CENTER", MB, "CENTER", 184, 0)
B.CreateMM(MB10, "micro_pets")
local MB10BG = CreateFrame("Button", nil, MB10)
B.CreateMB(MB10BG, MB10, 24, 20, 0, 0)
MB10BG:SetScript("OnEnter", function(self)
	self:SetAlpha(0.7)
	GameTooltip:SetOwner(self, "ANCHOR_TOP")
	GameTooltip:AddLine(key(COLLECTIONS, "TOGGLECOLLECTIONS"))
	GameTooltip:Show()
end)
MB10BG:SetScript("OnLeave", function(self)
	GameTooltip:Hide()
	self:SetAlpha(0)
end)
MB10BG:SetScript("OnClick", function(self)
	if InCombatLockdown() and not IsAddOnLoaded("Blizzard_Collections") then
		UIErrorsFrame:AddMessage(DB.InfoColor..ERR_POTION_COOLDOWN)
		return
	end
	ToggleCollectionsJournal()
end)

local MB11 = CreateFrame("Frame", nil, MB)
MB11:SetPoint("CENTER", MB, "CENTER", 210, 0)
B.CreateMM(MB11, "micro_store")
local MB11BG = CreateFrame("Button", nil, MB11)
B.CreateMB(MB11BG, MB11, 24, 20, 0, 0)
MB11BG:SetScript("OnEnter", function(self)
	self:SetAlpha(0.7)
	GameTooltip:SetOwner(self, "ANCHOR_TOP")
	GameTooltip:AddLine(BLIZZARD_STORE, cr, cg, cb)
	GameTooltip:Show()
end)
MB11BG:SetScript("OnLeave", function(self)
	GameTooltip:Hide()
	self:SetAlpha(0)
end)
MB11BG:SetScript("OnClick", function(self)
	if IsTrialAccount() then
		UIErrorsFrame:AddMessage(DB.InfoColor..ERR_GUILD_TRIAL_ACCOUNT)
	elseif C_StorePublic.IsDisabledByParentalControls() then
		UIErrorsFrame:AddMessage(DB.InfoColor..BLIZZARD_STORE_ERROR_PARENTAL_CONTROLS)
	else
		ToggleStoreUI()
	end
end)

local MB12 = CreateFrame("Frame", nil, MB)
MB12:SetPoint("CENTER", MB, "CENTER", 236, 0)
B.CreateMM(MB12, "micro_gm")
local MB12BG = CreateFrame("Button", nil, MB12)
B.CreateMB(MB12BG, MB12, 24, 20, 0, 0)
MB12BG:SetScript("OnEnter", function(self)
	self:SetAlpha(0.7)
	GameTooltip:SetOwner(self, "ANCHOR_TOP")
	GameTooltip:AddLine(HELP_BUTTON, cr, cg, cb)
	GameTooltip:Show()
end)
MB12BG:SetScript("OnLeave", function(self)
	GameTooltip:Hide()
	self:SetAlpha(0)
end)
MB12BG:SetScript("OnClick", function(self)
	ToggleFrame(HelpFrame)
end)

local MB13 = CreateFrame("Frame", nil, MB)
MB13:SetPoint("CENTER", MB, "CENTER", 262, 0)
B.CreateMM(MB13, "micro_settings")
local MB13BG = CreateFrame("Button", nil, MB13)
B.CreateMB(MB13BG, MB13, 24, 20, 0, 0)
MB13BG:SetScript("OnEnter", function(self)
	self:SetAlpha(0.7)
	GameTooltip:SetOwner(self, "ANCHOR_TOP")
	GameTooltip:AddLine(MAIN_MENU, cr, cg, cb)
	GameTooltip:Show()
end)
MB13BG:SetScript("OnLeave", function(self)
	GameTooltip:Hide()
	self:SetAlpha(0)
end)
MB13BG:SetScript("OnClick", function(self)
	ToggleFrame(GameMenuFrame)
	PlaySound("igMiniMapOpen")
end)

local MB14 = CreateFrame("Frame", nil, MB)
MB14:SetPoint("CENTER", MB, "CENTER", 299, 0)
B.CreateMM(MB14, "micro_bags")
local MB14BG = CreateFrame("Button", nil, MB14)
B.CreateMB(MB14BG, MB14, 35, 20, -6, 0)
MB14BG:SetScript("OnEnter", function(self)
	self:SetAlpha(0.7)
	GameTooltip:SetOwner(self, "ANCHOR_TOP")
	GameTooltip:AddLine(key(BAGSLOT, "OPENALLBAGS"))
	GameTooltip:Show()
end)
MB14BG:SetScript("OnLeave", function(self)
	GameTooltip:Hide()
	self:SetAlpha(0)
end)
MB14BG:SetScript("OnClick", function(self)
	ToggleAllBags()
end)