﻿local B, C, L, DB = unpack(select(2, ...))

-- Coords
local WorldMapDetailFrame, WorldMapTitleButton, WorldMapFrame = WorldMapDetailFrame, WorldMapTitleButton, WorldMapFrame
local formattext, player, cursor = ": %.1f, %.1f"

local function Cursor()
	local left, top = WorldMapDetailFrame:GetLeft() or 0, WorldMapDetailFrame:GetTop() or 0
	local width, height = WorldMapDetailFrame:GetWidth(), WorldMapDetailFrame:GetHeight()
	local scale = WorldMapDetailFrame:GetEffectiveScale()
	local x, y = GetCursorPosition()
	local cx = (x/scale - left) / width
	local cy = (top - y/scale) / height
	if cx < 0 or cx > 1 or cy < 0 or cy > 1 then return end
	return cx, cy
end

local function OnUpdate(player, cursor)
	local cx, cy = Cursor()
	local px, py = GetPlayerMapPosition("player")
	if cx and cy then
		cursor:SetFormattedText(MOUSE_LABEL..DB.MyColor..formattext, 100 * cx, 100 * cy)
	else
		cursor:SetText(MOUSE_LABEL..DB.MyColor..": --, --")
	end
	if not px or px == 0 or py == 0 then
		player:SetText(PLAYER..DB.MyColor..": --, --")
	else
		player:SetFormattedText(PLAYER..DB.MyColor..formattext, 100 * px, 100 * py)
	end
end

local function UpdateCoords(self, elapsed)
	self.elapsed = self.elapsed - elapsed
	if self.elapsed <= 0 then
		self.elapsed = 0.1
		OnUpdate(player, cursor)
	end
end

local tpt = {"LEFT", self, "BOTTOM"}
local function gen_coords(self)
	if player or cursor then return end
	player = B.CreateFS(WorldMapTitleButton, 14, "Player", false, "TOPLEFT", 50, -6)
	cursor = B.CreateFS(WorldMapTitleButton, 14, "Cursor", false, "TOPLEFT", 180, -6)
end

local w = CreateFrame("Frame")
w:RegisterEvent("PLAYER_ENTERING_WORLD")
w:RegisterEvent("WORLD_MAP_UPDATE")
w:SetScript("OnEvent", function(self, event, ...)
	if event == "PLAYER_ENTERING_WORLD" then
		if not NDuiDB["Map"]["Coord"] then return end
		gen_coords(self)
		local cond = false
		WorldMapFrameTutorialButton:SetPoint("TOPLEFT", WorldMapFrame, "TOPLEFT", -12, -12)
		self:UnregisterEvent("PLAYER_ENTERING_WORLD")
	elseif event == "WORLD_MAP_UPDATE" then
		-- making sure that coordinates are not calculated when map is hidden
		if not NDuiDB["Map"]["Coord"] then
			self:UnregisterEvent("WORLD_MAP_UPDATE")
			return
		end
		if not WorldMapFrame:IsVisible() and cond then
			self.elapsed = nil
			self:SetScript("OnUpdate", nil)
			cond = false
		else
			self.elapsed = 0.1
			self:SetScript("OnUpdate", UpdateCoords)
			cond = true
		end
	end
end)

hooksecurefunc("WorldMap_ToggleSizeUp", function()
	WorldMapFrame:SetScale(1)
end)

hooksecurefunc("WorldMap_ToggleSizeDown", function()
	WorldMapFrame:SetScale(NDuiDB["Map"]["MapScale"])
end)