﻿local B, C, L, DB = unpack(select(2, ...))
if not C.Minimap.Enable then return end

-- Shape, location and scale
function GetMinimapShape() return "SQUARE" end
Minimap:ClearAllPoints()
Minimap:SetPoint(unpack(C.Minimap.Pos))
MinimapCluster:SetScale(C.Minimap.Scale)
Minimap:SetFrameLevel(10)
DropDownList1:SetClampedToScreen(true)

-- Mask texture hint => addon will work with Carbonite
local hint = CreateFrame("Frame")
local total = 0
local SetTextureTrick = function(self, elapsed)
    total = total + elapsed
    if(total > 2) then
        Minimap:SetMaskTexture("Interface\\Buttons\\WHITE8X8")
        hint:SetScript("OnUpdate", nil)
    end
end

hint:RegisterEvent("PLAYER_LOGIN")
hint:SetScript("OnEvent", function()
    hint:SetScript("OnUpdate", SetTextureTrick)
end)

-- Background
local MBG = CreateFrame("Frame", nil, Minimap)
MBG:SetFrameLevel(Minimap:GetFrameLevel() - 1)
MBG:SetPoint("TOPLEFT", -3, 3)
MBG:SetPoint("BOTTOMRIGHT", 3, -3)
B.CreateBD(MBG)
local count, ticker = 0
local function combatPulse(r, g, b, a)
	count = count + 1
	if count == 15 then count = 1 end
	if count > 7 then
		a = (14-count)/10
	else
		a = count/10
	end
	MBG:SetBackdropBorderColor(r, g, b, a)
end
MBG:RegisterEvent("PLAYER_REGEN_ENABLED")
MBG:RegisterEvent("PLAYER_REGEN_DISABLED")
MBG:RegisterEvent("PLAYER_ENTERING_WORLD")
MBG:RegisterEvent("CALENDAR_UPDATE_PENDING_INVITES")
MBG:RegisterEvent("UPDATE_PENDING_MAIL")
MBG:SetScript("OnEvent", function(self, event)
	if not NDuiDB["Map"]["CombatPulse"] then
		self:UnregisterAllEvents()
		return 
	end
	if event == "PLAYER_REGEN_DISABLED" then
		if ticker then ticker:Cancel() end
		ticker = C_Timer.NewTicker(.1, function() combatPulse(1, 0, 0, 0) end)
	elseif not InCombatLockdown() then
		if CalendarGetNumPendingInvites() > 0 or MiniMapMailFrame:IsShown() then
			if ticker then ticker:Cancel() end
			ticker = C_Timer.NewTicker(.1, function() combatPulse(1, 1, 0, 0) end)
		else
			if ticker then ticker:Cancel() end
			self:SetBackdropBorderColor(0, 0, 0, 1)
		end
	end
end)
MiniMapMailFrame:HookScript("OnHide", function()
	if ticker then ticker:Cancel() end
	MBG:SetBackdropBorderColor(0, 0, 0, 1)
end)

-- Mousewheel zoom
Minimap:EnableMouseWheel(true)
Minimap:SetScript("OnMouseWheel", function(_, zoom)
    if zoom > 0 then
        Minimap_ZoomIn()
    else
        Minimap_ZoomOut()
    end
end)

-- Hiding ugly things
local _G = getfenv(0)

local frames = {
    "GameTimeFrame",
    "MinimapBorderTop",
    "MinimapNorthTag",
    "MinimapBorder",
    "MinimapZoneTextButton",
    "MinimapZoomOut",
    "MinimapZoomIn",
    "MiniMapVoiceChatFrame",
    "MiniMapWorldMapButton",
    "MiniMapMailBorder",
    "MiniMapTracking",
}

for i in pairs(frames) do
    _G[frames[i]]:Hide()
    _G[frames[i]].Show = B.Dummy
end
MinimapCluster:EnableMouse(false)
Minimap:SetArchBlobRingScalar(0)
Minimap:SetQuestBlobRingScalar(0)

-- Garrison
GarrisonLandingPageMinimapButton:ClearAllPoints()
GarrisonLandingPageMinimapButton:SetPoint("TOPLEFT", Minimap, "TOPLEFT", -3, 3)
GarrisonLandingPageMinimapButton:SetSize(42, 42)
GarrisonLandingPageMinimapButton:SetScale(.7)

-- QueueStatus Button
QueueStatusMinimapButton:ClearAllPoints()
QueueStatusMinimapButtonBorder:Hide()
QueueStatusMinimapButton:SetPoint("BOTTOMLEFT", Minimap, "BOTTOMLEFT", -5, -5)

-- Difficulty Flags
local flags = {"MiniMapInstanceDifficulty", "GuildInstanceDifficulty", "MiniMapChallengeMode"}
for k, v in pairs(flags) do
	local flag = _G[v]
	flag:ClearAllPoints()
	flag:SetPoint("TOPRIGHT", Minimap, "TOPRIGHT", 2, 2)
	flag:SetScale(.75)
	flag:SetFrameStrata("LOW")
end

-- Mail icon
MiniMapMailFrame:ClearAllPoints()
MiniMapMailFrame:SetPoint("BOTTOMRIGHT", Minimap, "BOTTOMRIGHT", 2, -6)
MiniMapMailFrame:SetFrameStrata("LOW")
MiniMapMailIcon:SetTexture(DB.mailTex)
MiniMapMailIcon:SetSize(21, 21)
MiniMapMailIcon:SetVertexColor(1, 1, 0)

-- Invites Icon
GameTimeCalendarInvitesTexture:ClearAllPoints()
GameTimeCalendarInvitesTexture:SetParent("Minimap")
GameTimeCalendarInvitesTexture:SetPoint("TOPRIGHT")
local Invt = CreateFrame("Button")
Invt:SetPoint("TOPRIGHT", Minimap, "BOTTOMLEFT", -20, -20)
Invt:SetSize(200, 50)
B.CreateBD(Invt)
B.CreateTex(Invt)
Invt.Text = Invt:CreateFontString(nil, "OVERLAY")
Invt.Text:SetFont(unpack(DB.Font))
Invt.Text:SetPoint("CENTER", Invt)
Invt.Text:SetText(DB.InfoColor..GAMETIME_TOOLTIP_CALENDAR_INVITES)
Invt:RegisterEvent("CALENDAR_UPDATE_PENDING_INVITES")
Invt:RegisterEvent("PLAYER_ENTERING_WORLD")
Invt:SetScript("OnEvent", function()
	if NDuiDB["Map"]["Invite"] and CalendarGetNumPendingInvites() > 0 then
		Invt:Show()
	else
		Invt:Hide()
	end
end)
Invt:RegisterForClicks("AnyUp")
Invt:SetScript("OnClick", function(self, btn)
	self:UnregisterAllEvents()
	if btn == "LeftButton" then
		ToggleCalendar()
	end
	Invt:Hide()
end)

-- Micro button alerts
if TalentMicroButtonAlert then
	TalentMicroButtonAlert:ClearAllPoints()
	TalentMicroButtonAlert:SetPoint("BOTTOMRIGHT", UIParent, "BOTTOMRIGHT", -220, 40)
	TalentMicroButtonAlert:SetScript("OnMouseUp", function(self, button)
		if not PlayerTalentFrame then LoadAddOn("Blizzard_TalentUI") end
		ToggleFrame(PlayerTalentFrame)
	end)
end

if EJMicroButtonAlert then
	EJMicroButtonAlert:ClearAllPoints()
	EJMicroButtonAlert:SetPoint("BOTTOM", UIParent, "BOTTOM", 40, 40)
	EJMicroButtonAlert:SetScript("OnMouseUp", function(self, button)
		if not EncounterJournal then LoadAddOn("Blizzard_EncounterJournal") end
		ToggleFrame(EncounterJournal)
	end)
end

if CollectionsMicroButtonAlert then
	CollectionsMicroButtonAlert:ClearAllPoints()
	CollectionsMicroButtonAlert:SetPoint("BOTTOM", UIParent, "BOTTOM", 65, 40)
	CollectionsMicroButtonAlert:SetScript("OnMouseUp", function(self, button)
		if not CollectionsJournal then LoadAddOn("Blizzard_Collections") end
		ToggleFrame(CollectionsJournal)
		CollectionsJournal_SetTab(CollectionsJournal, 2)
	end)
end

if TicketStatusFrame then
	TicketStatusFrame:ClearAllPoints()
	TicketStatusFrame:SetPoint("TOP", UIParent, "TOP", -400, -20)
	TicketStatusFrame.SetPoint = B.Dummy
end

-- Click func
Minimap:SetScript('OnMouseUp', function(self, btn)
Minimap:StopMovingOrSizing()
    if btn == "MiddleButton" then
        ToggleCalendar()
    elseif btn == "RightButton" then
        ToggleDropDownMenu(1, nil, MiniMapTrackingDropDown, self, - (Minimap:GetWidth()*.7), (Minimap:GetWidth()*.3))
    else
        Minimap_OnClick(self)
    end
end)

-- Clock
local c = CreateFrame("Frame")
c:RegisterEvent("PLAYER_ENTERING_WORLD")
c:SetScript("OnEvent", function()
	c:UnregisterEvent("PLAYER_ENTERING_WORLD")
	if NDuiDB["Map"]["Clock"] then
		if not TimeManagerClockButton then LoadAddOn("Blizzard_TimeManager") end
		local clockFrame, clockTime = TimeManagerClockButton:GetRegions()
		clockFrame:Hide()
		clockTime:SetFont(unpack(DB.Font))
		clockTime:SetTextColor(1, 1, 1)
		TimeManagerClockButton:SetPoint("BOTTOM", Minimap, "BOTTOM", 0, -6)
	else
		if TimeManagerClockButton then TimeManagerClockButton:Hide() end
		GameTimeFrame:Hide()
	end
end)