local B, C, L, DB = unpack(select(2, ...))
if not C.Chat.Enable then return end

-- Hook default elements
FCF_FadeInChatFrame = function(self)
	self.hasBeenFaded = true
end

FCF_FadeOutChatFrame = function(self)
	self.hasBeenFaded = false
end

FCFTab_UpdateColors = function(self, selected)
	if (selected) then
		self:SetAlpha(1)
		self:GetFontString():SetTextColor(unpack(C.Chat.TabColor1))
	else
		self:GetFontString():SetTextColor(unpack(C.Chat.TabColor2))
		self:SetAlpha(.3)
	end
end

for i = 1, 15 do
	CHAT_FONT_HEIGHTS[i] = i + 9
end

ChatFrameMenuButton.Show = B.Dummy
ChatFrameMenuButton:Hide()
QuickJoinToastButton.Show = B.Dummy
QuickJoinToastButton:Hide()
BNToastFrame:SetClampedToScreen(true)
BNToastFrame:SetClampRectInsets(-15, 15, 15, -15)
BNToastFrame:HookScript("OnShow", function(self)
	self:ClearAllPoints()
	self:SetPoint("BOTTOMLEFT", ChatFrame1Tab, "TOPLEFT", 0, 25)
end)

-- Reskin Chat
local function skinChat(self)
	if not self or (self and self.skinApplied) then return end

	local name = self:GetName()
	self:SetClampRectInsets(0, 0, 0, 0)
	self:SetMaxResize(UIParent:GetWidth(), UIParent:GetHeight())
	self:SetMinResize(100, 50)
	self:SetFont(STANDARD_TEXT_FONT, 14, "THINOUTLINE")
	self:SetShadowOffset(0, 0)
	self:SetShadowColor(0, 0, 0, .5)

	local frame = _G[name.."ButtonFrame"]
	frame:Hide()
	frame.Show = B.Dummy

	local eb = _G[name.."EditBox"]
	eb:SetAltArrowKeyMode(false)
	eb:ClearAllPoints()
	eb:SetPoint("BOTTOMLEFT", self, "TOPLEFT", 0, 24)
	eb:SetPoint("TOPRIGHT", self, "TOPRIGHT", -15, 54)
	B.CreateBD(eb)
	B.CreateTex(eb)
	for i = 3, 8 do
		select(i, eb:GetRegions()):SetAlpha(0)
	end
	eb:HookScript("OnEditFocusGained", function() eb:Show() end)
	eb:HookScript("OnEditFocusLost", function() eb:Hide() end)

	local lang = _G[name.."EditBoxLanguage"]
	lang:GetRegions():SetAlpha(0)
	lang:SetPoint("TOPLEFT", eb, "TOPRIGHT", -2, 0)
	lang:SetPoint("BOTTOMRIGHT", eb, "BOTTOMRIGHT", 28, 0)
	B.CreateBD(lang)
	B.CreateTex(lang)

	local tab = _G[name.."Tab"]
	tab:SetAlpha(1)
	local tabFs = tab:GetFontString()
	tabFs:SetFont(STANDARD_TEXT_FONT, 14, "THINOUTLINE")
	tabFs:SetShadowOffset(0, 0)
	tabFs:SetShadowColor(0, 0, 0, .5)
	tabFs:SetTextColor(unpack(C.Chat.TabColor1))
	for i = 1, 6 do
		select(i, tab:GetRegions()):SetTexture(nil)
	end
	select(8, tab:GetRegions()):SetTexture(nil)
	select(9, tab:GetRegions()):SetTexture(nil)
	select(10, tab:GetRegions()):SetTexture(nil)

	self.skinApplied = true
end

for i = 1, NUM_CHAT_WINDOWS do
	skinChat(_G["ChatFrame"..i])
end

hooksecurefunc("FCF_OpenTemporaryWindow", function()
	for _, chatFrameName in pairs(CHAT_FRAMES) do
		local frame = _G[chatFrameName]
		if frame.isTemporary then
			skinChat(frame)
		end
	end
end)

local function onEvent()
	-- Combatlogframe
	CombatLogQuickButtonFrame_CustomTexture:SetTexture(nil)

	-- Sticky
	if not NDuiDB["Chat"]["Sticky"] then
		ChatTypeInfo["WHISPER"].sticky = 0
		ChatTypeInfo["BN_WHISPER"].sticky = 0
	end

	-- Fading
	if NDuiDB["Chat"]["NoFade"] then
		for i = 1, 50 do
			if _G["ChatFrame" .. i] then
				_G["ChatFrame" .. i]:SetFading(false)
			end
		end
		hooksecurefunc("FCF_OpenTemporaryWindow", function()
			local cf = FCF_GetCurrentChatFrame():GetName() or nil
			if cf then
				_G[cf]:SetFading(false)
			end
		end)
	end

	-- Timestamp
	if NDuiDB["Chat"]["GreyStamp"] then
		TIMESTAMP_FORMAT_HHMM = DB.GreyColor.."[%I:%M]|r "
		TIMESTAMP_FORMAT_HHMMSS = DB.GreyColor.."[%I:%M:%S]|r "
		TIMESTAMP_FORMAT_HHMMSS_24HR = DB.GreyColor.."[%H:%M:%S]|r "
		TIMESTAMP_FORMAT_HHMMSS_AMPM = DB.GreyColor.."[%I:%M:%S %p]|r "
		TIMESTAMP_FORMAT_HHMM_24HR = DB.GreyColor.."[%H:%M]|r "
		TIMESTAMP_FORMAT_HHMM_AMPM = DB.GreyColor.."[%I:%M %p]|r "
	end

	-- Easy Resizing
	if NDuiDB["Chat"]["EasyResize"] then
		ChatFrame1Tab:HookScript("OnMouseDown", function(self, arg1)
			if arg1 == "LeftButton" then
				if select(8, GetChatWindowInfo(1)) then
					ChatFrame1:StartSizing("TOP")
				end
			end
		end)
		ChatFrame1Tab:SetScript("OnMouseUp", function(self, arg1)
			if arg1 == "LeftButton" then
				ChatFrame1:StopMovingOrSizing()
				FCF_SavePositionAndDimensions(ChatFrame1)
			end
		end)
	end

	-- ProfanityFilter
	if not BNFeaturesEnabledAndConnected() then return end
	if not NDuiDB["Chat"]["Freedom"] then
		SetCVar("profanityFilter", 1)
	else
		SetCVar("profanityFilter", 0)
	end
end

local event = CreateFrame("Frame")
event:RegisterEvent("PLAYER_LOGIN")
event:SetScript("OnEvent", onEvent)

-- Swith channels by Tab
local cycles = {
	{ chatType = "SAY", use = function(self, editbox) return 1 end },
    { chatType = "PARTY", use = function(self, editbox) return IsInGroup() end },
    { chatType = "RAID", use = function(self, editbox) return IsInRaid() end },
    { chatType = "INSTANCE_CHAT", use = function(self, editbox) return IsPartyLFG() end },
    { chatType = "GUILD", use = function(self, editbox) return IsInGuild() end },
	{ chatType = "CHANNEL", use = function(self, editbox)
		if DB.Client ~= "zhCN" then return false end
		local channels, inWorldChannel, number = {GetChannelList()}
		for i = 1, #channels do
			if channels[i] == L["World Channel Name"] then
				inWorldChannel = true
				number = channels[i-1]
				break
			end
		end
		if inWorldChannel then
			editbox:SetAttribute("channelTarget", number)
			return true
		else
			return false
		end
	end },
    { chatType = "SAY", use = function(self, editbox) return 1 end },
}

function ChatEdit_CustomTabPressed(self)
	if strsub(tostring(self:GetText()), 1, 1) == "/" then return end
    local currChatType = self:GetAttribute("chatType")
    for i, curr in ipairs(cycles) do
        if curr.chatType == currChatType then
            local h, r, step = i+1, #cycles, 1
            if IsShiftKeyDown() then h, r, step = i-1, 1, -1 end
            for j = h, r, step do
                if cycles[j]:use(self, currChatType) then
                    self:SetAttribute("chatType", cycles[j].chatType)
                    ChatEdit_UpdateHeader(self)
                    return
                end
            end
        end
    end
end

-- Quick Scroll
hooksecurefunc("FloatingChatFrame_OnMouseScroll", function(self, dir)
	if dir > 0 then
		if IsShiftKeyDown() then
			self:ScrollToTop()
		elseif IsControlKeyDown() then
			self:ScrollUp()
			self:ScrollUp()
		end
	else
		if IsShiftKeyDown() then
			self:ScrollToBottom()
		elseif IsControlKeyDown() then
			self:ScrollDown()
			self:ScrollDown()
		end
	end
end)

-- Autoinvite by whisper
local f = CreateFrame("frame")
f:RegisterEvent("CHAT_MSG_WHISPER")
f:RegisterEvent("CHAT_MSG_BN_WHISPER")
f:SetScript("OnEvent", function(self, event, arg1, arg2, _, _, _, _, _, _, _, _, _, _, arg3)
	if not NDuiDB["Chat"]["Invite"] then return end

	local list = {string.split(" ", NDuiDB["Chat"]["Keyword"])}
	for _, word in pairs(list) do
		if (not IsInGroup() or UnitIsGroupLeader("player") or UnitIsGroupAssistant("player")) and strlower(arg1) == strlower(word) then
			if event == "CHAT_MSG_BN_WHISPER" then
				local gameID = select(6, BNGetFriendInfoByID(arg3))
				local _, charName, _, realmName = BNGetGameAccountInfo(gameID)
				if CanCooperateWithGameAccount(gameID) and (not NDuiDB["Chat"]["GuildInvite"] or B.UnitInGuild(charName.."-"..realmName)) then
					BNInviteFriend(gameID)
				end
			else
				if not NDuiDB["Chat"]["GuildInvite"] or B.UnitInGuild(arg2) then
					InviteUnit(arg2)
				end
			end
		end
	end
end)