local B, C, L, DB = unpack(select(2, ...))
if not C.Chat.Enable then return end

local lines = {}

local frame = CreateFrame("Frame", nil, UIParent)
frame:SetPoint("CENTER", UIParent, "CENTER")
frame:SetSize(500, 400)
frame:Hide()
frame:SetFrameStrata("DIALOG")
B.CreateMF(frame)
B.CreateBD(frame)

local scrollArea = CreateFrame("ScrollFrame", "BCMCopyScroll", frame, "UIPanelScrollFrameTemplate")
scrollArea:SetPoint("TOPLEFT", frame, "TOPLEFT", 10, -30)
scrollArea:SetPoint("BOTTOMRIGHT", frame, "BOTTOMRIGHT", -30, 10)

local editBox = CreateFrame("EditBox", nil, frame)
editBox:SetMultiLine(true)
editBox:SetMaxLetters(99999)
editBox:EnableMouse(true)
editBox:SetAutoFocus(false)
editBox:SetFontObject(ChatFontNormal)
editBox:SetWidth(scrollArea:GetWidth())
editBox:SetHeight(270)
editBox:SetScript("OnEscapePressed", function(f) f:GetParent():GetParent():Hide() f:SetText("") end)
scrollArea:SetScrollChild(editBox)

local close = CreateFrame("Button", nil, frame, "UIPanelCloseButton")
close:SetPoint("TOPRIGHT", frame, "TOPRIGHT")
local copyFunc = function(self, btn)
	local cf = _G[format("%s%d", "ChatFrame", self:GetID())]
	local _, size = cf:GetFont()
	FCF_SetChatWindowFontSize(cf, cf, 0.01)
	local ct = 1
	for i = select("#", cf.FontStringContainer:GetRegions()), 1, -1 do
		local region = select(i, cf.FontStringContainer:GetRegions())
		if region:GetObjectType() == "FontString" then
			if region:GetText() then
				lines[ct] = tostring(region:GetText())
				ct = ct + 1
			end
		end
	end
	local lineCt = ct - 1
	local text = table.concat(lines, "\n", 1, lineCt)
	FCF_SetChatWindowFontSize(cf, cf, size)
	frame:Show()
	editBox:SetText(text)
	editBox:HighlightText(0)
	wipe(lines)
end
local hintFunc = function(self)
	GameTooltip:SetOwner(self, "ANCHOR_TOP")
	if SHOW_NEWBIE_TIPS == "1" then
		GameTooltip:AddLine(CHAT_OPTIONS_LABEL, 1, 1, 1)
		GameTooltip:AddLine(NEWBIE_TOOLTIP_CHATOPTIONS, nil, nil, nil, 1)
	end
	GameTooltip:AddLine(L["Chat Copy"], 0, 1, 0)
	GameTooltip:Show()
end
for i = 1, 10 do
	local tab = _G[format("%s%d%s", "ChatFrame", i, "Tab")]
	tab:SetScript("OnDoubleClick", copyFunc)
	tab:SetScript("OnEnter", hintFunc)
end

-- aurora reskin
if IsAddOnLoaded("Aurora") then
	local F = unpack(Aurora)
	F.ReskinClose(close)
	F.ReskinScroll(BCMCopyScrollScrollBar)
end