local B, C, L, DB = unpack(select(2, ...))
if DB.MyClass ~= "MONK" then return end

-- Stagger Master
local IconSize = C.Auras.IconSize
local bu, bar = {}
local function StaggerGo()
	bar = CreateFrame("StatusBar", "NDui_Stagger", UIParent)
	bar:SetSize(IconSize*4 + 15, 5)
	bar:SetPoint("CENTER", 0, -200)
	bar:SetFrameStrata("HIGH")
	B.CreateSB(bar, true)
	bar:SetMinMaxValues(0, 100)
	bar:SetValue(0)
	bar.Count = B.CreateFS(bar, 16, "", false, "TOPRIGHT", 0, -7)

	local spells = {115069, 115072, 115308, 124275}
	for i = 1, 4 do
		bu[i] = CreateFrame("Button", nil, UIParent, "SecureActionButtonTemplate")
		bu[i]:SetSize(IconSize, IconSize)
		bu[i]:SetFrameStrata("HIGH")
		B.CreateIF(bu[i])
		bu[i].Icon:SetTexture(GetSpellTexture(spells[i]))
		bu[i].Count = B.CreateFS(bu[i], 16, "")
		bu[i].Count:SetPoint("BOTTOMRIGHT", 2, -2)
		if i == 1 then
			bu[i]:SetPoint("BOTTOMLEFT", bar, "TOPLEFT", 0, 5)
			bu[i]:SetAttribute("type", "macro")
			bu[i]:SetAttribute("macrotext", "/click TotemFrameTotem1 RightButton")
		else
			bu[i]:SetPoint("LEFT", bu[i-1], "RIGHT", 5, 0)
		end
	end

	local Mover = B.Mover(bar, L["Toggle"], "Stagger", C.Auras.StaggerPos, bar:GetWidth(), 20)
	SlashCmdList["STAGGER"] = function(msg)
		if InCombatLockdown() then return end
		if msg:lower() == "reset" then
			wipe(NDuiDB["Stagger"])
			ReloadUI()
		else
			if Mover:IsVisible() then
				Mover:Hide()
			else
				Mover:Show()
			end
		end
	end
	SLASH_STAGGER1 = "/sb"
end

local f = CreateFrame("Frame")
f:RegisterEvent("PLAYER_LOGIN")
f:RegisterEvent("ACTIVE_TALENT_GROUP_CHANGED")
f:SetScript("OnEvent", function(self, event)
	if not NDuiDB["Auras"]["Stagger"] then
		f:UnregisterAllEvents()
		return
	end

	if event == "PLAYER_LOGIN" or event == "ACTIVE_TALENT_GROUP_CHANGED" then
		if GetSpecializationInfo(GetSpecialization()) ~= 268 then
			for i = 1, 4 do
				if bu[i] then bu[i]:Hide() end
			end
			if bar then bar:Hide() end

			f:UnregisterEvent("UNIT_AURA")
			f:UnregisterEvent("UNIT_MAXHEALTH")
			f:UnregisterEvent("PLAYER_TOTEM_UPDATE")
			f:UnregisterEvent("SPELL_UPDATE_COOLDOWN")
			f:UnregisterEvent("SPELL_UPDATE_CHARGES")
		else
			if not f.created then
				StaggerGo()
				f.created = true
			end
			for i = 1, 4 do
				bu[i]:Show()
				bu[i]:SetAlpha(.3)
			end
			bar:Show()
			bar:SetAlpha(.3)

			f:RegisterUnitEvent("UNIT_AURA", "player")
			f:RegisterEvent("UNIT_MAXHEALTH")
			f:RegisterEvent("PLAYER_TOTEM_UPDATE")
			f:RegisterEvent("SPELL_UPDATE_COOLDOWN")
			f:RegisterEvent("SPELL_UPDATE_CHARGES")
		end
	else
		-- Ox Statue
		do
			local haveStatue, name, start, dur = GetTotemInfo(1)
			if haveStatue and dur > 0 then
				bu[1]:SetAlpha(1)
				bu[1].CD:SetCooldown(start, dur)
			else
				bu[1]:SetAlpha(.3)
				bu[1].CD:SetCooldown(0, 0)
			end			
			bu[1]:SetScript("OnEnter", function(self)
				GameTooltip:Hide()
				GameTooltip:SetOwner(self, "ANCHOR_RIGHT", 0, 0)
				GameTooltip:ClearLines()
				GameTooltip:SetTotem(1)
				GameTooltip:Show()
			end)
			bu[1]:SetScript("OnLeave", GameTooltip_Hide)
		end

		-- Expel Harm
		do
			local count = GetSpellCount(115072)
			bu[2].Count:SetText(count)
			if count > 0 then
				bu[2]:SetAlpha(1)
			else
				bu[2]:SetAlpha(.3)
			end
			B.CreateAT(bu[2], 115072)
		end

		-- Ironskin Brew
		do
			local name, _, _, _, _, dur, exp = UnitBuff("player", GetSpellInfo(215479))
			local charges, maxCharges, chargeStart, chargeDuration = GetSpellCharges(115308)
			local start, duration = GetSpellCooldown(115308)
			bu[3].Count:SetText(charges)
			if name then
				bu[3]:SetAlpha(1)
				ClearChargeCooldown(bu[3])
				bu[3].CD:SetReverse(true)
				bu[3].CD:SetCooldown(exp - dur, dur)
				B.CreateAT(bu[3], name)
				ActionButton_ShowOverlayGlow(bu[3])
			else
				bu[3].CD:SetReverse(false)
				if charges < maxCharges and charges > 0 then
					StartChargeCooldown(bu[3], chargeStart, chargeDuration)
					bu[3].CD:SetCooldown(0, 0)
				elseif start and duration > 1.5 then
					ClearChargeCooldown(bu[3])
					bu[3].CD:SetCooldown(start, duration)
				elseif charges == maxCharges then
					bu[3]:SetAlpha(.3)
					ClearChargeCooldown(bu[3])
					bu[3].CD:SetCooldown(0, 0)
				end
				B.CreateAT(bu[3], 115308)
				ActionButton_HideOverlayGlow(bu[3])
			end
		end

		-- Stagger
		do
			local Total, Per
			local name, _, icon, _, _, duration, expire, _, _, _, _, _, _, _, _, _, value = UnitAura("player", GetSpellInfo(124275), "", "HARMFUL")
			if (not name) then name, _, icon, _, _, duration, expire, _, _, _, _, _, _, _, _, _, value = UnitAura("player", GetSpellInfo(124274), "", "HARMFUL") end
			if (not name) then name, _, icon, _, _, duration, expire, _, _, _, _, _, _, _, _, _, value = UnitAura("player", GetSpellInfo(124273), "", "HARMFUL") end
			if name and value > 0 and duration > 0 then
				Total = value * math.floor(duration)
				Per = Total / UnitHealthMax("player") * 100
				bar:SetAlpha(1)
				bu[4]:SetAlpha(1)
				bu[4].Icon:SetTexture(icon)
				bu[4].CD:SetCooldown(expire - 10, 10)
			else
				value = 0
				Per = 0
				bar:SetAlpha(.3)
				bu[4]:SetAlpha(.3)
				bu[4].Icon:SetTexture(GetSpellTexture(124275))
				bu[4].CD:SetCooldown(0, 0)
			end
			bar:SetValue(Per)
			bar.Count:SetText(DB.InfoColor..B.Numb(value).." "..DB.MyColor..B.Numb(Per).."%")
			if UnitAura("player", GetSpellInfo(124273), "", "HARMFUL") then
				ActionButton_ShowOverlayGlow(bu[4])
			else
				ActionButton_HideOverlayGlow(bu[4])
			end
		end
	end
end)