local B, C, L, DB = unpack(select(2, ...))
if DB.MyClass ~= "HUNTER" then return end

-- Marksman Master
local IconSize = C.Auras.IconSize + 3
local bu, bar = {}
local function MarksmanGo()
	bar = CreateFrame("StatusBar", "NDui_Marksman", UIParent)
	bar:SetSize(IconSize*5+20, 6)
	bar:SetFrameStrata("HIGH")
	B.CreateSB(bar, true)
	bar.Count = B.CreateFS(bar, 16, "", false, "CENTER", 0, -5)

	local spells = {187131, 194594, 204147, 185901, 214579}
	for i = 1, 5 do
		bu[i] = CreateFrame("Frame", nil, UIParent, "SecureActionButtonTemplate")
		bu[i]:SetSize(IconSize, IconSize)
		bu[i]:SetFrameStrata("HIGH")
		B.CreateIF(bu[i])
		bu[i].Icon:SetTexture(GetSpellTexture(spells[i]))
		bu[i].Count = B.CreateFS(bu[i], 16, "")
		bu[i].Count:SetPoint("TOP", 0, 15)
		if i == 1 then
			bu[i]:SetPoint("BOTTOMLEFT", bar, "TOPLEFT", 0, 5)
		else
			bu[i]:SetPoint("LEFT", bu[i-1], "RIGHT", 5, 0)
		end
	end

	local Mover = B.Mover(bar, L["Toggle"], "Marksman", C.Auras.MarksmanPos, bar:GetWidth(), 20)
	SlashCmdList["MARKSMAN"] = function(msg)
		if InCombatLockdown() then return end
		if msg:lower() == "reset" then
			wipe(NDuiDB["Marksman"])
			ReloadUI()
		else
			if Mover:IsVisible() then
				Mover:Hide()
			else
				Mover:Show()
			end
		end
	end
	SLASH_MARKSMAN1 = "/sb"
end

local f = CreateFrame("Frame")
f:RegisterEvent("PLAYER_LOGIN")
f:RegisterEvent("ACTIVE_TALENT_GROUP_CHANGED")
f:SetScript("OnEvent", function(self, event)
	if not NDuiDB["Auras"]["Marksman"] then
		f:UnregisterAllEvents()
		return
	end

	if event == "PLAYER_LOGIN" or event == "ACTIVE_TALENT_GROUP_CHANGED" then
		if GetSpecializationInfo(GetSpecialization()) ~= 254 or not IsPlayerSpell(214579) then
			for i = 1, 5 do
				if bu[i] then bu[i]:Hide() end
			end
			if bar then bar:Hide() end

			f:UnregisterEvent("UNIT_AURA")
			f:UnregisterEvent("PLAYER_TARGET_CHANGED")
			f:UnregisterEvent("UNIT_POWER_FREQUENT")
			f:UnregisterEvent("SPELL_UPDATE_COOLDOWN")
		else
			if not f.created then
				MarksmanGo()
				f.created = true
			end
			for i = 1, 5 do
				bu[i]:Show()
			end
			bar:Show()

			f:RegisterEvent("UNIT_AURA")
			f:RegisterEvent("PLAYER_TARGET_CHANGED")
			f:RegisterEvent("UNIT_POWER_FREQUENT")
			f:RegisterEvent("SPELL_UPDATE_COOLDOWN")
		end
	elseif event == "UNIT_POWER_FREQUENT" then
		local min, max = UnitPower("player"), UnitPowerMax("player")
		bar:SetMinMaxValues(0, max)
		bar:SetValue(min)
		bar.Count:SetText(min)
		bar:SetAlpha(1)
		if min > 120 then
			bar.Count:SetTextColor(1, 0, 0)
		elseif min > 70 then
			bar.Count:SetTextColor(1, 1, 0)
		elseif min < 50 then
			bar:SetAlpha(.3)
		else
			bar.Count:SetTextColor(1, 1, 1)
		end
	else
		-- Vulnerable
		do
			local name, _, _, _, _, duration, expire, caster = UnitDebuff("target", GetSpellInfo(187131))
			if name and caster == "player" then
				bu[1]:SetAlpha(1)
				bu[1].CD:SetCooldown(expire-duration, duration)
			else
				bu[1]:SetAlpha(.3)
				bu[1].CD:SetCooldown(0, 0)
			end
		end

		-- Tier 30: Black Arrow, True Aim, Lock & Load
		do
			if IsPlayerSpell(194599) then
				local start, duration = GetSpellCooldown(194599)
				if start and duration > 1.5 then
					bu[2]:SetAlpha(.3)
					bu[2].CD:SetCooldown(start, duration)
				else
					bu[2]:SetAlpha(1)
					bu[2].CD:SetCooldown(0, 0)
				end
				bu[2].Count:SetText("")
				bu[2].Icon:SetTexture(GetSpellTexture(194599))
			elseif IsPlayerSpell(199527) then
				local name, _, _, count, _, duration, expire = UnitDebuff("target", GetSpellInfo(199803))
				if name then
					bu[2]:SetAlpha(1)
					bu[2].CD:SetCooldown(expire-duration, duration)
					bu[2].Count:SetText(count)
				else
					bu[2]:SetAlpha(.3)
					bu[2].CD:SetCooldown(0, 0)
					bu[2].Count:SetText("")
				end
				bu[2].Icon:SetTexture(GetSpellTexture(199803))
			else
				local name, _, _, count, _, duration, expire = UnitBuff("player", GetSpellInfo(194594))
				if name then
					bu[2]:SetAlpha(1)
					bu[2].CD:SetCooldown(expire-duration, duration)
					bu[2].Count:SetText(count)
				else
					bu[2]:SetAlpha(.3)
					bu[2].CD:SetCooldown(0, 0)
					bu[2].Count:SetText("")
				end
				bu[2].Icon:SetTexture(GetSpellTexture(194594))
			end
		end

		-- Windburst, MM's Artifact
		do
			local start, duration = GetSpellCooldown(204147)
			if start and duration > 1.5 then
				bu[3]:SetAlpha(.3)
				bu[3].CD:SetCooldown(start, duration)
			else
				bu[3]:SetAlpha(1)
				bu[3].CD:SetCooldown(0, 0)
			end
		end

		-- Marked Shot
		do
			local name, _, _, _, _, duration, expire, caster = UnitDebuff("target", GetSpellInfo(185365))
			if name and caster == "player" then
				bu[4]:SetAlpha(1)
				bu[4].CD:SetCooldown(expire-duration, duration)
			else
				bu[4]:SetAlpha(.3)
				bu[4].CD:SetCooldown(0, 0)
			end
		end

		-- Sidewinders, spec at tier 100
		do
			local charges, maxCharges, chargeStart, chargeDuration = GetSpellCharges(214579)
			local start, duration = GetSpellCooldown(214579)
			bu[5].Count:SetText(charges)
			if charges < maxCharges and charges > 0 then
				StartChargeCooldown(bu[5], chargeStart, chargeDuration)
				bu[5].CD:SetCooldown(0, 0)
			elseif start and duration > 1.5 then
				ClearChargeCooldown(bu[5])
				bu[5].CD:SetCooldown(start, duration)
			elseif charges == maxCharges then
				ClearChargeCooldown(bu[5])
				bu[5].CD:SetCooldown(0, 0)
			end

			local hasBuff1 = UnitBuff("player", GetSpellInfo(223138))	-- Marking Targets
			local hasBuff2 = UnitBuff("player", GetSpellInfo(193526))	-- Trueshot
			if charges == maxCharges or hasBuff1 or hasBuff2 then
				bu[5].Count:SetTextColor(1, 0, 0)
				bu[5]:SetAlpha(1)
			else
				bu[5].Count:SetTextColor(1, 1, 1)
				bu[5]:SetAlpha(.3)
			end
		end
	end

	if not InCombatLockdown() then
		if not bar then return end
		for i = 1, 5 do
			bu[i]:SetAlpha(.1)
		end
		bar:SetAlpha(.1)
		bar.Count:SetText("")
		bu[5].Count:SetText("")
	end
end)