local B, C, L, DB = unpack(select(2, ...))

local _G, BuffFrame, TemporaryEnchantFrame = _G, BuffFrame, TemporaryEnchantFrame
local IconsPerRow = C.Auras.IconsPerRow
local BuffAnchor = CreateFrame("Frame", nil, UIParent)
BuffAnchor:SetPoint(unpack(C.Auras.BuffPos))
BuffAnchor:SetSize(30, 30)
TemporaryEnchantFrame:SetParent(BuffAnchor)
TemporaryEnchantFrame:ClearAllPoints()
TemporaryEnchantFrame:SetPoint("TOPRIGHT")

local function Style(Button)
	if not Button or (Button and Button.styled) then return end
	local name = Button:GetName()
	local Border = _G[name.."Border"]
	if Border then Border:Hide() end

	local Icon = _G[name.."Icon"]
	Icon:SetAllPoints()
	Icon:SetTexCoord(unpack(DB.TexCoord))
	Icon:SetDrawLayer("BACKGROUND", 1)

	local Duration = _G[name.."Duration"]
	Duration:ClearAllPoints()
	Duration:SetPoint("TOP", Button, "BOTTOM", 2, 2)
	Duration:SetFont(unpack(DB.Font))

	local Count = _G[name.."Count"]
	Count:ClearAllPoints()
	Count:SetParent(Button)
	Count:SetPoint("TOPRIGHT", Button, "TOPRIGHT", -1, -3)
	Count:SetFont(unpack(DB.Font))

	Button:SetSize(C.Auras.IconSize-2, C.Auras.IconSize-2)
	Button.HL = Button:CreateTexture(nil, "HIGHLIGHT")
	Button.HL:SetColorTexture(1, 1, 1, .3)
	Button.HL:SetAllPoints(Icon)
	B.CreateSD(Button, 3, 3, 0)

	Button.styled = true
end

local function MakeBuffFrame()
	local buff, previousBuff, aboveBuff, index
    local numBuffs = 0
    local slack = BuffFrame.numEnchants

    for i = 1, BUFF_ACTUAL_DISPLAY do
        buff = _G["BuffButton"..i]
		if not buff.styled then Style(buff) end
		numBuffs = numBuffs + 1
		index = numBuffs + slack
		buff:ClearAllPoints()
		if index > 1 and mod(index, IconsPerRow) == 1 then
			if index == IconsPerRow + 1 then
				buff:SetPoint("TOP", _G["BuffButton1"], "BOTTOM", 0, -12)
			else
				buff:SetPoint("TOP", aboveBuff, "BOTTOM", 0, -12)
			end
			aboveBuff = buff
		elseif index == 1 then
			buff:SetPoint("TOPRIGHT", BuffAnchor)
		else
			if numBuffs == 1 then
				if BuffFrame.numEnchants > 0 then
					buff:SetPoint("TOPRIGHT", TemporaryEnchantFrame, "TOPLEFT", -C.Auras.Spacing, 0)
				else
					buff:SetPoint("TOPRIGHT", _G["BuffButton1"], "TOPLEFT", -C.Auras.Spacing, 0)
				end
			else
				buff:SetPoint("RIGHT", previousBuff, "LEFT", -C.Auras.Spacing, 0)
			end
		end
		previousBuff = buff
    end
end
hooksecurefunc("BuffFrame_UpdateAllBuffAnchors", MakeBuffFrame)

for i = 1, NUM_TEMP_ENCHANT_FRAMES do
	local bu = _G["TempEnchant"..i]
	Style(bu)
end

local function MakeDebuffFrame(self, i)
	local Debuff = _G["DebuffButton"..i]
	Style(Debuff)
	local Pre = _G["DebuffButton"..(i-1)]
	Debuff:ClearAllPoints()
	if i == 1 then
		Debuff:SetPoint("TOPRIGHT", BuffAnchor, 0, -130)
	elseif i == IconsPerRow + 1 then
		Debuff:SetPoint("TOP", _G["DebuffButton1"], "BOTTOM", 0, -10)
	elseif i < IconsPerRow*2 + 1 then
		Debuff:SetPoint("RIGHT", Pre, "LEFT", -C.Auras.Spacing, 0)
	end
end
hooksecurefunc("DebuffButton_UpdateAnchors", MakeDebuffFrame)

local function FlashOnEnd(self, elapsed)
	if self.timeLeft < 10 then
		self:SetAlpha(BuffFrame.BuffAlphaValue)
	else
		self:SetAlpha(1)
	end
end
hooksecurefunc("AuraButton_OnUpdate", FlashOnEnd)