-----------------------------
-- INIT
-----------------------------
local B, C, L, DB = unpack(select(2, ...))
local cfg = C.bars.bar1
local dragFrameList = NDui.dragFrameList
local padding, margin = 2, 2
-----------------------------
-- FUNCTIONS
-----------------------------
if not cfg.enable then return end
local num = NUM_ACTIONBAR_BUTTONS
local buttonList = {}

--create the frame to hold the buttons
local frame = CreateFrame("Frame", "NDui_ActionBar1", UIParent, "SecureHandlerStateTemplate")
frame:SetWidth(num*cfg.size + (num-1)*margin + 2*padding)
frame:SetHeight(cfg.size + 2*padding)
frame:SetPoint("BOTTOM", UIParent, "BOTTOM", 0, 21)
frame:SetScale(cfg.scale)

--move the buttons into position and reparent them
MainMenuBarArtFrame:SetParent(frame)
MainMenuBarArtFrame:EnableMouse(false)

for i = 1, num do
	local button = _G["ActionButton"..i]
	table.insert(buttonList, button) --add the button object to the list
	button:SetSize(cfg.size, cfg.size)
	button:ClearAllPoints()
	if i == 1 then
		button:SetPoint("BOTTOMLEFT", frame, padding, padding)
	else
		local previous = _G["ActionButton"..i-1]
		button:SetPoint("LEFT", previous, "RIGHT", margin, 0)
	end
end

--show/hide the frame on a given state driver
frame.frameVisibility = "[petbattle] hide; show"
RegisterStateDriver(frame, "visibility", frame.frameVisibility)

--create drag frame and drag functionality
if C.bars.userplaced then
	rCreateDragFrame(frame, dragFrameList, -2 , true, L["Main Actionbar"]) --frame, dragFrameList, inset, clamp
end

--create the mouseover functionality
if cfg.mouseover.enable then
	rButtonBarFader(frame, buttonList, cfg.mouseover.fadeIn, cfg.mouseover.fadeOut) --frame, buttonList, fadeIn, fadeOut
	frame.mouseover = cfg.mouseover
end

--create the combat fader
if cfg.combat.enable then
	rCombatFrameFader(frame, cfg.combat.fadeIn, cfg.combat.fadeOut) --frame, buttonList, fadeIn, fadeOut
end

--fix stupid blizzard
local function ToggleButtonGrid()
	if InCombatLockdown() then return end
	local showgrid = tonumber(GetCVar("alwaysShowActionBars"))
	for i, button in next, buttonList do
		button:SetAttribute("showgrid", showgrid)
		ActionButton_ShowGrid(button)
	end
end
hooksecurefunc("MultiActionBar_UpdateGridVisibility", ToggleButtonGrid)

--_onstate-page state driver
local actionPage = "[overridebar]14;[shapeshift]13;[vehicleui]12;[possessbar]12;[bar:6]6;[bar:5]5;[bar:4]4;[bar:3]3;[bar:2]2;[bonusbar:5]11;[bonusbar:4]10;[bonusbar:3]9;[bonusbar:2]8;[bonusbar:1]7;1"
local buttonName = "ActionButton"
for i, button in next, buttonList do
	frame:SetFrameRef(buttonName..i, button)
end

frame:Execute(([[
	buttons = table.new()
	for i = 1, %d do
		table.insert(buttons, self:GetFrameRef("%s"..i))
	end
]]):format(num, buttonName))

frame:SetAttribute("_onstate-page", [[
	--print("_onstate-page", "index", newstate)
	for i, button in next, buttons do
		button:SetAttribute("actionpage", newstate)
	end
]])
RegisterStateDriver(frame, "page", actionPage)