local B, C, L, DB = unpack(select(2, ...))
  -- // slashcmd functionality
  -- // zork - 2012

  -----------------------------
  -- GLOBAL FUNCTIONS
  -----------------------------
  local InfoColor = "|cff70C0F5"

  --rCreateSlashCmdFunction func
  function rCreateSlashCmdFunction(addon, shortcut, dragFrameList, color)
    if not addon or not shortcut or not dragFrameList then return end
    local slashCmdFunction = function(cmd)
      if (cmd:match"unlock") then
        rUnlockAllFrames(dragFrameList, color..addon..": "..InfoColor..L["Unlock Actionbar"])
      elseif (cmd:match"lock") then
        rLockAllFrames(dragFrameList, color..addon..": "..InfoColor..L["Lock Actionbar"])
      elseif (cmd:match"reset") then
        rResetAllFramesToDefault(dragFrameList, color..addon..": "..InfoColor..L["Reset Actionbar"])
      else
        print(InfoColor.."------------------------")
        print("|cff0080ff"..addon.." "..InfoColor..L["Actionbar CMD"]..":")
        print(color.."\/"..shortcut.." lock|r "..InfoColor..L["Lock Actionbar"])
        print(color.."\/"..shortcut.." unlock|r "..InfoColor..L["Unlock Actionbar"])
        print(color.."\/"..shortcut.." reset|r "..InfoColor..L["Reset Actionbar"])
        print(InfoColor.."------------------------")
      end
    end
    return slashCmdFunction
  end