--------------------------
-- NDui Default Settings
--------------------------
local B, C, L, DB = unpack(select(2, ...))

-- Increase Chat History
for i = 1, 50 do
	if _G["ChatFrame"..i] and _G["ChatFrame"..i]:GetMaxLines() ~= 512 then
		_G["ChatFrame"..i]:SetMaxLines(512)
	end
end
hooksecurefunc("FCF_OpenTemporaryWindow", function()
	local cf = FCF_GetCurrentChatFrame():GetName() or nil
	if cf then
		if (_G[cf]:GetMaxLines() ~= 512) then
			_G[cf]:SetMaxLines(512)
		end
	end
end)

-- Addon Info
print("|cff0080ff< NDui >|cff70C0F5----------------")
print("|cff00ff00  LEG|c00ffff00 "..DB.Version.." |c0000ff00"..L["Version Info1"])
print("|c0000ff00  "..L["Version Info2"].."|c00ffff00 /ndui |c0000ff00"..L["Version Info3"])
print("|cff70C0F5------------------------")

-- Tuitorial
local function ForceDefaultSettings()
	SetCVar("autoLootDefault", 1)
	SetCVar("alwaysCompareItems", 0)
	SetCVar("useCompactPartyFrames", 1)
	SetCVar("lootUnderMouse", 1)
	SetCVar("autoSelfCast", 1)
	SetCVar("SpellTooltip_DisplayAvgValues", 1)
	SetCVar("nameplateShowEnemies", 1)
	SetCVar("nameplateShowSelf", 0)
	SetCVar("ShowClassColorInNameplate", 1)
	SetCVar("screenshotQuality", 10)
	SetCVar("showTutorials", 0)
	SetCVar("alwaysShowActionBars", 1)
	SetCVar("lockActionBars", 1)
	SetActionBarToggles(1, 1, 1, 1)
	SetCVar("chatStyle", "classic")
	SetCVar("enableFloatingCombatText", 1)
	SetCVar("floatingCombatTextCombatState", 1)
	SetCVar("floatingCombatTextCombatDamage", 1)
	SetCVar("floatingCombatTextCombatHealing", 1)
	SetCVar("floatingCombatTextCombatDamageDirectionalScale", 0)
	SetCVar("floatingCombatTextFloatMode", 1)
	SetCVar("doNotFlashLowHealthWarning", 1)
	SetCVar("ffxGlow", 0)
	SetCVar("autoQuestWatch", 1)
end

local function ForceRaidFrame()
	if not CompactUnitFrameProfiles.selectedProfile then return end
	SetRaidProfileOption(CompactUnitFrameProfiles.selectedProfile, "useClassColors", true)
	SetRaidProfileOption(CompactUnitFrameProfiles.selectedProfile, "displayPowerBar", true)
	SetRaidProfileOption(CompactUnitFrameProfiles.selectedProfile, "displayBorder", false)
	CompactUnitFrameProfiles_ApplyCurrentSettings()
	CompactUnitFrameProfiles_UpdateCurrentPanel()
end

local function ForceUIScale()
	Advanced_UseUIScale:Hide()
	Advanced_UIScaleSlider:Hide()
	SetCVar("useUiScale", 1)
	local scale = NDuiDB["Skins"]["SetScale"]
	if NDuiDB["Skins"]["UIScale"] then
		if GetCurrentResolution() ~= 0 then
			scale = .8*768/string.match(({GetScreenResolutions()})[GetCurrentResolution()], "%d+x(%d+)")
		end
		if scale < .5 then scale = .5 end
		NDuiDB["Skins"]["SetScale"] = scale
	end
	if scale < 0.64 then
		UIParent:SetScale(scale)
	else
		SetCVar("uiScale", scale)
	end
end

local function ForceChatSettings()
	FCF_SetLocked(ChatFrame1, nil)
	ChatFrame1:ClearAllPoints()
	ChatFrame1:SetPoint("BOTTOMLEFT", UIParent, "BOTTOMLEFT", 0, 28)
	ChatFrame1:SetWidth(380)
	ChatFrame1:SetHeight(190)
    ChatFrame1:SetUserPlaced(true)
	for i= 1, 10 do
		local cf = _G["ChatFrame"..i]
		FCF_SetWindowAlpha(cf, 0)
		ChatFrame_RemoveMessageGroup(cf,"CHANNEL")
	end
	local channels = {"SAY","EMOTE","YELL","GUILD","OFFICER","GUILD_ACHIEVEMENT","ACHIEVEMENT",
	"WHISPER","PARTY","PARTY_LEADER","RAID","RAID_LEADER","RAID_WARNING","INSTANCE_CHAT",
	"INSTANCE_CHAT_LEADER","CHANNEL1","CHANNEL2","CHANNEL3","CHANNEL4","CHANNEL5","CHANNEL6","CHANNEL7",
	}	
	for i, v in ipairs(channels) do
		ToggleChatColorNamesByClassGroup(true, v)
	end
	FCF_SavePositionAndDimensions(ChatFrame1)
	FCF_SetLocked(ChatFrame1, true)
	NDuiDB["Chat"]["Lock"] = true
end

StaticPopupDialogs["QUIT_TUTORIAL"] = {
	text = L["Quit Tutorial"],
	button1 = YES,
	button2 = NO,
	OnAccept = function()
		NDui_Tutorial:Hide()
	end,
}

StaticPopupDialogs["RELOAD_NDUI"] = {
	text = L["ReloadUI Required"],
	button1 = APPLY,
	button2 = CLASS_TRIAL_THANKS_DIALOG_CLOSE_BUTTON,
	OnAccept = function()
		ReloadUI()
	end,
}

-- DBM bars	
local function ForceDBMOptions()
	if not IsAddOnLoaded("DBM-Core") then return end
	if(DBT_AllPersistentOptions) then table.wipe(DBT_AllPersistentOptions) end
	DBT_AllPersistentOptions = {
		["Default"] = {
			["DBM"] = {
				["Scale"] = 1,
				["HugeScale"] = 1,
				["ExpandUpwards"] = true,
				["BarXOffset"] = 0,
				["BarYOffset"] = 15,
				["TimerPoint"] = "LEFT",
				["TimerX"] = 117.7955598588925,
				["TimerY"] = -114.8654337879873,
				["Width"] = 175,
				["Heigh"] = 20,
				["HugeWidth"] = 210,
				["HugeBarXOffset"] = 0,
				["HugeBarYOffset"] = 15,
				["HugeTimerPoint"] = "CENTER",
				["HugeTimerX"] = 330,
				["HugeTimerY"] = -42,
				["FontSize"] = 10,
				["StartColorR"] = 1,
				["StartColorG"] = 0.7019607843137254,
				["StartColorB"] = 0,
				["EndColorR"] = 1,
				["EndColorG"] = 0,
				["EndColorB"] = 0,
				["Texture"] = DB.normTex,
			},
		},
	}
end

-- Skada
local function ForceSkadaOptions()
	if not IsAddOnLoaded("Skada") then return end
	if(SkadaDB) then table.wipe(SkadaDB) end
	SkadaDB = {
		["hasUpgraded"] = true,
		["profiles"] = {
			["Default"] = {
				["windows"] = {
					{
						["barheight"] = 18,
						["classicons"] = false,
						["barslocked"] = true,
						["y"] = 24,
						["x"] = -5,
						["title"] = {
							["color"] = {
								["a"] = 0.3,
								["b"] = 0,
								["g"] = 0,
								["r"] = 0,
							},
							["font"] = "",
							["borderthickness"] = 0,
							["fontflags"] = "THINOUTLINE",
							["fontsize"] = 14,
							["texture"] = "normTex",
						},
						["barfontflags"] = "THINOUTLINE",
						["point"] = "BOTTOMRIGHT",
						["mode"] = "",
						["barwidth"] = 300,
						["barbgcolor"] = {
							["a"] = 0,
							["b"] = 0,
							["g"] = 0,
							["r"] = 0,
						},
						["barfontsize"] = 15,
						["background"] = {
							["height"] = 180,
							["texture"] = "None",
							["bordercolor"] = {
								["a"] = 0,
							},
						},
						["bartexture"] = "normTex",
					}, -- [1]
				},
				["icon"] = {
					["hide"] = true,
				},
				["tooltiprows"] = 10,
				["setstokeep"] = 30,
				["tooltippos"] = "topleft",
				["reset"] = {
					["join"] = 1,
				},
			},
		},
	}
end

local function gogogo()
	if not NDui_Tutorial then
		local f = CreateFrame("Frame", "NDui_Tutorial")
		f:SetPoint("CENTER")
		f:SetSize(400, 250)
		f:SetFrameStrata("HIGH")
		B.CreateMF(f)
		B.CreateBD(f)
		B.CreateTex(f)
		B.CreateFS(f, 30, "NDui", true, "TOPLEFT", 10, 25)

		f.Close = CreateFrame("Button", nil, f)
		f.Close:SetPoint("TOPRIGHT", -5, -5)
		f.Close:SetSize(20, 20)
		B.CreateBD(f.Close, 0.3)
		B.CreateFS(f.Close, 12, "X", true)
		B.CreateBC(f.Close)
		f.Close:SetScript("OnClick", function() StaticPopup_Show("QUIT_TUTORIAL") end)
		
		f.Title = f:CreateFontString(nil, "OVERLAY")
		f.Title:SetFont(unpack(DB.Font))
		f.Title:SetPoint("TOP", 0, -10)

		local ll = CreateFrame("Frame", nil, f)
		ll:SetPoint("TOP", -41, -32)
		B.CreateGF(ll, 80, .5, "Horizontal", .7, .7, .7, 0, 0.7)
		ll:SetFrameStrata("HIGH")
		local lr = CreateFrame("Frame", nil, f)
		lr:SetPoint("TOP", 41, -32)
		B.CreateGF(lr, 80, .5, "Horizontal", .7, .7, .7, 0.7, 0)
		lr:SetFrameStrata("HIGH")

		f.Body = f:CreateFontString(nil, "OVERLAY")
		f.Body:SetFont(unpack(DB.Font))
		f.Body:SetPoint("TOPLEFT", 20, -50)
		f.Body:SetPoint("BOTTOMRIGHT", -20, 50)
		f.Body:SetJustifyV("TOP")
		f.Body:SetJustifyH("LEFT")

		f.Foot = f:CreateFontString(nil, "OVERLAY")
		f.Foot:SetFont(unpack(DB.Font))
		f.Foot:SetPoint("BOTTOM", 0, 10)

		f.Load = CreateFrame("Button", "NDui_Load", f)
		f.Load:SetPoint("BOTTOMRIGHT", -10, 10)
		f.Load:SetSize(50, 20)
		B.CreateBD(f.Load, 0.3)
		B.CreateFS(f.Load, 12, APPLY, true)
		B.CreateBC(f.Load)

		f.Pass = CreateFrame("Button", "NDui_Pass", f)
		f.Pass:SetPoint("BOTTOMLEFT", 10, 10)
		f.Pass:SetSize(50, 20)
		B.CreateBD(f.Pass, 0.3)
		B.CreateFS(f.Pass, 12, L["Skip"], true)
		B.CreateBC(f.Pass)
	end
	NDui_Tutorial:Show()

	local function page5()
		NDui_Tutorial.Title:SetText(DB.InfoColor..L["Tips"])
		NDui_Tutorial.Body:SetText(L["Tutorial Page5"])
		NDui_Tutorial.Foot:SetText("5/5")
		NDui_Load:SetScript("OnClick", function()
			NDui_Tutorial:Hide()
			StaticPopup_Show("RELOAD_NDUI")
		end)
		NDui_Pass:SetScript("OnClick", function() StaticPopup_Show("QUIT_TUTORIAL") end)
	end	
	local function page4()
		NDui_Tutorial.Title:SetText(DB.InfoColor..ADDONS..SETTINGS)
		NDui_Tutorial.Body:SetText(L["Tutorial Page4"])
		NDui_Tutorial.Foot:SetText("4/5")
		NDui_Load:SetScript("OnClick", function()
			PlaySound("igQuestLogOpen")
			ForceDBMOptions()
			ForceSkadaOptions()
			UIErrorsFrame:AddMessage(DB.InfoColor..L["Tutorial Complete"])
			page5()
		end)
		NDui_Pass:SetScript("OnClick", function() page5() PlaySound("igQuestLogOpen") end)
	end	
	local function page3()
		NDui_Tutorial.Title:SetText(DB.InfoColor..L["ChatFrame"])
		NDui_Tutorial.Body:SetText(L["Tutorial Page3"])
		NDui_Tutorial.Foot:SetText("3/5")
		NDui_Load:SetScript("OnClick", function()
			PlaySound("igQuestLogOpen")
			ForceChatSettings()
			UIErrorsFrame:AddMessage(DB.InfoColor..L["Chat Settings Check"])
			page4()
		end)
		NDui_Pass:SetScript("OnClick", function() page4() PlaySound("igQuestLogOpen") end)
	end	
	local function page2()
		NDui_Tutorial.Title:SetText(DB.InfoColor..UI_SCALE)
		NDui_Tutorial.Body:SetText(L["Tutorial Page2"])
		NDui_Tutorial.Foot:SetText("2/5")
		NDui_Load:SetScript("OnClick", function()
			PlaySound("igQuestLogOpen")
			NDuiDB["Skins"]["UIScale"] = true
			ForceUIScale()
			UIErrorsFrame:AddMessage(DB.InfoColor..L["UIScale Check"])
			page3()
		end)
		NDui_Pass:SetScript("OnClick", function() page3() PlaySound("igQuestLogOpen") NDuiDB["Skins"]["UIScale"] = false end)
	end	
	local function page1()
		NDui_Tutorial.Title:SetText(DB.InfoColor..L["Default Settings"])
		NDui_Tutorial.Body:SetText(L["Tutorial Page1"])
		NDui_Tutorial.Foot:SetText("1/5")
		NDui_Load:SetScript("OnClick", function()
			PlaySound("igQuestLogOpen")
			ForceDefaultSettings()
			ForceRaidFrame()
			UIErrorsFrame:AddMessage(DB.InfoColor..L["Default Settings Check"])
			page2()
		end)
		NDui_Pass:SetScript("OnClick", function() page2() PlaySound("igQuestLogOpen") end)
	end
	page1()
end

local function HelloWorld()
	local c1, c2 = "|c00FFFF00", "|c0000FF00"
	local welcome = CreateFrame("Frame", "HelloWorld", UIParent)
	welcome:SetPoint("CENTER")
	welcome:SetSize(350, 400)
	welcome:SetScale(1.2)
	welcome:SetFrameStrata("HIGH")
	B.CreateMF(welcome)
	B.CreateBD(welcome)
	B.CreateTex(welcome)
	B.CreateFS(welcome, 30, "NDui", true, "TOPLEFT", 10, 25)
	B.CreateFS(welcome, 14, DB.Version, true, "TOPLEFT", 90, 12)
	B.CreateFS(welcome, 16, L["Help Title"], true, "TOP", 0, -10)
	local ll = CreateFrame("Frame", nil, welcome)
	ll:SetPoint("TOP", -51, -35)
	B.CreateGF(ll, 100, .5, "Horizontal", .7, .7, .7, 0, .7)
	ll:SetFrameStrata("HIGH")
	local lr = CreateFrame("Frame", nil, welcome)
	lr:SetPoint("TOP", 51, -35)
	B.CreateGF(lr, 100, .5, "Horizontal", .7, .7, .7, .7, 0)
	lr:SetFrameStrata("HIGH")
	B.CreateFS(welcome, 12, L["Help Info1"], false, "TOPLEFT", 20, -50)
	B.CreateFS(welcome, 12, L["Help Info2"], false, "TOPLEFT", 20, -70)
	B.CreateFS(welcome, 12, c1.." /ab "..c2..L["Help Info3"], false, "TOPLEFT", 20, -100)
	B.CreateFS(welcome, 12, c1.." /ar "..c2..L["Help Info4"], false, "TOPLEFT", 20, -120)
	B.CreateFS(welcome, 12, c1.." /aw "..c2..L["Help Info5"], false, "TOPLEFT", 20, -140)
	B.CreateFS(welcome, 12, c1.." /hb "..c2..L["Help Info6"], false, "TOPLEFT", 20, -160)
	B.CreateFS(welcome, 12, c1.." /omf "..c2..L["Help Info7"], false, "TOPLEFT", 20, -180)
	B.CreateFS(welcome, 12, c1.." /rl "..c2..L["Help Info8"], false, "TOPLEFT", 20, -200)
	B.CreateFS(welcome, 12, c1.." /rm "..c2..L["Help Info9"], false, "TOPLEFT", 20, -220)
	B.CreateFS(welcome, 12, c1.." /sb "..c2..L["Help Info10"], false, "TOPLEFT", 20, -240)
	B.CreateFS(welcome, 12, c1.." /cb "..c2..L["Help Info11"], false, "TOPLEFT", 20, -260)
	B.CreateFS(welcome, 12, c1.." /arc "..c2..L["Help Info15"], false, "TOPLEFT", 20, -280)
	B.CreateFS(welcome, 12, c1.." /ncl "..c2..L["Help Info12"], false, "TOPLEFT", 20, -300)
	B.CreateFS(welcome, 12, L["Help Info13"], false, "TOPLEFT", 20, -330)
	B.CreateFS(welcome, 12, L["Help Info14"], false, "TOPLEFT", 20, -350)
	local close = CreateFrame("Button", nil, welcome)
	close:SetPoint("TOPRIGHT", -10, -10)
	close:SetSize(20, 20)
	B.CreateBD(close, 0.3)
	B.CreateFS(close, 12, "X", true)
	B.CreateBC(close)
	close:SetScript("OnClick", function(self) welcome:Hide() end)
	local tutor = CreateFrame("Button", nil, welcome)
	tutor:SetPoint("BOTTOM", 0, 10)
	tutor:SetSize(100, 20)
	B.CreateBD(tutor, 0.3)
	B.CreateFS(tutor, 12, L["Tutorial"], true)
	B.CreateBC(tutor)
	tutor:SetScript("OnClick", function(self) welcome:Hide() gogogo() end)
end

local ndui = CreateFrame("Frame")
ndui:RegisterEvent("PLAYER_LOGIN")
ndui:SetScript("OnEvent", function()
	if not NDuiDB["Tutorial"]["Complete"] then
		HelloWorld()
		NDuiDB["Tutorial"]["Complete"] = true
	end

	ForceUIScale()
	if NDuiDB["Chat"]["Lock"] then ForceChatSettings() end
end)
SlashCmdList["NDUI"] = function()
	if not welcome then HelloWorld() else welcome:Show() end
end
SLASH_NDUI1 = "/ndui"