local B, C, L, DB = unpack(select(2, ...))

-- Default Settings
local defaultSettings = {
	Actionbar = {
		Hotkeys = true,
		Macro = true,
		Count = true,
		Classcolor = false,
		Cooldown = true,
		DecimalCD = true,
	},
	Auras = {
		Familiar = true,
		Reminder = true,
		Stagger = true,
		BloodHelper = true,
		Totems = true,
		DestroyTotems = true,
		Marksman = true,
	},
	AuraWatch = {
		Enable = true,
		Hint = true,
	},
	UFs = {
		Enable = true,
		Portrait = true,
		ClassColor = false,
		SmoothColor = false,
		PlayerDebuff = true,
		ToTAuras = false,
		Boss = true,
		Arena = true,
		ExpRep = false,
		Totems = false,
		ResourceBar = true,
		Castbars = true,
		AddPower = false,
		StealableBuff = true,
	},
	Chat = {
		Sticky = true,
		Lock = false,
		Invite = true,
		Freedom = true,
		Keyword = "raid",
		Oldname = false,
		GuildInvite = true,
		NoFade = false,
		GreyStamp = true,
		EasyResize = true,
		EnableFilter = true,
		Matches = 1,
		FilterList = "",
		AtList = "",
	},
	Map = {
		Coord = true,
		Invite = true,
		Clock = false,
		CombatPulse = false,
		HideFog = true,
		MapScale = 1.1,
	},
	Nameplate = {
		Enable = true,
		FriendlyCC = false,
		EnemyCC = true,
		Combat = false,
		MyFilter = 3,
		OtherFilter = 2,
		Height = 5,
		Width = 100,
		maxAuras = 5,
		AuraSize = 24,
		Arrow = true,
		ColorBorder = false,
		TankMode = false,
	},
	Skins = {
		UIScale = false,
		SetScale = .8,
		DBM = true,
		MicroMenu = true,
		Skada = true,
		RM = true,
		RMRune = false,
		DBMCount = "10",
		EasyMarking = true,
	},
	Tooltip = {
		CombatHide = false,
		Cursor = false,
		ClassColor = false,
		Scale = 1,
		HideTitle = false,
		HideRealm = false,
		HideRank = false,
		HidePVP = true,
		HideFaction = true,
		FactionIcon = true,
		LFDRole = false,
		TargetBy = false,
	},
	Misc = {
		Mail = true,
		Durability = true,
		HideErrors = true,
		SoloInfo = true,
		RareAlerter = true,
		AlertinChat = false,
		Focuser = true,
		Autoequip = true,
		ExpRep = true,
		Screenshot = false,
		TradeTab = true,
		RingAlerter = false,
		FasterLoot = true,
		AutoQuest = false,
		HideTalking = true,
	},
	Settings = {
		GUIScale = 1,
		Format = 1,
	},
	Tutorial = {
		Complete = false,
	},
}

local event = CreateFrame("Frame")
event:RegisterEvent("ADDON_LOADED")
event:SetScript("OnEvent", function(self, event, addon)
	if addon ~= "NDui" then return end
	self:UnregisterEvent("ADDON_LOADED")
	if not NDuiDB["LEGION"] then
		NDuiDB = {}
		NDuiDB["LEGION"] = true
	end

	for i, j in pairs(defaultSettings) do
		if type(j) == "table" then
			if NDuiDB[i] == nil then NDuiDB[i] = {} end
			for k, v in pairs(j) do
				if NDuiDB[i][k] == nil then
					NDuiDB[i][k] = v
				end
			end
		else
			if NDuiDB[i] == nil then NDuiDB[i] = j end
		end
	end
end)

-- Config
local tabList = {
	L["Actionbar"],
	L["Unitframes"],
	L["Auras"],
	L["Raid Tools"],
	L["ChatFrame"],
	L["Maps"],
	L["Nameplate"],
	L["Skins"],
	L["Tooltip"],
	L["Misc"],
	L["UI Settings"],
}

local optionList = {		--type, key, value, name, horizon, doubleline
	[1] = {
		{1, "Actionbar", "Hotkeys", L["Actionbar Hotkey"]},
		{1, "Actionbar", "Macro", L["Actionbar Macro"]},
		{1, "Actionbar", "Count", L["Actionbar Item Counts"]},
		{1, "Actionbar", "Classcolor", L["ClassColor BG"]},
		{},
		{1, "Actionbar", "Cooldown", L["Show Cooldown"]},
		{1, "Actionbar", "DecimalCD", L["Decimal Cooldown"], true},
	},
	[2] = {
		{1, "UFs", "Enable", L["Enable UFs"]},
		{},--blank
		{1, "UFs", "Boss", L["Boss Frame"]},
		{1, "UFs", "Arena", L["Arena Frame"], true},
		{1, "UFs", "Portrait", L["UFs Portrait"]},
		{1, "UFs", "Castbars", L["UFs Castbar"], true},
		{1, "UFs", "ClassColor", L["Classcolor HpBar"]},
		{1, "UFs", "SmoothColor", L["Smoothcolor HpBar"], true},
		{1, "UFs", "PlayerDebuff", L["Player Debuff"]},
		{1, "UFs", "ToTAuras", L["ToT Debuff"], true},
		{1, "UFs", "StealableBuff", L["Stealable Buff"]},
		{},--blank
		{1, "UFs", "ExpRep", L["UFs Expbar"]},
		{1, "UFs", "Totems", L["UFs Totems"], true},
		{1, "UFs", "ResourceBar", L["UFs Resource"]},
		{1, "UFs", "AddPower", L["UFs ExtraMana"], true},
	},
	[3] = {
		{1, "AuraWatch", "Enable", L["Enable AuraWatch"]},
		{1, "AuraWatch", "Hint", L["AuraWatch Tooltip"]},
		{},--blank
		{1, "Auras", "Reminder", L["Enable Reminder"]},
		{1, "Auras", "Familiar", L["Enable Familiar"]},
		{1, "Auras", "BloodHelper", L["Enable BloodHelper"]},
		{1, "Auras", "Stagger", L["Enable Stagger"]},
		{1, "Auras", "Totems", L["Enable Totems"]},
		{1, "Auras", "DestroyTotems", L["Destroy Totems"], true},
		{1, "Auras", "Marksman", L["Enable Marksman"]},
	},
	[4] = {
		{1, "Skins", "RM", L["Raid Manger"]},
		{1, "Skins", "RMRune", L["Runes Check"], true},
		{1, "Skins", "EasyMarking", L["Easy Mark"]},
		{1, "Misc", "RingAlerter", L["Legendary Ring"], true},
		{2, "Skins", "DBMCount", L["Countdown Sec"]},
		{},--blank
		{1, "Chat", "Invite", L["Whisper Invite"]},
		{1, "Chat", "GuildInvite", L["Guild Invite Only"], true},
		{2, "Chat", "Keyword", L["Whisper Keyword"]},
	},
	[5] = {
		{1, "Chat", "Lock", L["Lock Chat"]},
		{},--blank
		{1, "Chat", "Freedom", L["Language Filter"]},
		{1, "Chat", "Sticky", L["Chat Sticky"], true},
		{1, "Chat", "Oldname", L["Default Channel"]},
		{1, "Chat", "NoFade", L["Chat Nofade"], true},
		{1, "Chat", "GreyStamp", L["Timestamp"]},
		{1, "Chat", "EasyResize", L["Resizing"], true},
		{2, "Chat", "AtList", L["@List"]},
		{},--blank
		{1, "Chat", "EnableFilter", L["Enable Chatfilter"]},
		{3, "Chat", "Matches", L["Keyword Match"], false, {1, 3, 0}},
		{2, "Chat", "FilterList", L["Filter List"], true},
	},
	[6] = {
		{1, "Map", "Coord", L["Map Coords"]},
		{3, "Map", "MapScale", L["Map Scale"], false, {.5, 1.5, 1}},
		{},--blank
		{1, "Map", "Invite", L["Calendar Reminder"]},
		{1, "Map", "Clock", L["Minimap Clock"]},
		{1, "Map", "CombatPulse", L["Minimap Pulse"]},
		{1, "Misc", "ExpRep", L["Show Expbar"]},
	},
	[7] = {
		{1, "Nameplate", "Enable", L["Enable Nameplate"]},
		{1, "Nameplate", "TankMode", L["Tank Mode"], true},
		{1, "Nameplate", "FriendlyCC", L["Friend CC"]},
		{1, "Nameplate", "EnemyCC", L["Enemy CC"], true},
		{1, "Nameplate", "Combat", L["Combat Show"]},
		{1, "Nameplate", "Arrow", L["Show Arrow"], true},
		{3, "Nameplate", "Width", L["NP Width"], false, {50, 150, 0}},
		{3, "Nameplate", "Height", L["NP Height"], true, {5, 15, 0}},
		{},--blank
		{1, "Nameplate", "ColorBorder", L["Auras Border"]},
		{3, "Nameplate", "maxAuras", L["Max Auras"], false, {0, 10, 0}},
		{3, "Nameplate", "AuraSize", L["Auras Size"], true, {18, 30, 0}},
		{4, "Nameplate", "MyFilter", L["My Filter"], false, {L["Block All"], L["Show All"], L["Aura Whitelist"], L["Aura Blacklist"]}},
		{4, "Nameplate", "OtherFilter", L["Other Filter"], true, {L["Block All"], L["Aura Whitelist"]}},
	},
	[8] = {
		{1, "Skins", "UIScale", L["Lock UIScale"]},
		{3, "Skins", "SetScale", L["Setup UIScale"], false, {.5, 1.1, 2}},
		{},--blank
		{1, "Skins", "DBM", L["DBM Skin"]},
		{1, "Skins", "Skada", L["Skada Skin"]},
		{1, "Skins", "MicroMenu", L["Micromenu"]},
	},
	[9] = {
		{1, "Tooltip", "CombatHide", L["Hide Tooltip"]},
		{1, "Tooltip", "Cursor", L["Follow Cursor"]},
		{1, "Tooltip", "ClassColor", L["Classcolor Border"], true},
		{3, "Tooltip", "Scale", L["Tooltip Scale"], false, {0.5, 1.5, 1}},
		{},--blank
		{1, "Tooltip", "HideTitle", L["Hide Title"]},
		{1, "Tooltip", "HideRealm", L["Hide Realm"], true},
		{1, "Tooltip", "HideRank", L["Hide Rank"]},
		{1, "Tooltip", "HidePVP", L["Hide PVP"], true},
		{1, "Tooltip", "HideFaction", L["Hide Faction"]},
		{1, "Tooltip", "FactionIcon", L["FactionIcon"], true},
		{1, "Tooltip", "LFDRole", L["Group Roles"]},
		{1, "Tooltip", "TargetBy", L["Show TargetedBy"], true},
	},
	[10] = {
		{1, "Misc", "Mail", L["Mail Tool"]},
		{1, "Misc", "Durability", L["Show Durability"]},
		{1, "Misc", "HideErrors", L["Hide Error"]},
		{1, "Misc", "SoloInfo", L["SoloInfo"]},
		{1, "Misc", "RareAlerter", L["Rare Alert"]},
		{1, "Misc", "AlertinChat", L["Alert In Chat"], true},
		{1, "Misc", "Focuser", L["Easy Focus"]},
		{1, "Misc", "Autoequip", L["Auto Equip"]},
		{1, "Misc", "Screenshot", L["Auto ScreenShot"]},
		{1, "Misc", "TradeTab", L["TradeTabs"]},
		{1, "Misc", "FasterLoot", L["Faster Loot"]},
		{1, "Misc", "HideTalking", L["No Talking"]},
	},
	[11] = {
		{3, "Settings", "GUIScale", L["GUI Scale"], false, {0.5, 1.5, 1}},
		{4, "Settings", "Format", L["Numberize"], false, {L["Number Type1"], L["Number Type2"], L["Number Type3"]}},
	},
}

local r, g, b = DB.cc.r, DB.cc.g, DB.cc.b
local f = CreateFrame("Frame", "NDuiGUI", UIParent)
tinsert(UISpecialFrames, "NDuiGUI")
f:Hide()
local guiTab, guiPage, x, y = {}, {}

local function SelectTab(i)
	for num = 1, #tabList do
		if num == i then
			guiTab[num]:SetBackdropColor(r, g, b, .3)
			guiTab[num].checked = true
			guiPage[num]:Show()
		else
			guiTab[num]:SetBackdropColor(0, 0, 0, .3)
			guiTab[num].checked = false
			guiPage[num]:Hide()
		end
	end
end

local function CreateTab(i, name)
	local tab = CreateFrame("Button", nil, NDuiGUI)
	tab:SetPoint("TOPLEFT", 30, -(28*i + 40))
	tab:SetSize(130, 26)
	B.CreateBD(tab, .3, 1)
	local label = B.CreateFS(tab, 15, name, false, "LEFT", 15, 0)
	label:SetTextColor(1, .8, 0)

	tab:SetScript("OnClick", function(self)
		PlaySound("gsTitleOptionOK")
		SelectTab(i)
	end)
	tab:SetScript("OnEnter", function(self)
		if self.checked then return end
		self:SetBackdropColor(r, g, b, .3)
	end)
	tab:SetScript("OnLeave", function(self)
		if self.checked then return end
		self:SetBackdropColor(0, 0, 0, .3)
	end)
	return tab
end

local function CreateOption(i)
	local offset = 20
	for _, option in pairs(optionList[i]) do
		local type, key, value, name, horizon, data = unpack(option)
		-- Checkboxes
		if type == 1 then
			local f = CreateFrame("CheckButton", nil, guiPage[i], "InterfaceOptionsCheckButtonTemplate")
			if horizon then
				f:SetPoint("TOPLEFT", 300, -offset + 35)
			else
				f:SetPoint("TOPLEFT", 20, -offset)
				offset = offset + 35
			end
			B.CreateCB(f)
			B.CreateFS(f, 14, name, false, "LEFT", 30, 0)
			f:SetChecked(NDuiDB[key][value])
			f:SetScript("OnClick", function()
				NDuiDB[key][value] = f:GetChecked()
			end)
		-- Ediebox
		elseif type == 2 then
			local e = CreateFrame("EditBox", nil, guiPage[i])
			e:SetAutoFocus(false)
			e:SetSize(200, 30)
			e:SetMaxLetters(200)
			e:SetTextInsets(10, 10, 0, 0)
			e:SetFontObject(GameFontHighlight)
			if horizon then
				e:SetPoint("TOPLEFT", 315, -offset + 50)
			else
				e:SetPoint("TOPLEFT", 35, -offset - 20)
				offset = offset + 70
			end
			e:SetText(NDuiDB[key][value])
			B.CreateBD(e, .3)
			e:SetScript("OnEscapePressed", function()
				e:ClearFocus()
				e:SetText(NDuiDB[key][value])
			end)
			e:SetScript("OnEnterPressed", function()
				e:ClearFocus()
				NDuiDB[key][value] = e:GetText()
			end)
			local label = B.CreateFS(e, 14, name, false, "CENTER", 0, 25)
			label:SetTextColor(1, .8, 0)
		-- Slider
		elseif type == 3 then
			local min, max, step = unpack(data)
			local s = CreateFrame("Slider", key..value.."Slider", guiPage[i], "OptionsSliderTemplate")
			if horizon then
				s:SetPoint("TOPLEFT", 320, -offset + 40)
			else
				s:SetPoint("TOPLEFT", 40, -offset - 30)
				offset = offset + 70
			end
			s:SetWidth(190)
			s:SetMinMaxValues(min, max)
			s:SetValue(NDuiDB[key][value])
			s:SetScript("OnValueChanged", function(self, v)
				local current = tonumber(format("%."..step.."f", v))
				NDuiDB[key][value] = current
				_G[s:GetName().."Text"]:SetText(current)
			end)

			local label = B.CreateFS(s, 14, name, false, "CENTER", 0, 25)
			label:SetTextColor(1, .8, 0)
			_G[s:GetName().."Low"]:SetText(min)
			_G[s:GetName().."High"]:SetText(max)
			_G[s:GetName().."Text"]:ClearAllPoints()
			_G[s:GetName().."Text"]:SetPoint("TOP", s, "BOTTOM", 0, 3)
			_G[s:GetName().."Text"]:SetText(NDuiDB[key][value])
			s:SetBackdrop(nil)
			s.SetBackdrop = B.Dummy
			local bd = CreateFrame("Frame", nil, s)
			bd:SetPoint("TOPLEFT", 14, -2)
			bd:SetPoint("BOTTOMRIGHT", -15, 3)
			bd:SetFrameStrata("BACKGROUND")
			B.CreateBD(bd, .3)
			local slider = select(4, s:GetRegions())
			slider:SetTexture("Interface\\CastingBar\\UI-CastingBar-Spark")
			slider:SetBlendMode("ADD")
		-- Dropdown
		elseif type == 4 then
			local f = CreateFrame("Frame", nil, guiPage[i])
			if horizon then
				f:SetPoint("TOPLEFT", 315, -offset + 50)
			else
				f:SetPoint("TOPLEFT", 35, -offset - 20)
				offset = offset + 70
			end
			f:SetSize(200, 30)
			B.CreateBD(f, .3)		
			local t = B.CreateFS(f, 14, data[NDuiDB[key][value]])
			local b = CreateFrame("Button", nil, f)
			b:SetPoint("LEFT", f, "RIGHT")
			b:SetSize(22, 22)
			b.Icon = b:CreateTexture(nil, "ARTWORK")
			b.Icon:SetAllPoints()
			b.Icon:SetTexture(DB.gearTex)
			b.Icon:SetTexCoord(0, .5, 0, .5)
			b:SetHighlightTexture(DB.gearTex)
			b:GetHighlightTexture():SetTexCoord(0, .5, 0, .5)
			local l = CreateFrame("Frame", nil, f)
			l:SetPoint("TOP", f, "BOTTOM")
			B.CreateBD(l, .3)
			b:SetScript("OnShow", function() l:Hide() end)
			local label = B.CreateFS(f, 14, name, false, "CENTER", 0, 25)
			label:SetTextColor(1, .8, 0)

			local opt = {}
			local function selectOpt(i)
				for num = 1, #data do
					if num == i then
						opt[num]:SetBackdropColor(1, .8, 0, .3)
						opt[num].checked = true
					else
						opt[num]:SetBackdropColor(0, 0, 0, .3)
						opt[num].checked = false
					end
				end
				NDuiDB[key][value] = i
				t:SetText(data[i])
			end
			for i, j in pairs(data) do
				opt[i] = CreateFrame("Button", nil, l)
				opt[i]:SetPoint("TOPLEFT", 5, -5 - (i-1)*30)
				opt[i]:SetSize(190, 30)
				B.CreateBD(opt[i], .3)
				B.CreateFS(opt[i], 14, j, false, "LEFT", 8, 0)
				opt[i]:SetScript("OnClick", function(self)
					PlaySound("gsTitleOptionOK")
					selectOpt(i)
					l:Hide()
				end)
				opt[i]:SetScript("OnEnter", function(self)
					if self.checked then return end
					self:SetBackdropColor(1, 1, 1, .3)
				end)
				opt[i]:SetScript("OnLeave", function(self)
					if self.checked then return end
					self:SetBackdropColor(0, 0, 0, .3)
				end)
				b:SetScript("OnClick", function()
					PlaySound("gsTitleOptionOK")
					if l:IsShown() then l:Hide() else l:Show() end
					selectOpt(NDuiDB[key][value])
				end)
				l:SetSize(200, i*30 + 10)
			end			
		-- String
		elseif type == 5 then
			local fs = guiPage[i]:CreateFontString(nil, "OVERLAY")
			fs:SetFont(DB.Font[1], 12, DB.Font[3])
			fs:SetText(name)
			fs:SetTextColor(1, .8, 0)
			if horizon then
				fs:SetPoint("TOPLEFT", 255, -offset + 30)
			else
				fs:SetPoint("TOPLEFT", 25, -offset - 5)
				offset = offset + 35
			end
		-- Blank, no type
		else
			local l = CreateFrame("Frame", nil, guiPage[i])
			l:SetPoint("TOPLEFT", 25, -offset - 12)
			B.CreateGF(l, 500, .5, "Horizontal", .7, .7, .7, .7, 0)
			l:SetFrameStrata("HIGH")
			offset = offset + 35
		end
	end
end

local function OpenGUI()
	if InCombatLockdown() then UIErrorsFrame:AddMessage(DB.InfoColor..ERR_NOT_IN_COMBAT) return end
	if f.created then f:Show() return end
	f:SetScale(NDuiDB["Settings"]["GUIScale"])

	-- Main Frame
	f:SetSize(800, 600)
	f:SetPoint("CENTER")
	f:SetFrameStrata("HIGH")
	B.CreateMF(f)
	B.CreateBD(f)
	B.CreateTex(f)
	B.CreateFS(f, 18, L["NDui Console"], true, "TOP", 0, -10)
	B.CreateFS(f, 16, DB.Version, false, "TOP", 0, -30)

	local lu = CreateFrame("Frame", nil, f)
	lu:SetPoint("BOTTOMLEFT", f, "LEFT", 180, 1)
	B.CreateGF(lu, .5, 250, "Vertical", .7, .7, .7, .7, 0)
	lu:SetFrameStrata("HIGH")
	local ld = CreateFrame("Frame", nil, f)
	ld:SetPoint("TOPLEFT", f, "LEFT", 180, -1)
	B.CreateGF(ld, .5, 250, "Vertical", .7, .7, .7, 0, .7)
	ld:SetFrameStrata("HIGH")

	local close = CreateFrame("Button", nil, f)
	close:SetPoint("BOTTOMRIGHT", -30, 15)
	close:SetSize(80, 20)
	B.CreateBD(close, 0.3, 2)
	B.CreateBC(close)
	B.CreateFS(close, 14, CLOSE, true)
	close:SetScript("OnClick", function(self)
		f:Hide()
	end)
	local ok = CreateFrame("Button", nil, f)
	ok:SetPoint("RIGHT", close, "LEFT", -10, 0)
	ok:SetSize(80, 20)
	B.CreateBD(ok, 0.3, 2)
	B.CreateBC(ok)
	B.CreateFS(ok, 14, OKAY, true)
	ok:SetScript("OnClick", function(self)
		local scale = NDuiDB["Skins"]["SetScale"]
		if scale < 0.64 then
			UIParent:SetScale(scale)
		else
			SetCVar("uiScale", scale)
		end
		f:Hide()
		StaticPopup_Show("RELOAD_NDUI")
	end)

	for i, name in pairs(tabList) do
		guiTab[i] = CreateTab(i, name)
		guiPage[i] = CreateFrame("Frame", nil, NDuiGUI)
		guiPage[i]:SetPoint("TOPLEFT", 200, -60)
		guiPage[i]:SetSize(570, 500)
		B.CreateBD(guiPage[i], .3, 1)
		guiPage[i]:Hide()
		CreateOption(i)
	end

	local reset = CreateFrame("Button", nil, f)
	reset:SetPoint("BOTTOMLEFT", 30, 15)
	reset:SetSize(120, 20)
	B.CreateBD(reset, 0.3, 2)
	B.CreateBC(reset)
	B.CreateFS(reset, 14, L["NDui Reset"], true)
	StaticPopupDialogs["RESET_NDUI"] = {
		text = L["Reset NDui Check"],
		button1 = YES,
		button2 = NO,
		OnAccept = function()
			NDuiDB = {}
			ReloadUI()
		end,
		whileDead = 1,
	}
	reset:SetScript("OnClick", function(self)
		StaticPopup_Show("RESET_NDUI")
	end)

	f:Show()
	SelectTab(1)
	f.created = true
end

local gui = CreateFrame("Button", "GameMenuFrameNDui", GameMenuFrame, "GameMenuButtonTemplate")
gui:SetText(L["NDui Console"])
gui:SetPoint("TOP", GameMenuButtonAddons, "BOTTOM", 0, -21)
GameMenuFrame:HookScript("OnShow", function(self)
	GameMenuButtonLogout:SetPoint("TOP", gui, "BOTTOM", 0, -21)
	self:SetHeight(self:GetHeight() + gui:GetHeight() + 22)
end)

gui:SetScript("OnClick", function()
	OpenGUI()
	HideUIPanel(GameMenuFrame)
	PlaySound("igMainMenuOption")
end)

-- Aurora Reskin
if IsAddOnLoaded("Aurora") then
	F = unpack(Aurora)
	F.Reskin(gui)
end