local _, _, L, DB = unpack(select(2, ...))
NDuiADB = NDuiADB or {}
NDuiDB = NDuiDB or {}
DB.Version = GetAddOnMetadata("NDui", "Version")
DB.Client = GetLocale()

-- Colors
DB.MyClass = select(2, UnitClass("player"))
DB.cc = (CUSTOM_CLASS_COLORS or RAID_CLASS_COLORS)[DB.MyClass]
DB.MyColor = format("|cff%02x%02x%02x", DB.cc.r*255, DB.cc.g*255, DB.cc.b*255)
DB.InfoColor = "|cff70C0F5"
DB.GreyColor = "|cffB5B5B5"

-- Fonts
DB.Font = {STANDARD_TEXT_FONT, 12, "THINOUTLINE"}
DB.TipFont = {GameTooltipText:GetFont(), 14, 0}

local function FontRestyle(font, size, noOutline)
	font:SetFont(STANDARD_TEXT_FONT, size, noOutline and "" or "THINOUTLINE")
	font:SetShadowOffset(0, 0)
	font:SetShadowColor(0, 0, 0, 0)
end
FontRestyle(ChatFontNormal, 16)
FontRestyle(TextStatusBarText, 14, true)
FontRestyle(NumberFontNormal, 14)
FontRestyle(NumberFontNormalSmall, 13)

-- Textures
local Media = "Interface\\Addons\\NDui\\Media\\"
DB.bdTex = "Interface\\ChatFrame\\ChatFrameBackground"
DB.glowTex = Media.."glowTex"
DB.normTex = Media.."normTex"
DB.mailTex = "Interface\\Minimap\\Tracking\\Mailbox"
DB.gearTex = "Interface\\WorldMap\\Gear_64"
DB.Micro = Media.."MicroMenu\\"
DB.bgTex = Media.."bgTex"
DB.TexCoord = {.08, .92, .08, .92}
DB.textures = {
    normal            = Media.."ActionBar\\gloss",
    flash             = Media.."ActionBar\\flash",
    pushed            = Media.."ActionBar\\pushed",
    checked           = Media.."ActionBar\\checked",
    equipped          = Media.."ActionBar\\gloss_grey",
}
DB.LeftButton = " |TInterface\\TUTORIALFRAME\\UI-TUTORIAL-FRAME:14:12:0:-1:512:512:12:66:230:307|t "
DB.RightButton = " |TInterface\\TUTORIALFRAME\\UI-TUTORIAL-FRAME:14:12:0:-1:512:512:12:66:333:411|t "
DB.ScrollButton = " |TInterface\\TUTORIALFRAME\\UI-TUTORIAL-FRAME:14:12:0:-1:512:512:12:66:127:204|t "

-- RoleUpdater
local RoleUpdater = CreateFrame("Frame")
local function CheckRole(self, event, unit)
	local tree = GetSpecialization()
	if not tree then return end
	local _, _, _, _, _, role, stat = GetSpecializationInfo(tree)
	if role == "TANK" then
		DB.Role = "Tank"
	elseif role == "HEALER" then
		DB.Role = "Healer"
	elseif role == "DAMAGER" then
		if stat == 4 then	--1力量，2敏捷，4智力
			DB.Role = "Caster"
		else
			DB.Role = "Melee"
		end
	end
end
RoleUpdater:RegisterEvent("PLAYER_LOGIN")
RoleUpdater:RegisterEvent("PLAYER_TALENT_UPDATE")
RoleUpdater:SetScript("OnEvent", CheckRole)

-- Raidbuff Checklist
DB.BuffList = {
	[1] = {		-- 合剂
		188031,	-- 1300智力
		188033,	-- 1300敏捷
		188034,	-- 1300力量
		188035,	-- 1950耐力
	},
	[2] = {     -- 进食充分
		104273, -- 250敏捷，BUFF名一致
	},
	[3] = {     -- 符文
		224001,
	},
}

-- Reminder Buffs Checklist
DB.ReminderBuffs = {
	SHAMAN = {
		[L["Lightning Shield"]] = {			-- 闪电之盾
			["spells"] = {
				[192106] = true,
			},
			["requirespell"] = 192106,
			["combat"] = true,
			["instance"] = true,
			["pvp"] = true,
		},
	},
	ROGUE = {
		[L["Damage Poison"]] = {			-- 伤害类毒药
			["spells"] = {
				[2823] = true,			-- 致命药膏
			},
			["negate_spells"] = {
				[8679] = true,			-- 致伤药膏
				[200802] = true,		-- 苦痛毒液
			},
			["tree"] = 1,
			["combat"] = true,
			["instance"] = true,
			["pvp"] = true,
		},
		[L["Effect Poison"]] = { 			-- 效果类毒药
			["spells"] = {
				[3408] = true,   		-- 减速药膏
			},
			["negate_spells"] = {
				[108211] = true, 		-- 吸血药膏
			},
			["tree"] = 1,
			["pvp"] = true,
		},
	},
}

-- Filter Chat symbols
DB.Symbols = {"`", "～", "＠", "＃", "^", "＊", "！", "？", "。", "|", " ", "——", "￥", "’", "‘", "“", "”", "【", "】", "『", "』", "《", "》", "〈", "〉", "（", "）", "〔", "〕", "、", "，", "：", ",", "_"}