local B, C, L, DB = unpack(select(2, ...))
if DB.Client ~= "zhCN" then return end

local hx = {
	"技能监视列表更新；",
	"动作条调整；",
	"聊天窗口调整；",
	"射击猎助手优化；",
	"给冷却计时方式添加一个切换选项；",
	"Tab键可以切换至世界频道；",
	"控制台字号微调；",
	"额外法力值满值时透明度降低；",
	"鼠标提示框调整；",
	"修复有时无法追踪世界任务的问题；",
	"Aurora部分模块调整；",
	"宠物手册添加一个快速切换标签；",
	"耐久提示修复；",
	"UI缩放对未选择分辨率的调整；",
	"修正与诺米对话有可能导致Tradetabs失效的问题；",
	"添加神器能量计算的命令；",
	"自动收起任务列表功能调整；",
	"任务通报一个错误修复；",
	"Skada更新",
	"更新支持7.1。",
}

local function changelog()
	local f = CreateFrame("Frame", "NDuiChangeLog", UIParent)
	f:SetPoint("CENTER")
	f:SetScale(1.2)
	f:SetFrameStrata("HIGH")
	B.CreateMF(f)
	B.CreateBD(f)
	B.CreateTex(f)
	B.CreateFS(f, 30, "NDui", true, "TOPLEFT", 10, 25)
	B.CreateFS(f, 14, DB.Version, true, "TOPLEFT", 90, 12)
	B.CreateFS(f, 16, L["Changelog"], true, "TOP", 0, -10)
	local ll = CreateFrame("Frame", nil, f)
	ll:SetPoint("TOP", -51, -35)
	B.CreateGF(ll, 100, 1, "Horizontal", 0, 0, 0, 0, 0.7)
	ll:SetFrameStrata("HIGH")
	local lr = CreateFrame("Frame", nil, f)
	lr:SetPoint("TOP", 51, -35)
	B.CreateGF(lr, 100, 1, "Horizontal", 0, 0, 0, 0.7, 0)
	lr:SetFrameStrata("HIGH")
	local offset = 0
	for n, t in pairs(hx) do
		B.CreateFS(f, 12, n..": "..t, false, "TOPLEFT", 15, -(50 + offset))
		offset = offset + 20
	end
	f:SetSize(400, 60 + offset)
	local close = CreateFrame("Button", nil, f)
	close:SetPoint("TOPRIGHT", -10, -10)
	close:SetSize(20, 20)
	B.CreateBD(close, 0.3)
	B.CreateFS(close, 12, "X", true)
	B.CreateBC(close)
	close:SetScript("OnClick", function(self) f:Hide() end)
end

local cl = CreateFrame("Frame")
cl:RegisterEvent("PLAYER_ENTERING_WORLD")
cl:SetScript("OnEvent", function()
	cl:UnregisterEvent("PLAYER_ENTERING_WORLD")
	NDuiADB["Changelog"] = NDuiADB["Changelog"] or {}
	if (not HelloWorld) and NDuiADB["Changelog"].Version ~= DB.Version then
		changelog()
		NDuiADB["Changelog"].Version = DB.Version
	end
end)

SlashCmdList["NDUICHANGELOG"] = function()
	if not NDuiChangeLog then changelog() else NDuiChangeLog:Show() end
end
SLASH_NDUICHANGELOG1 = '/ncl'