local F, C = unpack(select(2, ...))
--[[
	Credit: Paopao001
]]
tinsert(C.themes["Aurora"], function()
	-- Fix alertframe bg
	local function fixBg(f)
		if f:GetObjectType() == "AnimationGroup" then
			f = f:GetParent()
		end
		if f.bg then
			f.bg:SetBackdropColor(0, 0, 0, AuroraConfig.alpha)
		end
	end

	local function fixAnim(frame)
		frame:HookScript("OnEnter", fixBg)
		frame:HookScript("OnShow", fixBg)
		frame.animIn:HookScript("OnPlay", fixBg)
		frame.animIn:HookScript("OnFinished", fixBg)
	end

	-- Achievement alert
	hooksecurefunc(AlertFrame, "AddAlertFrame", function(self, frame)
		if frame.queue == AchievementAlertSystem then
			if not frame.bg then
				frame.bg = F.CreateBDFrame(frame)
				frame.bg:SetPoint("TOPLEFT", 0, -5)
				frame.bg:SetPoint("BOTTOMRIGHT", 0, 5)

				frame.Unlocked:SetTextColor(1, 1, 1)
				frame.GuildName:ClearAllPoints()
				frame.GuildName:SetPoint("TOPLEFT", 50, -14)
				frame.GuildName:SetPoint("TOPRIGHT", -50, -14)
				F.ReskinIcon(frame.Icon.Texture)

				frame.GuildBanner:SetTexture("")
				frame.OldAchievement:SetTexture("")
				frame.GuildBorder:SetTexture("")
				frame.Icon.Bling:SetTexture("")
			end
			frame.Background:SetTexture("")
			frame.Icon.Overlay:SetTexture("")
			frame.glow:SetTexture("")
			frame.shine:SetTexture("")
			-- otherwise it hides
			frame.Shield.Points:Show()
			frame.Shield.Icon:Show()
			fixAnim(frame)
		elseif frame.queue == CriteriaAlertSystem then
			if not frame.bg then
				local icon = frame.Icon.Texture
				frame.bg = F.CreateBDFrame(frame)
				frame.bg:SetPoint("TOPLEFT", icon, -6, 5)
				frame.bg:SetPoint("BOTTOMRIGHT", icon, 236, -5)

				frame.Unlocked:SetTextColor(1, 1, 1)
				F.ReskinIcon(icon)

				frame.Background:SetTexture("")
				frame.Icon.Bling:SetTexture("")
				frame.Icon.Overlay:SetTexture("")
				frame.glow:SetTexture("")
				frame.shine:SetTexture("")
			end
			fixAnim(frame)
		elseif frame.queue == LootAlertSystem then
			if not frame.bg then
				frame.bg = F.CreateBDFrame(frame)
				frame.bg:SetPoint("TOPLEFT", frame, 10, -10)
				frame.bg:SetPoint("BOTTOMRIGHT", frame, -10, 10)

				frame.Icon:SetTexCoord(.08, .92, .08, .92)
				F.CreateBDFrame(frame.Icon)
				frame.SpecRing:SetTexture("")
				frame.SpecIcon:SetTexCoord(.08, .92, .08, .92)
				frame.SpecIcon.bg = F.CreateBG(frame.SpecIcon)
				frame.SpecIcon.bg:SetDrawLayer("BORDER", 2)
			end
			frame.glow:SetTexture("")
			frame.shine:SetTexture("")
			frame.Background:SetTexture("")
			frame.PvPBackground:SetTexture("")
			frame.BGAtlas:SetTexture("")
			frame.IconBorder:SetTexture("")
			frame.SpecIcon.bg:SetShown(frame.SpecIcon:IsShown() and frame.SpecIcon:GetTexture() ~= nil)
			fixAnim(frame)
		elseif frame.queue == LootUpgradeAlertSystem then
			if not frame.bg then
				frame.bg = F.CreateBDFrame(frame)
				frame.bg:SetPoint("TOPLEFT", 10, -10)
				frame.bg:SetPoint("BOTTOMRIGHT", -10, 10)

				F.ReskinIcon(frame.Icon)
				frame.Icon:SetDrawLayer("BORDER", 5)
				frame.Icon:ClearAllPoints()
				frame.Icon:SetPoint("CENTER", frame.BaseQualityBorder)

				frame.BaseQualityBorder:SetSize(52, 52)
				frame.BaseQualityBorder:SetTexture(C.media.backdrop)
				frame.UpgradeQualityBorder:SetTexture(C.media.backdrop)
				frame.UpgradeQualityBorder:SetSize(52, 52)
				frame.Background:SetTexture("")
				frame.Sheen:SetTexture("")
				frame.BorderGlow:SetTexture("")
			end
			frame.BaseQualityBorder:SetTexture("")
			frame.UpgradeQualityBorder:SetTexture("")
			fixAnim(frame)
		elseif frame.queue == MoneyWonAlertSystem then
			if not frame.bg then
				frame.bg = F.CreateBDFrame(frame)
				frame.bg:SetPoint("TOPLEFT", 8, -8)
				frame.bg:SetPoint("BOTTOMRIGHT", -8, 8)

				F.ReskinIcon(frame.Icon)
				frame.Background:SetTexture("")
				frame.IconBorder:SetTexture("")
			end
			fixAnim(frame)
		elseif frame.queue == NewRecipeLearnedAlertSystem then
			if not frame.bg then
				frame.bg = F.CreateBDFrame(frame)
				frame.bg:SetPoint("TOPLEFT", 10, -5)
				frame.bg:SetPoint("BOTTOMRIGHT", -10, 5)

				frame:GetRegions():SetTexture("")
				frame.Icon:SetDrawLayer("ARTWORK")
				F.CreateBG(frame.Icon)
				frame.glow:SetTexture("")
				frame.shine:SetTexture("")
			end
			frame.Icon:SetMask(nil)
			frame.Icon:SetTexCoord(.08, .92, .08, .92)
			fixAnim(frame)
		end
	end)

	-- Guild challenges

	--[[local bg = F.CreateBDFrame(GuildChallengeAlertFrame)
	bg:SetPoint("TOPLEFT", 8, -12)
	bg:SetPoint("BOTTOMRIGHT", -8, 13)
	F.CreateBG(GuildChallengeAlertFrameEmblemBackground)

	GuildChallengeAlertFrameGlow:SetTexture("")
	GuildChallengeAlertFrameShine:SetTexture("")
	GuildChallengeAlertFrameEmblemBorder:SetTexture("")

	-- Dungeon completion rewards

	do
		local frame = DungeonCompletionAlertFrame

		frame.dungeonTexture:SetTexCoord(.08, .92, .08, .92)
		F.CreateBDFrame(frame.dungeonTexture)
		local bg = F.CreateBDFrame(frame)
		bg:SetPoint("TOPLEFT", 2, -10)
		bg:SetPoint("BOTTOMRIGHT", 0, 2)

		frame.raidArt:SetTexture("")
		frame.dungeonArt1:SetTexture("")
		frame.dungeonArt2:SetTexture("")
		frame.dungeonArt3:SetTexture("")
		frame.dungeonArt4:SetTexture("")
		frame.heroicIcon:SetTexture("")
		frame.glowFrame.glow:SetTexture("")
		frame.shine:SetTexture("")

		hooksecurefunc("DungeonCompletionAlertFrame_SetUp", function(f)
			local name, typeID, subtypeID, textureFilename, moneyBase, moneyVar, experienceBase, experienceVar, numStrangers, numRewards = GetLFGCompletionReward()

			for i = 1, numRewards+1 do
				local reward = _G["DungeonCompletionAlertFrameReward"..i]
				if reward then
					select(2, reward:GetRegions()):SetTexture("")
					reward.texture:SetTexCoord(.08, .92, .08, .92)
					reward.texture:ClearAllPoints()
					reward.texture:SetPoint("TOPLEFT", 6, -6)
					reward.texture:SetPoint("BOTTOMRIGHT", -6, 6)
					F.CreateBG(reward.texture)

					if i == 1 then
						reward:SetPoint("TOPRIGHT", f, "TOPRIGHT", -10, 0)
					else
						reward:SetPoint("RIGHT", _G["DungeonCompletionAlertFrameReward"..(i-1)], "LEFT", 0, 0)
					end
				end
			end
		end)
	end

	-- Scenario alert

	do
		local frame = ScenarioAlertFrame

		frame.bg = F.CreateBDFrame(frame)
		frame.bg:SetPoint("TOPLEFT", 5, -5)
		frame.bg:SetPoint("BOTTOMRIGHT", -5, 5)
		frame:HookScript("OnEnter", fixBg)
		frame:HookScript("OnShow", fixBg)
		frame.animIn:HookScript("OnFinished", fixBg)
		frame.dungeonTexture:SetTexCoord(.08, .92, .08, .92)
		F.CreateBDFrame(frame.dungeonTexture)

		select(1, frame:GetRegions()):Hide()
		select(3, frame:GetRegions()):Hide()
		frame.glowFrame.glow:SetTexture("")
		frame.shine:SetTexture("")

		hooksecurefunc("ScenarioAlertFrame_SetUp", function(f)
			local name, typeID, subtypeID, textureFilename, moneyBase, moneyVar, experienceBase, experienceVar, numStrangers, numRewards = GetLFGCompletionReward()

			for i = 1, numRewards+1 do
				local reward = _G["ScenarioAlertFrameReward"..i]
				if reward then
					select(2, reward:GetRegions()):SetTexture("")
					reward.texture:SetTexCoord(.08, .92, .08, .92)
					reward.texture:ClearAllPoints()
					reward.texture:SetPoint("TOPLEFT", 6, -6)
					reward.texture:SetPoint("BOTTOMRIGHT", -6, 6)
					F.CreateBG(reward.texture)

					if i == 1 then
						reward:SetPoint("TOPRIGHT", f, "TOPRIGHT", -10, 0)
					else
						reward:SetPoint("RIGHT", _G["ScenarioAlertFrameReward"..(i-1)], "LEFT", 0, 0)
					end
				end
			end
		end)
	end

	-- Digsite completion alert

	do
		local frame = DigsiteCompleteToastFrame
		local icon = frame.DigsiteTypeTexture

		frame.bg = F.CreateBDFrame(frame)
		frame.bg:SetPoint("TOPLEFT", 8, -8)
		frame.bg:SetPoint("BOTTOMRIGHT", -8, 8)

		frame:GetRegions():Hide()

		frame.glow:SetTexture("")
		frame.shine:SetTexture("")
	end

	-- Garrison building alert

	do
		local frame = GarrisonBuildingAlertFrame
		local icon = frame.Icon

		frame:GetRegions():Hide()
		frame.glow:SetTexture("")
		frame.shine:SetTexture("")

		local bg = CreateFrame("Frame", nil, frame)
		bg:SetPoint("TOPLEFT", 8, -8)
		bg:SetPoint("BOTTOMRIGHT", -8, 10)
		bg:SetFrameLevel(frame:GetFrameLevel()-1)
		F.CreateBD(bg)

		icon:SetTexCoord(.08, .92, .08, .92)
		icon:SetDrawLayer("ARTWORK")
		F.CreateBG(icon)
	end

	-- Garrison mission alert

	do
		local frame = GarrisonMissionAlertFrame

		frame.Background:Hide()
		frame.IconBG:Hide()
		frame.glow:SetTexture("")
		frame.shine:SetTexture("")

		local bg = CreateFrame("Frame", nil, frame)
		bg:SetPoint("TOPLEFT", 8, -8)
		bg:SetPoint("BOTTOMRIGHT", -8, 10)
		bg:SetFrameLevel(frame:GetFrameLevel()-1)
		F.CreateBD(bg)
	end

	-- Garrison shipyard mission alert
	
	do
		local frame = GarrisonShipMissionAlertFrame

		frame.Background:Hide()
		frame.glow:SetTexture("")
		frame.shine:SetTexture("")

		local bg = CreateFrame("Frame", nil, frame)
		bg:SetPoint("TOPLEFT", 8, -8)
		bg:SetPoint("BOTTOMRIGHT", -8, 10)
		bg:SetFrameLevel(frame:GetFrameLevel()-1)
		F.CreateBD(bg)
	end

	-- Garrison follower alert

	do
		local frame = GarrisonFollowerAlertFrame

		frame:GetRegions():Hide()
		select(5, frame:GetRegions()):Hide()
		frame.FollowerBG:SetAlpha(0)
		frame.glow:SetTexture("")
		frame.shine:SetTexture("")

		local bg = CreateFrame("Frame", nil, frame)
		bg:SetPoint("TOPLEFT", 16, -5)
		bg:SetPoint("BOTTOMRIGHT", -16, 15)
		bg:SetFrameLevel(frame:GetFrameLevel()-1)
		F.CreateBD(bg)

		F.ReskinGarrisonPortrait(frame.PortraitFrame)
	end

	-- Garrison talent alert

	do
		local frame = GarrisonTalentAlertFrame

		frame:GetRegions():Hide()
		frame.Icon:SetTexCoord(.08, .92, .08, .92)
		F.CreateBDFrame(frame.Icon)
		frame.glow:SetTexture("")
		frame.shine:SetTexture("")

		local bg = CreateFrame("Frame", nil, frame)
		bg:SetPoint("TOPLEFT", 8, -8)
		bg:SetPoint("BOTTOMRIGHT", -8, 10)
		bg:SetFrameLevel(frame:GetFrameLevel()-1)
		F.CreateBD(bg)
	end

	-- World quest alert
	
	do
		local frame = WorldQuestCompleteAlertFrame

		for i = 2, 5 do
			select(i, frame:GetRegions()):Hide()
		end
		frame.QuestTexture:SetTexCoord(.08, .92, .08, .92)
		F.CreateBDFrame(frame.QuestTexture)
		frame.shine:SetTexture("")
		
		local bg = CreateFrame("Frame", nil, frame)
		bg:SetPoint("TOPLEFT", 3, -8)
		bg:SetPoint("BOTTOMRIGHT", -8, 5)
		bg:SetFrameLevel(frame:GetFrameLevel()-1)
		F.CreateBD(bg)
	end]]
end)