﻿-- Author      : Nogarder
-- Create Date : 2013/4/7 12:57:04
--register initialize function
--NPA.DataCollector.RegisterModule( datatype, initfunc, uninitfunc )
NPA.DataCollector.RegisterModule("Quest",
	function()
		local getglobal=getglobal
		local string_match=string.match
		local string_gmatch=string.gmatch
		local tonumber=tonumber
		local string_find=string.find
		local pairs=pairs
		local string_split=string.split
		local table_getn=table.getn
		local UnitName=UnitName
		local next=next
		local string_gsub=string.gsub
		--global 
		--main --using local for speed
		local NPA_EventHandler_FireEvent=NPA.EventHandler.FireEvent
		local NPA_NamePlate_GetFrameData=NPA.NamePlate.GetFrameData
		--
		local NPA_DataCollector_QuestData={}
		local NPA_DataCollector_QuestDataCount=0
		local NPA_DataCollector_NameToQuest={}

		--swap=NPA_DataCollector_QuestData
		--swap2=NPA_DataCollector_NameToQuest

		local FireUpdateEvent=function(framedata)
			local name=UnitName(framedata.unit or "")
			if(name==nil)then
				return
			end
			--using name to quest list
			framedata.QuestData=NPA_DataCollector_NameToQuest[name]
			NPA_EventHandler_FireEvent(8,"Quest_Updated",framedata)
		end
		local CheckEveryFrame=function()
			for frame,framedata in pairs(NPA_NamePlate_GetFrameData())do
				if(frame:IsShown())then
					FireUpdateEvent(framedata)
				end
			end
		end
		--
		local delayedTimer=0
		local requestupdate=false;
		NPA.EventHandler.RegisterEvent(3,"NPA_MainFrame_OnUpdate","DataCollector_Quest",function(elapse)
			if(requestUpdate~=true)then
				return
			end

			delayedTimer=delayedTimer+elapse
			if(delayedTimer<1)then
				return
			end
			
			--build quest data from quest log
			--NPA_DataCollector_QuestData={}
			NPA_DataCollector_QuestDataCount=0
			local numQuests=GetNumQuestLogEntries()
			--
			for index=1,numQuests do 
				--title, level, suggestedGroup, isHeader, isCollapsed, isComplete, frequency, questID, startEvent, displayQuestID, isOnMap, hasLocalPOI, isTask, isStory = GetQuestLogTitle(questIndex)
				local title,level,_,isHeader,_,isComplete,_,questID=GetQuestLogTitle(index)
				if((not isHeader) and title and (not isComplete))then--is quest entry and not complete
					local numobj=GetNumQuestLeaderBoards(index)
					if(numobj>0 )then
						--
						for objid=1,numobj do
							local text=GetQuestLogLeaderBoard(objid,index)
							if(text~=nil)then
								for current,max in string_gmatch(text,"(%d+)/(%d+)") do
									if(tonumber(current)<tonumber(max))then
										NPA_DataCollector_QuestDataCount=NPA_DataCollector_QuestDataCount+1
										if(not NPA_DataCollector_QuestData[NPA_DataCollector_QuestDataCount])then
											NPA_DataCollector_QuestData[NPA_DataCollector_QuestDataCount]={}
										end
										local questdata=NPA_DataCollector_QuestData[NPA_DataCollector_QuestDataCount]
										questdata.Item=string_gsub(string_gsub(text,"-",""),"'","")
										questdata.Current=tonumber(current)
										questdata.Max=tonumber(max)
										questdata.Name=title or ""
										questdata.Level=level
										questdata.QuestID=questID
									end
								end
							end
						end
					end
				end
			end
			--clear unused name-to-quest data
			--build a quest id list
			local questidlist={}
			for i=1,NPA_DataCollector_QuestDataCount do
				questidlist[NPA_DataCollector_QuestData[i].QuestID]=true
			end
			
			for name,quest in pairs(NPA_DataCollector_NameToQuest)do
				if(questidlist[quest.QuestID]~=true or quest.Current==quest.Max or (not quest.Current) or (not quest.Max))then
					NPA_DataCollector_NameToQuest[name]=nil
				end
			end

			--print("debug quest count")
			--Print(NPA_DataCollector_QuestDataCount)
			--swap=NPA_DataCollector_QuestData

			--fire event
			CheckEveryFrame()

			delayedTimer=0
			requestUpdate=false
		end)
		--build data when quest log updated
		NPA.EventHandler.RegisterEvent(0,"QUEST_LOG_UPDATE","DataCollector_Quest",function()
			--delay the update to prevent repeating
			requestUpdate=true
			delayedTimer=0
		end)
		NPA.EventHandler.RegisterEvent(2,"DataCollector_TooltipsUpdated","DataCollector_Quest",function(unit,lines)
			--detect quest entry changes
			--detect quest entry changes
			local name=UnitName(unit)
			if(not name)then
				return
			end
			--search every line
			local bestcount=9999
			local currentquest

			for _,line in pairs(lines)do
				if(line:IsShown())then
					local text=line:GetText()

					local checktext=string_match(text,"%d+/%d+%s+.+")
					if(checktext~=nil)then
						local name=string_gsub(checktext,"%d+/%d+%s+","")
						name =string_gsub(string_gsub(name,"-",""),"'","")

						---check name to quest
						--find out the best quest to show
						for i=1,NPA_DataCollector_QuestDataCount do
							local questdata=NPA_DataCollector_QuestData[i]
							if(string_find(questdata.Item,name))then
								local count=questdata.Max-questdata.Current
								if(count>0 and count<bestcount)then
									currentquest=questdata
									bestcount=count
								end
							end
						end
					end
				end
			end

			if(NPA_DataCollector_NameToQuest[name]~=currentquest)then
				NPA_DataCollector_NameToQuest[name]=currentquest
				
				CheckEveryFrame()
			end
		end)
		--fire update when name changes
		NPA.EventHandler.RegisterEvent(1,"NamePlate_DefaultMain_OnShow","DataCollector_Quest",FireUpdateEvent)
		--NPA.EventHandler.RegisterEvent(8,"Name_Updated","DataCollector_Quest",FireUpdateEvent)
	end,
	--------
	function()
		-------unregister all events
		NPA.EventHandler.RegisterEvent(0,"QUEST_LOG_UPDATE","DataCollector_Quest",nil)
		NPA.EventHandler.RegisterEvent(2,"DataCollector_TooltipsUpdated","DataCollector_Quest",nil)
		NPA.EventHandler.RegisterEvent(1,"NamePlate_DefaultMain_OnShow","DataCollector_Quest",nil)
	end
	)
