﻿-- Author      : Nogarder
-- Create Date : 2012/3/19 18:04:25
local UnitExists=UnitExists
local UnitName=UnitName
local UnitHealth=UnitHealth
local UnitHealthMax=UnitHealthMax
local UnitGUID=UnitGUID
local NPA_GetTime=NPA.GetTime
local UnitIsPlayer=UnitIsPlayer
--global
local pairs=pairs
local table_getn=table.getn
--main --using local for speed

NPA.FrameToGUID={}
local NPA_EventHandler_FireEvent=NPA.EventHandler.FireEvent
--store showing frames
local NPA_FrameToGUID_VisiableFrameData={}
--guid-to-frame lookup table
local NPA_FrameToGUID_GUIDToFrameData={}
--macro for add guid to framedata
local NPA_FrameToGUID_SetFrameDataGUID=function(framedata,guid)
	if(guid)then
		framedata.GUID=guid
		--add to guid to frame lookup table
		NPA_FrameToGUID_GUIDToFrameData[guid]=framedata
		--fire event to notify frame-guid based module
		NPA_EventHandler_FireEvent(1,"DataCollector_GUIDAttached",framedata)
		return true
	end
end
--------default nameplate events
--using default frame rather than module frame
--data start/stop being collectable when default show/hide, and module frame may not show/hide yet.
NPA.EventHandler.RegisterEvent(1,"NamePlate_DefaultMain_PreOnShow","DataCollector_FrameToGUID",function(framedata,NPA_DataCollector_CollectableUnitToGUID)
	if(framedata.unit)then
		--count in when a nameplate is shown
		NPA_FrameToGUID_VisiableFrameData[framedata]=true
		NPA_FrameToGUID_SetFrameDataGUID(framedata , UnitGUID(framedata.unit))
	else
		framedata.UnitData={}
	end
end)
NPA.EventHandler.RegisterEvent(1,"NamePlate_DefaultMain_OnHide","DataCollector_FrameToGUID",function(framedata)
	--count out when a nameplate is hidden
	NPA_FrameToGUID_VisiableFrameData[framedata]=nil
	--remove from guid-to-frame lookup table if exists
	if(framedata.GUID)then
		NPA_FrameToGUID_GUIDToFrameData[framedata.GUID]=nil
	end
	--also fire a guid remove event to alert frame-guid based modules
	NPA_EventHandler_FireEvent(1,"DataCollector_GUIDDetached",framedata)
end)
--wrap up unitdata change with frame -- only when the frame matching guid is visible
NPA.EventHandler.RegisterEvent(7,"Any","DataCollector_FrameToGUID",function(event,unitdata)
	local guid=unitdata.GUID
	if(guid and NPA_FrameToGUID_GUIDToFrameData[guid])then
		NPA_EventHandler_FireEvent(8,event,NPA_FrameToGUID_GUIDToFrameData[guid])
	end
end)


--this is for target arrow and combat text
local FrameDataList={}
--
NPA.FrameToGUID.GetFrameByGUID=function(guid)
	--check guid to framedata
	local framedata=NPA_FrameToGUID_GUIDToFrameData[guid]
	if(framedata)then
		return framedata.ModuleMain
	elseif(FrameDataList[guid])then
		return FrameDataList[guid]
	elseif(guid==UnitGUID("player"))then --this may change so using real-time one
		--check player
		return UIParent --player's position is UIParent Center
	end
end
--this is for tracker module's fake nameplates
NPA.FrameToGUID.RegisterFrameByGUID=function(guid,modulemain)
	FrameDataList[guid]=modulemain
end

NPA.FrameToGUID.CheckFrameByGUIDNoFake=function(guid)
	return NPA_FrameToGUID_GUIDToFrameData[guid]
end