/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.javahl;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.tigris.subversion.javahl.RevisionKind;

public class Revision
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected int revKind;
    public static final Revision HEAD = new Revision(7, true);
    public static final Revision START = new Revision(0, true);
    public static final Revision COMMITTED = new Revision(3, true);
    public static final Revision PREVIOUS = new Revision(4, true);
    public static final Revision BASE = new Revision(5, true);
    public static final Revision WORKING = new Revision(6, true);
    public static final int SVN_INVALID_REVNUM = -1;

    public Revision(int kind) {
        this(kind, true);
    }

    protected Revision(int kind, boolean marker) {
        if (kind < 0 || kind > 7) {
            throw new IllegalArgumentException(String.valueOf(kind) + " is not a legal revision kind");
        }
        this.revKind = kind;
    }

    public int getKind() {
        return this.revKind;
    }

    public String toString() {
        switch (this.revKind) {
            case 5: {
                return "BASE";
            }
            case 3: {
                return "COMMITTED";
            }
            case 7: {
                return "HEAD";
            }
            case 4: {
                return "PREV";
            }
            case 6: {
                return "WORKING";
            }
        }
        return super.toString();
    }

    public int hashCode() {
        return this.revKind * -1;
    }

    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        if (!(target instanceof Revision)) {
            return false;
        }
        return ((Revision)target).revKind == this.revKind;
    }

    public static Revision getInstance(long revisionNumber) {
        return new Number(revisionNumber);
    }

    static Number createNumber(long revNumber) {
        return revNumber < 0L ? null : new Number(revNumber);
    }

    public static Revision getInstance(Date revisionDate) {
        return new DateSpec(revisionDate);
    }

    public static class Number
    extends Revision {
        private static final long serialVersionUID = 1L;
        protected long revNumber;

        public Number(long number) {
            super(1, true);
            if (number < 0L) {
                throw new IllegalArgumentException("Invalid (negative) revision number: " + number);
            }
            this.revNumber = number;
        }

        public long getNumber() {
            return this.revNumber;
        }

        public String toString() {
            return Long.toString(this.revNumber);
        }

        public boolean equals(Object target) {
            if (!super.equals(target)) {
                return false;
            }
            return ((Number)target).revNumber == this.revNumber;
        }

        public int hashCode() {
            return (int)(this.revNumber ^ this.revNumber >>> 32);
        }
    }

    public static class DateSpec
    extends Revision {
        private static final long serialVersionUID = 1L;
        protected Date revDate;

        public DateSpec(Date date) {
            super(2, true);
            if (date == null) {
                throw new IllegalArgumentException("a date must be specified");
            }
            this.revDate = date;
        }

        public Date getDate() {
            return this.revDate;
        }

        public String toString() {
            SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z", Locale.US);
            return String.valueOf('{') + dateFormat.format(this.revDate) + '}';
        }

        public boolean equals(Object target) {
            if (!super.equals(target)) {
                return false;
            }
            return ((DateSpec)target).revDate.equals(this.revDate);
        }

        public int hashCode() {
            return this.revDate.hashCode();
        }
    }

    public static final class Kind
    implements RevisionKind {
    }
}

