/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.tools.usage.util.reader;

import java.io.Reader;
import org.tigris.subversion.subclipse.tools.usage.util.reader.ReadUntilImpl;

public class ReadUntilAlternativesImpl
extends ReadUntilImpl {
    private char[][] allAlternatives;
    private char[] currentAlternative;
    private int alternativesIndex = -1;

    public ReadUntilAlternativesImpl(Reader reader, String[] stringAlternatives) {
        super(reader, new char[0]);
        this.initAlternativesCharSequences(stringAlternatives);
    }

    private void initAlternativesCharSequences(String[] stringAlternatives) {
        this.allAlternatives = new char[stringAlternatives.length][];
        int i = 0;
        while (i < stringAlternatives.length) {
            this.allAlternatives[i] = stringAlternatives[i].toCharArray();
            ++i;
        }
    }

    protected int getNumberOfCharactersToMatch() {
        if (this.currentAlternative != null) {
            return this.currentAlternative.length;
        }
        return 0;
    }

    protected boolean doesMatch(char character) {
        if (this.currentAlternative == null || this.currentAlternative[this.getMatchingIndex()] != character) {
            boolean newAlternativeSelected = this.matchAlternative(character);
            if (!newAlternativeSelected) {
                this.setMatchingIndex(0);
            }
            return newAlternativeSelected;
        }
        return true;
    }

    private boolean matchAlternative(char character) {
        int i = this.alternativesIndex + 1;
        while (i < this.allAlternatives.length) {
            char[] alternative = this.allAlternatives[i];
            if (this.doesMatch(character, alternative)) {
                this.currentAlternative = alternative;
                this.alternativesIndex = i;
                return true;
            }
            ++i;
        }
        this.currentAlternative = null;
        this.alternativesIndex = -1;
        return false;
    }

    private boolean doesMatch(char character, char[] potentiallyMatchingAlternative) {
        int currentMatchingIndex = this.getMatchingIndex();
        int j = 0;
        while (j < currentMatchingIndex) {
            if (potentiallyMatchingAlternative[j] != this.currentAlternative[j]) {
                return false;
            }
            ++j;
        }
        return potentiallyMatchingAlternative[currentMatchingIndex] == character;
    }

    protected char[] getCharactersToMatch() {
        return this.currentAlternative;
    }

    public String getAlternative() {
        if (this.alternativesIndex >= 0) {
            return new String(this.allAlternatives[this.alternativesIndex]);
        }
        return null;
    }
}

