/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.tools.usage.util;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.tigris.subversion.subclipse.tools.usage.util.StatusUtils;

public class BrowserUtil {
    public static void checkedCreateInternalBrowser(String url, String browserId, String pluginId, ILog log) {
        try {
            BrowserUtil.openUrl(url, PlatformUI.getWorkbench().getBrowserSupport().createBrowser(browserId), pluginId, log);
        }
        catch (PartInitException e) {
            Object[] messageArguments = new Object[]{url};
            IStatus errorStatus = StatusUtils.getErrorStatus(pluginId, "Could not open browser for url \"{0}\".", e, messageArguments);
            log.log(errorStatus);
        }
    }

    public static void checkedCreateExternalBrowser(String url, String pluginId, ILog log) {
        try {
            BrowserUtil.openUrl(url, PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser(), pluginId, log);
        }
        catch (PartInitException e) {
            Object[] messageArguments = new Object[]{url};
            IStatus errorStatus = StatusUtils.getErrorStatus(pluginId, "Could not open browser for url \"{0}\".", e, messageArguments);
            log.log(errorStatus);
        }
    }

    public static void openUrl(String url, IWebBrowser browser, String pluginId, ILog log) {
        Object[] messageArguments = new Object[]{url};
        try {
            browser.openURL(new URL(url));
        }
        catch (PartInitException e) {
            IStatus errorStatus = StatusUtils.getErrorStatus(pluginId, "Could not open browser for url \"{0}\".", e, messageArguments);
            log.log(errorStatus);
        }
        catch (MalformedURLException e) {
            IStatus errorStatus = StatusUtils.getErrorStatus(pluginId, "Could not display malformed url \"{0}\".", e, messageArguments);
            log.log(errorStatus);
        }
    }
}

