/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.tools.usage.reporting;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.tigris.subversion.subclipse.tools.usage.internal.SubclipseToolsUsageActivator;
import org.tigris.subversion.subclipse.tools.usage.reporting.ReportingMessages;
import org.tigris.subversion.subclipse.tools.usage.util.BrowserUtil;

public class UsageReportEnablementDialog
extends Dialog {
    private Button checkBox;
    private boolean reportEnabled;

    public UsageReportEnablementDialog(boolean reportEnabled, Shell parentShell) {
        super(parentShell);
        this.reportEnabled = reportEnabled;
    }

    public UsageReportEnablementDialog(boolean reportEnabled, IShellProvider parentShell) {
        super(parentShell);
        this.reportEnabled = reportEnabled;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.reportEnabled = this.checkBox.getSelection();
        } else if (buttonId == 1) {
            this.reportEnabled = false;
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.getDialogTitle());
    }

    private String getDialogTitle() {
        return ReportingMessages.UsageReport_DialogTitle;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.checkBox.setFocus();
        this.checkBox.setSelection(this.reportEnabled);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        Link link = new Link(composite, 64);
        link.setFont(parent.getFont());
        link.setText(ReportingMessages.UsageReport_DialogMessage);
        link.setToolTipText(ReportingMessages.UsageReport_ExplanationPage);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BrowserUtil.checkedCreateExternalBrowser(ReportingMessages.UsageReport_ExplanationPage, "org.tigris.subversion.subclipse.tools.usage", SubclipseToolsUsageActivator.getDefault().getLog());
            }
        });
        this.checkBox = new Button(composite, 32);
        this.checkBox.setText(ReportingMessages.UsageReport_Checkbox_Text);
        return composite;
    }

    public boolean isReportEnabled() {
        return this.reportEnabled;
    }
}

