/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.util;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.tigris.subversion.subclipse.ui.Policy;

public class WorkspaceDialog
extends TitleAreaDialog {
    private String windowTitle;
    private String message;
    private TreeViewer treeViewer;
    private Text fileNameText;
    private ImageDescriptor imageDescriptor;
    private Image dlgTitleImage;
    private Text pathText;
    protected IContainer wsSelectedContainer;

    public WorkspaceDialog(Shell parentShell, String windowTitle, String message, ImageDescriptor imageDescriptor, Text pathText) {
        super(parentShell);
        this.windowTitle = windowTitle;
        this.message = message;
        this.imageDescriptor = imageDescriptor;
        this.pathText = pathText;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.setTitle(this.message);
        this.dlgTitleImage = this.imageDescriptor.createImage();
        this.setTitleImage(this.dlgTitleImage);
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        IResource selectedResource;
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)data);
        this.getShell().setText(this.windowTitle);
        this.treeViewer = new TreeViewer(composite, 2048);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 550;
        gd.heightHint = 250;
        this.treeViewer.getTree().setLayoutData((Object)gd);
        this.treeViewer.setContentProvider((IContentProvider)new LocationPageContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.treeViewer.setInput((Object)ResourcesPlugin.getWorkspace());
        Path existingWorkspacePath = new Path(this.pathText.getText());
        if (existingWorkspacePath != null && (selectedResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)existingWorkspacePath)) != null) {
            this.treeViewer.expandToLevel((Object)selectedResource, 0);
            this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)selectedResource));
        }
        Composite group = new Composite(composite, 0);
        layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        Label label = new Label(group, 0);
        label.setLayoutData((Object)new GridData());
        label.setText(Policy.bind("WorkspaceDialog.fileName"));
        this.fileNameText = new Text(group, 2048);
        this.fileNameText.setLayoutData((Object)new GridData(4, 128, true, false));
        this.setupListeners();
        return parent;
    }

    protected void okPressed() {
        String patchName = this.fileNameText.getText();
        if (patchName.equals("")) {
            this.setErrorMessage(Policy.bind("WorkspaceDialog.enterFileName"));
            return;
        }
        if (!ResourcesPlugin.getWorkspace().validateName(patchName, 1).isOK()) {
            this.fileNameText.setText("");
            this.setErrorMessage(Policy.bind("WorkspaceDialog.multipleSegments"));
            return;
        }
        if (this.wsSelectedContainer == null) {
            this.getSelectedContainer();
        }
        Assert.isNotNull((Object)this.wsSelectedContainer);
        IFile file = this.wsSelectedContainer.getFile((IPath)new Path(this.fileNameText.getText()));
        if (file != null) {
            this.pathText.setText(file.getFullPath().toString());
        }
        super.okPressed();
    }

    private void getSelectedContainer() {
        Object obj = ((IStructuredSelection)this.treeViewer.getSelection()).getFirstElement();
        if (obj instanceof IContainer) {
            this.wsSelectedContainer = (IContainer)obj;
        } else if (obj instanceof IFile) {
            this.wsSelectedContainer = ((IFile)obj).getParent();
        }
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    public boolean close() {
        if (this.dlgTitleImage != null) {
            this.dlgTitleImage.dispose();
        }
        return super.close();
    }

    void setupListeners() {
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection s = (IStructuredSelection)event.getSelection();
                Object obj = s.getFirstElement();
                if (obj instanceof IContainer) {
                    WorkspaceDialog.this.wsSelectedContainer = (IContainer)obj;
                } else if (obj instanceof IFile) {
                    IFile tempFile = (IFile)obj;
                    WorkspaceDialog.this.wsSelectedContainer = tempFile.getParent();
                    WorkspaceDialog.this.fileNameText.setText(tempFile.getName());
                }
            }
        });
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection s = event.getSelection();
                if (s instanceof IStructuredSelection) {
                    Object item = ((IStructuredSelection)s).getFirstElement();
                    if (WorkspaceDialog.this.treeViewer.getExpandedState(item)) {
                        WorkspaceDialog.this.treeViewer.collapseToLevel(item, 1);
                    } else {
                        WorkspaceDialog.this.treeViewer.expandToLevel(item, 1);
                    }
                }
            }
        });
        this.fileNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WorkspaceDialog.this.setErrorMessage(null);
            }
        });
    }

    class LocationPageContentProvider
    extends BaseWorkbenchContentProvider {
        boolean showClosedProjects = false;

        LocationPageContentProvider() {
        }

        public Object[] getChildren(Object element) {
            if (element instanceof IWorkspace) {
                Object[] allProjects = ((IWorkspace)element).getRoot().getProjects();
                if (this.showClosedProjects) {
                    return allProjects;
                }
                ArrayList<Object> accessibleProjects = new ArrayList<Object>();
                int i = 0;
                while (i < allProjects.length) {
                    if (allProjects[i].isOpen()) {
                        accessibleProjects.add(allProjects[i]);
                    }
                    ++i;
                }
                return accessibleProjects.toArray();
            }
            return super.getChildren(element);
        }
    }
}

