/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.operations;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.ui.IWorkbenchPart;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.SVNTeamProvider;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.operations.SVNOperation;
import org.tigris.subversion.subclipse.ui.subscriber.SVNSynchronizeParticipant;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class CommitOperation
extends SVNOperation {
    private IResource[] resourcesToAdd;
    private IResource[] resourcesToDelete;
    private IResource[] resourcesToCommit;
    private String commitComment;
    private boolean keepLocks;
    private ISVNClientAdapter svnClient;
    private ISynchronizePageConfiguration configuration;
    private boolean useJavaHLHack = true;
    private boolean canRunAsJob = true;

    public CommitOperation(IWorkbenchPart part, IResource[] selectedResources, IResource[] resourcesToAdd, IResource[] resourcesToDelete, IResource[] resourcesToCommit, String commitComment, boolean keepLocks) {
        super(part);
        this.resourcesToAdd = resourcesToAdd;
        this.resourcesToDelete = resourcesToDelete;
        this.resourcesToCommit = resourcesToCommit;
        this.commitComment = commitComment;
        this.keepLocks = keepLocks;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void execute(IProgressMonitor monitor) throws SVNException, InterruptedException {
        monitor.beginTask(null, this.resourcesToAdd.length + this.resourcesToDelete.length + this.resourcesToCommit.length);
        String adminFolderName = SVNProviderPlugin.getPlugin().getAdminDirectoryName();
        File cleanUpPathList = null;
        try {
            try {
                IResource[] providerResources;
                List list;
                SVNTeamProvider provider;
                Iterator iterator;
                Set keySet;
                Map table;
                this.svnClient = SVNProviderPlugin.getPlugin().getSVNClientManager().getSVNClient();
                if (this.resourcesToAdd.length > 0) {
                    table = this.getProviderMapping(this.resourcesToAdd);
                    if (table.get(null) != null) {
                        throw new SVNException(Policy.bind("RepositoryManager.addErrorNotAssociated"));
                    }
                    keySet = table.keySet();
                    iterator = keySet.iterator();
                    while (iterator.hasNext()) {
                        SVNTeamProvider provider2 = (SVNTeamProvider)iterator.next();
                        List list2 = (List)table.get(provider2);
                        IResource[] providerResources2 = list2.toArray(new IResource[list2.size()]);
                        provider2.add(providerResources2, 0, Policy.subMonitorFor(monitor, this.resourcesToAdd.length));
                    }
                }
                if (this.resourcesToDelete.length > 0) {
                    ISVNClientAdapter svnDeleteClient = null;
                    Map table2 = this.getProviderMapping(this.resourcesToDelete);
                    if (table2.get(null) != null) {
                        throw new SVNException(Policy.bind("RepositoryManager.addErrorNotAssociated"));
                    }
                    Set keySet2 = table2.keySet();
                    Iterator iterator2 = keySet2.iterator();
                    while (iterator2.hasNext()) {
                        provider = (SVNTeamProvider)iterator2.next();
                        list = (List)table2.get(provider);
                        providerResources = list.toArray(new IResource[list.size()]);
                        File[] files = new File[providerResources.length];
                        int i = 0;
                        while (i < providerResources.length) {
                            ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)providerResources[i]);
                            if (svnDeleteClient == null) {
                                svnDeleteClient = svnResource.getRepository().getSVNClient();
                            }
                            files[i] = svnResource.getFile();
                            ++i;
                        }
                        try {
                            svnDeleteClient.remove(files, true);
                        }
                        catch (SVNClientException e) {
                            throw new TeamException(e.getMessage());
                        }
                    }
                }
                this.setJavaHLHackMode(this.resourcesToCommit);
                table = this.getCommitProviderMapping(this.resourcesToCommit);
                keySet = table.keySet();
                iterator = keySet.iterator();
                while (iterator.hasNext()) {
                    ProjectAndRepository mapKey = (ProjectAndRepository)iterator.next();
                    provider = mapKey.getTeamProvider();
                    list = (List)table.get(mapKey);
                    providerResources = list.toArray(new IResource[list.size()]);
                    if (this.createAdminFolder(mapKey.getParent(), adminFolderName, providerResources)) {
                        cleanUpPathList = mapKey.getParent();
                    }
                    provider.checkin(providerResources, this.commitComment, this.keepLocks, this.getDepth(providerResources), Policy.subMonitorFor(monitor, providerResources.length));
                    this.deleteAdminFolders(cleanUpPathList, adminFolderName);
                }
            }
            catch (TeamException e) {
                throw SVNException.wrapException((TeamException)e);
            }
            Object var14_18 = null;
        }
        catch (Throwable throwable) {
            Object var14_17 = null;
            monitor.done();
            this.deleteAdminFolders(cleanUpPathList, adminFolderName);
            if (this.configuration == null) throw throwable;
            SVNSynchronizeParticipant sync = (SVNSynchronizeParticipant)this.configuration.getParticipant();
            IResource[] roots = sync.getResources();
            if (roots.length > 1) {
                roots = this.reduceRoots(roots);
            }
            sync.refresh(roots, monitor);
            throw throwable;
        }
        monitor.done();
        this.deleteAdminFolders(cleanUpPathList, adminFolderName);
        if (this.configuration == null) return;
        SVNSynchronizeParticipant sync = (SVNSynchronizeParticipant)this.configuration.getParticipant();
        IResource[] roots = sync.getResources();
        if (roots.length > 1) {
            roots = this.reduceRoots(roots);
        }
        sync.refresh(roots, monitor);
    }

    private void deleteAdminFolders(File pathList, String adminFolderName) {
        if (pathList == null) {
            return;
        }
        File path = new File(pathList, adminFolderName);
        CommitOperation.deleteFolder(path);
    }

    private static boolean deleteFolder(File folder) {
        if (folder.isDirectory()) {
            String[] children = folder.list();
            int i = 0;
            while (i < children.length) {
                if (!CommitOperation.deleteFolder(new File(folder, children[i]))) {
                    return false;
                }
                ++i;
            }
        }
        return folder.delete();
    }

    private boolean createAdminFolder(File path, String adminFolderName, IResource[] resources) {
        File admin;
        if (!this.useJavaHLHack) {
            return false;
        }
        String url = null;
        String uuid = null;
        String time = null;
        ISVNInfo info = null;
        if (resources.length > 0 && (info = resources[0].getType() == 4 ? this.getSVNInfo(SVNWorkspaceRoot.getSVNResourceFor((IResource)resources[0])) : this.getSVNInfo(SVNWorkspaceRoot.getSVNResourceFor((IResource)resources[0].getProject()))) != null) {
            url = info.getRepository().toString();
            uuid = info.getUuid();
            time = "2008-01-01T21:03:13.980237Z";
        }
        if ((admin = new File(path, adminFolderName)).mkdir()) {
            File tmp = new File(admin, "tmp");
            tmp.mkdir();
            File entries = new File(admin, "entries");
            File format = new File(admin, "format");
            try {
                entries.createNewFile();
                format.createNewFile();
                FileWriter ew = new FileWriter(entries);
                if (url == null) {
                    ew.write("9\n");
                } else {
                    ew.write("9\n\ndir\n0\n" + url + "\n" + url + "\n\n\n\n" + time + "\n0\n\n\n\nsvn:special svn:externals svn:needs-lock\n\n\n\n\n\n\n\n\n\n\n\n" + uuid + "\n\f\n");
                }
                ew.flush();
                ew.close();
                FileWriter fw = new FileWriter(format);
                fw.write("9\n");
                fw.flush();
                fw.close();
            }
            catch (IOException iOException) {}
        } else {
            return false;
        }
        return true;
    }

    private int getDepth(IResource[] resources) {
        int depth = 2;
        int i = 0;
        while (i < resources.length) {
            if (resources[i].getType() != 1) {
                ISVNLocalResource svnResource;
                block6: {
                    svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resources[i]);
                    try {
                        if (!svnResource.getStatus().isDeleted()) break block6;
                        return 2;
                    }
                    catch (SVNException sVNException) {}
                }
                if (svnResource.getStatus().isPropModified()) {
                    depth = 0;
                }
            }
            ++i;
        }
        return depth;
    }

    protected String getTaskName() {
        return Policy.bind("CommitOperation.taskName");
    }

    private Map getCommitProviderMapping(IResource[] resources) {
        ProjectAndRepository mapKey = null;
        HashMap<ProjectAndRepository, ArrayList<IResource>> result = new HashMap<ProjectAndRepository, ArrayList<IResource>>();
        int i = 0;
        while (i < resources.length) {
            ArrayList<IResource> list;
            if (mapKey == null || !this.svnClient.canCommitAcrossWC()) {
                SVNTeamProvider provider = (SVNTeamProvider)RepositoryProvider.getProvider((IProject)resources[i].getProject(), (String)SVNProviderPlugin.getTypeId());
                mapKey = new ProjectAndRepository(provider, this.getRootURL(SVNWorkspaceRoot.getSVNResourceFor((IResource)resources[i])));
            }
            if ((list = (ArrayList<IResource>)result.get(mapKey)) == null) {
                list = new ArrayList<IResource>();
                result.put(mapKey, list);
            }
            list.add(resources[i]);
            ++i;
        }
        return result;
    }

    private Map getProviderMapping(IResource[] resources) {
        RepositoryProvider provider = null;
        HashMap<RepositoryProvider, ArrayList<IResource>> result = new HashMap<RepositoryProvider, ArrayList<IResource>>();
        int i = 0;
        while (i < resources.length) {
            ArrayList<IResource> list;
            if (provider == null || !this.svnClient.canCommitAcrossWC()) {
                provider = RepositoryProvider.getProvider((IProject)resources[i].getProject(), (String)SVNProviderPlugin.getTypeId());
            }
            if ((list = (ArrayList<IResource>)result.get(provider)) == null) {
                list = new ArrayList<IResource>();
                result.put(provider, list);
            }
            list.add(resources[i]);
            ++i;
        }
        return result;
    }

    private String getRootURL(ISVNLocalResource localResource) {
        if (!this.useJavaHLHack) {
            return null;
        }
        ISVNInfo info = this.getSVNInfo(localResource);
        if (info == null) {
            return null;
        }
        SVNUrl repos = info.getRepository();
        if (repos == null) {
            return null;
        }
        return repos.toString();
    }

    private ISVNInfo getSVNInfo(ISVNLocalResource localResource) {
        ISVNInfo info;
        if (!this.useJavaHLHack) {
            return null;
        }
        if (localResource == null) {
            return null;
        }
        File file = localResource.getFile();
        if (file == null) {
            return null;
        }
        try {
            this.svnClient = SVNProviderPlugin.getPlugin().getSVNClientManager().getSVNClient();
        }
        catch (SVNException sVNException) {
            return null;
        }
        try {
            SVNProviderPlugin.disableConsoleLogging();
            info = this.svnClient.getInfoFromWorkingCopy(file);
            SVNProviderPlugin.enableConsoleLogging();
        }
        catch (SVNClientException sVNClientException) {
            SVNProviderPlugin.enableConsoleLogging();
            return null;
        }
        return info;
    }

    public void setConfiguration(ISynchronizePageConfiguration configuration) {
        this.configuration = configuration;
    }

    protected boolean canRunAsJob() {
        return this.canRunAsJob;
    }

    private IResource[] reduceRoots(IResource[] roots) {
        ArrayList<IResource> rootArray = new ArrayList<IResource>();
        int i = 0;
        while (i < roots.length) {
            int j = 0;
            while (j < this.resourcesToCommit.length) {
                if (this.resourcesToCommit[j].getFullPath().toString().startsWith(roots[i].getFullPath().toString())) {
                    rootArray.add(roots[i]);
                    break;
                }
                ++j;
            }
            ++i;
        }
        roots = new IResource[rootArray.size()];
        rootArray.toArray(roots);
        return roots;
    }

    private void setJavaHLHackMode(IResource[] resources) {
        if (!SVNUIPlugin.getPlugin().getPreferenceStore().getBoolean("pref_use_javahl_commit_hack")) {
            this.useJavaHLHack = false;
            return;
        }
        if (this.svnClient.canCommitAcrossWC()) {
            this.useJavaHLHack = false;
            return;
        }
    }

    public void setCanRunAsJob(boolean canRunAsJob) {
        this.canRunAsJob = canRunAsJob;
    }

    private class ProjectAndRepository {
        private SVNTeamProvider provider;
        private String rootURL;
        private String key;
        private File parent;

        public ProjectAndRepository(SVNTeamProvider provider, String rootURL) {
            this.provider = provider;
            this.rootURL = rootURL == null ? "" : rootURL;
        }

        public SVNTeamProvider getTeamProvider() {
            return this.provider;
        }

        public String getRootURL() {
            return this.rootURL;
        }

        private File getParent() {
            if (this.parent == null) {
                if (CommitOperation.this.useJavaHLHack) {
                    this.parent = this.provider.getSVNWorkspaceRoot().getLocalRoot().getFile().getParentFile();
                    if (this.isWorkingCopy(this.parent)) {
                        this.parent = this.getWorkingCopyRoot(this.parent);
                    }
                } else {
                    this.parent = this.provider.getProject().getFullPath().toFile();
                }
                if (this.parent == null) {
                    this.parent = this.provider.getSVNWorkspaceRoot().getLocalRoot().getFile();
                }
            }
            return this.parent;
        }

        private File getWorkingCopyRoot(File folder) {
            File parentFolder = folder.getParentFile();
            if (this.isWorkingCopy(parentFolder)) {
                return this.getWorkingCopyRoot(parentFolder);
            }
            return folder;
        }

        private boolean isWorkingCopy(File folder) {
            if (folder != null && folder.isDirectory()) {
                return new File(folder, SVNProviderPlugin.getPlugin().getAdminDirectoryName()).exists();
            }
            return false;
        }

        private String getKey() {
            if (this.key == null) {
                try {
                    this.key = String.valueOf(this.getParent().getCanonicalPath()) + this.rootURL;
                }
                catch (IOException iOException) {
                    this.key = String.valueOf(this.getParent().getAbsolutePath()) + this.rootURL;
                }
            }
            return this.key;
        }

        public String toString() {
            return this.getKey();
        }

        public int hashCode() {
            return this.getKey().hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProjectAndRepository other = (ProjectAndRepository)obj;
            return this.getKey().equals(other.getKey());
        }
    }
}

