/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.team.core.TeamException;
import org.tigris.subversion.subclipse.core.ISVNRemoteFolder;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.actions.RemoteResourceTransfer;
import org.tigris.subversion.subclipse.ui.actions.SVNAction;
import org.tigris.subversion.subclipse.ui.repository.RepositoryManager;

public class PasteRemoteResourceAction
extends SVNAction {
    protected void execute(IAction action) throws InvocationTargetException, InterruptedException {
        Clipboard clipboard = new Clipboard(this.getShell().getDisplay());
        final ISVNRemoteResource resource = (ISVNRemoteResource)clipboard.getContents((Transfer)RemoteResourceTransfer.getInstance());
        clipboard.dispose();
        RepositoryManager manager = SVNUIPlugin.getPlugin().getRepositoryManager();
        final String message = manager.promptForComment(this.getShell(), new IResource[0]);
        if (message == null) {
            return;
        }
        ISVNRemoteResource selectedResource = this.getSelectedRemoteResources()[0];
        final ISVNRemoteFolder destination = selectedResource.isFolder() ? (ISVNRemoteFolder)selectedResource : selectedResource.getParent();
        this.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    SVNProviderPlugin.getPlugin().getRepositoryResourcesManager().copyRemoteResource(resource, destination, message, monitor);
                }
                catch (TeamException e) {
                    throw new InvocationTargetException(e);
                }
            }
        }, true, 2);
    }

    protected boolean isEnabled() {
        if (this.getSelectedRemoteResources().length != 1) {
            return false;
        }
        Clipboard clipboard = new Clipboard(this.getShell().getDisplay());
        boolean result = clipboard.getContents((Transfer)RemoteResourceTransfer.getInstance()) != null;
        clipboard.dispose();
        return result;
    }
}

