/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.tigris.subversion.subclipse.core.ISVNRemoteFolder;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.WorkspacePathValidator;
import org.tigris.subversion.subclipse.ui.actions.CheckoutAsProjectAction;
import org.tigris.subversion.subclipse.ui.operations.CheckoutAsProjectOperation;
import org.tigris.subversion.subclipse.ui.util.PromptingDialog;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class CheckoutIntoAction
extends CheckoutAsProjectAction {
    protected IPath intoDir;
    private ISVNRemoteFolder[] selectedFolders;
    private String projectName;
    private String projectNamePrefix;
    private String projectNameSuffix;
    private String intoDirectory;
    private SVNRevision svnRevision = SVNRevision.HEAD;
    private int depth = 3;
    private boolean ignoreExternals = false;
    private boolean force = true;

    public CheckoutIntoAction(ISVNRemoteFolder[] selectedFolders, String projectName, String intoDirectory, Shell shell) {
        this.selectedFolders = selectedFolders;
        this.projectName = projectName;
        this.intoDirectory = intoDirectory;
        this.shell = shell;
    }

    public CheckoutIntoAction(ISVNRemoteFolder[] selectedFolders, String projectNamePrefix, String projectNameSuffix, String intoDirectory, Shell shell) {
        this(selectedFolders, null, intoDirectory, shell);
        this.projectNamePrefix = projectNamePrefix;
        this.projectNameSuffix = projectNameSuffix;
    }

    public void execute(IAction action) throws InvocationTargetException, InterruptedException {
        if (this.intoDirectory == null) {
            if (!WorkspacePathValidator.validateWorkspacePath()) {
                return;
            }
            DirectoryDialog intoDirDia = new DirectoryDialog(this.shell);
            intoDirDia.setMessage(Policy.bind("CheckoutInto.message"));
            String intoDirString = intoDirDia.open();
            if (intoDirString == null) {
                return;
            }
            this.intoDir = new Path(intoDirString);
        } else {
            this.intoDir = new Path(this.intoDirectory);
        }
        this.checkoutSelectionIntoWorkspaceDirectory();
    }

    protected void checkoutSelectionIntoWorkspaceDirectory() throws InvocationTargetException, InterruptedException {
        this.run((IRunnableWithProgress)new WorkspaceModifyOperation(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void execute(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
                block20: {
                    block19: {
                        try {
                            try {
                                block17: {
                                    int i;
                                    HashMap<String, ISVNRemoteFolder> targetFolders;
                                    block18: {
                                        ISVNRemoteFolder[] folders = CheckoutIntoAction.this.getSelectedRemoteFolders();
                                        boolean renameMultipleProjects = CheckoutIntoAction.this.shouldRenameMultipleProjects();
                                        ArrayList<IProject> targetProjects = new ArrayList<IProject>();
                                        targetFolders = new HashMap<String, ISVNRemoteFolder>();
                                        monitor.beginTask(null, 100);
                                        int i2 = 0;
                                        while (true) {
                                            IProject project;
                                            if (i2 >= folders.length) {
                                                CheckoutIntoAction.this.projects = targetProjects.toArray(new IResource[targetProjects.size()]);
                                                PromptingDialog prompt = new PromptingDialog(CheckoutIntoAction.this.getShell(), CheckoutIntoAction.this.projects, CheckoutIntoAction.getOverwriteLocalAndFileSystemPrompt(), Policy.bind("ReplaceWithAction.confirmOverwrite"));
                                                CheckoutIntoAction.this.projects = prompt.promptForMultiple();
                                                if (CheckoutIntoAction.this.projects.length == 0) break block17;
                                                CheckoutIntoAction.this.localFolders = new IProject[CheckoutIntoAction.this.projects.length];
                                                CheckoutIntoAction.this.remoteFolders = new ISVNRemoteFolder[CheckoutIntoAction.this.projects.length];
                                                i = 0;
                                                break block18;
                                            }
                                            CheckoutIntoAction.this.proceed = true;
                                            if (folders[i2].getRepository().getRepositoryRoot().toString().equals(folders[i2].getUrl().toString())) {
                                                CheckoutIntoAction.this.shell.getDisplay().syncExec(new Runnable(this){
                                                    final /* synthetic */ 1 this$1;
                                                    {
                                                        this.this$1 = var1_1;
                                                    }

                                                    public void run() {
                                                        1.access$0(this.this$1).proceed = MessageDialog.openQuestion((Shell)CheckoutIntoAction.access$1(1.access$0(this.this$1)), (String)Policy.bind("CheckoutAsProjectAction.title"), (String)Policy.bind("AddToWorkspaceAction.checkingOutRoot"));
                                                    }
                                                });
                                            }
                                            if (!CheckoutIntoAction.this.proceed) break;
                                            if (renameMultipleProjects) {
                                                String originalProjectName;
                                                try {
                                                    originalProjectName = SVNWorkspaceRoot.getProjectName((ISVNRemoteFolder)folders[i2], (IProgressMonitor)monitor);
                                                }
                                                catch (Exception exception) {
                                                    originalProjectName = folders[i2].getName();
                                                }
                                                String newProjectName = CheckoutIntoAction.this.modifyProjectName(originalProjectName);
                                                project = SVNWorkspaceRoot.getProject((String)newProjectName);
                                            } else if (CheckoutIntoAction.this.projectName == null) {
                                                try {
                                                    project = SVNWorkspaceRoot.getProject((ISVNRemoteFolder)folders[i2], (IProgressMonitor)monitor);
                                                }
                                                catch (Exception exception) {
                                                    project = SVNWorkspaceRoot.getProject((String)folders[i2].getName());
                                                }
                                            } else {
                                                project = SVNWorkspaceRoot.getProject((String)CheckoutIntoAction.this.projectName);
                                            }
                                            targetFolders.put(project.getName(), folders[i2]);
                                            targetProjects.add(project);
                                            ++i2;
                                        }
                                        Object var10_13 = null;
                                        break block19;
                                    }
                                    while (i < CheckoutIntoAction.this.projects.length) {
                                        CheckoutIntoAction.this.localFolders[i] = (IProject)CheckoutIntoAction.this.projects[i];
                                        CheckoutIntoAction.this.remoteFolders[i] = (ISVNRemoteFolder)targetFolders.get(CheckoutIntoAction.this.projects[i].getName());
                                        ++i;
                                    }
                                    break block20;
                                }
                                CheckoutIntoAction.this.proceed = false;
                                break block20;
                            }
                            catch (Exception e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                        catch (Throwable throwable) {
                            Object var10_14 = null;
                            monitor.done();
                            throw throwable;
                        }
                    }
                    monitor.done();
                    return;
                }
                Object var10_15 = null;
                monitor.done();
            }

            static /* synthetic */ CheckoutIntoAction access$0(1 var0) {
                return var0.CheckoutIntoAction.this;
            }
        }, true, 1);
        if (this.proceed) {
            CheckoutAsProjectOperation checkoutAsProjectOperation = new CheckoutAsProjectOperation(this.getTargetPart(), this.remoteFolders, this.localFolders, this.intoDir);
            checkoutAsProjectOperation.setSvnRevision(this.svnRevision);
            checkoutAsProjectOperation.setDepth(this.depth);
            checkoutAsProjectOperation.setIgnoreExternals(this.ignoreExternals);
            checkoutAsProjectOperation.setForce(this.force);
            checkoutAsProjectOperation.run();
        }
    }

    protected ISVNRemoteFolder[] getSelectedRemoteFolders() {
        if (this.selectedFolders != null) {
            return this.selectedFolders;
        }
        return super.getSelectedRemoteFolders();
    }

    public void setSvnRevision(SVNRevision svnRevision) {
        this.svnRevision = svnRevision;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public void setIgnoreExternals(boolean ignoreExternals) {
        this.ignoreExternals = ignoreExternals;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    private String getProjectNamePrefix() {
        return this.projectNamePrefix;
    }

    private String getProjectNameSuffix() {
        return this.projectNameSuffix;
    }

    private boolean shouldRenameMultipleProjects() {
        ISVNRemoteFolder[] folders = this.getSelectedRemoteFolders();
        return folders != null && folders.length > 1 && (this.getProjectNamePrefix() != null || this.getProjectNameSuffix() != null);
    }

    private String modifyProjectName(String originalProjectName) {
        StringBuffer buffer = new StringBuffer();
        if (this.getProjectNamePrefix() != null) {
            buffer.append(this.getProjectNamePrefix().trim());
        }
        buffer.append(originalProjectName);
        if (this.getProjectNameSuffix() != null) {
            buffer.append(this.getProjectNameSuffix().trim());
        }
        return buffer.toString();
    }
}

