/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.graph.editors;

import java.util.Iterator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.SelectionEditPolicy;
import org.tigris.subversion.subclipse.graph.cache.Node;
import org.tigris.subversion.subclipse.graph.editors.GraphEditPart;
import org.tigris.subversion.subclipse.graph.editors.NodeFigure;

public class RevisionEditPart
extends AbstractGraphicalEditPart {
    private static final int NODE_WIDTH = 50;
    private static final int NODE_HEIGHT = 30;
    private static final int NODE_OFFSET_Y = 40;
    private static final int NODE_OFFSET_X = 85;

    protected IFigure createFigure() {
        Node node = (Node)this.getModel();
        GraphEditPart graphEditPart = (GraphEditPart)this.getParent().getParent();
        NodeFigure nodeFigure = graphEditPart.getNodeFigure(node);
        node.setView((Object)nodeFigure);
        if (node.getTags() != null) {
            Iterator iter = node.getTags().iterator();
            while (iter.hasNext()) {
                Node tag = (Node)iter.next();
                nodeFigure.addTag(tag);
            }
        }
        nodeFigure.endLayout();
        int index = graphEditPart.isChronologicalMode() ? node.getGraphIndex() : node.getBranchIndex();
        Rectangle rect = new Rectangle(85, 40 + index * 40, 50, 30);
        ((AbstractGraphicalEditPart)this.getParent()).getFigure().getLayoutManager().setConstraint((IFigure)nodeFigure, (Object)rect);
        return nodeFigure;
    }

    protected void refreshVisuals() {
        Node node = (Node)this.getModel();
        GraphEditPart graphEditPart = (GraphEditPart)this.getParent().getParent();
        NodeFigure nodeFigure = graphEditPart.getNodeFigure(node);
        nodeFigure.setSelected(this.getSelected() != 0);
        graphEditPart.setConnectionVisibility();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Selection Feedback", (EditPolicy)new SelectionEditPolicy(){

            protected void hideSelection() {
                RevisionEditPart.this.refreshVisuals();
            }

            protected void showSelection() {
                RevisionEditPart.this.refreshVisuals();
            }
        });
    }
}

