/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.clientadapter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;
import org.tigris.subversion.clientadapter.AdapterManager;
import org.tigris.subversion.clientadapter.ILoadErrorHandler;
import org.tigris.subversion.clientadapter.ISVNClientWrapper;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;

public class Activator
extends Plugin {
    public static final String PLUGIN_ID = "org.tigris.subversion.clientadapter";
    public static final String LOAD_ERROR_HANDLERS = "org.tigris.subversion.clientadapter.loadErrorHandlers";
    private static Activator plugin;
    private AdapterManager adapterManager;
    private Map wrappers;
    private ILoadErrorHandler[] loadErrorHandlers;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.adapterManager = new AdapterManager();
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        this.adapterManager = null;
        super.stop(context);
    }

    public ISVNClientAdapter getClientAdapter(String id) {
        ISVNClientWrapper wrapper;
        if (id == null) {
            return this.getAnyClientAdapter();
        }
        if (this.wrappers == null) {
            this.wrappers = this.adapterManager.getClientWrappers();
        }
        if ((wrapper = (ISVNClientWrapper)this.wrappers.get(id)) == null || !wrapper.isAvailable()) {
            return null;
        }
        return wrapper.getAdapter();
    }

    public ISVNClientAdapter getAnyClientAdapter() {
        if (this.wrappers == null) {
            this.wrappers = this.adapterManager.getClientWrappers();
        }
        if (this.wrappers.isEmpty()) {
            return null;
        }
        ISVNClientWrapper wrapper = null;
        Iterator iterator = this.wrappers.values().iterator();
        while (iterator.hasNext()) {
            wrapper = (ISVNClientWrapper)iterator.next();
            if (wrapper.isAvailable()) break;
        }
        if (wrapper == null) {
            return null;
        }
        return wrapper.getAdapter();
    }

    public ISVNClientWrapper[] getAllClientWrappers() {
        this.wrappers = this.adapterManager.getClientWrappers();
        return this.wrappers.values().toArray(new ISVNClientWrapper[this.wrappers.size()]);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public void handleLoadErrors(ISVNClientWrapper clientWrapper) {
        try {
            this.loadErrorHandlers = this.getLoadErrorHandlers();
            if (this.loadErrorHandlers != null) {
                int i = 0;
                while (i < this.loadErrorHandlers.length) {
                    this.loadErrorHandlers[i].handleLoadError(clientWrapper);
                    ++i;
                }
            }
        }
        catch (Exception exception) {}
    }

    private ILoadErrorHandler[] getLoadErrorHandlers() throws Exception {
        if (this.loadErrorHandlers == null) {
            ArrayList<ILoadErrorHandler> handlerList = new ArrayList<ILoadErrorHandler>();
            IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
            IConfigurationElement[] configurationElements = extensionRegistry.getConfigurationElementsFor(LOAD_ERROR_HANDLERS);
            int i = 0;
            while (i < configurationElements.length) {
                IConfigurationElement configurationElement = configurationElements[i];
                ILoadErrorHandler handler = (ILoadErrorHandler)configurationElement.createExecutableExtension("class");
                handlerList.add(handler);
                ++i;
            }
            this.loadErrorHandlers = new ILoadErrorHandler[handlerList.size()];
            handlerList.toArray(this.loadErrorHandlers);
        }
        return this.loadErrorHandlers;
    }
}

